/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.allocstd;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class DiyCostDriverSaveOpPlugin
extends AbstractOperationServicePlugIn {
    private static final String COSTCENTER = "COSTCENTER";
    private static final Log logger = LogFactory.getLog(DiyCostDriverSaveOpPlugin.class);
    private static final String COSTOBJECT = "COSTOBJECT";
    private static final String[] billFile = new String[]{"org", "manuorg", "costdriver", "costcenter", "qty"};
    private static final String[] entryFile = new String[]{"benefcostcenter", "matnum", "matauxpty", "matversion", "entryqty", "costobject", "material", "auxpty"};
    private static final String MATERIALGROUP = "MATERIALGROUP";
    private static final String MATERIAL = "MATERIAL";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("entryentity");
        fieldKeys.add("benefcostcenter");
        fieldKeys.add("costcenter");
        fieldKeys.add("costobject");
        fieldKeys.add("costdriver");
        fieldKeys.add("entryqty");
        fieldKeys.add("material");
        fieldKeys.add("manuorg");
        fieldKeys.add("appnum");
        fieldKeys.add("org");
        fieldKeys.add("expdate");
        fieldKeys.add("effectdate");
        fieldKeys.add("auxpty");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                HashMap<String, Long> billnoMap = new HashMap<String, Long>();
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                DynamicObjectCollection billnos = QueryServiceHelper.query((String)"sca_diycostdriver", (String)"id,billno", null);
                for (DynamicObject bill : billnos) {
                    Long id = bill.getLong("id");
                    String billno = bill.getString("billno");
                    billnoMap.put(billno, id);
                }
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    Set centerIds;
                    DynamicObjectCollection entryentity;
                    DynamicObject costdriver;
                    DynamicObject diyBill = dataEntity.getDataEntity();
                    String billno = diyBill.getString("billno");
                    long orgId = diyBill.getLong("org.id");
                    String appNum = diyBill.getString("appnum");
                    long id = diyBill.getLong("id");
                    String costcentName = diyBill.getString("costcenter.name");
                    if (billnoMap.get(billno) != null && !((Long)billnoMap.get(billno)).equals(id)) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u7f16\u53f7\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"DiyCostDriverSaveOpPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]), new Object[0]));
                    }
                    if (CadEmptyUtils.isEmpty((DynamicObject)(costdriver = diyBill.getDynamicObject("costdriver")))) {
                        return;
                    }
                    String allocClass = costdriver.getString("allocclass");
                    boolean isMaterialGroup = DiyCostDriverSaveOpPlugin.MATERIALGROUP.equals(allocClass);
                    boolean isMaterialCostDriver = DiyCostDriverSaveOpPlugin.MATERIAL.equals(allocClass);
                    DynamicObject costcenter = diyBill.getDynamicObject("costcenter");
                    if (CadEmptyUtils.isEmpty((DynamicObject)costcenter) && DiyCostDriverSaveOpPlugin.COSTOBJECT.equals(allocClass)) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u4e2d\u5fc3\u201d\u3002", (String)"DiyCostDriverSaveOpPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject manuorg = diyBill.getDynamicObject("manuorg");
                    boolean isOrgEnableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
                    if (isOrgEnableMulFactory) {
                        if (CadEmptyUtils.isEmpty((DynamicObject)manuorg)) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff1a\u6838\u7b97\u7ec4\u7ec7\u5f00\u542f\u591a\u5de5\u5382\u6838\u7b97\u65f6\uff0c\u751f\u4ea7\u7ec4\u7ec7\u4e3a\u5fc5\u5f55\u3002", (String)"DiyCostDriverSaveOpPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                            return;
                        }
                        boolean isProduce = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"04");
                        List manuOrgIds = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)orgId, (boolean)isProduce);
                        if (CadEmptyUtils.isEmpty((List)manuOrgIds) || !manuOrgIds.contains(manuorg.getPkValue())) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u751f\u4ea7\u7ec4\u7ec7\u4e0e\u6838\u7b97\u7ec4\u7ec7\u65e0\u5173\u8054\u5173\u7cfb\u3002", (String)"DiyCostDriverSaveOpPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
                            return;
                        }
                        if (CadEmptyUtils.isEmpty((DynamicObject)costcenter) && !isMaterialCostDriver && !isMaterialGroup) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff1a\u6838\u7b97\u7ec4\u7ec7\u5f00\u542f\u591a\u5de5\u5382\u6838\u7b97\u65f6\uff0c\u6210\u672c\u4e2d\u5fc3\u4e3a\u5fc5\u5f55\u3002", (String)"DiyCostDriverSaveOpPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
                            return;
                        }
                    }
                    if ((entryentity = diyBill.getDynamicObjectCollection("entryentity")).size() == 0) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u81f3\u5c11\u7ef4\u62a4\u4e00\u6761\u660e\u7ec6\u4fe1\u606f\u3002", (String)"DiyCostDriverSaveOpPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]), costcentName));
                        return;
                    }
                    HashSet<Long> benefcostcenterSet = new HashSet<Long>(16);
                    HashMap<Long, DynamicObject> centerMap = new HashMap<Long, DynamicObject>(16);
                    for (DynamicObject entry : entryentity) {
                        if (isMaterialCostDriver) {
                            DynamicObject matAuxpty;
                            DynamicObject material = entry.getDynamicObject("matnum");
                            if (CadEmptyUtils.isEmpty((DynamicObject)material)) {
                                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff1a\u6210\u672c\u52a8\u56e0\u7684\u5206\u914d\u5c42\u7ea7\u4e3a\u7269\u6599\u7ea7\uff0c\u7269\u6599\u7f16\u7801\u4e3a\u5fc5\u5f55\u3002", (String)"DiyCostDriverSaveOpPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]));
                                continue;
                            }
                            Boolean isAffectPrice = false;
                            Boolean bl = material.getBoolean("isuseauxpty");
                            if (bl.booleanValue()) {
                                DynamicObjectCollection auxptyentry = material.getDynamicObjectCollection("auxptyentry");
                                for (DynamicObject aux : auxptyentry) {
                                    if (!aux.getBoolean("isaffectprice")) continue;
                                    isAffectPrice = true;
                                    break;
                                }
                            }
                            if (!isAffectPrice.booleanValue() || !CadEmptyUtils.isEmpty((DynamicObject)(matAuxpty = entry.getDynamicObject("matauxpty")))) continue;
                            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u3010%1$s/%2$s\u3011\u542f\u7528\u4e86\u5f71\u54cd\u6210\u672c\u7684\u8f85\u52a9\u5c5e\u6027\uff0c\u8bf7\u586b\u5199\u8f85\u52a9\u5c5e\u6027\u3002", (String)"DiyCostDriverSaveOpPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]), material.getString("number"), material.getString("name")));
                            continue;
                        }
                        if (isMaterialGroup) {
                            DynamicObject materialGroup = entry.getDynamicObject("materialgroup");
                            if (!CadEmptyUtils.isEmpty((DynamicObject)materialGroup)) continue;
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff1a\u6210\u672c\u52a8\u56e0\u7684\u5206\u914d\u5c42\u7ea7\u4e3a\u7269\u6599\u5206\u7c7b\u7ea7\uff0c\u7269\u6599\u5206\u7c7b\u4e3a\u5fc5\u5f55\u3002", (String)"DiyCostDriverSaveOpPlugin_9", (String)"macc-sca-form", (Object[])new Object[0]));
                            return;
                        }
                        DynamicObject benefCostcenter = entry.getDynamicObject("benefcostcenter");
                        if (CadEmptyUtils.isEmpty((DynamicObject)benefCostcenter)) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff1a\u6210\u672c\u52a8\u56e0\u7684\u5206\u914d\u5c42\u7ea7\u4e3a\u6210\u672c\u4e2d\u5fc3\u6216\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u65f6\uff0c\u53d7\u76ca\u6210\u672c\u4e2d\u5fc3\u4e3a\u5fc5\u5f55\u3002", (String)"DiyCostDriverSaveOpPlugin_10", (String)"macc-sca-form", (Object[])new Object[0]));
                            return;
                        }
                        if (DiyCostDriverSaveOpPlugin.COSTCENTER.equals(allocClass)) {
                            if (benefcostcenterSet.contains(benefCostcenter.getLong("id"))) {
                                this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5206\u914d\u5c42\u7ea7\u4e3a\u6210\u672c\u4e2d\u5fc3\u65f6\uff0c\u660e\u7ec6\u4fe1\u606f\u4e2d\u53d7\u76ca\u6210\u672c\u4e2d\u5fc3\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DiyCostDriverSaveOpPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]), new Object[0]));
                                return;
                            }
                            benefcostcenterSet.add(benefCostcenter.getLong("id"));
                        } else {
                            DynamicObject costobject = entry.getDynamicObject("costobject");
                            if (CadEmptyUtils.isEmpty((DynamicObject)costobject)) {
                                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff1a\u6210\u672c\u52a8\u56e0\u7684\u5206\u914d\u5c42\u7ea7\u4e3a\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u65f6\uff0c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4e3a\u5fc5\u5f55\u3002", (String)"DiyCostDriverSaveOpPlugin_12", (String)"macc-sca-form", (Object[])new Object[0]));
                                return;
                            }
                        }
                        if ((CadEmptyUtils.isEmpty((DynamicObject)benefCostcenter) || !"4".equals(benefCostcenter.getString("orgduty.number"))) && !"5".equals(benefCostcenter.getString("orgduty.number"))) continue;
                        centerMap.put(benefCostcenter.getLong("id"), entry);
                    }
                    if (!isOrgEnableMulFactory || isMaterialCostDriver || (centerIds = centerMap.keySet()).isEmpty()) continue;
                    Set centerManuOrgByIds = OrgHelper.getCenterManuOrgByIds((Long)orgId, centerIds, (String)appNum);
                    StringJoiner joiner = new StringJoiner("\uff1b");
                    for (Map.Entry entry : centerMap.entrySet()) {
                        Long key = (Long)entry.getKey();
                        if (centerManuOrgByIds.contains(key)) continue;
                        DynamicObject value = (DynamicObject)entry.getValue();
                        joiner.add("\u3010" + value.getDynamicObject("benefcostcenter").getString("number") + "/" + value.getDynamicObject("benefcostcenter").getString("name") + "\u3011");
                    }
                    String message = joiner.toString();
                    if (!StringUtils.isNotBlank((CharSequence)message)) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u6210\u672c\u4e2d\u5fc3%s\u672a\u7ef4\u62a4\u6210\u672c\u4e2d\u5fc3\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u5bf9\u5e94\u8868\uff0c\u8bf7\u5148\u7ef4\u62a4\u5bf9\u5e94\u8868\u3002", (String)"DiyCostDriverSaveOpPlugin_13", (String)"macc-sca-form", (Object[])new Object[0]), message));
                    return;
                }
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] datas;
        for (DynamicObject data : datas = e.getDataEntities()) {
            DynamicObject org;
            boolean isOrgEnableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)data.getLong("org.id"));
            if (!isOrgEnableMulFactory) {
                data.set("manuorg", null);
            }
            if ((org = data.getDynamicObject("org")) != null && this.isEnableEffectByOrg(org.getLong("id"), data.getString("appnum"))) {
                long existsSourceId = this.getExistsSourceId(data);
                data.set("sourceid", (Object)existsSourceId);
            }
            DynamicObjectCollection entryEntity = data.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryEntity) {
                long auxptyId;
                DynamicObject costObject = dynamicObject.getDynamicObject("costobject");
                if (costObject == null || CadEmptyUtils.isEmpty((Long)(auxptyId = costObject.getLong("auxpty.id")))) continue;
                dynamicObject.set("auxpty_id", (Object)auxptyId);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] datas;
        for (DynamicObject data : datas = e.getDataEntities()) {
            Object id = data.getPkValue();
            this.setEntity(id);
        }
    }

    private void setEntity(Object id) {
        HashSet<Object> fids = new HashSet<Object>();
        fids.add(id);
        Object[] diyCostdBill = BusinessDataServiceHelper.load((Object[])fids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sca_diycostdriver"));
        if (CadEmptyUtils.isEmpty((Object[])diyCostdBill)) {
            return;
        }
        DynamicObject costdriver = diyCostdBill[0].getDynamicObject("costdriver");
        diyCostdBill[0].set("costbaseunit", (Object)costdriver.getLong("unit.id"));
        String allocClass = costdriver.getString("allocclass");
        DynamicObjectCollection entryentitys = diyCostdBill[0].getDynamicObjectCollection("entryentity");
        if (CadEmptyUtils.isEmpty((List)entryentitys)) {
            return;
        }
        BigDecimal sum = new BigDecimal(0);
        for (DynamicObject entry : entryentitys) {
            BigDecimal entryQty = entry.getBigDecimal("entryqty");
            sum = sum.add(entryQty);
            if (COSTCENTER.equals(allocClass)) {
                entry.set("costobject", null);
                entry.set("material", null);
                continue;
            }
            DynamicObject costObject = entry.getDynamicObject("costobject");
            if (costObject == null) continue;
            long material = costObject.getLong("material.id");
            entry.set("material", (Object)material);
        }
        diyCostdBill[0].set("qty", (Object)sum);
        SaveServiceHelper.update((DynamicObject[])diyCostdBill);
    }

    private long getExistsSourceId(DynamicObject dataEntity) {
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        DynamicObject costDriver = dataEntity.getDynamicObject("costdriver");
        if (org == null || costAccount == null || costDriver == null) {
            return 0L;
        }
        DynamicObject manuOrg = dataEntity.getDynamicObject("manuorg");
        DynamicObject costCenter = dataEntity.getDynamicObject("costcenter");
        QFilter[] filters = new QFilter[]{new QFilter("id", "!=", dataEntity.getPkValue()), new QFilter("org", "=", org.getPkValue()), new QFilter("costaccount", "=", costAccount.getPkValue()), new QFilter("manuorg", "=", manuOrg == null ? Long.valueOf(0L) : manuOrg.getPkValue()), new QFilter("costcenter", "=", costCenter == null ? Long.valueOf(0L) : costCenter.getPkValue()), new QFilter("costdriver", "=", costDriver.getPkValue()), new QFilter("effectstatus", "in", (Object)new String[]{"E"}), new QFilter("appnum", "=", (Object)dataEntity.getString("appnum"))};
        DynamicObject sourceObject = QueryServiceHelper.queryOne((String)"sca_diycostdriver", (String)"id, sourceid", (QFilter[])filters);
        if (sourceObject == null) {
            return 0L;
        }
        return CadEmptyUtils.isEmpty((Long)sourceObject.getLong("sourceid")) ? sourceObject.getLong("id") : sourceObject.getLong("sourceid");
    }

    private boolean isEnableEffectByOrg(Long orgId, String appId) {
        return SysParamHelper.getEnableEffectByOrg((Long)orgId, (String)appId, (String)"sca_diycostdriver");
    }
}

