/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.allocstd;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.SysParamHelper;

public class DiyCostDriverUnEffectOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billno");
        fieldKeys.add("org");
        fieldKeys.add("manuorg");
        fieldKeys.add("costaccount");
        fieldKeys.add("sourceid");
        fieldKeys.add("effectdate");
        fieldKeys.add("expdate");
        fieldKeys.add("effectstatus");
        fieldKeys.add("effectperiod");
        fieldKeys.add("expperiod");
        fieldKeys.add("costdriver");
        fieldKeys.add("costcenter");
        fieldKeys.add("materialgroupstd");
        fieldKeys.add("entryentity");
        fieldKeys.add("entryentity.benefcostcenter");
        fieldKeys.add("entryentity.costobject");
        fieldKeys.add("entryentity.matnum");
        fieldKeys.add("entryentity.matauxpty");
        fieldKeys.add("entryentity.materialgroup");
        fieldKeys.add("appnum");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity entity : dataEntities = this.getDataEntities()) {
                    DynamicObject dataEntity = entity.getDataEntity();
                    DynamicObject accountOrg = (DynamicObject)dataEntity.get("org");
                    DynamicObject costAccount = (DynamicObject)dataEntity.get("costaccount");
                    DynamicObject costDriver = dataEntity.getDynamicObject("costdriver");
                    DynamicObject effectPeriod = (DynamicObject)dataEntity.get("effectperiod");
                    if (accountOrg == null || costAccount == null || costDriver == null) {
                        return;
                    }
                    long costAccountId = costAccount.getLong("id");
                    DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
                    if (currentPeriod == null) {
                        return;
                    }
                    String status = dataEntity.getString("effectstatus");
                    if (!DiyCostDriverUnEffectOpPlugin.this.isEnableEffectByOrg(accountOrg.getLong("id"), dataEntity.getString("appnum"))) {
                        this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u5931\u6548\u5931\u8d25\uff0c\u5f53\u524d\u5355\u636e\u672a\u542f\u7528\u6709\u6548\u671f\u63a7\u5236", (String)"DiyCostDriverUnEffectOpPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                        continue;
                    }
                    if (!"E".equals(status)) {
                        this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u5931\u6548\u5931\u8d25\uff0c\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u5df2\u751f\u6548", (String)"DiyCostDriverUnEffectOpPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                        continue;
                    }
                    if (PeriodHelper.compare2period((DynamicObject)currentPeriod, (DynamicObject)effectPeriod) < 0) {
                        this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u5931\u6548\u5931\u8d25\uff0c\u5355\u636e\u751f\u6548\u671f\u95f4\u5e94\u5c0f\u4e8e\u5f53\u524d\u671f\u95f4", (String)"DiyCostDriverUnEffectOpPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                        continue;
                    }
                    dataEntity.set("expperiod", (Object)currentPeriod);
                    dataEntity.set("expdate", (Object)currentPeriod.getDate("begindate"));
                    dataEntity.set("effectstatus", (Object)"F");
                    SaveServiceHelper.update((DynamicObject)dataEntity);
                }
            }
        });
    }

    private boolean isEnableEffectByOrg(Long orgId, String appId) {
        return SysParamHelper.getEnableEffectByOrg((Long)orgId, (String)appId, (String)"sca_diycostdriver");
    }
}

