/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.allocstd;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.sca.algox.utils.CadEmptyUtils;

public class ResourceUseSaveOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("entryentity");
        fieldKeys.add("facthour");
        fieldKeys.add("factuse");
        fieldKeys.add("factbatch");
        fieldKeys.add("version");
        fieldKeys.add("auxpty");
        fieldKeys.add("material");
        fieldKeys.add("workhour");
        fieldKeys.add("org");
        fieldKeys.add("manuorg");
        fieldKeys.add("source");
        fieldKeys.add("srcbillid");
        fieldKeys.add("bizdate");
        fieldKeys.add("pricedate");
        fieldKeys.add("appnum");
        fieldKeys.add("costobject");
        fieldKeys.add("processseq");
        fieldKeys.add("operationno");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                HashMap<Long, Long> orgCostAccountMap = new HashMap<Long, Long>(16);
                HashMap<Long, DynamicObject> costAccountPeriodMap = new HashMap<Long, DynamicObject>(16);
                HashMap<Long, List> orgManuOrgMap = new HashMap<Long, List>(16);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    List manuorgList;
                    String operationNoStr;
                    Long costAccountId;
                    DynamicObject resouceBill = dataEntity.getDataEntity();
                    String appNum = resouceBill.getString("appnum");
                    DynamicObjectCollection entryentity = resouceBill.getDynamicObjectCollection("entryentity");
                    int index = 1;
                    long org = resouceBill.getLong("org.id");
                    if (!orgCostAccountMap.containsKey(org)) {
                        orgCostAccountMap.put(org, CostAccountHelper.getCostAccountByAccoutOrg((Long)org, (String)appNum));
                    }
                    if (!costAccountPeriodMap.containsKey(costAccountId = (Long)orgCostAccountMap.get(org))) {
                        costAccountPeriodMap.put(costAccountId, PeriodHelper.getCurrentPeriod((Long)costAccountId));
                    }
                    DynamicObject currentPeriod = (DynamicObject)costAccountPeriodMap.get(costAccountId);
                    HashSet<Long> costObjectIds = new HashSet<Long>(16);
                    for (DynamicObject entry : entryentity) {
                        Object costObject = entry.get("costobject");
                        if (costObject == null) continue;
                        long costObjectId = 0L;
                        if (costObject instanceof DynamicObject) {
                            costObjectId = entry.getDynamicObject("costobject").getLong("id");
                        } else if (costObject instanceof Long) {
                            costObjectId = Long.parseLong(String.valueOf(costObject));
                        }
                        costObjectIds.add(costObjectId);
                    }
                    String processSeqStr = resouceBill.getString("processseq");
                    if (!CadEmptyUtils.isEmpty((String)processSeqStr) && !processSeqStr.matches("^(?!0+$)\\d{1,4}$")) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u3010%s\u3011\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8f93\u51654\u4f4d\u62164\u4f4d\u4ee5\u5185\u7684\u6b63\u6574\u6570\u3002", (String)"ResourceUseSaveOpPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]), processSeqStr));
                    }
                    if (!CadEmptyUtils.isEmpty((String)(operationNoStr = resouceBill.getString("operationno"))) && !operationNoStr.matches("^(?!0+$)\\d{1,4}$")) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u53f7\u3010%s\u3011\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8f93\u51654\u4f4d\u62164\u4f4d\u4ee5\u5185\u7684\u6b63\u6574\u6570\u3002", (String)"ResourceUseSaveOpPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]), operationNoStr));
                    }
                    QFilter qFilter = new QFilter("id", "in", costObjectIds);
                    DataSet costObjectInfo = QueryServiceHelper.queryDataSet((String)"getCostObjectInfo", (String)"cad_costobject", (String)"id,bookdate", (QFilter[])qFilter.toArray(), null);
                    HashMap costInfoMap = new HashMap(16);
                    costObjectInfo.forEach(s -> costInfoMap.put(s.getLong("id"), s.getDate("bookdate")));
                    for (DynamicObject entry : entryentity) {
                        BigDecimal facthour;
                        Long workHourid = 0L;
                        workHourid = entry.get("workhour") instanceof DynamicObject ? Long.valueOf(entry.getLong("workhour.id")) : Long.valueOf(entry.getLong("workhour"));
                        if (currentPeriod != null) {
                            Object costObject = entry.get("costobject");
                            if (costObject == null) continue;
                            long costObjectId = 0L;
                            if (costObject instanceof DynamicObject) {
                                costObjectId = entry.getDynamicObject("costobject").getLong("id");
                            } else if (costObject instanceof Long) {
                                costObjectId = Long.parseLong(String.valueOf(costObject));
                            }
                            Date endDate = currentPeriod.getDate("enddate");
                            Date bookDate = (Date)costInfoMap.get(costObjectId);
                            if (endDate != null && bookDate != null && bookDate.getTime() > DateUtils.getDayEndTime((Date)endDate).getTime()) {
                                this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u8bb0\u8d26\u65e5\u671f\u5927\u4e8e\u5f53\u524d\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u3002", (String)"ResourceUseSaveOpPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]), index));
                            }
                        }
                        if ((facthour = entry.getBigDecimal("facthour")).compareTo(BigDecimal.ZERO) != 0 && CadEmptyUtils.isEmpty((Long)workHourid)) {
                            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u660e\u7ec6\u4fe1\u606f\u7b2c%d\u884c\uff0c\u5f55\u5165\u4e86\u5b9e\u9645\u5de5\u65f6\uff0c\u5de5\u65f6\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ResourceUseSaveOpPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]), index));
                        }
                        ++index;
                    }
                    String source = dataEntity.getDataEntity().getString("source");
                    Long manuorgId = 0L;
                    manuorgId = resouceBill.get("manuorg") instanceof DynamicObject ? Long.valueOf(resouceBill.getLong("manuorg.id")) : Long.valueOf(resouceBill.getLong("manuorg"));
                    if (!"EXCEL".equalsIgnoreCase(source) || CadEmptyUtils.isEmpty((Long)manuorgId)) continue;
                    Long accountOrg = (Long)resouceBill.getDynamicObject("org").getPkValue();
                    if (!orgManuOrgMap.containsKey(accountOrg)) {
                        manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)accountOrg, (String)"sca_resourceuse");
                        orgManuOrgMap.put(accountOrg, manuorgList);
                    }
                    if ((manuorgList = (List)orgManuOrgMap.get(accountOrg)) != null && manuorgList.contains(manuorgId)) continue;
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002\u751f\u4ea7\u7ec4\u7ec7\u4e0e\u6838\u7b97\u7ec4\u7ec7\u6ca1\u6709\u59d4\u6258\u5173\u7cfb\uff0c\u4e0d\u80fd\u5bfc\u5165", (String)"ResourceUseSaveOpPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]));
                }
                orgCostAccountMap.clear();
                orgManuOrgMap.clear();
                costAccountPeriodMap.clear();
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] datas;
        for (DynamicObject data : datas = e.getDataEntities()) {
            String source = data.getString("source");
            if (!"EXCEL".equalsIgnoreCase(source)) continue;
            DynamicObjectCollection entryEntity = data.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryEntity) {
                Long material;
                DynamicObject costObject = dynamicObject.getDynamicObject("costobject");
                if (costObject == null) continue;
                long auxptyId = costObject.getLong("auxpty.id");
                if (!CadEmptyUtils.isEmpty((Long)auxptyId)) {
                    dynamicObject.set("auxpty_id", (Object)auxptyId);
                }
                if (CadEmptyUtils.isEmpty((Long)(material = Long.valueOf(costObject.getLong("material.id"))))) continue;
                dynamicObject.set("material_id", (Object)material);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] ress;
        DynamicObject[] dataEntities;
        HashSet<Long> resIds = new HashSet<Long>(16);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            long srcBillId = dataEntity.getLong("srcbillid");
            if (!CadEmptyUtils.isEmpty((Long)srcBillId)) continue;
            resIds.add(dataEntity.getLong("id"));
        }
        if (resIds.isEmpty()) {
            return;
        }
        for (DynamicObject res : ress = BusinessDataServiceHelper.load((Object[])resIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"sca_resourceuse"))) {
            res.set("pricedate", (Object)res.getDate("bizdate"));
        }
        SaveServiceHelper.update((DynamicObject[])ress);
    }
}

