/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.allocstd;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;

public class WorkQtyCollecOpPlugin
extends AbstractOperationServicePlugIn {
    private static final String ENTITY_CAD_COSTDRIVER = "cad_costdriver";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("baseunit");
        fieldKeys.add("entryentity");
        fieldKeys.add("costdriver");
        fieldKeys.add("org");
        fieldKeys.add("qty");
        fieldKeys.add("costdriver");
        fieldKeys.add("costcenter");
        fieldKeys.add("entryentity.seq");
        fieldKeys.add("entryentity.costobject");
        fieldKeys.add("entryentity.entryqty");
        fieldKeys.add("entryentity.benefcostcenter");
        fieldKeys.add("entryentity.material");
        fieldKeys.add("appnum");
        fieldKeys.add("manuorg");
        fieldKeys.add("workactivity");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                String faultTip = "";
                if ("save".equals(operateKey)) {
                    faultTip = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"WorkQtyCollecOpPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]);
                } else if ("submit".equals(operateKey)) {
                    faultTip = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002", (String)"WorkQtyCollecOpPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]);
                } else if ("audit".equals(operateKey)) {
                    faultTip = ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\u3002", (String)"WorkQtyCollecOpPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]);
                }
                ArrayList<Long> notCostDriverList = new ArrayList<Long>();
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    this.checkManuorgObjectMust(dataEntity, faultTip);
                    this.checkCostObjectMust(dataEntity, faultTip);
                    this.checkQty(dataEntity, faultTip);
                    this.putWorkActivityId(dataEntity, notCostDriverList);
                    this.dealPrecision(dataEntity);
                }
                if ("save".equals(operateKey)) {
                    this.fillCostDriver(this.dataEntities, notCostDriverList);
                }
                this.checkCenter(this.dataEntities, operateKey);
            }

            private void dealPrecision(ExtendedDataEntity dataEntity) {
                DynamicObject bill = dataEntity.getDataEntity();
                DynamicObject baseunit = bill.getDynamicObject("baseunit");
                String precisionaccount = baseunit.getString("precisionaccount");
                int roundType = 4;
                if ("2".equals(precisionaccount)) {
                    roundType = 1;
                } else if ("3".equals(precisionaccount)) {
                    roundType = 0;
                }
                bill.set("qty", (Object)bill.getBigDecimal("qty").setScale(baseunit.getInt("precision"), roundType));
                DynamicObjectCollection rows = bill.getDynamicObjectCollection("entryentity");
                for (DynamicObject row : rows) {
                    row.set("entryqty", (Object)row.getBigDecimal("entryqty").setScale(baseunit.getInt("precision"), roundType));
                }
            }

            private void fillCostDriver(ExtendedDataEntity[] dataEntities, List<Long> notCostDriverList) {
                if (CadEmptyUtils.isEmpty(notCostDriverList)) {
                    return;
                }
                QFilter workactivityQF = new QFilter("workactivity", "in", notCostDriverList);
                QFilter statusQF = new QFilter("status", "=", (Object)"C");
                QFilter enableQF = new QFilter("enable", "=", (Object)Boolean.TRUE);
                QFilter appIdFilter = this.getAppIdFilter(dataEntities[0]);
                QFilter[] qf = new QFilter[]{workactivityQF, statusQF, enableQF, appIdFilter};
                Object[] costdriverCollec = BusinessDataServiceHelper.load((String)WorkQtyCollecOpPlugin.ENTITY_CAD_COSTDRIVER, (String)"id, workactivity,allocclass", (QFilter[])qf);
                HashMap<Long, Object> map = new HashMap<Long, Object>();
                if (!CadEmptyUtils.isEmpty((Object[])costdriverCollec)) {
                    for (Object costdriver : costdriverCollec) {
                        map.put(costdriver.getLong("workactivity.id"), costdriver);
                    }
                }
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    Long workactivityId;
                    DynamicObject bill = dataEntity.getDataEntity();
                    if (!CadEmptyUtils.isEmpty((DynamicObject)bill.getDynamicObject("costdriver")) || CadEmptyUtils.isEmpty((Long)(workactivityId = Long.valueOf(bill.getLong("workactivity.id"))))) continue;
                    DynamicObject costdriver = (DynamicObject)map.get(workactivityId);
                    if (CadEmptyUtils.isEmpty((DynamicObject)costdriver)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u4f5c\u4e1a\u6d3b\u52a8\u5bf9\u5e94\u7684\u6210\u672c\u52a8\u56e0\u3002", (String)"WorkQtyCollecOpPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
                        continue;
                    }
                    bill.set("costdriver", (Object)costdriver);
                }
            }

            private void checkCenter(ExtendedDataEntity[] dataEntity, String operateKey) {
                if ("submit".equals(operateKey) || "audit".equals(operateKey)) {
                    for (ExtendedDataEntity entity : dataEntity) {
                        DynamicObject diyBill = entity.getDataEntity();
                        long orgId = diyBill.getLong("org.id");
                        String appNum = diyBill.getString("appnum");
                        if (!OrgHelper.isOrgEnableMultiFactory((Long)orgId)) continue;
                        DynamicObjectCollection entryEntity = diyBill.getDynamicObjectCollection("entryentity");
                        HashMap<Long, DynamicObject> centerMap = new HashMap<Long, DynamicObject>(16);
                        for (DynamicObject entry : entryEntity) {
                            DynamicObject benefCostcenter = entry.getDynamicObject("benefcostcenter");
                            if ((CadEmptyUtils.isEmpty((DynamicObject)benefCostcenter) || !"4".equals(benefCostcenter.getString("orgduty.number"))) && !"5".equals(benefCostcenter.getString("orgduty.number"))) continue;
                            centerMap.put(benefCostcenter.getLong("id"), entry);
                        }
                        Set centerIds = centerMap.keySet();
                        if (centerIds.isEmpty()) continue;
                        Set centerManuOrgByIds = OrgHelper.getCenterManuOrgByIds((Long)orgId, centerIds, (String)appNum);
                        StringJoiner joiner = new StringJoiner("\uff1b");
                        for (Map.Entry entry : centerMap.entrySet()) {
                            Long key = (Long)entry.getKey();
                            if (centerManuOrgByIds.contains(key)) continue;
                            DynamicObject value = (DynamicObject)entry.getValue();
                            joiner.add("\u3010" + value.getDynamicObject("benefcostcenter").getString("number") + "/" + value.getDynamicObject("benefcostcenter").getString("name") + "\u3011");
                        }
                        String message = joiner.toString();
                        if (!StringUtils.isNotBlank((CharSequence)message)) continue;
                        String tips = "submit".equals(operateKey) ? ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002\u6210\u672c\u4e2d\u5fc3%s\u672a\u7ef4\u62a4\u6210\u672c\u4e2d\u5fc3\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u5bf9\u5e94\u8868\uff0c\u8bf7\u5148\u7ef4\u62a4\u5bf9\u5e94\u8868\u3002", (String)"WorkQtyCollecOpPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\u3002\u6210\u672c\u4e2d\u5fc3%s\u672a\u7ef4\u62a4\u6210\u672c\u4e2d\u5fc3\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u5bf9\u5e94\u8868\uff0c\u8bf7\u5148\u7ef4\u62a4\u5bf9\u5e94\u8868\u3002", (String)"WorkQtyCollecOpPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]);
                        this.addErrorMessage(entity, String.format(tips, message));
                        return;
                    }
                }
            }

            private void putWorkActivityId(ExtendedDataEntity dataEntity, List<Long> notCostDriverList) {
                DynamicObject bill = dataEntity.getDataEntity();
                DynamicObject workactivity = bill.getDynamicObject("workactivity");
                if (workactivity == null) {
                    return;
                }
                notCostDriverList.add(workactivity.getLong("id"));
                bill.set("baseunit", workactivity.get("unit"));
            }

            private void checkQty(ExtendedDataEntity dataEntity, String faultTip) {
                double diff;
                DynamicObjectCollection entryentity;
                DynamicObject entity = dataEntity.getDataEntity();
                BigDecimal qty = entity.getBigDecimal("qty");
                if (qty == null || qty.compareTo(BigDecimal.ZERO) <= 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u201c\u57fa\u672c\u6570\u91cf\u201d\u5fc5\u987b>0\u3002", (String)"WorkQtyCollecOpPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]), faultTip));
                }
                if ((entryentity = entity.getDynamicObjectCollection("entryentity")) == null || entryentity.isEmpty()) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkQtyCollecOpPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]), faultTip));
                    return;
                }
                BigDecimal countQty = BigDecimal.ZERO;
                for (DynamicObject entry : entryentity) {
                    BigDecimal entryqty = entry.getBigDecimal("entryqty");
                    int seq = entry.getInt("seq");
                    if (entryqty == null || entryqty.compareTo(BigDecimal.ZERO) <= 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u660e\u7ec6\u4fe1\u606f\u7b2c%2$s\u884c\u201c\u57fa\u672c\u6570\u91cf\u201d\u5fc5\u987b>0\u3002", (String)"WorkQtyCollecOpPlugin_10", (String)"macc-sca-form", (Object[])new Object[0]), faultTip, seq));
                    }
                    countQty = countQty.add(entryqty);
                }
                if (qty != null && countQty != null && (BigDecimal.valueOf(diff = qty.doubleValue() - countQty.doubleValue()).compareTo(BigDecimal.ZERO) < 0 || BigDecimal.valueOf(diff).compareTo(BigDecimal.ZERO) > 0)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5355\u636e\u5934\u6570\u91cf \u2260 \u660e\u7ec6\u4fe1\u606f\u6570\u91cf\u5408\u8ba1\u3002", (String)"WorkQtyCollecOpPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]), faultTip));
                }
            }

            private void checkCostObjectMust(ExtendedDataEntity dataEntity, String faultTip) {
                DynamicObject entity = dataEntity.getDataEntity();
                DynamicObject costdriver = entity.getDynamicObject("costdriver");
                if (costdriver == null) {
                    return;
                }
                String allocclass = costdriver.getString("allocclass");
                if (!"COSTOBJECT".equalsIgnoreCase(allocclass)) {
                    return;
                }
                DynamicObjectCollection entryentity = entity.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryentity) {
                    DynamicObject costobject = entry.getDynamicObject("costobject");
                    if (costobject != null) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff1a\u5206\u914d\u5c42\u7ea7\u4e3a\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u65f6\uff0c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4e3a\u5fc5\u5f55\u3002", (String)"WorkQtyCollecOpPlugin_12", (String)"macc-sca-form", (Object[])new Object[0]), faultTip));
                }
            }

            private QFilter getAppIdFilter(ExtendedDataEntity dataEntity) {
                DynamicObject entity = dataEntity.getDataEntity();
                String appId = entity.getString("appnum");
                if ("sca".equals(appId)) {
                    ArrayList<String> appNumListForSca = new ArrayList<String>();
                    appNumListForSca.add("sca");
                    appNumListForSca.add(" ");
                    return new QFilter("appnum", "in", appNumListForSca);
                }
                return new QFilter("appnum", "=", (Object)appId);
            }

            private void checkManuorgObjectMust(ExtendedDataEntity dataEntity, String faultTip) {
                DynamicObject entity = dataEntity.getDataEntity();
                String appnum = entity.getString("appnum");
                long orgId = entity.getLong("org.id");
                DynamicObject manuorg = entity.getDynamicObject("manuorg");
                if (CostAccountHelper.isOrgEnableMulFactory((Long)orgId, (String)appnum) && CadEmptyUtils.isEmpty((DynamicObject)manuorg)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u4fdd\u5b58\u5931\u8d25\u3002\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff1a\u751f\u4ea7\u7ec4\u7ec7\u4e3a\u5fc5\u5f55\u3002", (String)"WorkQtyCollecOpPlugin_13", (String)"macc-sca-form", (Object[])new Object[0]), faultTip));
                }
            }
        });
    }
}

