/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.calc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.JSONUtils;

public class AbsorbCostImportOp
implements IImportPlugin {
    private Log logger = LogFactory.getLog(AbsorbCostImportOp.class);

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        String msg = "";
        HashMap costObjectMap = null;
        try {
            costObjectMap = (HashMap)JSONUtils.cast((String)data.get("costobject").toString(), HashMap.class);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
        if (costObjectMap != null && costObjectMap.get("billno") != null) {
            String costObjectNumber = (String)costObjectMap.get("billno");
            DynamicObject costObject = this.getCostObjectValue(data);
            if (costObject == null || costObjectNumber.equals(costObject.getString("billno"))) {
                String costObjectName = (String)costObjectMap.get("name");
                msg = String.format(ResManager.loadKDString((String)"\u6a21\u677f\u4e2d\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201c%s\u201d\u7684\u751f\u4ea7\u7ec4\u7ec7\u4e0e\u6210\u672c\u4e2d\u5fc3\u4e0e\u6a21\u677f\u7ef4\u62a4\u7684\u751f\u4ea7\u7ec4\u7ec7\u4e0e\u6210\u672c\u4e2d\u5fc3\u4e0d\u4e00\u81f4\u3002", (String)"AbsorbCostImportOp_2", (String)"macc-sca-form", (Object[])new Object[0]), costObjectName);
                importlogs.add(new ImportLogger.ImportLog(msg));
                return false;
            }
        }
        return true;
    }

    private DynamicObject getCostObjectValue(Map<String, Object> data) {
        HashMap acctorgMap = null;
        try {
            acctorgMap = (HashMap)JSONUtils.cast((String)data.get("org").toString(), HashMap.class);
        }
        catch (IOException e) {
            this.logger.error((Throwable)e);
        }
        if (acctorgMap == null) {
            return null;
        }
        HashMap manuorgMap = null;
        try {
            manuorgMap = (HashMap)JSONUtils.cast((String)data.get("manuorg").toString(), HashMap.class);
        }
        catch (IOException e) {
            this.logger.error((Throwable)e);
        }
        if (manuorgMap == null) {
            return null;
        }
        HashMap costcenterMap = null;
        try {
            costcenterMap = (HashMap)JSONUtils.cast((String)data.get("costcenter").toString(), HashMap.class);
        }
        catch (IOException e) {
            this.logger.error((Throwable)e);
        }
        if (costcenterMap == null) {
            return null;
        }
        String acctorgNumber = (String)acctorgMap.get("number");
        String manuorgNumber = (String)manuorgMap.get("number");
        String costcenterNumber = (String)costcenterMap.get("number");
        QFilter acctFilter = new QFilter("org.number", "=", (Object)acctorgNumber);
        QFilter manuorgFilter = new QFilter("manuorg.number", "=", (Object)manuorgNumber);
        QFilter centerFilter = new QFilter("costcenter.number", "=", (Object)costcenterNumber);
        DynamicObject costObjct = QueryServiceHelper.queryOne((String)"cad_costobject", (String)"id, billno, name", (QFilter[])new QFilter[]{acctFilter, manuorgFilter, centerFilter});
        return costObjct;
    }

    public void afterImportData(List<Object> pkIds, List<ImportLogger.ImportLog> importlogs) {
        DynamicObjectCollection billCol = QueryServiceHelper.query((String)"sca_absorbadjust", (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
        if (CollectionUtils.isEmpty((Collection)billCol)) {
            return;
        }
        ArrayList billNos = new ArrayList(pkIds.size());
        billCol.forEach(dyo -> billNos.add(dyo.getString("billno")));
        if (!CollectionUtils.isEmpty(pkIds)) {
            OperationResult submitOpResult = OperationServiceHelper.executeOperate((String)"submit", (String)"sca_absorbadjust", (Object[])pkIds.toArray(), (OperateOption)OperateOption.create());
            if (null != submitOpResult && submitOpResult.isSuccess()) {
                OperationResult auditOpResult = OperationServiceHelper.executeOperate((String)"audit", (String)"sca_absorbadjust", (Object[])pkIds.toArray(), (OperateOption)OperateOption.create());
                if (null == auditOpResult || !auditOpResult.isSuccess()) {
                    importlogs.add(new ImportLogger.ImportLog(String.format("\u6570\u636e\u5bfc\u5165\u6210\u529f\uff0c\u81ea\u52a8\u5ba1\u6838\u5931\u8d25\uff0c\u8bf7\u624b\u5de5\u5ba1\u6838\u5355\u636e\uff0c\u5355\u636e\u7f16\u53f7\uff1a{%s}", billNos)));
                }
            } else {
                importlogs.add(new ImportLogger.ImportLog(String.format("\u6570\u636e\u5bfc\u5165\u6210\u529f\uff0c\u81ea\u52a8\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u624b\u5de5\u63d0\u4ea4\uff0c\u5ba1\u6838\u5355\u636e\uff0c\u5355\u636e\u7f16\u53f7\uff1a{%s}", billNos)));
            }
        }
    }
}

