/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.calc;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.CalcResultHelper;
import kd.macc.sca.algox.utils.PeriodHelper;
import kd.macc.sca.algox.utils.ScaCalcHelper;
import kd.macc.sca.common.costcalc.CalcResultObjectInfo;
import kd.macc.sca.common.costcalc.ShareHelper;
import kd.macc.sca.common.costcalc.groupkey.MatFinalGroupKey;
import kd.macc.sca.opplugin.calc.CostConfirm_ChangeRecord;
import kd.macc.sca.opplugin.calc.CostConfirm_Object;
import kd.macc.sca.opplugin.calc.CostConfirm_Object2Account;
import kd.macc.sca.opplugin.calc.CostUnConfirmPeriodValidator;
import kd.macc.sca.opplugin.calc.FinishDiffBillSearcher;

public class CostConfirmUnconfirmOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CostConfirmUnconfirmOpPlugin.class);
    private FinishDiffBillSearcher finishDiffBillSearcher;
    private CostConfirm_Object costObjectHelper;
    private CostConfirm_ChangeRecord changeRecordHelper;
    private CostConfirm_Object2Account object2AcountHelper;

    public FinishDiffBillSearcher getFinishDiffBillSearcher() {
        if (this.finishDiffBillSearcher == null) {
            this.finishDiffBillSearcher = new FinishDiffBillSearcher();
        }
        return this.finishDiffBillSearcher;
    }

    public CostConfirm_Object getCostObjectHelper() {
        if (this.costObjectHelper == null) {
            this.costObjectHelper = new CostConfirm_Object();
        }
        return this.costObjectHelper;
    }

    public CostConfirm_ChangeRecord getChangeRecordHelper() {
        if (this.changeRecordHelper == null) {
            this.changeRecordHelper = new CostConfirm_ChangeRecord();
        }
        return this.changeRecordHelper;
    }

    public CostConfirm_Object2Account getObject2AcountHelper() {
        if (this.object2AcountHelper == null) {
            this.object2AcountHelper = new CostConfirm_Object2Account();
        }
        return this.object2AcountHelper;
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("bizstatus");
        fieldKeys.add("costobject");
        fieldKeys.add("srcbill");
        fieldKeys.add("period");
        fieldKeys.add("org");
        fieldKeys.add("costaccount");
        fieldKeys.add("costcenter");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        CostUnConfirmPeriodValidator validator = new CostUnConfirmPeriodValidator();
        validator.setFinishDiffBillSearcher(this.getFinishDiffBillSearcher());
        e.getValidators().add(validator);
        logger.info("\u6210\u672c\u786e\u8ba4\u5355\u53cd\u786e\u8ba4\uff1a\u5f00\u59cb");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        FinishDiffBillSearcher billSearcher = this.getFinishDiffBillSearcher();
        if (billSearcher.getCostConfirms().isEmpty()) {
            billSearcher.search(e.getDataEntities());
        }
        List<ExtendedDataEntity> successDataEntities = this.unauditCostAudit(e.getValidExtDataEntities());
        e.getValidExtDataEntities().clear();
        e.getValidExtDataEntities().addAll(successDataEntities);
        List<ExtendedDataEntity> scEntities = this.unConfirmNextPeriodBill(successDataEntities);
        e.getValidExtDataEntities().clear();
        e.getValidExtDataEntities().addAll(scEntities);
    }

    private List<ExtendedDataEntity> unConfirmNextPeriodBill(List<ExtendedDataEntity> successDataEntities) {
        Set<Long> autoNotConfirmIds = this.getNeedUnConfirmBillIds(successDataEntities);
        Set failCostobjectIds = null;
        if (autoNotConfirmIds != null && !autoNotConfirmIds.isEmpty()) {
            OperateOption operate = OperateOption.create();
            operate.setVariableValue("periodCheck", "false");
            OperationResult result = OperationServiceHelper.executeOperate((String)"op_unconfirm", (String)"sca_costconfirm", (Object[])autoNotConfirmIds.toArray(), (OperateOption)operate);
            if (!result.isSuccess()) {
                logger.info("\u53cd\u786e\u8ba4\u672a\u6765\u671f\u95f4\u7684\u6210\u672c\u786e\u8ba4\u5355\u5b58\u5728\u9519\u8bef\uff1a{}", (Object)JSON.toJSONString((Object)result.getAllErrorInfo()));
                QFilter[] filters = new QFilter[]{new QFilter("id", "in", autoNotConfirmIds), new QFilter("bizstatus", "=", (Object)"B")};
                DataSet costConfirm = QueryServiceHelper.queryDataSet((String)"costconfirm", (String)"sca_costconfirm", (String)"id,costobject", (QFilter[])filters, null);
                failCostobjectIds = Sets.newHashSetWithExpectedSize((int)10);
                for (Row row : costConfirm) {
                    failCostobjectIds.add(row.getLong("costobject"));
                }
            }
        }
        if (failCostobjectIds == null) {
            return new ArrayList<ExtendedDataEntity>(successDataEntities);
        }
        ArrayList succObj = Lists.newArrayList();
        for (ExtendedDataEntity dataEntity : successDataEntities) {
            Long costobjectId = dataEntity.getDataEntity().getLong("costobject.id");
            if (!failCostobjectIds.contains(costobjectId)) {
                succObj.add(dataEntity);
                continue;
            }
            String costConfirmBillNo = CostUnConfirmPeriodValidator.buildBillNoString(dataEntity.getDataEntity());
            OperateErrorInfo errInfo = new OperateErrorInfo();
            errInfo.setPkValue(dataEntity.getDataEntity().getPkValue());
            errInfo.setLevel(ErrorLevel.Error);
            errInfo.setMessage(String.format(ResManager.loadKDString((String)"%s\u53cd\u786e\u8ba4\u5931\u8d25\u3002\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u6709\u672a\u6765\u671f\u95f4\u7684\u6210\u672c\u786e\u8ba4\u5355\u9700\u8981\u5220\u9664\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"CostConfirmUnconfirmOpPlugin_12", (String)"macc-sca-form", (Object[])new Object[0]), costConfirmBillNo));
            this.getOperationResult().addErrorInfo(errInfo);
        }
        return succObj;
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        FinishDiffBillSearcher billSearcher = this.getFinishDiffBillSearcher();
        DynamicObject[] successObjs = this.deleteCostAudit(e.getDataEntities());
        if (successObjs.length == 0) {
            return;
        }
        ArrayList<Object> calcResultIds = new ArrayList<Object>(successObjs.length);
        HashSet<Long> costConfirmIds = new HashSet<Long>(successObjs.length);
        HashSet<Long> finishDiffIds = new HashSet<Long>(successObjs.length);
        HashSet<Long> costObjectIds = new HashSet<Long>(successObjs.length);
        Long orgId = null;
        Long costAccountId = null;
        Long periodId = null;
        for (DynamicObject dataEntity : successObjs) {
            if (CadEmptyUtils.isEmpty(orgId)) {
                orgId = dataEntity.getLong("org.id");
            }
            if (CadEmptyUtils.isEmpty(costAccountId)) {
                costAccountId = dataEntity.getLong("costaccount.id");
            }
            if (CadEmptyUtils.isEmpty(periodId)) {
                periodId = dataEntity.getLong("period.id");
            }
            Long costConfirmId = (Long)dataEntity.getPkValue();
            costConfirmIds.add(costConfirmId);
            Long calcResultId = dataEntity.getLong("srcbill");
            calcResultIds.add(calcResultId);
            Set<Long> set1 = billSearcher.getCostConfirm2FinishDiff().get(costConfirmId);
            if (set1 != null) {
                finishDiffIds.addAll(set1);
            }
            Long costObjectId = dataEntity.getLong("costobject.id");
            costObjectIds.add(costObjectId);
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sca_finishdiffbill"), (Object[])finishDiffIds.toArray());
        this.updateBizStatus(successObjs);
        Map mainJoinSideCalcResultInfo = ScaCalcHelper.getMainJoinSideCalcResultInfo((Long)orgId, (Long)costAccountId, periodId, (Long)PeriodHelper.getPrePeriodId(periodId), costObjectIds);
        this.unMainJoinShare(calcResultIds, mainJoinSideCalcResultInfo);
        CalcResultHelper.updateDiff(calcResultIds, (String)"2");
        HashSet<Long> confirmObject = new HashSet<Long>(10);
        HashMap<Long, Set<Long>> confirmObjAcct = new HashMap<Long, Set<Long>>(10);
        this.getConfirmBill(costConfirmIds, costObjectIds, confirmObject, confirmObjAcct);
        this.getCostObjectHelper().updateStatus(successObjs, mainJoinSideCalcResultInfo, "A", confirmObject);
        this.getObject2AcountHelper().updateStatus(successObjs, mainJoinSideCalcResultInfo, "A", confirmObjAcct);
        this.getChangeRecordHelper().updateStatus(successObjs, mainJoinSideCalcResultInfo, "A");
        CalcResultHelper.updateBizStatus(calcResultIds, (String)"A");
        logger.info(String.format("\u53cd\u786e\u8ba4\u6210\u529f %s \u5f20", successObjs.length));
    }

    private Set<Long> getNeedUnConfirmBillIds(List<ExtendedDataEntity> successDataEntities) {
        if (successDataEntities == null || successDataEntities.isEmpty()) {
            return null;
        }
        long orgId = 0L;
        long costAccountId = 0L;
        long periodId = 0L;
        HashSet costobjectIds = Sets.newHashSetWithExpectedSize((int)10);
        for (ExtendedDataEntity entity : successDataEntities) {
            if (CadEmptyUtils.isEmpty((Long)orgId)) {
                orgId = entity.getDataEntity().getLong("org.id");
                costAccountId = entity.getDataEntity().getLong("costaccount.id");
                periodId = entity.getDataEntity().getLong("period.id");
            }
            costobjectIds.add(entity.getDataEntity().getLong("costobject.id"));
        }
        long nextPeriodId = PeriodHelper.getNextPeriodId((Object)periodId);
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("costobject", "in", (Object)costobjectIds), new QFilter("costaccount", "=", (Object)costAccountId), new QFilter("period", "=", (Object)nextPeriodId), new QFilter("bizstatus", "=", (Object)"B")};
        DataSet costConfirm = QueryServiceHelper.queryDataSet((String)"costconfirm", (String)"sca_costconfirm", (String)"id,costobject", (QFilter[])filters, null);
        HashSet costconfirmIds = Sets.newHashSetWithExpectedSize((int)10);
        for (Row row : costConfirm) {
            costconfirmIds.add(row.getLong("id"));
        }
        return costconfirmIds;
    }

    private void unMainJoinShare(List<Object> calcResultIds, Map<Long, Map<Long, CalcResultObjectInfo>> mainJoinSideCalcResultInfo) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"sca_calcresult");
        Object[] calcResults = BusinessDataServiceHelper.load((Object[])calcResultIds.toArray(new Object[0]), (DynamicObjectType)type);
        if (!CadEmptyUtils.isEmpty((Object[])calcResults)) {
            for (Object calcResult : calcResults) {
                String productType;
                MatFinalGroupKey key;
                long costObjectId = calcResult.getLong("costobject.id");
                Map<Long, CalcResultObjectInfo> objectInfoMap = mainJoinSideCalcResultInfo.get(costObjectId);
                if (objectInfoMap == null || !ShareHelper.existsJoinPro(objectInfoMap)) continue;
                long orgId = calcResult.getLong("org.id");
                long costAccountId = calcResult.getLong("costaccount.id");
                long costCenterId = calcResult.getLong("costcenter.id");
                DynamicObjectCollection entryEntitys = calcResult.getDynamicObjectCollection("entryentity");
                HashMap sumMap = Maps.newHashMapWithExpectedSize((int)16);
                HashMap groupMap = Maps.newHashMapWithExpectedSize((int)(entryEntitys.size() - 2));
                for (DynamicObject entryEntity : entryEntitys) {
                    String calType = entryEntity.getString("caltype");
                    key = new MatFinalGroupKey(Long.valueOf(orgId), Long.valueOf(costAccountId), Long.valueOf(costCenterId), Long.valueOf(costObjectId), Long.valueOf(entryEntity.getLong("obj.id")), entryEntity.getString("producttype"), Long.valueOf(entryEntity.getLong("resource.id")), entryEntity.getString("costlevel"), entryEntity.getString("calcbasis"), Long.valueOf(entryEntity.getLong("element.id")), Long.valueOf(entryEntity.getLong("subelement.id")), Long.valueOf(entryEntity.getLong("material.id")), Long.valueOf(entryEntity.getLong("auxpty.id")), Long.valueOf(entryEntity.getLong("matversion.id")), entryEntity.getString("datatype"), entryEntity.getString("difftype"), entryEntity.getString("keycol"), Long.valueOf(entryEntity.getLong("keycolid.id")));
                    if ("3".equals(calType) || "4".equals(calType)) {
                        groupMap.put(key, entryEntity);
                    }
                    if (!"5".equals(calType)) continue;
                    sumMap.put(key, entryEntity);
                }
                BigDecimal mainTotal = BigDecimal.ZERO;
                for (Map.Entry groupMapEntry : groupMap.entrySet()) {
                    key = (MatFinalGroupKey)groupMapEntry.getKey();
                    DynamicObject mainRow = (DynamicObject)groupMapEntry.getValue();
                    productType = key.getProductType();
                    BigDecimal mainDiffAmt = mainRow.getBigDecimal("diff");
                    BigDecimal mainDiffQty = mainRow.getBigDecimal("diffqty");
                    if (!"C".equals(productType)) continue;
                    if (ScaCalcHelper.isContainsProductFacted(objectInfoMap, (String)"A") && (BigDecimal.ZERO.compareTo(mainDiffAmt) != 0 || BigDecimal.ZERO.compareTo(mainDiffQty) != 0)) {
                        logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61:{}\u5b58\u5728\u8054\u4ea7\u54c1\u5b8c\u5de5\u9700\u8981\u91cd\u65b0\u6574\u5408\u5b8c\u5de5\u5dee\u5f02");
                        Map<Long, CalcResultObjectInfo> objInfoMap = mainJoinSideCalcResultInfo.get(costObjectId);
                        for (Map.Entry<Long, CalcResultObjectInfo> entry : objInfoMap.entrySet()) {
                            CalcResultObjectInfo objectInfo = entry.getValue();
                            if (!"A".equals(objectInfo.getProductType())) continue;
                            long joinObj = objectInfo.getCostObjectId();
                            MatFinalGroupKey joinKey = new MatFinalGroupKey(key.getOrgId(), key.getCostAccountId(), key.getCostCenterid(), key.getCostObjectId(), Long.valueOf(joinObj), "A", key.getResourceId(), key.getCostLevel(), key.getCalcBasis(), key.getElementId(), key.getSubelementId(), key.getMaterialId(), key.getAuxptyId(), key.getMatVersionId(), key.getDataType(), key.getDiffType(), key.getKeycol(), key.getKeycolId());
                            if (groupMap.containsKey(joinKey)) {
                                DynamicObject joinRow = (DynamicObject)groupMap.get(joinKey);
                                BigDecimal joinDiffAmt = joinRow.getBigDecimal("diff");
                                BigDecimal joinDiffQty = joinRow.getBigDecimal("diffqty");
                                mainDiffAmt = mainDiffAmt.add(joinDiffAmt);
                                mainDiffQty = mainDiffQty.add(joinDiffQty);
                                joinRow.set("diff", (Object)BigDecimal.ZERO);
                                joinRow.set("diffqty", (Object)BigDecimal.ZERO);
                                continue;
                            }
                            logger.info("\u4e3b\u4ea7\u54c1key\uff1a{}\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8054\u4ea7\u54c1key\uff1a{}\u884c", (Object)key, (Object)joinKey);
                        }
                    }
                    if ("2".equals(key.getDataType())) {
                        mainTotal = mainTotal.add(mainDiffAmt);
                    }
                    mainRow.set("diffqty", (Object)mainDiffQty);
                    mainRow.set("diff", (Object)mainDiffAmt);
                }
                for (Map.Entry matFinalGroupEntry : sumMap.entrySet()) {
                    key = (MatFinalGroupKey)matFinalGroupEntry.getKey();
                    DynamicObject value = (DynamicObject)matFinalGroupEntry.getValue();
                    productType = key.getProductType();
                    if ("C".equals(productType)) {
                        value.set("diff", (Object)mainTotal);
                        continue;
                    }
                    if (!"A".equals(productType)) continue;
                    value.set("diff", (Object)BigDecimal.ZERO);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])calcResults);
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        logger.info("\u6210\u672c\u786e\u8ba4\u5355\u53cd\u786e\u8ba4\uff1a\u7ed3\u675f");
    }

    private List<ExtendedDataEntity> unauditCostAudit(List<ExtendedDataEntity> dataEntities) {
        FinishDiffBillSearcher billSearcher = this.getFinishDiffBillSearcher();
        HashSet<Long> allCostAdjustIds = new HashSet<Long>();
        HashSet<Long> costAdjustIds = new HashSet<Long>();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Long costConfirmId = (Long)dataEntity.getDataEntity().getPkValue();
            Set<Long> finishDiffIdSet = billSearcher.getCostConfirm2FinishDiff().get(costConfirmId);
            if (finishDiffIdSet == null) continue;
            for (Long finishDiffId : finishDiffIdSet) {
                Set<Long> set = billSearcher.getFinishDiff2CostAdjust().get(finishDiffId);
                if (set == null) continue;
                allCostAdjustIds.addAll(set);
                for (Long costAdjustId : set) {
                    DynamicObject obj = billSearcher.getCostAdjusts().get(costAdjustId);
                    if (obj == null || !StringUtils.equals((CharSequence)"C", (CharSequence)obj.getString("billstatus"))) continue;
                    costAdjustIds.add(costAdjustId);
                }
            }
        }
        if (costAdjustIds.isEmpty()) {
            if (!allCostAdjustIds.isEmpty()) {
                logger.info(String.format("\u627e\u5230\u4e86\u5173\u8054\u7684%s\u5f20\u6210\u672c\u8c03\u6574\u5355\uff0c\u5747\u4e0d\u662f\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u65e0\u9700\u53cd\u5ba1\u6838\u3002", allCostAdjustIds.size()));
            }
            return new ArrayList<ExtendedDataEntity>(dataEntities);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("diffAlloc", "true");
        OperationResult unauditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_stdcostdiffbill", (Object[])costAdjustIds.toArray(), (OperateOption)option);
        logger.info(String.format("\u53cd\u5ba1\u6838\u6210\u672c\u8c03\u6574\u5355%s\u5f20\uff0c\u6210\u529f%s\u5f20", costAdjustIds.size(), unauditResult.getSuccessPkIds().size()));
        HashMap<Long, Set> failCostConfirmIds = new HashMap<Long, Set>();
        QFilter adjustidQF = new QFilter("id", "in", allCostAdjustIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".unauditCostAudit"), (String)"cal_stdcostdiffbill", (String)"id,billno,billstatus", (QFilter[])new QFilter[]{adjustidQF}, null);
        Object object = null;
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                if (StringUtils.equals((CharSequence)"A", (CharSequence)row.getString("billstatus"))) continue;
                Long costAdjustId = row.getLong("id");
                Set<Long> srcCostConfirmIds = billSearcher.getCostConfirmIdByCostAdjustId(costAdjustId);
                for (Long costConfirmId : srcCostConfirmIds) {
                    Set set = failCostConfirmIds.computeIfAbsent(costConfirmId, s -> new HashSet());
                    set.add(costAdjustId);
                }
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        ArrayList<ExtendedDataEntity> successList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Long costConfirmId = (Long)dataEntity.getDataEntity().getPkValue();
            Set set = (Set)failCostConfirmIds.get(costConfirmId);
            if (set == null) {
                successList.add(dataEntity);
                continue;
            }
            for (Long costAdjustId : set) {
                String costConfirmBillNo = CostUnConfirmPeriodValidator.buildBillNoString(dataEntity.getDataEntity());
                String costAdjustBillNo = String.valueOf(costAdjustId);
                DynamicObject costAdjustObj = billSearcher.getCostAdjusts().get(costAdjustId);
                if (costAdjustObj != null) {
                    costAdjustBillNo = costAdjustObj.getString("billno");
                }
                OperateErrorInfo errInfo = new OperateErrorInfo();
                errInfo.setPkValue((Object)costConfirmId);
                errInfo.setLevel(ErrorLevel.Error);
                errInfo.setMessage(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u53cd\u786e\u8ba4\u5931\u8d25\uff1a\u5173\u8054\u7684\u5b58\u8d27\u6838\u7b97\u6210\u672c\u8c03\u6574\u5355\u201c%2$s\u201d\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u8bf7\u624b\u5de5\u53cd\u5ba1\u6838\u3002", (String)"CostConfirmUnconfirmOpPlugin_10", (String)"macc-sca-form", (Object[])new Object[0]), costConfirmBillNo, costAdjustBillNo));
                this.getOperationResult().addErrorInfo(errInfo);
            }
        }
        return successList;
    }

    private DynamicObject[] deleteCostAudit(DynamicObject[] dataEntities) {
        FinishDiffBillSearcher billSearcher = this.getFinishDiffBillSearcher();
        HashSet<Long> costAdjustIds = new HashSet<Long>();
        for (DynamicObject dataEntity : dataEntities) {
            Long costConfirmId = (Long)dataEntity.getPkValue();
            Set<Long> finishDiffIdSet = billSearcher.getCostConfirm2FinishDiff().get(costConfirmId);
            if (finishDiffIdSet == null) continue;
            for (Long finishDiffId : finishDiffIdSet) {
                Set<Long> set = billSearcher.getFinishDiff2CostAdjust().get(finishDiffId);
                if (set == null) continue;
                costAdjustIds.addAll(set);
            }
        }
        if (costAdjustIds.isEmpty()) {
            logger.info("\u6ca1\u6709\u627e\u5230\u9700\u8981\u540c\u6b65\u5220\u9664\u7684\u6210\u672c\u8c03\u6574\u5355");
            return dataEntities;
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cal_stdcostdiffbill"), (Object[])costAdjustIds.toArray());
        HashMap<Long, Set> failCostConfirmIds = new HashMap<Long, Set>();
        int failAdjustCount = 0;
        QFilter adjustidQF = new QFilter("id", "in", costAdjustIds);
        DynamicObject[] dynamicObjectArray = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".deleteCostAudit"), (String)"cal_stdcostdiffbill", (String)"id,billno,billstatus", (QFilter[])new QFilter[]{adjustidQF}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long costAdjustId = row.getLong("id");
                Set<Long> srcCostConfirmIds = billSearcher.getCostConfirmIdByCostAdjustId(costAdjustId);
                for (Long costConfirmId : srcCostConfirmIds) {
                    Set set = failCostConfirmIds.computeIfAbsent(costConfirmId, s -> new HashSet());
                    set.add(costAdjustId);
                }
                ++failAdjustCount;
            }
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        logger.info(String.format("\u5220\u9664\u6210\u672c\u8c03\u6574\u5355%s\u5f20\uff0c\u5931\u8d25%s\u5f20", costAdjustIds.size(), failAdjustCount));
        ArrayList<DynamicObject> successList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            Long costConfirmId = (Long)dataEntity.getPkValue();
            Set set = (Set)failCostConfirmIds.get(costConfirmId);
            if (set == null) {
                successList.add(dataEntity);
                continue;
            }
            for (Long costAdjustId : set) {
                String costConfirmBillNo = CostUnConfirmPeriodValidator.buildBillNoString(dataEntity);
                String costAdjustBillNo = String.valueOf(costAdjustId);
                DynamicObject costAdjustObj = billSearcher.getCostAdjusts().get(costAdjustId);
                if (costAdjustObj != null) {
                    costAdjustBillNo = costAdjustObj.getString("billno");
                }
                OperateErrorInfo errInfo = new OperateErrorInfo();
                errInfo.setPkValue((Object)costConfirmId);
                errInfo.setLevel(ErrorLevel.Error);
                errInfo.setMessage(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u53cd\u786e\u8ba4\u5931\u8d25\uff1a\u5173\u8054\u7684\u5b58\u8d27\u6838\u7b97\u6210\u672c\u8c03\u6574\u5355\u201c%2$s\u201d\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u624b\u5de5\u5220\u9664\u3002", (String)"CostConfirmUnconfirmOpPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]), costConfirmBillNo, costAdjustBillNo));
                this.getOperationResult().addErrorInfo(errInfo);
            }
        }
        return successList.toArray(new DynamicObject[0]);
    }

    private void updateBizStatus(DynamicObject[] dataEntities) {
        for (DynamicObject costConfirm : dataEntities) {
            costConfirm.set("bizstatus", (Object)"A");
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        logger.info(String.format("\u5171\u66f4\u65b0 %s \u5f20\u6210\u672c\u786e\u8ba4\u5355\u7684\u72b6\u6001\u4e3a\u672a\u786e\u8ba4", dataEntities.length));
    }

    private void getConfirmBill(Set<Long> costConfirmIds, Set<Long> costObjectIds, Set<Long> costObjectInfo, Map<Long, Set<Long>> objectAccountInfo) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "not in", costConfirmIds), new QFilter("costobject", "in", costObjectIds), new QFilter("bizstatus", "=", (Object)"B")};
        DynamicObjectCollection costConfirm = QueryServiceHelper.query((String)"sca_costconfirm", (String)"costobject.id AS costobject,costaccount.id AS costaccount", (QFilter[])filters);
        for (DynamicObject confirm : costConfirm) {
            Long costAccountId = confirm.getLong("costaccount");
            Long costObjectId = confirm.getLong("costobject");
            costObjectInfo.add(costObjectId);
            Set set = objectAccountInfo.computeIfAbsent(costAccountId, s -> new HashSet());
            set.add(costObjectId);
        }
    }
}

