/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.calc;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.common.costcalc.CalcResultObjectInfo;

class CostConfirm_Object {
    private static final Log logger = LogFactory.getLog(CostConfirm_Object.class);

    CostConfirm_Object() {
    }

    public void updateStatus(DynamicObject[] costConfirms, Map<Long, Map<Long, CalcResultObjectInfo>> mainJoinSideCalcResultInfo, String status, Set<Long> notInCostObjectIds) {
        if (costConfirms == null) {
            return;
        }
        HashSet<Long> costObjectIds = new HashSet<Long>(costConfirms.length);
        for (DynamicObject data : costConfirms) {
            Long costObjectId = data.getLong("costobject.id");
            if (notInCostObjectIds != null && notInCostObjectIds.contains(costObjectId)) continue;
            if (mainJoinSideCalcResultInfo.containsKey(costObjectId)) {
                costObjectIds.addAll(mainJoinSideCalcResultInfo.get(costObjectId).keySet());
                continue;
            }
            costObjectIds.add(costObjectId);
        }
        if (CadEmptyUtils.isEmpty(costObjectIds)) {
            return;
        }
        ArrayList<String> selectKeys = new ArrayList<String>(4);
        selectKeys.add("id");
        selectKeys.add("bizstatus");
        selectKeys.add("modifier");
        selectKeys.add("modifytime");
        MainEntityType subMainType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)"cad_costobject", selectKeys);
        DynamicObject[] costObjects = BusinessDataServiceHelper.load((Object[])costObjectIds.toArray(), (DynamicObjectType)subMainType);
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        Date modifyTime = TimeServiceHelper.now();
        for (DynamicObject costObject : costObjects) {
            costObject.set("bizstatus", (Object)status);
            costObject.set("modifier", (Object)userId);
            costObject.set("modifytime", (Object)modifyTime);
        }
        SaveServiceHelper.save((DynamicObject[])costObjects);
        logger.info(String.format("\u5171\u66f4\u65b0 %s \u5f20\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7684\u72b6\u6001", costObjects.length));
    }
}

