/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.calc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CostCloseAccountHelper;
import kd.macc.sca.opplugin.calc.FinishDiffBillSearcher;

public class CostUnConfirmPeriodValidator
extends AbstractValidator {
    private FinishDiffBillSearcher finishDiffBillSearcher;

    public FinishDiffBillSearcher getFinishDiffBillSearcher() {
        if (this.finishDiffBillSearcher == null) {
            this.finishDiffBillSearcher = new FinishDiffBillSearcher();
        }
        return this.finishDiffBillSearcher;
    }

    public void setFinishDiffBillSearcher(FinishDiffBillSearcher finishDiffBillSearcher) {
        this.finishDiffBillSearcher = finishDiffBillSearcher;
    }

    public void validate() {
        ExtendedDataEntity[] passDataEntities = this.getDataEntities();
        passDataEntities = this.checkPeriod(passDataEntities);
        passDataEntities = this.checkBizStatus(passDataEntities);
        passDataEntities = this.checkFinishDiff(passDataEntities);
    }

    private ExtendedDataEntity[] checkPeriod(ExtendedDataEntity[] dataEntities) {
        ArrayList<ExtendedDataEntity> passList = new ArrayList<ExtendedDataEntity>(dataEntities.length);
        HashMap<Long, Long> costaccountMap = new HashMap<Long, Long>();
        HashMap<String, Boolean> acctPeriodManuCloseMap = new HashMap<String, Boolean>();
        boolean periodCheck = !this.getOption().containsVariable("periodCheck");
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String billNo;
            String costObjectNumber;
            DynamicObject costConfirm = dataEntity.getDataEntity();
            DynamicObject costobject = costConfirm.getDynamicObject("costobject");
            String string = costObjectNumber = costobject == null ? "" : costobject.getString("billno");
            if (!"B".equals(costConfirm.getString("bizstatus"))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4e3a\u201c%s\u201d\u7684\u5355\u636e\u53cd\u786e\u8ba4\u5931\u8d25\uff1a\u6b64\u5355\u636e\u5df2\u662f\u672a\u786e\u8ba4\u72b6\u6001\u3002", (String)"CostUnConfirmPeriodValidator_0", (String)"macc-sca-form", (Object[])new Object[0]), costObjectNumber));
                continue;
            }
            Long costAccountId = costConfirm.getLong("costaccount.id");
            Long orgId = costConfirm.getLong("org.id");
            Long periodId = costConfirm.getLong("period.id");
            if (costAccountId == null || Long.compare(0L, costAccountId) == 0) {
                billNo = CostUnConfirmPeriodValidator.buildBillNoString(costConfirm);
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\uff1a\u6210\u672c\u8d26\u7c3f\u4e3a\u7a7a\u3002", (String)"CostUnConfirmPeriodValidator_1", (String)"macc-sca-form", (Object[])new Object[0]), billNo));
                continue;
            }
            if (orgId == null || Long.compare(0L, orgId) == 0) {
                billNo = CostUnConfirmPeriodValidator.buildBillNoString(costConfirm);
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\uff1a\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"CostUnConfirmPeriodValidator_2", (String)"macc-sca-form", (Object[])new Object[0]), billNo));
                continue;
            }
            if (periodId == null || Long.compare(0L, periodId) == 0) {
                billNo = CostUnConfirmPeriodValidator.buildBillNoString(costConfirm);
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\uff1a\u671f\u95f4\u4e3a\u7a7a\u3002", (String)"CostUnConfirmPeriodValidator_3", (String)"macc-sca-form", (Object[])new Object[0]), billNo));
                continue;
            }
            Long currPeriod = (Long)costaccountMap.get(costAccountId);
            if (currPeriod == null) {
                currPeriod = this.getPeriod(orgId, costAccountId);
                costaccountMap.put(costAccountId, currPeriod);
            }
            if (periodCheck && Long.compare(periodId, currPeriod) != 0) {
                String billNo2 = CostUnConfirmPeriodValidator.buildBillNoString(costConfirm);
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\uff1a\u6838\u7b97\u671f\u95f4 \u2260 \u8d26\u7c3f\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u53cd\u786e\u8ba4\u3002", (String)"CostUnConfirmPeriodValidator_4", (String)"macc-sca-form", (Object[])new Object[0]), billNo2));
                continue;
            }
            Long manuOrg = costobject == null ? 0L : costobject.getLong("manuorg.id");
            if (manuOrg != 0L) {
                String key = String.format("%s@%s@%s@%s", orgId, manuOrg, costAccountId, periodId);
                Boolean closeFlag = false;
                if (acctPeriodManuCloseMap.containsKey(key)) {
                    closeFlag = (Boolean)acctPeriodManuCloseMap.get(key);
                } else {
                    closeFlag = CostCloseAccountHelper.checkIsCloseAccount((Long)orgId, (Long)manuOrg, (Long)costAccountId, (Long)periodId);
                    acctPeriodManuCloseMap.put(key, closeFlag);
                }
                if (closeFlag.booleanValue()) {
                    String billNo3 = CostUnConfirmPeriodValidator.buildBillNoString(costConfirm);
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u671f\u95f4\u5df2\u5173\u8d26\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u786e\u8ba4\u3002", (String)"CostUnConfirmPeriodValidator_5", (String)"macc-sca-form", (Object[])new Object[0]), billNo3));
                    continue;
                }
            }
            passList.add(dataEntity);
        }
        return passList.toArray(new ExtendedDataEntity[0]);
    }

    private ExtendedDataEntity[] checkBizStatus(ExtendedDataEntity[] dataEntities) {
        ArrayList<ExtendedDataEntity> passList = new ArrayList<ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject costConfirm = dataEntity.getDataEntity();
            String bizstatus = costConfirm.getString("bizstatus");
            if ("A".equals(bizstatus)) {
                String billNo = CostUnConfirmPeriodValidator.buildBillNoString(costConfirm);
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\uff1a\u672a\u786e\u8ba4\u5355\u636e\u4e0d\u80fd\u53cd\u786e\u8ba4\u3002", (String)"CostUnConfirmPeriodValidator_6", (String)"macc-sca-form", (Object[])new Object[0]), billNo));
                continue;
            }
            passList.add(dataEntity);
        }
        return passList.toArray(new ExtendedDataEntity[0]);
    }

    private ExtendedDataEntity[] checkFinishDiff(ExtendedDataEntity[] dataEntities) {
        ArrayList<ExtendedDataEntity> passList = new ArrayList<ExtendedDataEntity>(dataEntities.length);
        FinishDiffBillSearcher billSearcher = this.getFinishDiffBillSearcher();
        if (billSearcher.getCostConfirms().isEmpty()) {
            DynamicObject[] objs = new DynamicObject[dataEntities.length];
            for (int i = 0; i < dataEntities.length; ++i) {
                objs[i] = dataEntities[i].getDataEntity();
            }
            if (objs.length > 0) {
                billSearcher.search(objs);
            }
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            if (!this.checkFinishDiff(dataEntity)) continue;
            passList.add(dataEntity);
        }
        return passList.toArray(new ExtendedDataEntity[0]);
    }

    private boolean checkFinishDiff(ExtendedDataEntity dataEntity) {
        FinishDiffBillSearcher billSearcher = this.getFinishDiffBillSearcher();
        Long costConfirmId = (Long)dataEntity.getDataEntity().getPkValue();
        Set<Long> finishDiffIdSet = billSearcher.getCostConfirm2FinishDiff().get(costConfirmId);
        if (finishDiffIdSet == null || finishDiffIdSet.isEmpty()) {
            return true;
        }
        for (Long finishDiffId : finishDiffIdSet) {
            String voucher;
            DynamicObject finishDiffObj = billSearcher.getFinishDiffBills().get(finishDiffId);
            if (finishDiffObj != null && StringUtils.isNotBlank((CharSequence)(voucher = finishDiffObj.getString("vouchernum")))) {
                String finishDiffBillNo = finishDiffObj.getString("billno");
                String costConfirmBillNo = CostUnConfirmPeriodValidator.buildBillNoString(dataEntity.getDataEntity());
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5173\u8054\u7684\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355%2$s\uff0c\u5df2\u751f\u6210\u51ed\u8bc1%3$s\uff0c\u4e0d\u5141\u8bb8\u53cd\u786e\u8ba4\u3002", (String)"CostUnConfirmPeriodValidator_10", (String)"macc-sca-form", (Object[])new Object[0]), costConfirmBillNo, finishDiffBillNo, voucher));
                return false;
            }
            Set<Long> costAdjustIdSet = billSearcher.getFinishDiff2CostAdjust().get(finishDiffId);
            if (costAdjustIdSet == null || costAdjustIdSet.isEmpty()) continue;
            for (Long costAdjustId : costAdjustIdSet) {
                boolean isvoucher;
                DynamicObject costAdjustObj = billSearcher.getCostAdjusts().get(costAdjustId);
                if (costAdjustObj == null || !(isvoucher = costAdjustObj.getBoolean("isvoucher"))) continue;
                String voucher2 = costAdjustObj.getString("vouchernum");
                String adjustBillNo = costAdjustObj.getString("billno");
                String costConfirmBillNo = CostUnConfirmPeriodValidator.buildBillNoString(dataEntity.getDataEntity());
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5173\u8054\u7684\u6210\u672c\u8c03\u8282\u5355%2$s\uff0c\u5df2\u751f\u6210\u51ed\u8bc1%3$s\uff0c\u4e0d\u5141\u8bb8\u53cd\u786e\u8ba4\u3002", (String)"CostUnConfirmPeriodValidator_11", (String)"macc-sca-form", (Object[])new Object[0]), costConfirmBillNo, adjustBillNo, voucher2));
                return false;
            }
        }
        return true;
    }

    private Long getPeriod(Long orgId, Long costaccountId) {
        if (orgId == null || costaccountId == null) {
            return null;
        }
        QFilter orgQF = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQF = new QFilter("entry.costaccount", "=", (Object)costaccountId);
        DynamicObjectCollection res = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id, entry.currentperiod AS currentperiod", (QFilter[])new QFilter[]{orgQF, costaccountQF});
        if (res == null || res.size() == 0) {
            return null;
        }
        return ((DynamicObject)res.get(0)).getLong("currentperiod");
    }

    public static String buildBillNoString(DynamicObject costConfirm) {
        DynamicObject costaccount = costConfirm.getDynamicObject("costaccount");
        DynamicObject period = costConfirm.getDynamicObject("period");
        DynamicObject costObject = costConfirm.getDynamicObject("costobject");
        String acctName = costaccount == null ? "" : costaccount.getString("name");
        String periodName = period == null ? "" : period.getString("name");
        String costObjectName = costObject == null ? "" : costObject.getString("name");
        return String.format(ResManager.loadKDString((String)"\u8d26\u7c3f\u3010%1$s\u3011-\u671f\u95f4\u3010%2$s\u3011-\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3010%3$s\u3011", (String)"CostUnConfirmPeriodValidator_12", (String)"macc-sca-form", (Object[])new Object[0]), acctName, periodName, costObjectName);
    }
}

