/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.calc;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.algox.utils.PeriodHelper;
import kd.macc.sca.algox.utils.ScaCalcHelper;
import kd.macc.sca.common.costcalc.CalcResultObjectInfo;
import kd.macc.sca.opplugin.calc.CostConfirm_HeaderKey;

public class FinishDiffBillSearcher {
    private static final Log logger = LogFactory.getLog(FinishDiffBillSearcher.class);
    private MainEntityType subFinishDiffBillType;
    private MainEntityType subCostAdjustType;
    private Map<Long, DynamicObject> costConfirms = new HashMap<Long, DynamicObject>();
    private Map<Long, DynamicObject> finishDiffBills = new HashMap<Long, DynamicObject>();
    private Map<Long, DynamicObject> costAdjusts = new HashMap<Long, DynamicObject>();
    private Map<Long, Set<Long>> costConfirm2FinishDiff = new HashMap<Long, Set<Long>>();
    private Map<Long, Long> finishDiff2CostConfim = new HashMap<Long, Long>();
    private Map<Long, Set<Long>> finishDiff2CostAdjust = new HashMap<Long, Set<Long>>();
    private Map<Long, Set<Long>> costAdjust2FinishDiffs = new HashMap<Long, Set<Long>>();

    public MainEntityType getSubFinishDiffBillType() {
        if (this.subFinishDiffBillType == null) {
            ArrayList<String> selectKeys = new ArrayList<String>(8);
            selectKeys.add("id");
            selectKeys.add("billno");
            selectKeys.add("org");
            selectKeys.add("costaccount");
            selectKeys.add("period");
            selectKeys.add("costcenter");
            selectKeys.add("costobject");
            selectKeys.add("sourcebill");
            selectKeys.add("vouchernum");
            selectKeys.add("adjustbill");
            this.subFinishDiffBillType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)"sca_finishdiffbill", selectKeys);
        }
        return this.subFinishDiffBillType;
    }

    public MainEntityType getSubCostAdjustType() {
        if (this.subCostAdjustType == null) {
            ArrayList<String> selectKeys = new ArrayList<String>(8);
            selectKeys.add("id");
            selectKeys.add("billno");
            selectKeys.add("billstatus");
            selectKeys.add("isvoucher");
            selectKeys.add("vouchernum");
            this.subCostAdjustType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)"cal_stdcostdiffbill", selectKeys);
        }
        return this.subCostAdjustType;
    }

    public void clear() {
        this.costConfirms.clear();
        this.finishDiffBills.clear();
        this.costAdjusts.clear();
        this.costConfirm2FinishDiff.clear();
        this.finishDiff2CostConfim.clear();
        this.finishDiff2CostAdjust.clear();
        this.costAdjust2FinishDiffs.clear();
    }

    public void search(DynamicObject[] dataEntities) {
        this.clear();
        HashMap<CostConfirm_HeaderKey, List> groupByCostObjects = new HashMap<CostConfirm_HeaderKey, List>(dataEntities.length);
        HashSet<Long> costObjectIds = new HashSet<Long>(16);
        for (DynamicObject costConfirm : dataEntities) {
            this.costConfirms.put((Long)costConfirm.getPkValue(), costConfirm);
            CostConfirm_HeaderKey key = new CostConfirm_HeaderKey(costConfirm.getLong("org.id"), costConfirm.getLong("costaccount.id"), costConfirm.getLong("period.id"), costConfirm.getLong("costcenter.id"), costConfirm.getLong("costobject.id"));
            List list = groupByCostObjects.computeIfAbsent(key, s -> new ArrayList(1));
            list.add(costConfirm);
            costObjectIds.add(costConfirm.getLong("costobject.id"));
        }
        DynamicObject costConfirm = dataEntities[0];
        long orgId = costConfirm.getLong("org.id");
        long costAccountId = costConfirm.getLong("costaccount.id");
        long periodId = costConfirm.getLong("period.id");
        Map mainJoinSideCalcResultInfo = ScaCalcHelper.getMainJoinSideCalcResultInfo((Long)orgId, (Long)costAccountId, (Long)periodId, (Long)PeriodHelper.getPrePeriodId((Object)periodId), costObjectIds);
        DynamicObject[] finishDiffObjs = this.loadFinishDiffBill(dataEntities, mainJoinSideCalcResultInfo);
        if (finishDiffObjs.length == 0) {
            logger.info("\u6ca1\u6709\u53d6\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355");
            return;
        }
        int nullAdjustCount = 0;
        for (DynamicObject finishdiffBill : finishDiffObjs) {
            Long finishdiffBillId = finishdiffBill.getLong("id");
            this.finishDiffBills.put(finishdiffBillId, finishdiffBill);
            Long srcCostConfirmId = finishdiffBill.getLong("sourcebill");
            if (srcCostConfirmId == null || Long.compare(0L, srcCostConfirmId) == 0 || !this.costConfirms.containsKey(srcCostConfirmId)) {
                CostConfirm_HeaderKey key = new CostConfirm_HeaderKey(finishdiffBill.getLong("org.id"), finishdiffBill.getLong("costaccount.id"), finishdiffBill.getLong("period.id"), finishdiffBill.getLong("costcenter.id"), finishdiffBill.getLong("costobject.id"));
                List srcCostConfirms = (List)groupByCostObjects.get(key);
                if (srcCostConfirms == null || srcCostConfirms.isEmpty()) continue;
                String billno = finishdiffBill.getString("billno");
                logger.warn(String.format("\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355\u3010%s\u3011\u6839\u636e\u6e90\u5355\u5185\u7801\u5b57\u6bb5\u503c(%s)\u6ca1\u6709\u627e\u5230\u6e90\u5934\u6210\u672c\u786e\u8ba4\u5355\uff0c\u81ea\u52a8\u6839\u636e\u8d26\u7c3f+\u671f\u95f4+\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7ec4\u5408\u5339\u914d\u4e86\u4e00\u5f20\u6210\u672c\u786e\u8ba4\u5355", billno, srcCostConfirmId));
                srcCostConfirmId = (Long)((DynamicObject)srcCostConfirms.get(0)).getPkValue();
            }
            this.finishDiff2CostConfim.put(finishdiffBillId, srcCostConfirmId);
            Set finishDiffIdSet = this.costConfirm2FinishDiff.computeIfAbsent(srcCostConfirmId, s -> new HashSet(1));
            finishDiffIdSet.add(finishdiffBillId);
            DynamicObjectCollection rows = finishdiffBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : rows) {
                Long adjustBillId = row.getLong("adjustbill");
                if (adjustBillId != null && Long.compare(0L, adjustBillId) != 0) {
                    Set srcFinishDiffIdSet = this.costAdjust2FinishDiffs.computeIfAbsent(adjustBillId, s -> new HashSet(1));
                    srcFinishDiffIdSet.add(finishdiffBillId);
                    Set costAdjustIdSet = this.finishDiff2CostAdjust.computeIfAbsent(finishdiffBillId, s -> new HashSet(10));
                    costAdjustIdSet.add(adjustBillId);
                    continue;
                }
                ++nullAdjustCount;
            }
        }
        if (nullAdjustCount > 0) {
            logger.warn(String.format("\u4f20\u5165%s\u5f20\u6210\u672c\u786e\u8ba4\u5355\uff0c\u5171\u8bfb\u53d6\u4e86%s\u5f20\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355\uff0c\u5176\u4e2d%s\u884c\u6ca1\u6709\u8bb0\u5f55\u5173\u8054\u7684\u6210\u672c\u8c03\u6574\u5355\u5185\u7801", this.costConfirms.size(), this.finishDiffBills.size(), nullAdjustCount));
        }
        this.searchCostAdjustByFinishDiffIds(finishDiffObjs);
        if (!this.costAdjust2FinishDiffs.isEmpty()) {
            DynamicObject[] costAdjustObjs;
            for (DynamicObject costAdjustObj : costAdjustObjs = BusinessDataServiceHelper.load((Object[])this.costAdjust2FinishDiffs.keySet().toArray(), (DynamicObjectType)this.getSubCostAdjustType())) {
                this.costAdjusts.put((Long)costAdjustObj.getPkValue(), costAdjustObj);
            }
        }
        logger.info(String.format("\u4f20\u5165%s\u5f20\u6210\u672c\u786e\u8ba4\u5355\uff0c\u5171\u8bfb\u53d6\u4e86%s\u5f20\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355\uff0c\u5339\u914d\u4e0a\u4e86%s\u5f20\u3002\u5171\u8bfb\u53d6\u4e86%s\u5f20\u6210\u672c\u8c03\u6574\u5355\uff0c\u5339\u914d\u4e0a\u4e86%s\u5f20", this.costConfirms.size(), this.finishDiffBills.size(), this.finishDiff2CostConfim.size(), this.costAdjusts.size(), this.costAdjust2FinishDiffs.size()));
    }

    public Map<Long, DynamicObject> getCostConfirms() {
        return this.costConfirms;
    }

    public Map<Long, DynamicObject> getFinishDiffBills() {
        return this.finishDiffBills;
    }

    public Map<Long, DynamicObject> getCostAdjusts() {
        return this.costAdjusts;
    }

    public Map<Long, Set<Long>> getCostConfirm2FinishDiff() {
        return this.costConfirm2FinishDiff;
    }

    public Map<Long, Long> getFinishDiff2CostConfim() {
        return this.finishDiff2CostConfim;
    }

    public Map<Long, Set<Long>> getFinishDiff2CostAdjust() {
        return this.finishDiff2CostAdjust;
    }

    @Deprecated
    public Map<Long, Long> getCostAdjust2FinishDiff() {
        HashMap<Long, Long> costAdjust2FinishDiff = new HashMap<Long, Long>(this.costAdjust2FinishDiffs.size());
        for (Map.Entry<Long, Set<Long>> entry : this.costAdjust2FinishDiffs.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            costAdjust2FinishDiff.put(entry.getKey(), entry.getValue().iterator().next());
        }
        return costAdjust2FinishDiff;
    }

    public Map<Long, Set<Long>> getCostAdjust2FinishDiffs() {
        return this.costAdjust2FinishDiffs;
    }

    public Set<Long> getCostConfirmIdByCostAdjustId(Long costAdjustId) {
        HashSet<Long> costConfirmIds = new HashSet<Long>();
        Set<Long> srcFinishDiffIds = this.getCostAdjust2FinishDiffs().get(costAdjustId);
        if (srcFinishDiffIds != null) {
            for (Long finishDiffId : srcFinishDiffIds) {
                Long costConfirmId = this.getFinishDiff2CostConfim().get(finishDiffId);
                if (costConfirmId == null) continue;
                costConfirmIds.add(costConfirmId);
            }
        }
        return costConfirmIds;
    }

    private DynamicObject[] loadFinishDiffBill(DynamicObject[] costConfirms, Map<Long, Map<Long, CalcResultObjectInfo>> mainJoinSideCalcResultInfo) {
        if (costConfirms == null || costConfirms.length == 0) {
            return new DynamicObject[0];
        }
        HashSet<Long> costConfirmIds = new HashSet<Long>(costConfirms.length);
        HashSet<Long> costAccountIds = new HashSet<Long>(2);
        HashSet<Long> periodIds = new HashSet<Long>(1);
        HashSet<Long> costObjectIds = new HashSet<Long>(costConfirms.length);
        for (DynamicObject costConfirm : costConfirms) {
            costConfirmIds.add((Long)costConfirm.getPkValue());
            costAccountIds.add(costConfirm.getLong("costaccount.id"));
            periodIds.add(costConfirm.getLong("period.id"));
            long costObjectId = costConfirm.getLong("costobject.id");
            if (mainJoinSideCalcResultInfo.containsKey(costObjectId)) {
                costObjectIds.addAll(mainJoinSideCalcResultInfo.get(costObjectId).keySet());
                continue;
            }
            costObjectIds.add(costObjectId);
        }
        QFilter costAccountIdQF = new QFilter("costaccount", "in", costAccountIds);
        QFilter periodIdQF = new QFilter("period", "in", periodIds);
        QFilter costObjectIdQF = new QFilter("costobject", "in", costObjectIds);
        QFilter[] qf = new QFilter[]{costAccountIdQF, periodIdQF, costObjectIdQF};
        StringBuilder sbFilters = new StringBuilder();
        for (QFilter filter : qf) {
            sbFilters.append("\r\n ").append(filter.toString());
        }
        HashSet<Long> finishDiffIds = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".loadFinishDiffBill1"), (String)"sca_finishdiffbill", (String)"id", (QFilter[])qf, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                finishDiffIds.add(row.getLong(0));
            }
        }
        logger.info(String.format("\u4f7f\u7528\u8d26\u7c3f+\u671f\u95f4+\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u8bfb\u53d6\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355\uff0c\u5171\u53d6\u51fa %s \u5f20\u5355\uff0c\u53d6\u6570\u6761\u4ef6\uff1a%s", finishDiffIds.size(), sbFilters.toString()));
        QFilter srcIdsFilter = new QFilter("sourcebill", "in", costConfirmIds);
        int rowCount = 0;
        int addCount = 0;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".loadFinishDiffBill2"), (String)"sca_finishdiffbill", (String)"id", (QFilter[])new QFilter[]{srcIdsFilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ++rowCount;
                if (!finishDiffIds.add(row.getLong(0))) continue;
                ++addCount;
            }
        }
        logger.info(String.format("\u4f7f\u7528\u6210\u672c\u786e\u8ba4\u5355\u5185\u7801(%s\u5f20)\u5171\u641c\u7d22\u51fa\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355%s\u5f20\uff0c\u5176\u4e2d%s\u5f20\u662f\u4f7f\u7528\u8d26\u7c3f+\u671f\u95f4+\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u6ca1\u5339\u914d\u5230\u7684\uff0c\u53d6\u6570\u6761\u4ef6\uff1a%s", costConfirmIds.size(), rowCount, addCount, srcIdsFilter.toString()));
        if (finishDiffIds.isEmpty()) {
            return new DynamicObject[0];
        }
        return BusinessDataServiceHelper.load((Object[])finishDiffIds.toArray(), (DynamicObjectType)this.getSubFinishDiffBillType());
    }

    private void searchCostAdjustByFinishDiffIds(DynamicObject[] finishDiffObjs) {
        if (finishDiffObjs == null || finishDiffObjs.length == 0) {
            return;
        }
        HashSet<Long> finishDiffIds = new HashSet<Long>(finishDiffObjs.length);
        HashSet<Long> periodIds = new HashSet<Long>(10);
        HashSet<Long> costaccountIds = new HashSet<Long>(10);
        for (DynamicObject obj : finishDiffObjs) {
            finishDiffIds.add((Long)obj.getPkValue());
            costaccountIds.add(obj.getLong("costaccount.id"));
            periodIds.add(obj.getLong("period.id"));
        }
        Date startdate = null;
        Date enddate = null;
        for (Long periodId : periodIds) {
            Date[] dates = PeriodHelper.getPeriodStartAndEndTime((Long)periodId);
            if (dates == null) continue;
            if (startdate == null || dates[0].before(startdate)) {
                startdate = dates[0];
            }
            if (enddate != null && !dates[1].after(enddate)) continue;
            enddate = dates[1];
        }
        QFilter srcIdsFilter = new QFilter("entryentity.srcbillid", "in", finishDiffIds);
        srcIdsFilter.and("costaccount", "in", costaccountIds);
        srcIdsFilter.and("biztype", "=", (Object)"A");
        if (startdate != null) {
            srcIdsFilter.and("bookdate", ">=", (Object)startdate);
        }
        if (enddate != null) {
            srcIdsFilter.and("bookdate", "<=", (Object)enddate);
        }
        int rowCount = 0;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".loadFinishDiffBill2"), (String)"cal_stdcostdiffbill", (String)"id, entryentity.srcbillid srcbillid ", (QFilter[])new QFilter[]{srcIdsFilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long adjustBillId = row.getLong("id");
                Long finishdiffBillId = row.getLong("srcbillid");
                if (finishdiffBillId == null || Long.compare(0L, finishdiffBillId) == 0) continue;
                Set costAdjustIdSet = this.finishDiff2CostAdjust.computeIfAbsent(finishdiffBillId, s -> new HashSet(10));
                if (costAdjustIdSet.add(adjustBillId)) {
                    ++rowCount;
                }
                Set srcFinishDiffIdSet = this.costAdjust2FinishDiffs.computeIfAbsent(adjustBillId, s -> new HashSet(1));
                srcFinishDiffIdSet.add(finishdiffBillId);
            }
        }
        if (rowCount > 0) {
            logger.warn(String.format("\u5230\u6210\u672c\u786e\u8ba4\u5355\u4e2d\u6839\u636e\u6e90\u5355\u5185\u7801\u641c\u7d22\u6570\u636e\uff0c\u989d\u5916\u641c\u7d22\u51fa\u5173\u8054\u7684%s\u5f20\u6210\u672c\u786e\u8ba4\u5355\uff08\u8fd9\u4e9b\u6210\u672c\u786e\u8ba4\u5355\u5185\u7801\uff0c\u6ca1\u6709\u53cd\u5199\u5230\u5173\u8054\u7684\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355\u4e2d\uff09", rowCount));
        }
    }
}

