/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.feealloc;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.BaseDataCompareDiffHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.sca.common.util.TimeUtils;

public class MatAllocStdAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MatAllocStdAuditOp.class);
    private static final String[] billFile = new String[]{"org", "manuorg"};
    private static final String[] entryFile = new String[]{"costcenter", "bmaterial", "matversion", "auxpty", "materialgroup", "costdriver"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("billno");
        fieldKeys.add("billstatus");
        fieldKeys.add("manuorg");
        fieldKeys.add("effectdate");
        fieldKeys.add("expdate");
        fieldKeys.add("auditdate");
        fieldKeys.add("auditor");
        fieldKeys.add("creator");
        fieldKeys.add("createtime");
        fieldKeys.add("modifier");
        fieldKeys.add("modifytime");
        fieldKeys.add("appnum");
        fieldKeys.add("sourceid");
        fieldKeys.add("allocentry");
        fieldKeys.add("allocentry.costcenter");
        fieldKeys.add("allocentry.bmaterial");
        fieldKeys.add("allocentry.matversion");
        fieldKeys.add("allocentry.auxpty");
        fieldKeys.add("allocentry.materialgroup");
        fieldKeys.add("allocentry.costdriver");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                if ("unaudit".equals(this.getOperateKey())) {
                    ExtendedDataEntity[] dataEntities = this.getDataEntities();
                    HashMap<Long, Boolean> effectOrgMap = new HashMap<Long, Boolean>(2);
                    for (ExtendedDataEntity dataEntity : dataEntities) {
                        Boolean enableEffectByOrg;
                        DynamicObject checkData = dataEntity.getDataEntity();
                        long orgId = checkData.getLong("org.id");
                        if (effectOrgMap.get(orgId) != null) {
                            enableEffectByOrg = (Boolean)effectOrgMap.get(orgId);
                        } else {
                            enableEffectByOrg = SysParamHelper.getEnableEffectByOrg((Long)orgId, (String)checkData.getString("appnum"), (String)"sca_matallocstd");
                            effectOrgMap.put(orgId, enableEffectByOrg);
                        }
                        Date date = checkData.getDate("expdate");
                        if (!enableEffectByOrg.booleanValue() || date == null || date.compareTo(new Date()) >= 0) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u6570\u636e\u5df2\u7ecf\u5931\u6548\uff0c\u65e0\u6cd5\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"MatAllocStdAuditOp_0", (String)"macc-sca-form", (Object[])new Object[0]));
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        if ("audit".equals(e.getOperationKey())) {
            DynamicObject[] dataEntities = e.getDataEntities();
            Set sourceIdsSet = Arrays.stream(dataEntities).map(o -> o.getLong("id")).collect(Collectors.toSet());
            String selectFileName = "org,manuorg,sourceid,allocentry.costcenter,allocentry.bmaterial,allocentry.matversion,allocentry.auxpty,allocentry.materialgroup,allocentry.costdriver";
            Map recentDataByUnAuditMap = BaseDataCompareDiffHelper.getRecentDataByUnAudit(sourceIdsSet, (String)"sca_matallocstd", (String)selectFileName);
            ArrayList<Long> deleteDataList = new ArrayList<Long>(10);
            ArrayList<DynamicObject> modifyDataList = new ArrayList<DynamicObject>(10);
            Long deleteId = null;
            for (DynamicObject dataEntity : dataEntities) {
                Set recentDataEntrySet;
                DynamicObject recentDataByUnAudit;
                Long orgId = dataEntity.getLong("org.id");
                Boolean enableEffectByOrg = SysParamHelper.getEnableEffectByOrg((Long)orgId, (String)dataEntity.getString("appnum"), (String)"sca_matallocstd");
                if (enableEffectByOrg.booleanValue() && (recentDataByUnAudit = (DynamicObject)recentDataByUnAuditMap.get(dataEntity.getLong("id"))) != null && (recentDataEntrySet = BaseDataCompareDiffHelper.recentDataDiffResult((DynamicObject)recentDataByUnAudit, (DynamicObject)dataEntity, (String[])billFile, (String[])entryFile)) != null) {
                    if (recentDataEntrySet.size() == 0) {
                        deleteId = recentDataByUnAudit.getLong("id");
                        deleteDataList.add(deleteId);
                    } else {
                        this.createModifyData(modifyDataList, recentDataByUnAudit, recentDataEntrySet);
                    }
                }
                Date date = dataEntity.getDate("effectdate");
                Date expdate = dataEntity.getDate("expdate");
                if (date != null) {
                    if (deleteId != null && enableEffectByOrg.booleanValue() && expdate != null && expdate.compareTo(new Date()) > 0) {
                        date = this.getEffectDate(dataEntity, deleteId);
                        dataEntity.set("effectdate", (Object)date);
                    }
                } else {
                    date = enableEffectByOrg != false ? this.getEffectDate(dataEntity, deleteId) : kd.macc.cad.common.utils.DateUtils.getDefaultEffectDate();
                    dataEntity.set("effectdate", (Object)date);
                }
                if (expdate == null) {
                    dataEntity.set("expdate", (Object)TimeUtils.getDeFaultExpDate());
                }
                dataEntity.set("auditdate", (Object)new Date());
                dataEntity.set("auditor_id", (Object)Long.parseLong(RequestContext.get().getUserId()));
            }
            if (deleteDataList.size() > 0) {
                DeleteServiceHelper.delete((String)"sca_matallocstd", (QFilter[])new QFilter[]{new QFilter("id", "in", deleteDataList)});
            }
            if (modifyDataList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])modifyDataList.toArray(new DynamicObject[0]));
            }
        } else if ("unaudit".equals(e.getOperationKey())) {
            DynamicObject[] dataEntities = e.getDataEntities();
            Date opDate = new Date();
            ArrayList<DynamicObject> saveDataLIst = new ArrayList<DynamicObject>(dataEntities.length);
            HashSet ids = Sets.newHashSetWithExpectedSize((int)16);
            for (DynamicObject dataEntity : dataEntities) {
                ids.add(dataEntity.getLong("id"));
            }
            QFilter filter = new QFilter("id", "in", (Object)ids);
            DynamicObjectCollection allocStds = QueryServiceHelper.query((String)"sca_matallocstd", (String)"id,auditor,auditdate", (QFilter[])filter.toArray());
            HashMap<Long, DynamicObject> auditorMsgMap = new HashMap<Long, DynamicObject>(32);
            for (DynamicObject obj : allocStds) {
                auditorMsgMap.put(obj.getLong("id"), obj);
            }
            for (DynamicObject dataEntity : dataEntities) {
                Boolean enableEffectByOrg = SysParamHelper.getEnableEffectByOrg((Long)dataEntity.getLong("org.id"), (String)dataEntity.getString("appnum"), (String)"sca_matallocstd");
                if (!enableEffectByOrg.booleanValue()) continue;
                DynamicObject newProductData = (DynamicObject)OrmUtils.clone((Object)dataEntity, (IDataEntityType)dataEntity.getDataEntityType(), (boolean)true, (boolean)true);
                String newNumber = newProductData.getString("billno");
                newProductData.set("billno", (Object)(newNumber + "-" + DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"ddHHmmss"})));
                newProductData.set("expdate", (Object)opDate);
                newProductData.set("billstatus", (Object)"C");
                newProductData.set("sourceid", dataEntity.getPkValue());
                if (auditorMsgMap.containsKey(dataEntity.getLong("id"))) {
                    DynamicObject obj = (DynamicObject)auditorMsgMap.get(dataEntity.getLong("id"));
                    newProductData.set("auditor_id", obj.get("auditor"));
                    newProductData.set("auditdate", obj.get("auditdate"));
                }
                saveDataLIst.add(newProductData);
                dataEntity.set("effectdate", (Object)opDate);
                Date invalidDate = dataEntity.getDate("expdate");
                if (invalidDate != null) continue;
                dataEntity.set("expdate", (Object)TimeUtils.getDeFaultExpDate());
            }
            if (saveDataLIst.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])saveDataLIst.toArray(new DynamicObject[0]));
            }
        }
    }

    private void createModifyData(ArrayList<DynamicObject> modifyDataList, DynamicObject recentDataByUnAudit, Set<String> recentDataEntrySet) {
        DynamicObjectCollection entryentity = recentDataByUnAudit.getDynamicObjectCollection("allocentry");
        entryentity.clear();
        for (String key : recentDataEntrySet) {
            String[] split = key.split("@");
            if (split != null && split.length == 6) {
                DynamicObject entry = entryentity.addNew();
                entry.set("costcenter", (Object)BaseDataCompareDiffHelper.getDynamicObjectIdValue((String)split[0]));
                entry.set("bmaterial", (Object)BaseDataCompareDiffHelper.getDynamicObjectIdValue((String)split[1]));
                entry.set("matversion", (Object)BaseDataCompareDiffHelper.getDynamicObjectIdValue((String)split[2]));
                entry.set("auxpty", (Object)BaseDataCompareDiffHelper.getDynamicObjectIdValue((String)split[3]));
                entry.set("materialgroup", (Object)BaseDataCompareDiffHelper.getDynamicObjectIdValue((String)split[4]));
                entry.set("costdriver", (Object)BaseDataCompareDiffHelper.getDynamicObjectIdValue((String)split[5]));
                continue;
            }
            logger.error("createModifyData\u5206\u5f55key\u5f02\u5e38", (Object)key);
        }
        modifyDataList.add(recentDataByUnAudit);
    }

    private Date getEffectDate(DynamicObject dataEntity, Long deleteId) {
        DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("allocentry");
        Set entryentitySet = entryentity.stream().map(dynamicObject -> dynamicObject.getLong("costcenter.id") + "@" + dynamicObject.getLong("bmaterial.id") + "@" + dynamicObject.getLong("matversion.id") + "@" + dynamicObject.getLong("auxpty.id") + "@" + dynamicObject.getLong("materialgroup.id") + "@" + dynamicObject.getLong("costdriver.id")).collect(Collectors.toSet());
        Long orgId = dataEntity.getLong("org.id");
        Long manuorgId = dataEntity.getLong("manuorg.id");
        QFilter statusQf = new QFilter("billstatus", "=", (Object)"C");
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter manuorgQf = new QFilter("manuorg", "=", (Object)manuorgId);
        QFilter appNumQf = new QFilter("appnum", "=", (Object)dataEntity.getString("appnum"));
        QFilter idQf = new QFilter("id", "!=", dataEntity.getPkValue());
        String selectStr = "id,effectdate,expdate,allocentry.costcenter.id as costcenter,allocentry.bmaterial.id as bmaterial,allocentry.matversion.id as matversion,allocentry.auxpty.id as auxpty,allocentry.materialgroup.id as materialgroup,allocentry.costdriver.id as costdriver";
        DataSet rows = QueryServiceHelper.queryDataSet((String)"getEffectDateQuery", (String)"sca_matallocstd", (String)selectStr, (QFilter[])new QFilter[]{orgQf, manuorgQf, statusQf, idQf, appNumQf}, (String)"effectdate desc");
        Date effectdate = null;
        Date expdate = null;
        while (rows.hasNext()) {
            Date date;
            Row row = rows.next();
            String key = row.getLong("costcenter") + "@" + row.getLong("bmaterial") + "@" + row.getLong("matversion") + "@" + row.getLong("auxpty") + "@" + row.getLong("materialgroup") + "@" + row.getLong("costdriver");
            if (!entryentitySet.contains(key)) continue;
            if (deleteId != null && deleteId.compareTo(row.getLong("id")) == 0) {
                date = row.getDate("effectdate");
                if (effectdate == null) {
                    effectdate = date;
                    continue;
                }
                effectdate = effectdate.compareTo(date) > 0 ? date : effectdate;
                continue;
            }
            date = row.getDate("expdate");
            if (expdate == null) {
                expdate = date;
                continue;
            }
            expdate = expdate.compareTo(date) > 0 ? expdate : date;
        }
        if (effectdate == null && expdate == null) {
            effectdate = TimeUtils.getDefaultEffectDate();
        } else if (effectdate != null && expdate != null) {
            effectdate = effectdate.compareTo(expdate) > 0 ? effectdate : expdate;
        } else if (expdate != null) {
            effectdate = expdate;
        }
        return effectdate;
    }
}

