/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.feealloc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.Keycol;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MatUseCollectSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("manuorg");
        fieldKeys.add("costcenter");
        fieldKeys.add("biztype");
        fieldKeys.add("source");
        fieldKeys.add("srcbilltype");
        fieldKeys.add("entryentity");
        fieldKeys.add("entryentity.qty");
        fieldKeys.add("entryentity.material");
        fieldKeys.add("entryentity.matversion");
        fieldKeys.add("entryentity.auxpty");
        fieldKeys.add("entryentity.lotcoderule");
        fieldKeys.add("entryentity.project");
        fieldKeys.add("entryentity.tracknumber");
        fieldKeys.add("entryentity.configuredcode");
        fieldKeys.add("entryentity.lotcoderule");
        fieldKeys.add("entryentity.keycol");
        fieldKeys.add("entryentity.keycolid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
                    String source;
                    String newType;
                    DynamicObject matUseCollect = dataEntity.getDataEntity();
                    String srcbilltype = matUseCollect.getString("srcbilltype.number");
                    Boolean qytZeroValidate = this.getQtyZeroValidate(srcbilltype);
                    DynamicObjectCollection entries = matUseCollect.getDynamicObjectCollection("entryentity");
                    int row = 0;
                    for (DynamicObject entry : entries) {
                        ++row;
                        BigDecimal qty = entry.getBigDecimal("qty");
                        if (qty.compareTo(BigDecimal.ZERO) != 0 || !qytZeroValidate.booleanValue()) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u5206\u5f55\u7b2c%s\u884c\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff1a\u6570\u91cf\u22600\u3002", (String)"MatUseCollectSaveOp_0", (String)"macc-sca-form", (Object[])new Object[0]), row));
                    }
                    List errorMsgs = MatUseCollectSaveOp.this.validateMatRelationMustInput(entries);
                    if (!CollectionUtils.isEmpty((Collection)errorMsgs)) {
                        errorMsgs.forEach(e -> this.addErrorMessage(dataEntity, (String)e));
                    }
                    if (!(newType = "TPLIMPORT").equalsIgnoreCase(source = dataEntity.getDataEntity().getString("source"))) continue;
                    this.checkCostParam(dataEntity, newType);
                    this.checkManuorg(dataEntity);
                }
            }

            private Boolean getQtyZeroValidate(String srcbilltype) {
                Boolean qytZeroValidate = Boolean.TRUE;
                if ("cal_costadjust_subentity".equals(srcbilltype)) {
                    qytZeroValidate = Boolean.FALSE;
                }
                return qytZeroValidate;
            }

            private void checkManuorg(ExtendedDataEntity dataEntity) {
                DynamicObject dy = dataEntity.getDataEntity();
                Long accountorg = (Long)dy.getDynamicObject("org").getPkValue();
                DynamicObject manuorgData = dy.getDynamicObject("manuorg");
                if (manuorgData != null) {
                    Long manuorg = (Long)manuorgData.getPkValue();
                    List manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)accountorg, (String)"sca_matusecollect");
                    if (manuorgList != null && manuorgList.contains(manuorg)) {
                        return;
                    }
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002\u751f\u4ea7\u7ec4\u7ec7\u4e0e\u6838\u7b97\u7ec4\u7ec7\u6ca1\u6709\u59d4\u6258\u5173\u7cfb\uff0c\u4e0d\u80fd\u5bfc\u5165", (String)"MatUseCollectSaveOp_8", (String)"macc-sca-form", (Object[])new Object[0]));
                }
            }

            private void checkCostParam(ExtendedDataEntity dataEntity, String newType) {
                String costParamEntity = "cad_sysparam";
                DynamicObject dy = dataEntity.getDataEntity();
                Long accountorg = (Long)dy.getDynamicObject("org").getPkValue();
                Long costcenter = (Long)dy.getDynamicObject("costcenter").getPkValue();
                QFilter accountorgQF = new QFilter("accountorg", "=", (Object)accountorg);
                QFilter costcenterQF = new QFilter("costcenter", "=", (Object)costcenter);
                QFilter costcenterQFNull = new QFilter("costcenter", "=", (Object)0L);
                QFilter completetype = new QFilter("matcollectway", "=", (Object)newType);
                boolean hasAccountAndCost = QueryServiceHelper.exists((String)costParamEntity, (QFilter[])new QFilter[]{accountorgQF, costcenterQF, completetype});
                if (hasAccountAndCost) {
                    return;
                }
                boolean hasAccount = QueryServiceHelper.exists((String)costParamEntity, (QFilter[])new QFilter[]{accountorgQF, costcenterQFNull, completetype});
                if (hasAccount) {
                    return;
                }
                DynamicObjectCollection result = QueryServiceHelper.query((String)costParamEntity, (String)"id, matcollectway", (QFilter[])new QFilter[]{accountorgQF, costcenterQF});
                String showCompletetype = this.showCompletetype(result);
                if ("".equals(showCompletetype)) {
                    DynamicObjectCollection result2 = QueryServiceHelper.query((String)costParamEntity, (String)"id, matcollectway", (QFilter[])new QFilter[]{accountorgQF, costcenterQFNull});
                    showCompletetype = this.showCompletetype(result2);
                }
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002\u6210\u672c\u53c2\u6570\u8bbe\u7f6e\u7684\u6750\u6599\u5f52\u96c6\u65b0\u589e\u65b9\u5f0f\u4e3a\u3010%s\u3011\u3002", (String)"MatUseCollectSaveOp_9", (String)"macc-sca-form", (Object[])new Object[0]), showCompletetype));
            }

            private String showCompletetype(DynamicObjectCollection result) {
                if (result != null && !result.isEmpty()) {
                    String realCompletetype = "";
                    for (DynamicObject costparam : result) {
                        realCompletetype = costparam.getString("matcollectway");
                        if ("".equals(realCompletetype)) continue;
                        SysParamEnum enumByValue = SysParamEnum.getEnumByValue((String)realCompletetype);
                        return enumByValue.getName();
                    }
                }
                return "";
            }
        });
    }

    private List<String> validateMatRelationMustInput(DynamicObjectCollection entries) {
        ArrayList<String> results = new ArrayList<String>();
        int row = 0;
        for (DynamicObject entry : entries) {
            boolean enableAuxprop;
            ++row;
            DynamicObject material = null;
            material = entry.get("material") instanceof DynamicObject ? entry.getDynamicObject("material") : CostObjectHelper.getMaterialById((Long)entry.getLong("material"));
            Long auxpty = 0L;
            auxpty = entry.get("auxpty") instanceof DynamicObject ? Long.valueOf(entry.getLong("auxpty.id")) : Long.valueOf(entry.getLong("auxpty"));
            String lotcoderule = entry.getString("lotcoderule");
            if (material == null || !(enableAuxprop = BomRouterHelper.isEnableAuxprop((DynamicObject)material)) || !CadEmptyUtils.isEmpty((Long)auxpty)) continue;
            String errMsg = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u4fe1\u606f\u7b2c%1$s\u884c\u7269\u6599\uff1a%2$s\u5df2\u542f\u7528\u8f85\u52a9\u5c5e\u6027\uff0c\u8bf7\u586b\u5199\u8f85\u52a9\u5c5e\u6027\u3002", (String)"MatUseCollectSaveOp_4", (String)"macc-sca-form", (Object[])new Object[0]), row, material.getString("number"));
            results.add(errMsg);
        }
        return results;
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            String biztype = dataEntity.getString("biztype");
            if (!"PRODUCTMATFALLBACK".equals(biztype)) continue;
            DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                BigDecimal qty = entry.getBigDecimal("qty");
                if (qty.compareTo(BigDecimal.ZERO) > 0) {
                    qty = qty.multiply(new BigDecimal(-1));
                }
                entry.set("qty", (Object)qty);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.endOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection entryEntitys = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryEntity : entryEntitys) {
                Keycol calcKey = CalcKeyHelper.getCalcKey((DynamicObject)entryEntity, (boolean)true);
                entryEntity.set("keycol", (Object)calcKey.getKeycol());
                entryEntity.set("keycolid", (Object)calcKey.getId());
                entryEntity.set("keycolid_id", (Object)calcKey.getId());
            }
        }
        SaveServiceHelper.update((DynamicObject[])dataEntities);
    }
}

