/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.feealloc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.macc.cad.common.helper.MfgfeeBillImportHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.opplugin.feealloc.MfgFeeAllocStdSaveValidator;

public class MfgFeeAllocStdSaveOpPlugin
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new MfgFeeAllocStdSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObjectCollection entrys;
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> expenseitemIdList = new ArrayList<Long>();
        for (DynamicObject diyBill : dataEntities) {
            boolean issender = diyBill.getBoolean("issender");
            boolean isexpense = diyBill.getBoolean("isexpense");
            boolean isbeneficiary = diyBill.getBoolean("isbeneficiary");
            if (issender) {
                diyBill.set("costcentergroup", null);
            } else {
                diyBill.set("costcenter", null);
            }
            entrys = diyBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                expenseitemIdList.add(entry.getLong("expenseitem.id"));
                if (isexpense) {
                    entry.set("subelement", null);
                } else {
                    entry.set("expenseitem", null);
                }
                DynamicObjectCollection dynamicObjectCollection = entry.getDynamicObjectCollection("subentryentity");
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    if (isbeneficiary) {
                        dynamicObject.set("centergroup", null);
                        continue;
                    }
                    dynamicObject.set("benefcostcenter", null);
                }
            }
        }
        Map expenseitemMap = MfgfeeBillImportHelper.expenseitemIdToMasterId(expenseitemIdList);
        for (DynamicObject dataEntity : dataEntities) {
            boolean isBeneficiary = dataEntity.getBoolean("isbeneficiary");
            String allocType = dataEntity.getString("allocmold");
            if (!allocType.equals("C")) {
                dataEntity.set("execondition", null);
            }
            entrys = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                Long expenseitemMasterId = (Long)expenseitemMap.get(entry.getLong("expenseitem.id"));
                if (!CadEmptyUtils.isEmpty((Long)expenseitemMasterId)) {
                    entry.set("expenseitem_id", (Object)expenseitemMasterId);
                }
                DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection("subentryentity");
                HashSet<DynamicObject> nullRow = new HashSet<DynamicObject>();
                for (DynamicObject subentry : subEntrys) {
                    if (subentry.getLong("benefcostcenter.masterid") == 0L && subentry.getLong("centergroup.masterid") == 0L) {
                        nullRow.add(subentry);
                        continue;
                    }
                    if (isBeneficiary && subentry.getLong("benefcostcenter.masterid") == 0L) {
                        nullRow.add(subentry);
                        continue;
                    }
                    if (isBeneficiary || subentry.getLong("centergroup.masterid") != 0L) continue;
                    nullRow.add(subentry);
                }
                subEntrys.removeAll(nullRow);
            }
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("entryentity");
        fieldKeys.add("subentryentity");
        fieldKeys.add("costcenter");
        fieldKeys.add("benefcostcenter");
        fieldKeys.add("manuorg");
        fieldKeys.add("issender");
        fieldKeys.add("isexpense");
        fieldKeys.add("isbeneficiary");
        fieldKeys.add("costcentergroup");
        fieldKeys.add("subelement");
        fieldKeys.add("expenseitem");
        fieldKeys.add("costdriver");
        fieldKeys.add("allocmold");
        fieldKeys.add("appnum");
        fieldKeys.add("execondition");
        fieldKeys.add("org");
        fieldKeys.add("centergroup");
        fieldKeys.add("allocdim");
        fieldKeys.add("entryentity.subentryentity");
    }
}

