/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.init;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;

public class WipCostInitDelOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("costaccount");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                this.checkCostAccount();
            }

            private void checkCostAccount() {
                HashMap<Long, ExtendedDataEntity> costAccountMap = new HashMap<Long, ExtendedDataEntity>();
                Long orgId = 0L;
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject entity = dataEntity.getDataEntity();
                    DynamicObject costaccount = entity.getDynamicObject("costaccount");
                    if (CadEmptyUtils.isEmpty((DynamicObject)costaccount)) continue;
                    costAccountMap.put(costaccount.getLong("id"), dataEntity);
                    orgId = entity.getLong("org.id");
                }
                String fields = "entryentity.isenabled AS isenabled,entryentity.isinit AS isinit,entryentity.costaccount AS costaccount";
                QFilter orgQF = new QFilter("org", "=", (Object)orgId);
                QFilter costaccountQF = new QFilter("entryentity.costaccount", "in", costAccountMap.keySet());
                QFilter[] qf = new QFilter[]{orgQF, costaccountQF};
                DynamicObjectCollection stdCosts = QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])qf);
                for (DynamicObject stdCost : stdCosts) {
                    if (!stdCost.getBoolean("isinit")) continue;
                    this.addErrorMessage((ExtendedDataEntity)costAccountMap.get(stdCost.getLong("costaccount")), ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002\u6210\u672c\u8d26\u7c3f\u5df2\u7ecf\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"WipCostInitDelOpPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                }
            }
        });
        super.onAddValidators(e);
    }
}

