/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.calc;

import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;

public class CostCalcResultQueryPlugin
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        QFilter filter = CalcRptHelper.getQFilter((ReportQueryParam)reportQueryParam, (boolean)true);
        long orgId = this.getQueryParam().getFilter().getLong("org");
        if (OrgHelper.isOrgEnableMultiFactory((Long)orgId)) {
            List manuOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)"sca_calcresultrpt");
            filter.and("costobject.manuorg", "in", (Object)manuOrg);
        }
        ORM orm = ORM.create();
        String algoKey = ((Object)((Object)this)).getClass().getName() + ".query";
        String selectFields = this.getQueryFields();
        DataSet dataSet = orm.queryDataSet(algoKey, "sca_calcresult", selectFields, new QFilter[]{filter});
        dataSet = this.groupByCostObject(dataSet);
        QFilter fxfilter = CalcRptHelper.getQFilter((ReportQueryParam)reportQueryParam, (boolean)false);
        fxfilter.and(new QFilter("entryentity.difftype", "=", (Object)"3"));
        DataSet dataSet_update = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_calcresult", (String)"currency AS currencyid,period,costobject,costobject.manuorg AS entrymanuorg,entryentity.pdcurramount AS curupdatediff", (QFilter[])new QFilter[]{fxfilter}, null);
        dataSet_update = dataSet_update.groupBy(new String[]{"currencyid", "period", "costobject", "entrymanuorg"}).sum("curupdatediff").finish();
        dataSet = dataSet.join(dataSet_update, JoinType.LEFT).on("costobject", "costobject").on("period", "period").select(dataSet.getRowMeta().getFieldNames(), new String[]{"curupdatediff"}).finish();
        DataSet resultSet = this.getAllDataSet(dataSet);
        return resultSet;
    }

    private DataSet groupByCostObject(DataSet dataSet) {
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"currencyid", "period", "periodname", "costaccount", "bizstatus", "costcenter", "costcenternumber", "costcentername", "objnumber", "costobject", "entrymanuorg", "material", "auxpty", "unit"});
        GroupbyDataSet sumDataSet = groupbyDataSet.sum("pdstartqty").sum("pdstartamount").sum("pdcurrqty").sum("pdcurramount").sum("pdcompqty").sum("pdcompanount").sum("pdendqty").sum("pdendamount").sum("totalqty").sum("totalamount").sum("stdqty").sum("stdamount").sum("diff").sum("totalupdatediff");
        return sumDataSet.finish().select("currencyid, period, periodname, costaccount, costcenter, costcenternumber, costcentername,bizstatus,objnumber, costobject,entrymanuorg,material,auxpty,unit,pdstartqty, pdstartamount, pdcurrqty, pdcurramount, pdcompqty, pdcompanount, pdendqty, pdendamount, totalqty, totalamount, stdqty, stdamount, diff,totalupdatediff,0 AS seqcol");
    }

    private DataSet getAllDataSet(DataSet dataSet) {
        String total = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"CostCalcResultQueryPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]);
        GroupbyDataSet groupbyCostCenterDataSet = dataSet.groupBy(new String[]{"currencyid", "period", "costcenter"});
        groupbyCostCenterDataSet = groupbyCostCenterDataSet.sum("pdstartamount").sum("pdcurramount").sum("pdcompanount").sum("pdendamount").sum("totalamount").sum("stdamount").sum("diff").sum("totalupdatediff").sum("curupdatediff");
        DataSet costCenterSumDataSet = this.getgroupbyCostCenterDataSet(groupbyCostCenterDataSet, total);
        GroupbyDataSet groupbyPeriodDataSet = dataSet.groupBy(new String[]{"currencyid", "period"});
        groupbyPeriodDataSet = groupbyPeriodDataSet.sum("pdstartamount").sum("pdcurramount").sum("pdcompanount").sum("pdendamount").sum("totalamount").sum("stdamount").sum("diff").sum("totalupdatediff").sum("curupdatediff");
        DataSet periodSumDataSet = this.getgroupbyPeriodDataSet(groupbyPeriodDataSet, total);
        DataSet unionDataSet = dataSet.union(costCenterSumDataSet).union(periodSumDataSet);
        return unionDataSet.orderBy(new String[]{"period", "costcenter desc", "objnumber", "seqcol"});
    }

    private DataSet getgroupbyCostCenterDataSet(GroupbyDataSet groupbyCostCenterDataSet, String total) {
        return groupbyCostCenterDataSet.finish().select("currencyid,period,'' AS periodname,0 AS costaccount,costcenter,'" + total + "' AS costcenternumber,'' AS costcentername,'' as bizstatus,'' AS objnumber,0 AS costobject,0 AS entrymanuorg,0 AS material,0 AS auxpty,0 AS unit,0 AS pdstartqty,pdstartamount,0 AS pdcurrqty,pdcurramount,0 AS pdcompqty,pdcompanount,0 AS pdendqty,pdendamount,0 AS totalqty,totalamount,0 AS stdqty,stdamount,diff,totalupdatediff,1 AS seqcol,curupdatediff");
    }

    private DataSet getgroupbyPeriodDataSet(GroupbyDataSet groupbyPeriodDataSet, String total) {
        return groupbyPeriodDataSet.finish().select("currencyid,period,'" + total + "' AS periodname,0 AS costaccount,0 AS costcenter,'' AS costcenternumber,'' AS costcentername,'' as bizstatus,'' AS objnumber,0 AS costobject,0 AS entrymanuorg,0 AS material,0 AS auxpty,0 AS unit,0 AS pdstartqty,pdstartamount,0 AS pdcurrqty,pdcurramount,0 AS pdcompqty,pdcompanount,0 AS pdendqty,pdendamount,0 AS totalqty,totalamount,0 AS stdqty, stdamount,diff,totalupdatediff, 2 AS seqcol,curupdatediff");
    }

    private String getQueryFields() {
        String fields = "currency AS currencyid,period AS period, period.name AS periodname,costcenter AS costcenter,bizstatus,costaccount,costcenter.number AS costcenternumber,costcenter.name AS costcentername,entryentity.obj.billno objnumber,entryentity.obj AS costobject,costobject.manuorg.id AS entrymanuorg,entryentity.obj.material AS material,entryentity.obj.auxpty AS auxpty,entryentity.obj.material.baseunit AS unit, entryentity.pdstartqty AS pdstartqty,entryentity.pdstartamount AS pdstartamount,entryentity.pdcurrqty AS pdcurrqty,entryentity.pdcurramount AS pdcurramount,entryentity.pdcompqty AS pdcompqty,entryentity.pdcompanount AS pdcompanount,entryentity.pdendqty AS pdendqty,entryentity.pdendamount AS pdendamount,entryentity.totalqty AS totalqty,entryentity.totalamount AS totalamount,entryentity.stdqty As stdqty,entryentity.stdamount AS stdamount,entryentity.diff AS diff,entryentity.costupdatediffamt AS totalupdatediff";
        return fields;
    }
}

