/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.difftransfer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;

public class CostDiffCarryOverTypeFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costcenter = (BasedataEdit)this.getControl("costcenter");
        costcenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org != null) {
            return;
        }
        this.initQueryInfo();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        switch (name) {
            case "org": {
                List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                QFilter idFilter = new QFilter("id", "in", (Object)hasPermAccountOrgIds);
                listShowParameter.getListFilterParameter().getQFilters().add(idFilter);
                break;
            }
            case "costaccount": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostDiffCarryOverTypeFormPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter costAccountFilter = StartCostHelper.getEndInitCostAccountIdsFilter((Long)((Long)org.getPkValue()), (String)"sca");
                listShowParameter.getListFilterParameter().getQFilters().add(costAccountFilter);
                break;
            }
            case "costcenter": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u3002", (String)"CostDiffCarryOverTypeFormPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                QFilter orgFilter = new QFilter("accountorg", "=", (Object)org.getLong("id"));
                QFilter orgDutyFilter = new QFilter("orgduty", "=", (Object)4L);
                listShowParameter.getListFilterParameter().getQFilters().add(orgFilter);
                listShowParameter.getListFilterParameter().getQFilters().add(orgDutyFilter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyname = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyname) {
            case "org": {
                this.setCostAccount(newValue);
                break;
            }
            case "costaccount": {
                this.setCurrencyAndPeriod(newValue);
                break;
            }
            case "endperiod": {
                this.setBeginPeriod(newValue);
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject endPeriod;
        ArrayList props = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "startperiod", "endperiod", "difftype"});
        boolean isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, (List)props);
        if (!isPass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"CostDiffCarryOverTypeFormPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        DynamicObject startPeriod = this.getModel().getDataEntity().getDynamicObject("startperiod");
        int value = PeriodHelper.compare2period((DynamicObject)startPeriod, (DynamicObject)(endPeriod = this.getModel().getDataEntity().getDynamicObject("endperiod")));
        if (value > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u671f\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u671f\u95f4\u3002", (String)"CostDiffCarryOverTypeFormPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    private void setCostAccount(Object org) {
        if (org == null) {
            return;
        }
        DynamicObject orgDO = (DynamicObject)org;
        Long mainBookId = OrgHelper.getCostAccountByAccoutOrg((Long)orgDO.getLong("id"));
        if (mainBookId != null && mainBookId != 0L) {
            boolean isnit = StartCostHelper.isInit((Long)mainBookId, (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
            if (isnit) {
                this.getModel().setValue("costaccount", (Object)mainBookId);
            }
        } else {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
        }
    }

    private void setCurrencyAndPeriod(Object costAccount) {
        if (costAccount == null) {
            return;
        }
        DynamicObject costAccountDO = (DynamicObject)costAccount;
        Long currency = CalcRptHelper.getCurrency((DynamicObject)costAccountDO);
        this.getModel().setValue("currency", (Object)currency);
        this.setPeriod();
    }

    private void setPeriod() {
        Long costaccountId;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (org == null || costaccount == null) {
            return;
        }
        Long orgId = org.getLong("id");
        Long currperiod = CalcRptHelper.getCurrPeriod((Long)orgId, (Long)(costaccountId = Long.valueOf(costaccount.getLong("id"))));
        if (currperiod != null && currperiod != 0L) {
            this.getModel().setValue("startperiod", (Object)currperiod);
            this.getModel().setValue("endperiod", (Object)currperiod);
        }
    }

    private void initQueryInfo() {
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        if (isaccount) {
            this.getModel().setValue("org", (Object)currentOrgId);
            this.setCostAccount(this.getModel().getDataEntity().getDynamicObject("org"));
            this.setCurrencyAndPeriod(this.getModel().getDataEntity().getDynamicObject("costaccount"));
            this.getView().updateView();
        }
    }

    private void setBeginPeriod(Object endPeriod) {
        DynamicObject startPeriod = this.getModel().getDataEntity().getDynamicObject("startperiod");
        if (endPeriod == null || startPeriod == null) {
            return;
        }
        int value = PeriodHelper.compare2period((DynamicObject)startPeriod, (DynamicObject)((DynamicObject)endPeriod));
        if (value > 0) {
            this.getModel().setValue("startperiod", endPeriod);
            this.getView().updateView("startperiod");
        }
    }
}

