/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.difftransfer;

import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.PeriodHelper;

public class CostDiffCarryOverTypeQueryPlugin
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        ORM orm = ORM.create();
        String algoKey = ((Object)((Object)this)).getClass().getName() + ".query";
        String selectFields = this.getQueryFields();
        QFilter filter = this.getQFilter(reportQueryParam);
        DataSet dataSet = orm.queryDataSet(algoKey, "sca_prodiffbill", selectFields, new QFilter[]{filter});
        dataSet = this.mergeSameItem(dataSet);
        DataSet resultSet = this.getAllDataSet(dataSet);
        return resultSet.orderBy(new String[]{"period desc", "costcentercol desc", "seqcol"});
    }

    private DataSet getAllDataSet(DataSet dataSet) {
        String subtotal = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"CostDiffCarryOverTypeQueryPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]);
        String total = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CostDiffCarryOverTypeQueryPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]);
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"period", "costcentercol", "periodname", "costcenternumber", "costcentername"});
        DataSet groupByCostCenterDataSet = this.getGroupDataSet(groupbyDataSet, subtotal, "costcenter");
        groupbyDataSet = dataSet.groupBy(new String[]{"period", "periodname"});
        DataSet groupByPeriodDataSet = this.getGroupDataSet(groupbyDataSet, subtotal, "period");
        groupbyDataSet = dataSet.groupBy();
        DataSet totalDataSet = this.getGroupDataSet(groupbyDataSet, total, "");
        DataSet resultSet = dataSet.union(groupByCostCenterDataSet).union(groupByPeriodDataSet).union(totalDataSet);
        return resultSet;
    }

    private DataSet getGroupDataSet(GroupbyDataSet groupbyDataSet, String total, String groupField) {
        DataSet resultSet = null;
        DataSet dataSet = groupbyDataSet.sum("beginperioddiff").sum("curperioddiff").sum("curperiodcarryover").sum("endperioddiff").finish();
        if ("costcenter".equals(groupField)) {
            resultSet = dataSet.select("0 as accorg,0 as costaccountcol,period,costcentercol,'' as periodname,'" + total + "' as costcenternumber,'' as costcentername,'' as sourcebill ,'' as difftypecol, 0 as element,0 as subelement,beginperioddiff,curperioddiff,curperiodcarryover,endperioddiff,1 as seqcol");
        } else if ("period".equals(groupField)) {
            resultSet = dataSet.select("0 as accorg,0 as costaccountcol,period,0 as costcentercol,'" + total + "' as periodname,'' as costcenternumber,'' as costcentername,'' as sourcebill ,'' as difftypecol, 0 as element,0 as subelement,beginperioddiff,curperioddiff,curperiodcarryover,endperioddiff,2 as seqcol");
        } else if ("".equals(groupField)) {
            resultSet = dataSet.select("0 as accorg,0 as costaccountcol,0 as period,0 as costcentercol,'" + total + "' as periodname,'' as costcenternumber,'' as costcentername,'' as sourcebill ,'' as difftypecol, 0 as element,0 as subelement,beginperioddiff,curperioddiff,curperiodcarryover,endperioddiff,3 as seqcol");
        }
        return resultSet;
    }

    private String getQueryFields() {
        String fields = "org as acctorg,costaccount as costaccountcol,period as period,costcenter as costcentercol,period.name as periodname,costcenter.number as costcenternumber,costcenter.name as costcentername,sourcebill as sourcebill,entryentity.difftype as difftypecol,entryentity.element as element,entryentity.subelement as subelement,entryentity.entrystartamt as beginperioddiff,entryentity.entrycurdiffamt as curperioddiff,entryentity.entrycurcarryamt as curperiodcarryover,entryentity.entryendamt as endperioddiff,0 as seqcol";
        return fields;
    }

    private QFilter getQFilter(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        Object value = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"org");
        QFilter filter = new QFilter("org", "=", value);
        value = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"costaccount");
        filter.and(new QFilter("costaccount", "=", value));
        FilterItemInfo filterItemInfo = filterInfo.getFilterItem("startperiod");
        DynamicObject startPeriod = (DynamicObject)filterItemInfo.getValue();
        filterItemInfo = filterInfo.getFilterItem("endperiod");
        DynamicObject endPeriod = (DynamicObject)filterItemInfo.getValue();
        List periodIds = PeriodHelper.getStart2EndAllPeriodIds((DynamicObject)startPeriod, (DynamicObject)endPeriod);
        filter.and(new QFilter("period", "in", (Object)periodIds));
        String difftype = (String)CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"difftype");
        String[] types = difftype.split(",");
        filter.and(new QFilter("entryentity.difftype", "in", (Object)types));
        value = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"costcenter");
        if (value != null) {
            filter.and(new QFilter("costcenter", "in", value));
        }
        return filter;
    }

    private DataSet mergeSameItem(DataSet dataSet) {
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"acctorg", "costaccountcol", "period", "costcentercol", "periodname", "costcenternumber", "costcentername", "sourcebill", "difftypecol", "element", "subelement"});
        DataSet ds = groupbyDataSet.sum("beginperioddiff").sum("curperioddiff").sum("curperiodcarryover").sum("endperioddiff").finish();
        ds = ds.select("acctorg,costaccountcol,period,costcentercol,periodname,costcenternumber,costcentername,sourcebill,difftypecol,element,subelement,beginperioddiff,curperioddiff,curperiodcarryover,endperioddiff,0 as seqcol");
        return ds;
    }
}

