/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.difftransfer;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ReportUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import org.apache.commons.collections.CollectionUtils;

public class UnAbsorbDiffRptPlugin
extends AbstractReportFormPlugin {
    protected static final Log logger = LogFactory.getLog(UnAbsorbDiffRptPlugin.class);
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final String[] clearFileName = new String[]{"periodnum", "manuorgname", "costcenternum", "costcentername", "entrycostobject", "entrymaterialnum", "entrymaterial"};
    private static final String CAL_SYSCTRLENTITY = "cal_sysctrlentity";

    public void afterBindData(EventObject e) {
        this.initOrg();
    }

    private void initOrg() {
        DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("org");
        if (!kd.bos.orm.util.CollectionUtils.isEmpty((Collection)org)) {
            return;
        }
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isAccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        if (isAccount) {
            this.getModel().setValue("org", (Object)new Object[]{currentOrgId});
            this.getView().updateView("org");
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"UnAbsorbDiffRptPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
        }
        this.configManuOrg();
        this.setCostAccount();
    }

    private void configManuOrg() {
        DynamicObjectCollection orgList = this.getModel().getDataEntity().getDynamicObjectCollection("org");
        if (orgList == null || orgList.size() == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        } else {
            List orgIds = orgList.stream().map(orgMul -> orgMul.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            List enableMulOrgIds = OrgHelper.getOrgEnableMultiFactory(orgIds);
            if (enableMulOrgIds == null || enableMulOrgIds.isEmpty()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
                this.getModel().setValue("manuorg", null);
            }
        }
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgInput = (BasedataEdit)this.getControl("org");
        orgInput.addBeforeF7SelectListener(evt -> {
            List orgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter qfId = new QFilter("id", "in", (Object)orgIds);
            List qFilters = filterParameter.getQFilters();
            qFilters.add(qfId);
        });
        BasedataEdit manuOrgInput = (BasedataEdit)this.getControl("manuorg");
        manuOrgInput.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("org");
            if (org.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"UnAbsorbDiffRptPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            ArrayList orgIdSet = new ArrayList();
            org.forEach(o -> orgIdSet.add(o.getDynamicObject("fbasedataid").getLong("id")));
            List orgEnableMultiFactory = OrgHelper.getOrgEnableMultiFactory(orgIdSet);
            Set<Long> userHasPermOrgs = this.getUserHasPermOrgs(orgEnableMultiFactory);
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(new QFilter("id", "in", userHasPermOrgs));
        });
        BasedataEdit costAccountInput = (BasedataEdit)this.getControl("costaccount");
        costAccountInput.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("org");
            if (org.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"UnAbsorbDiffRptPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            HashSet<Long> orgIdSet = new HashSet<Long>();
            org.forEach(o -> orgIdSet.add(o.getDynamicObject("fbasedataid").getLong("id")));
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(UnAbsorbDiffRptPlugin.getEndInitCostAccountIdsFilter(orgIdSet, this.getView().getFormShowParameter().getAppId()));
        });
        BasedataEdit beginPeriod = (BasedataEdit)this.getControl("beginperiod");
        beginPeriod.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("org");
            if (org.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"UnAbsorbDiffRptPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection costAccount = (DynamicObjectCollection)this.getModel().getValue("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"UnAbsorbDiffRptPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            HashSet<Long> orgIdSet = new HashSet<Long>();
            org.forEach(o -> orgIdSet.add(o.getDynamicObject("fbasedataid").getLong("id")));
            HashSet<Long> accountIdSet = new HashSet<Long>();
            costAccount.forEach(c -> accountIdSet.add(c.getDynamicObject("fbasedataid").getLong("id")));
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            QFilter filter = UnAbsorbDiffRptPlugin.getPeriodTypeFilter(this.getView().getFormShowParameter().getAppId(), orgIdSet, accountIdSet);
            if (filter == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u671f\u95f4\u7c7b\u578b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"UnAbsorbDiffRptPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(filter);
            this.getStartPeriodFilter(qFilters, accountIdSet, false);
        });
        BasedataEdit endPeriod = (BasedataEdit)this.getControl("endperiod");
        endPeriod.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("org");
            if (org.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"UnAbsorbDiffRptPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection costAccount = (DynamicObjectCollection)this.getModel().getValue("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"UnAbsorbDiffRptPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            HashSet<Long> orgIdSet = new HashSet<Long>();
            org.forEach(o -> orgIdSet.add(o.getDynamicObject("fbasedataid").getLong("id")));
            HashSet<Long> accountIdSet = new HashSet<Long>();
            costAccount.forEach(c -> accountIdSet.add(c.getDynamicObject("fbasedataid").getLong("id")));
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            QFilter filter = UnAbsorbDiffRptPlugin.getPeriodTypeFilter(this.getView().getFormShowParameter().getAppId(), orgIdSet, accountIdSet);
            if (filter == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u671f\u95f4\u7c7b\u578b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"UnAbsorbDiffRptPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(filter);
            this.getStartPeriodFilter(qFilters, accountIdSet, true);
        });
        BasedataEdit costCenterInput = (BasedataEdit)this.getControl("costcenter");
        costCenterInput.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("org");
            if (org.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u3002", (String)"UnAbsorbDiffRptPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                HashSet orgIdSet = new HashSet();
                org.forEach(o -> orgIdSet.add(o.getDynamicObject("fbasedataid").getLong("id")));
                QFilter qfId = null;
                for (Long orgId : orgIdSet) {
                    DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getValue("manuorg");
                    List manuOrgList = dynamicObjects.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList());
                    QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactoryForList((long)orgId, manuOrgList, (String)this.getView().getFormShowParameter().getAppId(), (String)this.getBillEntityId());
                    if (qfId != null) {
                        qfId = qfId.or(costCenterIdFilter);
                        continue;
                    }
                    qfId = costCenterIdFilter;
                }
                ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                QFilter qfNumber = new QFilter("orgduty.number", "=", (Object)"4");
                List qFilters = filterParameter.getQFilters();
                if (qfId != null) {
                    qFilters.add(qfId);
                }
                qFilters.add(qfNumber);
            }
        });
        BasedataEdit costObject = (BasedataEdit)this.getControl("costobject");
        costObject.addBeforeF7SelectListener(evt -> {
            DynamicObject material;
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObjectCollection costCenter = this.getModel().getDataEntity().getDynamicObjectCollection("costcenter");
            if (costCenter.size() > 0) {
                HashSet costCenterIds = new HashSet(16);
                costCenter.forEach(p -> costCenterIds.add(p.getDynamicObject("fbasedataid").getLong("masterid")));
                qFilters.add(new QFilter("costcenter", "in", costCenterIds));
            }
            if ((material = this.getModel().getDataEntity().getDynamicObject("material")) != null) {
                qFilters.add(new QFilter("material", "=", material.getPkValue()));
            }
            DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("org");
            ArrayList orgIdSet = new ArrayList();
            org.forEach(o -> orgIdSet.add(o.getDynamicObject("fbasedataid").getLong("id")));
            if (orgIdSet.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7", (String)"UnAbsorbDiffRptPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(new QFilter("org", "in", orgIdSet));
            DynamicObjectCollection manuorg = (DynamicObjectCollection)this.getModel().getValue("manuorg");
            ArrayList manuorgSet = new ArrayList();
            manuorg.forEach(o -> manuorgSet.add(o.getDynamicObject("fbasedataid").getLong("id")));
            if (!manuorgSet.isEmpty()) {
                qFilters.add(new QFilter("manuorg", "in", manuorgSet));
            }
        });
        BasedataEdit material = (BasedataEdit)this.getControl("material");
        material.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject costObj = this.getModel().getDataEntity().getDynamicObject("costobject");
            if (costObj != null) {
                qFilters.add(new QFilter("id", "=", (Object)costObj.getLong("material.masterid")));
            }
        });
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        try {
            String opName = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u67e5\u8be2", (String)"UnAbsorbDiffRptPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]), (String)"UnAbsorbDiffRptPlugin_10", (String)"macc-sca-form", (Object[])new Object[0]);
            String opDescription = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u672a\u5438\u6536\u8d39\u7528\u67e5\u8be2\u6210\u529f\u3002", (String)"UnAbsorbDiffRptPlugin_9", (String)"macc-sca-form", (Object[])new Object[0]), (String)"UnAbsorbDiffRptPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]);
            WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opName, (String)opDescription, (String)"sca_calcresultrpt", (IDataModel)this.getModel());
        }
        catch (Exception ex) {
            logger.error("\u67e5\u8be2\u5931\u8d25", (Throwable)ex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "org": {
                this.setCostAccount();
                this.configManuOrg();
                break;
            }
            case "costaccount": {
                this.setCurrency();
                this.setPeriod();
                break;
            }
            case "beginperiod": {
                this.setPeriodRange("begin");
                break;
            }
            case "endperiod": {
                this.setPeriodRange("end");
                break;
            }
            case "showtype": {
                this.setFieldVisible();
            }
        }
    }

    private void setFieldVisible() {
        String showType = this.getModel().getDataEntity().getString("showtype");
        if ("A".equals(showType)) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
    }

    public void setVisible(boolean flag) {
        this.getView().setVisible(Boolean.valueOf(flag), new String[]{"costobject"});
        this.getView().setVisible(Boolean.valueOf(flag), new String[]{"bizstatus"});
    }

    public void setCostAccount() {
        IDataModel model = this.getModel();
        DynamicObjectCollection org = (DynamicObjectCollection)model.getValue("org");
        model.setValue("costcenter", null);
        if (kd.bos.orm.util.CollectionUtils.isEmpty((Collection)org)) {
            this.getModel().setValue("costaccount", null);
            return;
        }
        HashSet<Long> orgIds = new HashSet<Long>();
        org.forEach(o -> orgIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
        DynamicObjectCollection costAccounts = this.getCostAccount(orgIds);
        HashMap<Long, DynamicObjectCollection> orgAndCostMap = new HashMap<Long, DynamicObjectCollection>();
        for (Object costAccount : costAccounts) {
            orgAndCostMap.computeIfAbsent(costAccount.getLong("orgid"), r -> new DynamicObjectCollection()).add(costAccount);
        }
        ArrayList<Long> accountIds = new ArrayList<Long>();
        block1: for (Map.Entry entry : orgAndCostMap.entrySet()) {
            DynamicObjectCollection values = (DynamicObjectCollection)entry.getValue();
            if (values.size() == 1) {
                accountIds.add(((DynamicObject)values.get(0)).getLong("accountid"));
                continue;
            }
            for (DynamicObject value : values) {
                if (!value.getBoolean("ismainaccount")) continue;
                accountIds.add(value.getLong("accountid"));
                continue block1;
            }
        }
        QFilter orgQF = new QFilter("org", "in", orgIds);
        QFilter qFilter = new QFilter("entry.costaccount", "in", accountIds);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)CAL_SYSCTRLENTITY, (String)"id, entry.currentperiod AS currentperiod", (QFilter[])new QFilter[]{orgQF, qFilter});
        HashSet periods = new HashSet();
        if (!dynamicObjects.isEmpty()) {
            dynamicObjects.forEach(dynamicObject -> periods.add(dynamicObject.getLong("currentperiod")));
        }
        if (accountIds.isEmpty() || periods.size() > 1) {
            this.getModel().setValue("costaccount", null);
            return;
        }
        model.setValue("costaccount", (Object)accountIds.toArray());
        this.getView().updateView("costaccount");
        this.setCurrency();
        this.setPeriod();
    }

    public void setCurrency() {
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getValue("costaccount");
        if (dynamicObjects.isEmpty()) {
            this.getModel().setValue("currency", null);
            return;
        }
        HashSet<Long> calpolicys = new HashSet<Long>();
        for (DynamicObject row : dynamicObjects) {
            DynamicObject dynamicObject = row.getDynamicObject("fbasedataid").getDynamicObject("calpolicy");
            if (dynamicObject == null) continue;
            calpolicys.add(dynamicObject.getLong("id"));
        }
        if (calpolicys.isEmpty()) {
            this.getModel().setValue("currency", null);
            return;
        }
        HashSet<Long> currencyIds = new HashSet<Long>();
        DynamicObjectCollection objectCollection = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "in", calpolicys)});
        for (DynamicObject dynamicObject : objectCollection) {
            currencyIds.add(dynamicObject.getLong("currency"));
        }
        if (currencyIds.size() == 0) {
            this.getModel().setValue("currency", null);
            return;
        }
        if (currencyIds.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5e01\u522b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u5e01\u522b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"UnAbsorbDiffRptPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]));
            this.getModel().setValue("costaccount", null);
            this.getView().updateView("costaccount");
            return;
        }
        this.getModel().setValue("currency", currencyIds.toArray()[0]);
        this.getView().updateView("currency");
    }

    public DynamicObjectCollection getCostAccount(Set<Long> orgIds) {
        QFilter accountorgQF = new QFilter("org", "in", orgIds);
        QFilter enablestdtQF = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"sca_startstdcost", (String)"org.id as orgid,entryentity.costaccount.id as accountid,entryentity.costaccount.ismainaccount as ismainaccount", (QFilter[])new QFilter[]{accountorgQF, enablestdtQF});
        return result;
    }

    public void setPeriod() {
        DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("org");
        DynamicObjectCollection account = (DynamicObjectCollection)this.getModel().getValue("costaccount");
        HashSet orgIds = new HashSet();
        HashSet costAccountIds = new HashSet();
        org.forEach(o -> orgIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
        account.forEach(c -> costAccountIds.add(c.getDynamicObject("fbasedataid").getLong("id")));
        if (orgIds.isEmpty() || costAccountIds.isEmpty()) {
            this.getModel().setValue("beginperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        QFilter orgQF = new QFilter("org", "in", orgIds);
        QFilter costAccountQF = new QFilter("entry.costaccount", "in", costAccountIds);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)CAL_SYSCTRLENTITY, (String)"id,entry.calpolicy.periodtype as periodtype, entry.currentperiod AS currentperiod", (QFilter[])new QFilter[]{orgQF, costAccountQF});
        if (dynamicObjects.isEmpty()) {
            this.getModel().setValue("beginperiod", null);
            this.getModel().setValue("endperiod", null);
        } else {
            HashSet<Long> periods = new HashSet<Long>();
            HashSet periodTypes = Sets.newHashSetWithExpectedSize((int)4);
            for (DynamicObject dynamicObject : dynamicObjects) {
                periods.add(dynamicObject.getLong("currentperiod"));
                periodTypes.add(dynamicObject.getLong("periodtype"));
            }
            if (periodTypes.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u671f\u95f4\u7c7b\u578b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"UnAbsorbDiffRptPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                this.getModel().setValue("beginperiod", null);
                this.getModel().setValue("endperiod", null);
            } else if (periods.size() == 1) {
                this.getModel().setValue("beginperiod", periods.toArray()[0]);
                this.getModel().setValue("endperiod", periods.toArray()[0]);
            } else {
                this.getModel().setValue("beginperiod", null);
                this.getModel().setValue("endperiod", null);
            }
        }
        this.getView().updateView("beginperiod");
        this.getView().updateView("endperiod");
    }

    public void setPeriodRange(String flag) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObject beginperiod = dataEntity.getDynamicObject("beginperiod");
        DynamicObject endperiod = dataEntity.getDynamicObject("endperiod");
        if (beginperiod == null || endperiod == null) {
            return;
        }
        if (beginperiod.getDate("begindate").compareTo(endperiod.getDate("begindate")) <= 0) {
            return;
        }
        if ("begin".equals(flag)) {
            this.getModel().setValue("endperiod", (Object)beginperiod);
        } else if ("end".equals(flag)) {
            this.getModel().setValue("beginperiod", (Object)endperiod);
        }
    }

    public static QFilter getEndInitCostAccountIdsFilter(Set<Long> orgIds, String appNum) {
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)appNum);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{orgFilter, qfAppNum, isInitFilter};
        DynamicObjectCollection costAccountIds = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])filters);
        if (CollectionUtils.isNotEmpty((Collection)costAccountIds)) {
            Set costAccountIdList = costAccountIds.stream().map(costAccount -> costAccount.getLong("costaccountid")).collect(Collectors.toSet());
            return new QFilter("id", "in", costAccountIdList);
        }
        return new QFilter("id", "=", (Object)0L);
    }

    public static QFilter getPeriodTypeFilter(String appNum, Set<Long> orgId, Set<Long> costAccountId) {
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)appNum);
        QFilter qfOrg = new QFilter("org", "in", orgId);
        QFilter qfCostAccount = new QFilter("entryentity.costaccount", "in", costAccountId);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.calpolicy.periodtype periodtype", (QFilter[])new QFilter[]{qfAppNum, qfOrg, qfCostAccount});
        if (result.isEmpty()) {
            return new QFilter("periodtype", ">", (Object)0L);
        }
        HashSet<Long> periodTypeIds = new HashSet<Long>();
        for (DynamicObject row : result) {
            periodTypeIds.add(row.getLong("periodtype"));
        }
        if (periodTypeIds.size() > 1) {
            return null;
        }
        return new QFilter("periodtype", "in", periodTypeIds);
    }

    public Set<Long> getUserHasPermOrgs(List<Long> accOrg) {
        HashSet productOrgs = Sets.newHashSetWithExpectedSize((int)16);
        for (Long org : accOrg) {
            productOrgs.addAll(ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org, (String)this.getBillEntityId()));
        }
        return productOrgs;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject endPeriod;
        DynamicObject beginPeriod;
        DynamicObject currency;
        DynamicObjectCollection costAccount;
        boolean isPass = true;
        FilterInfo filter = queryParam.getFilter();
        DynamicObjectCollection org = filter.getDynamicObjectCollection("org");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)org)) {
            isPass = false;
        }
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)(costAccount = filter.getDynamicObjectCollection("costaccount")))) {
            isPass = false;
        }
        if ((currency = filter.getDynamicObject("currency")) == null) {
            isPass = false;
        }
        if ((beginPeriod = filter.getDynamicObject("beginperiod")) == null) {
            isPass = false;
        }
        if ((endPeriod = filter.getDynamicObject("endperiod")) == null) {
            isPass = false;
        }
        if (!isPass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5185\u5bb9\u672a\u6309\u8981\u6c42\u586b\u5199\u3002", (String)"UnAbsorbDiffRptPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        FilterInfo filterInfo = queryParam.getFilter();
        filterInfo.addFilterItem("entityId", (Object)this.getBillEntityId());
        return super.verifyQuery(queryParam);
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        super.afterCreateColumn(e);
        List cols = e.getColumns();
        Iterator it = cols.iterator();
        String showType = this.getModel().getDataEntity().getString("showtype");
        boolean periodMerge = this.getModel().getDataEntity().getBoolean("periodmerge");
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof ReportColumn)) continue;
            ReportColumn reportColumn = (ReportColumn)obj;
            String key = reportColumn.getFieldKey();
            if (periodMerge && "periodnum".equals(key)) {
                reportColumn.setHide(true);
            }
            if ("B".equals(showType)) {
                if (!"entrycostobject".equals(key) && !"entrycostobjectname".equals(key) && !"manuorgname".equals(key) && !"entrybizstatus".equals(key) && !"sourcenumber".equals(key) && !"sourcerow".equals(key)) continue;
                reportColumn.setHide(true);
                continue;
            }
            if (!"C".equals(showType) || !"costcenternum".equals(key) && !"costcentername".equals(key) && !"entrycostobject".equals(key) && !"entrycostobjectname".equals(key) && !"manuorgname".equals(key) && !"entrybizstatus".equals(key) && !"sourcenumber".equals(key) && !"sourcerow".equals(key)) continue;
            reportColumn.setHide(true);
        }
        this.getView().updateView("reportlistap");
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        Boolean mergesame = (Boolean)this.getModel().getValue("mergesame");
        if (mergesame.booleanValue()) {
            ReportUtils.clearFileNameValue((String[])clearFileName, (DynamicObjectCollection)rowData, (String[])clearFileName);
        }
        for (DynamicObject rowDatum : rowData) {
            DynamicObject entrycostobject = rowDatum.getDynamicObject("entrycostobject");
            if (entrycostobject == null) continue;
            rowDatum.set("auxpty", entrycostobject.get("auxpty"));
        }
    }

    private void getStartPeriodFilter(List<QFilter> qFilters, Set<Long> costAccountId, boolean isEndPeriod) {
        QFilter filter = new QFilter("entry.costaccount", "in", costAccountId);
        DynamicObjectCollection result = QueryServiceHelper.query((String)CAL_SYSCTRLENTITY, (String)"entry.startperiod.id startperiod,entry.currentperiod.id currentperiod", (QFilter[])filter.toArray());
        if (result.isEmpty()) {
            qFilters.add(new QFilter("id", "=", (Object)-1L));
            return;
        }
        long startPeriod = ((DynamicObject)result.get(0)).getLong("startperiod");
        for (DynamicObject dynamicObject : result) {
            long period = dynamicObject.getLong("startperiod");
            if (period >= startPeriod) continue;
            startPeriod = period;
        }
        long lastPeriod = ((DynamicObject)result.get(0)).getLong("currentperiod");
        for (DynamicObject dynamicObject : result) {
            long period = dynamicObject.getLong("currentperiod");
            if (period <= lastPeriod) continue;
            lastPeriod = period;
        }
        qFilters.add(new QFilter("id", ">=", (Object)startPeriod));
        if (!isEndPeriod) {
            qFilters.add(new QFilter("id", "<=", (Object)lastPeriod));
        }
    }
}

