/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.feealloc;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.qing.Field;
import kd.bos.entity.qing.IQingDataProvider;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.entity.qing.QingMeta;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class MatAllocQingQueryPlugin
extends AbstractFormPlugin
implements IQingDataProvider {
    private static final String[] FILED_IDS = new String[]{"org", "costaccount", "costcenter", "costobejctentry", "submat", "material", "beginperiod", "endperiod"};

    public QingMeta getMeta(String arg0) {
        QingMeta result = this.createColumnItems();
        return result;
    }

    public QingData getData(String qingPageId, int start, int limit) {
        QingData result = new QingData();
        if (start != 1) {
            return result;
        }
        Map<String, Integer> dataIndex = this.createDataIndex();
        result.setDataindex(dataIndex);
        List<QFilter> filters = this.getRptFilterArgs();
        DataSet data = this.query(filters);
        List<Object[]> dataRows = MatAllocQingQueryPlugin.GetRowDatas(data, dataIndex);
        result.setRows(dataRows);
        return result;
    }

    private DataSet query(List<QFilter> filters) {
        if (filters == null || filters.isEmpty()) {
            return null;
        }
        String matType1 = ResManager.loadKDString((String)"\u5171\u8017\u6750\u6599", (String)"MatAllocQingQueryPlugin_15", (String)"macc-sca-form", (Object[])new Object[0]);
        String matType2 = ResManager.loadKDString((String)"\u76f4\u63a5\u6750\u6599", (String)"MatAllocQingQueryPlugin_16", (String)"macc-sca-form", (Object[])new Object[0]);
        QFilter cf = QFilter.of((String)"costobject  < ?", (Object[])new Object[]{1L});
        String str = "org.name orgname,costaccount.name acctname,costcenter.name centername,costobject.name objectname,period.name pdname,'" + matType1 + "' mattype,material.name matname,useamount amount,creator.name creator,entryentity.costobejctentry.name subobjectname,entryentity.costobejctentry.material.name submatname";
        DataSet comDataSet = QueryServiceHelper.queryDataSet((String)"aaa0-c", (String)"sca_matalloc", (String)str, (QFilter[])filters.toArray(new QFilter[]{cf}), (String)"period desc", (int)10000);
        QFilter df = QFilter.of((String)"costobject  > ?", (Object[])new Object[]{1L});
        String ds = "org.name orgname,costaccount.name acctname,costcenter.name centername,costobject.name objectname,period.name pdname,'" + matType2 + "' mattype,material.name matname,useamount amount,creator.name creator,entryentity.costobejctentry.name subobjectname,entryentity.costobejctentry.material.name submatname";
        DataSet dirDataSet = QueryServiceHelper.queryDataSet((String)"aaa0-d", (String)"sca_matalloc", (String)ds, (QFilter[])filters.toArray(new QFilter[]{df}), (String)"period desc", (int)10000);
        return comDataSet.union(dirDataSet);
    }

    private QingMeta createColumnItems() {
        QingMeta result = new QingMeta();
        result.addColumn(this.createFieldObj("orgname", ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"MatAllocQingQueryPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]), QingFieldType.String.toNumber()));
        result.addColumn(this.createFieldObj("acctname", ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f", (String)"MatAllocQingQueryPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]), QingFieldType.String.toNumber()));
        result.addColumn(this.createFieldObj("centername", ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3", (String)"MatAllocQingQueryPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]), QingFieldType.String.toNumber()));
        result.addColumn(this.createFieldObj("objectname", ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61", (String)"MatAllocQingQueryPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]), QingFieldType.String.toNumber()));
        result.addColumn(this.createFieldObj("subobjectname", ResManager.loadKDString((String)"\u6240\u5c5e\u6210\u672c\u6838\u7b97\u5bf9\u8c61", (String)"MatAllocQingQueryPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]), QingFieldType.String.toNumber()));
        result.addColumn(this.createFieldObj("matname", ResManager.loadKDString((String)"\u7269\u6599", (String)"MatAllocQingQueryPlugin_9", (String)"macc-sca-form", (Object[])new Object[0]), QingFieldType.String.toNumber()));
        result.addColumn(this.createFieldObj("submatname", ResManager.loadKDString((String)"\u6240\u5c5e\u7269\u6599", (String)"MatAllocQingQueryPlugin_10", (String)"macc-sca-form", (Object[])new Object[0]), QingFieldType.String.toNumber()));
        result.addColumn(this.createFieldObj("amount", ResManager.loadKDString((String)"\u6210\u672c\u91d1\u989d", (String)"MatAllocQingQueryPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]), QingFieldType.Number.toNumber()));
        result.addColumn(this.createFieldObj("mattype", ResManager.loadKDString((String)"\u8017\u7528\u7c7b\u578b", (String)"MatAllocQingQueryPlugin_12", (String)"macc-sca-form", (Object[])new Object[0]), QingFieldType.String.toNumber()));
        result.addColumn(this.createFieldObj("pdname", ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4", (String)"MatAllocQingQueryPlugin_13", (String)"macc-sca-form", (Object[])new Object[0]), QingFieldType.String.toNumber()));
        result.addColumn(this.createFieldObj("creator", ResManager.loadKDString((String)"\u521b\u5efa\u4eba", (String)"MatAllocQingQueryPlugin_14", (String)"macc-sca-form", (Object[])new Object[0]), QingFieldType.String.toNumber()));
        return result;
    }

    private Field createFieldObj(String key, String name, int fieldType) {
        Field field = new Field();
        field.setKey(key);
        field.setName(new LocaleString(name));
        field.setFieldType(fieldType);
        return field;
    }

    private Map<String, Integer> createDataIndex() {
        QingMeta meta = this.createColumnItems();
        return MatAllocQingQueryPlugin.createDataIndex(meta);
    }

    public static List<Object[]> GetRowDatas(DataSet ds, Map<String, Integer> dataIndexMap) {
        ArrayList<Object[]> rowDatas = new ArrayList<Object[]>();
        if (ds != null) {
            while (ds.hasNext()) {
                Row row = ds.next();
                Object[] curRowData = new Object[dataIndexMap.size()];
                int i = 0;
                for (String colName : dataIndexMap.keySet()) {
                    Object cellValue;
                    curRowData[i] = cellValue = row.get(colName);
                    ++i;
                }
                rowDatas.add(curRowData);
            }
        }
        return rowDatas;
    }

    public static Map<String, Integer> createDataIndex(QingMeta meta) {
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>(16);
        List columns = meta.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            result.put(((Field)columns.get(i)).getKey(), i);
        }
        return result;
    }

    private String getFilterCacheKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(RequestContext.get().getAccountId()).append('_');
        sb.append(RequestContext.get().getUserId()).append('_');
        sb.append("sca_matallocrpt");
        return sb.toString();
    }

    private List<QFilter> getRptFilterArgs() {
        String args = SessionManager.getCurrent().get(this.getFilterCacheKey());
        if (StringUtils.isEmpty((String)args)) {
            return null;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        Map map = (Map)SerializationUtils.fromJsonString((String)args, Map.class);
        for (String filed : FILED_IDS) {
            Object val = map.get(filed);
            if (val == null) continue;
            if ("beginperiod".equals(filed)) {
                filters.add(new QFilter("period", ">=", val));
                continue;
            }
            if ("endperiod".equals(filed)) {
                filters.add(new QFilter("period", "<=", val));
                continue;
            }
            filters.add(new QFilter(filed, "=", val));
        }
        return filters;
    }
}

