/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.restore;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.sca.algox.utils.CostAccountHelper;

public class DiffCheckRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private Log logger = LogFactory.getLog(DiffCheckRptPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("forg");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costacc");
        costaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costcenter = (BasedataEdit)this.getControl("costcenter");
        costcenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costobject = (BasedataEdit)this.getControl("product");
        costobject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit period = (BasedataEdit)this.getControl("headperiod");
        period.addBeforeF7SelectListener(evt -> {
            DynamicObject costAccount;
            DynamicObject accountOrg = this.getModel().getDataEntity().getDynamicObject("forg");
            if (CadEmptyUtils.isEmpty((DynamicObject)accountOrg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"DiffCheckRptPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if (CadEmptyUtils.isEmpty((DynamicObject)(costAccount = this.getModel().getDataEntity().getDynamicObject("costacc")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"DiffCheckRptPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                List qFilters = filterParameter.getQFilters();
                qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)Long.valueOf(String.valueOf(accountOrg.getPkValue())), (Long)Long.valueOf(String.valueOf(costAccount.getPkValue()))));
            }
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ReportShowParameter reportShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        ReportQueryParam reportQueryParam = reportShowParameter.getReportQueryParam();
        if (reportQueryParam != null) {
            return;
        }
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("forg");
        if (org != null) {
            return;
        }
        this.initQueryInfo();
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        ArrayList props = Lists.newArrayList((Object[])new String[]{"forg", "costacc", "currency", "headperiod"});
        boolean isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, (List)props);
        if (!isPass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"DiffCheckRptPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        try {
            WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)ResManager.loadKDString((String)"\u67e5\u8be2", (String)"DiffCheckRptPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"DiffCheckRptPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]), (String)"sca_diffalloccheckrpt", (IDataModel)this.getModel());
        }
        catch (Exception e) {
            this.logger.error("+++++\u5dee\u5f02\u5206\u644a\u5bf9\u6570\u62a5\u8868\u5199\u64cd\u4f5c\u65e5\u5fd7\u9519\u8bef" + e.getMessage());
        }
        return super.verifyQuery(queryParam);
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("forg");
        switch (name) {
            case "forg": {
                List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                QFilter idFilter = new QFilter("id", "in", (Object)hasPermAccountOrgIds);
                listShowParameter.getListFilterParameter().getQFilters().add(idFilter);
                break;
            }
            case "costacc": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"DiffCheckRptPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter costAccountFilter = StartCostHelper.getEndInitCostAccountIdsFilter((Long)((Long)org.getPkValue()), (String)"sca");
                listShowParameter.getListFilterParameter().getQFilters().add(costAccountFilter);
                break;
            }
            case "costcenter": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u3002", (String)"DiffCheckRptPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                QFilter orgFilter = new QFilter("accountorg", "=", (Object)org.getLong("id"));
                orgFilter.and(new QFilter("orgduty", "=", (Object)4L));
                listShowParameter.getListFilterParameter().getQFilters().add(orgFilter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyname = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyname) {
            case "forg": {
                this.getModel().setValue("costacc", null);
                this.getModel().setValue("currency", null);
                this.getModel().setValue("headperiod", null);
                this.getModel().setValue("product", null);
                this.setCostAccount(newValue);
                break;
            }
            case "costacc": {
                this.getModel().setValue("currency", null);
                this.getModel().setValue("headperiod", null);
                this.getModel().setValue("product", null);
                this.setCurrencyAndPeriod(newValue);
                break;
            }
            case "showdiffdetail": {
                if (((Boolean)newValue).booleanValue()) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"difftypes"});
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, new String[]{"difftypes"});
            }
        }
    }

    private void setCostAccount(Object org) {
        if (org == null) {
            return;
        }
        DynamicObject orgDO = (DynamicObject)org;
        Long costAccount = CostAccountHelper.getDefaultAccountByAcctOrg((Long)orgDO.getLong("id"), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
        if (costAccount != 0L) {
            this.getModel().setValue("costacc", (Object)costAccount);
        } else {
            this.getModel().setValue("costacc", null);
        }
    }

    private void setCurrencyAndPeriod(Object costAccount) {
        if (costAccount == null) {
            return;
        }
        DynamicObject costAccountDO = (DynamicObject)costAccount;
        Long currency = CalcRptHelper.getCurrency((DynamicObject)costAccountDO);
        this.getModel().setValue("currency", (Object)currency);
        this.getView().setEnable(Boolean.FALSE, new String[]{"currency"});
        this.setPeriod();
    }

    private void setPeriod() {
        Long costaccountId;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("forg");
        DynamicObject costaccount = dataEntity.getDynamicObject("costacc");
        if (org == null || costaccount == null) {
            return;
        }
        Long orgId = org.getLong("id");
        Long currperiod = CalcRptHelper.getCurrPeriod((Long)orgId, (Long)(costaccountId = Long.valueOf(costaccount.getLong("id"))));
        if (currperiod != null && currperiod != 0L) {
            this.getModel().setValue("headperiod", (Object)currperiod);
        }
    }

    private void initQueryInfo() {
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (isaccount && permAccountOrgIds.contains(currentOrgId)) {
            this.getModel().setValue("forg", (Object)currentOrgId);
            this.setCostAccount(this.getModel().getDataEntity().getDynamicObject("forg"));
            this.setCurrencyAndPeriod(this.getModel().getDataEntity().getDynamicObject("costacc"));
            this.getView().updateView();
        }
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        List columns = event.getColumns();
        String displaymodel = this.getModel().getDataEntity().getString("displaymodel");
        for (AbstractReportColumn col : columns) {
            if (!(col instanceof ReportColumn)) continue;
            ReportColumn reportColumn = (ReportColumn)col;
            String key = reportColumn.getFieldKey();
            if ("matversion".equals(key) || "aprox".equals(key)) {
                reportColumn.setHide(true);
            }
            if ("configuredcode".equals(key) && !"2".equals(displaymodel) && !"3".equals(displaymodel)) {
                reportColumn.setHide(true);
            }
            if (!"tracknumber".equals(key) || "3".equals(displaymodel)) continue;
            reportColumn.setHide(true);
        }
    }
}

