/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.common.errorcode;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;

public class FMMErrorCode {
    public static final ErrorCode DEFAULT_VALUE_ERROR = FMMErrorCode.create("defaultValueException", FMMErrorCode.getFailedToSetDefaultValue());
    public static final ErrorCode FORMULA_ERROR = FMMErrorCode.create("formulaException", FMMErrorCode.getIncorrectExpressionSyntax());
    public static final ErrorCode DATE_PARSE_ERROR = FMMErrorCode.create("dateParseException", FMMErrorCode.getDateConversionError());

    private FMMErrorCode() {
    }

    private static ErrorCode create(String code, String message) {
        return new ErrorCode("mmc.fmm." + code, message);
    }

    private static String getFailedToSetDefaultValue() {
        return ResManager.loadKDString((String)"\u8bbe\u7f6e\u9ed8\u8ba4\u503c\u5931\u8d25", (String)"FMMErrorCode_1", (String)"mmc-fmm-common", (Object[])new Object[0]);
    }

    private static String getIncorrectExpressionSyntax() {
        return ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u5b58\u5728\u8bed\u6cd5\u9519\u8bef\u3002", (String)"FMMErrorCode_2", (String)"mmc-fmm-common", (Object[])new Object[0]);
    }

    private static String getDateConversionError() {
        return ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (String)"FMMErrorCode_3", (String)"mmc-fmm-common", (Object[])new Object[0]);
    }
}

