/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.common.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.fmm.common.util.MMCUtils;

public class BOMUniqueUtil {
    public static String bomUniqueCheck(DynamicObject bom, String operate) {
        DynamicObject createOrg;
        String op = ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"BOMUniqueUtil_0", (String)"mmc-fmm-common", (Object[])new Object[0]);
        if (StringUtils.equalsIgnoreCase((CharSequence)operate, (CharSequence)"save")) {
            op = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"BOMUniqueUtil_1", (String)"mmc-fmm-common", (Object[])new Object[0]);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operate, (CharSequence)"submit")) {
            op = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"BOMUniqueUtil_2", (String)"mmc-fmm-common", (Object[])new Object[0]);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operate, (CharSequence)"assign")) {
            op = ResManager.loadKDString((String)"\u5206\u914d", (String)"BOMUniqueUtil_3", (String)"mmc-fmm-common", (Object[])new Object[0]);
        }
        if (bom == null) {
            return null;
        }
        IDataEntityType mainEntityType = bom.getDataEntityType();
        if (mainEntityType == null) {
            return null;
        }
        String entityKey = mainEntityType.getName();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        Long id = (Long)bom.getPkValue();
        if (id > 0L) {
            QFilter qFilter = new QFilter("id", "!=", (Object)id);
            qFilterList.add(qFilter);
        }
        if ((createOrg = MMCUtils.getDynamicObjectDynamicObjectData(bom, "createorg")) == null) {
            return null;
        }
        BaseDataService baseDataService = new BaseDataService();
        baseDataService.clearBaseDataFilterCache(entityKey, (Long)createOrg.getPkValue());
        QFilter baseDataCreaterOrgFilter = BaseDataServiceHelper.getBaseDataProFilter((String)entityKey, (Long)((Long)createOrg.getPkValue()), (String)"id");
        QFilter qFilter = new QFilter("createorg", "=", createOrg.getPkValue());
        if (baseDataCreaterOrgFilter != null) {
            qFilter = baseDataCreaterOrgFilter;
        }
        qFilterList.add(qFilter);
        DynamicObject matObj = MMCUtils.getDynamicObjectDynamicObjectData(bom, "materialid");
        if (matObj == null) {
            return null;
        }
        QFilter qFilter2 = new QFilter("materialid", "=", matObj.getPkValue());
        qFilterList.add(qFilter2);
        DynamicObject type = MMCUtils.getDynamicObjectDynamicObjectData(bom, "type");
        if (type == null) {
            return null;
        }
        qFilter = new QFilter("type", "=", type.getPkValue());
        qFilterList.add(qFilter);
        DynamicObject version = MMCUtils.getDynamicObjectDynamicObjectData(bom, "version");
        Long versionPK = 0L;
        if (version != null) {
            versionPK = Long.parseLong(version.getPkValue().toString());
        }
        QFilter qFilter3 = new QFilter("version", "=", (Object)versionPK);
        qFilterList.add(qFilter3);
        DynamicObject replace = MMCUtils.getDynamicObjectDynamicObjectData(bom, "replaceno");
        Long replacepk = 0L;
        if (replace != null) {
            replacepk = Long.parseLong(replace.getPkValue().toString());
        }
        QFilter reqFilter = new QFilter("replaceno", "=", (Object)replacepk);
        qFilterList.add(reqFilter);
        DynamicObject wbs = MMCUtils.getDynamicObjectDynamicObjectData(bom, "wbs");
        Long wbsPk = 0L;
        if (wbs != null) {
            wbsPk = Long.parseLong(wbs.getPkValue().toString());
        }
        QFilter wbsFilter = new QFilter("wbs", "=", (Object)wbsPk);
        qFilterList.add(wbsFilter);
        DynamicObject auxpty = MMCUtils.getDynamicObjectDynamicObjectData(bom, "auxproperty");
        Long auxptypk = 0L;
        if (auxpty != null) {
            auxptypk = Long.parseLong(auxpty.getPkValue().toString());
        }
        QFilter AupFilter = new QFilter("auxproperty", "=", (Object)auxptypk);
        qFilterList.add(AupFilter);
        DynamicObject configuredcode = bom.getDynamicObject("configuredcode");
        long configCode = 0L;
        if (configuredcode != null) {
            configCode = Long.parseLong(configuredcode.getPkValue().toString());
        }
        QFilter codeFilter = new QFilter("configuredcode", "=", (Object)configCode);
        qFilterList.add(codeFilter);
        if (StringUtils.isNotBlank((CharSequence)entityKey) && !qFilterList.isEmpty()) {
            DynamicObjectCollection exists = QueryServiceHelper.query((String)entityKey, (String)"id,number,createorg.name orgName", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
            StringBuilder error = new StringBuilder();
            for (DynamicObject o : exists) {
                if (error.length() > 0) {
                    error.append('\u3001');
                }
                error.append(String.format("%s(%s)", o.getString("number"), o.getString("orgName")));
            }
            if (error.length() > 0) {
                return String.format(ResManager.loadKDString((String)"\u5728\u4f7f\u7528\u7ec4\u7ec7\u201c%1$s\u201d\u4e0b\u5b58\u5728\u201c\u4ea7\u54c1\u7f16\u7801\u201d\u3001\u201cBOM\u7c7b\u578b\u201d\u3001\u201c\u7248\u672c\u53f7\u201d\u3001\u201cWBS\u201d\u3001\u201c\u66ff\u4ee3\u53f7\u201d\u3001\u201c\u8f85\u52a9\u5c5e\u6027\u201d\u76f8\u540c\u7684BOM\u6570\u636e\u201c%2$s\u201d\uff0c%3$s\u5931\u8d25\u3002", (String)"BOMUniqueUtil_4", (String)"mmc-fmm-common", (Object[])new Object[0]), MMCUtils.getDynamicObjectStringData(createOrg, "name"), error.toString(), op);
            }
        }
        return "";
    }

    public static DynamicObject repeatEntryValidate(String verifyDimension, Map<String, List<DynamicObject>> repeatEntryDataMap, DynamicObject entryData) {
        if (StringUtils.isEmpty((CharSequence)verifyDimension.trim())) {
            return null;
        }
        String[] splits = verifyDimension.split(",");
        StringBuilder uniqueBuilder = new StringBuilder();
        block14: for (int i = 0; i < splits.length; ++i) {
            switch (splits[i]) {
                case "A": {
                    DynamicObject material = entryData.getDynamicObject("entrymaterialid");
                    if (material == null) continue block14;
                    long materialPk = material.getLong("id");
                    uniqueBuilder.append(materialPk).append(":");
                    continue block14;
                }
                case "B": {
                    DynamicObject version = entryData.getDynamicObject("entryversion");
                    if (version == null) continue block14;
                    long versionPk = version.getLong("id");
                    uniqueBuilder.append(versionPk).append(":");
                    continue block14;
                }
                case "C": {
                    DynamicObject auxproperty = entryData.getDynamicObject("entryauxproperty");
                    if (auxproperty == null) continue block14;
                    long auxpropertyPk = auxproperty.getLong("id");
                    uniqueBuilder.append(auxpropertyPk).append(":");
                    continue block14;
                }
                case "D": {
                    String operationNumber = entryData.getString("entryoperationnumber");
                    if (!StringUtils.isNotEmpty((CharSequence)operationNumber)) continue block14;
                    uniqueBuilder.append(operationNumber).append(":");
                    continue block14;
                }
                case "E": {
                    DynamicObject configCode = entryData.getDynamicObject("entryconfiguredcode");
                    if (configCode == null) continue block14;
                    long configCodePk = configCode.getLong("id");
                    uniqueBuilder.append(configCodePk).append(":");
                }
            }
        }
        List repeatEntrys = repeatEntryDataMap.getOrDefault(uniqueBuilder.toString(), new ArrayList(2));
        DynamicObject repeatRow = null;
        if (repeatEntrys.isEmpty()) {
            repeatEntrys.add(entryData);
        } else {
            Date validate = entryData.getDate("entryvaliddate");
            Date invalidate = entryData.getDate("entryinvaliddate");
            for (DynamicObject rowData : repeatEntrys) {
                Date repeatInvalidate;
                Date repeatValidate = rowData.getDate("entryvaliddate");
                if (!BOMUniqueUtil.valiDateIntersect(validate, invalidate, repeatValidate, repeatInvalidate = rowData.getDate("entryinvaliddate"))) continue;
                repeatRow = rowData;
                break;
            }
            if (repeatRow == null) {
                repeatEntrys.add(entryData);
            }
        }
        repeatEntryDataMap.put(uniqueBuilder.toString(), repeatEntrys);
        return repeatRow;
    }

    private static boolean valiDateIntersect(Date validate, Date invalidate, Date repeatValidate, Date repeatInvalidate) {
        boolean dateFlag = false;
        if (!validate.before(repeatValidate) && !validate.after(repeatInvalidate)) {
            dateFlag = true;
        } else if (!invalidate.before(repeatValidate) && !invalidate.after(repeatInvalidate)) {
            dateFlag = true;
        } else if (!repeatValidate.before(validate) && !repeatValidate.after(invalidate)) {
            dateFlag = true;
        } else if (!repeatInvalidate.before(validate) && !repeatInvalidate.after(invalidate)) {
            dateFlag = true;
        }
        return dateFlag;
    }

    public static String getVerifyDimensionStr(String verifyDimension) {
        if (StringUtils.isEmpty((CharSequence)verifyDimension.trim())) {
            return null;
        }
        String[] splits = verifyDimension.split(",");
        StringBuilder messageBuilder = new StringBuilder();
        block14: for (int i = 0; i < splits.length; ++i) {
            switch (splits[i]) {
                case "A": {
                    messageBuilder.append(ResManager.loadKDString((String)"\u201c\u7ec4\u4ef6\u7f16\u7801\u201d", (String)"BOMUniqueUtil_5", (String)"mmc-fmm-common", (Object[])new Object[0])).append("\u3001");
                    continue block14;
                }
                case "B": {
                    messageBuilder.append(ResManager.loadKDString((String)"\u201c\u7248\u672c\u53f7\u201d", (String)"BOMUniqueUtil_6", (String)"mmc-fmm-common", (Object[])new Object[0])).append("\u3001");
                    continue block14;
                }
                case "C": {
                    messageBuilder.append(ResManager.loadKDString((String)"\u201c\u8f85\u52a9\u5c5e\u6027\u201d", (String)"BOMUniqueUtil_7", (String)"mmc-fmm-common", (Object[])new Object[0])).append("\u3001");
                    continue block14;
                }
                case "D": {
                    messageBuilder.append(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u53f7\u201d", (String)"BOMUniqueUtil_8", (String)"mmc-fmm-common", (Object[])new Object[0])).append("\u3001");
                    continue block14;
                }
                case "E": {
                    messageBuilder.append(ResManager.loadKDString((String)"\u201c\u914d\u7f6e\u53f7\u201d", (String)"BOMUniqueUtil_9", (String)"mmc-fmm-common", (Object[])new Object[0])).append("\u3001");
                }
            }
        }
        String message = "";
        if (StringUtils.isNotEmpty((CharSequence)messageBuilder.toString())) {
            message = messageBuilder.substring(0, messageBuilder.length() - 1);
        }
        return message;
    }

    public static String buildErrorMessageInfo(String verifyDimension, DynamicObject entry, String checkRepeat) {
        String verifyDimensionStr = BOMUniqueUtil.getVerifyDimensionStr(verifyDimension);
        String errorInfo = "";
        if ("B".equals(checkRepeat)) {
            String matNumber = BOMUniqueUtil.getMaterialNumber(entry);
            errorInfo = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u7f16\u7801%1$s\u5728\u540c\u4e00\u65f6\u95f4\u5185\u5b58\u5728%2$s\u5b8c\u5168\u76f8\u540c\u7684\u591a\u884c\u5206\u5f55\u3002", (String)"BOMUniqueUtil_10", (String)"mmc-fmm-common", (Object[])new Object[0]), matNumber, verifyDimensionStr);
        } else if ("C".equals(checkRepeat)) {
            String matNumber = BOMUniqueUtil.getMaterialNumber(entry);
            errorInfo = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u201d\u91cd\u590d\u6027\u6821\u9a8c\u201d\u4e3a\u201c\u4e25\u683c\u63a7\u5236\u201d\uff0c\u4e0d\u5141\u8bb8\u5b58\u5728\u91cd\u590d\u884c\uff0c\u7ec4\u4ef6\u7f16\u7801%1$s\u5728\u540c\u4e00\u65f6\u95f4\u5185\u5b58\u5728%2$s\u5b8c\u5168\u76f8\u540c\u7684\u591a\u884c\u5206\u5f55\u3002", (String)"BOMUniqueUtil_11", (String)"mmc-fmm-common", (Object[])new Object[0]), matNumber, verifyDimensionStr);
        }
        return errorInfo;
    }

    private static String getMaterialNumber(DynamicObject entry) {
        DynamicObject matInfo = entry.getDynamicObject("entrymaterial");
        DynamicObject material = null;
        material = matInfo != null ? matInfo.getDynamicObject("masterid") : entry.getDynamicObject("entrymaterialid");
        String materialNumber = "";
        if (material != null) {
            materialNumber = material.getString("number");
        }
        return materialNumber;
    }

    public static DynamicObject getBomTypeDefVersionRule(DynamicObject bomType) {
        if (bomType != null) {
            DynamicObject versionRuleNew;
            DynamicObject bomTypeNew = bomType;
            if (!bomType.containsProperty("isversion") || !bomType.containsProperty("versionrule")) {
                bomTypeNew = BusinessDataServiceHelper.loadSingleFromCache((Object)bomType.getPkValue(), (String)"mpdm_bomtype", (String)"isversion,versionrule");
            }
            boolean isversion = bomTypeNew.getBoolean("isversion");
            DynamicObject versionRule = bomTypeNew.getDynamicObject("versionrule");
            DynamicObject dynamicObject = versionRuleNew = isversion && versionRule != null ? versionRule : null;
            if (versionRuleNew != null) {
                return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_bomversionrule_new", (String)"id,number,entryentity.version", (QFilter[])new QFilter[]{new QFilter("id", "=", versionRuleNew.getPkValue())});
            }
        }
        return null;
    }

    public static boolean checkIsSameRule(DynamicObject versionRule, DynamicObject version) {
        if (versionRule != null && version != null) {
            DynamicObject rule = BOMUniqueUtil.getVersionRule(version);
            return versionRule.getPkValue().equals(rule.getPkValue());
        }
        return true;
    }

    public static DynamicObject getVersionRule(DynamicObject version) {
        DynamicObject newVersion = version;
        if (!version.containsProperty("bomversionrule")) {
            newVersion = BusinessDataServiceHelper.loadSingleFromCache((Object)version.getPkValue(), (String)version.getDynamicObjectType().getName(), (String)"bomversionrule");
        }
        return newVersion.getDynamicObject("bomversionrule");
    }
}

