/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.util.StringUtils;

public class MMCUtils {
    public final Calendar calendar = Calendar.getInstance();
    protected static final Date currDate = new Date();
    protected static final Timestamp currTime = new Timestamp(System.currentTimeMillis());
    public static final long dayTime = 86400000L;
    public static final String ENTITY_EQUARCHIVES = "eam_equarchives";
    public static final String ENTITY_FUNCTIONPOSITION = "eam_functionposition";
    public static final String ENTITY_FUNCTIONPOSITION_F7 = "eam_functionposition_bd";
    public static final long hourTime = 3600000L;
    public static final long minuteTime = 60000L;
    public static final DBRoute scmDBRoute = new DBRoute("scm");
    public static final long secondTime = 1000L;
    public static final DBRoute sysDBRoute = new DBRoute("sys");
    public static final int treeNodeMaxLevel = 50;
    public static final DBRoute wfsDBRoute = new DBRoute("wfs");

    private MMCUtils() {
    }

    public static FormShowParameter createFormShowParameter(String formID, ShowType showType, Map customParameters, CloseCallBack closeCallBack) {
        if (MMCUtils.isEmptyString(formID) || showType == null) {
            return null;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formID);
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        if (openStyle != null) {
            openStyle.setShowType(showType);
        }
        if (customParameters != null) {
            formShowParameter.setCustomParams(customParameters);
        }
        if (closeCallBack != null) {
            formShowParameter.setCloseCallBack(closeCallBack);
        }
        return formShowParameter;
    }

    public static BigDecimal getDataModelBigDecimalData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param);
        return value instanceof BigDecimal ? (BigDecimal)value : null;
    }

    public static BigDecimal getDataModelBigDecimalData(IDataModel dataModel, String param, BigDecimal defaultValue) {
        if (dataModel == null || param == null) {
            return defaultValue;
        }
        BigDecimal value = MMCUtils.getDataModelBigDecimalData(dataModel, param);
        return value == null ? defaultValue : value;
    }

    public static BigDecimal getDataModelBigDecimalData(IDataModel dataModel, String param, int rowIndex) {
        if (dataModel == null || param == null || rowIndex < 0) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param, rowIndex);
        return value instanceof BigDecimal ? (BigDecimal)value : null;
    }

    public static BigDecimal getDataModelBigDecimalData(IDataModel dataModel, String param, int rowIndex, BigDecimal defaultValue) {
        if (dataModel == null || param == null || rowIndex < 0) {
            return defaultValue;
        }
        BigDecimal value = MMCUtils.getDataModelBigDecimalData(dataModel, param, rowIndex);
        return value == null ? defaultValue : value;
    }

    public static Boolean getDataModelBooleanData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return Boolean.FALSE;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param);
        return value instanceof Boolean ? (Boolean)value : Boolean.FALSE;
    }

    public static Boolean getDataModelBooleanData(IDataModel dataModel, String param, int rowIndex) {
        if (dataModel == null || param == null || rowIndex < 0) {
            return Boolean.FALSE;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param, rowIndex);
        return value instanceof Boolean ? (Boolean)value : Boolean.FALSE;
    }

    public static Object getDataModelData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return null;
        }
        IDataEntityProperty dep = dataModel.getProperty(param);
        Object value = dep == null ? null : dataModel.getValue(param);
        return value;
    }

    public static Object getDataModelData(IDataModel dataModel, String param, int rowIndex) {
        if (dataModel == null || param == null || rowIndex < 0) {
            return null;
        }
        IDataEntityProperty dep = dataModel.getProperty(param);
        Object value = dep == null ? null : dataModel.getValue(param, rowIndex);
        return value;
    }

    public static Date getDataModelDateData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param);
        return value instanceof Date ? (Date)value : null;
    }

    public static Date getDataModelDateData(IDataModel dataModel, String param, int rowIndex) {
        if (dataModel == null || param == null || rowIndex < 0) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param, rowIndex);
        return value instanceof Date ? (Date)value : null;
    }

    public static DynamicObject getDataModelDynamicObjectData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param);
        return value instanceof DynamicObject ? (DynamicObject)value : null;
    }

    public static DynamicObject getDataModelDynamicObjectData(IDataModel dataModel, String param, int rowIndex) {
        if (dataModel == null || param == null || rowIndex < 0) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param, rowIndex);
        return value instanceof DynamicObject ? (DynamicObject)value : null;
    }

    public static Integer getDataModelIntegerData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param);
        return value instanceof Integer ? (Integer)value : null;
    }

    public static Integer getDataModelIntegerData(IDataModel dataModel, String param, int rowIndex) {
        if (dataModel == null || param == null || rowIndex < 0) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param, rowIndex);
        return value instanceof Integer ? (Integer)value : null;
    }

    public static ILocaleString getDataModelLocaleStringData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param);
        return value instanceof ILocaleString ? (ILocaleString)value : null;
    }

    public static String getDataModelStringData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param);
        return value == null ? null : value.toString();
    }

    public static String getDataModelStringData(IDataModel dataModel, String param, int rowIndex) {
        if (dataModel == null || param == null || rowIndex < 0) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param, rowIndex);
        return value == null ? null : value.toString();
    }

    public static String getDataModelStringData(IDataModel dataModel, String param, int rowIndex, String defaultValue) {
        if (dataModel == null || param == null || rowIndex < 0) {
            return defaultValue;
        }
        String value = MMCUtils.getDataModelStringData(dataModel, param, rowIndex);
        return value == null ? defaultValue : value;
    }

    public static String getDataModelStringData(IDataModel dataModel, String param, String defaultValue) {
        if (dataModel == null || param == null) {
            return defaultValue;
        }
        String value = MMCUtils.getDataModelStringData(dataModel, param);
        return value == null ? defaultValue : value;
    }

    public static BigDecimal getDynamicObjectBigDecimalData(DynamicObject dynObj, String param) {
        if (dynObj == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDynamicObjectData(dynObj, param);
        return value instanceof BigDecimal ? (BigDecimal)value : null;
    }

    public static BigDecimal getDynamicObjectBigDecimalData(DynamicObject dynObj, String param, BigDecimal defaultValue) {
        if (dynObj == null || param == null) {
            return defaultValue;
        }
        BigDecimal value = MMCUtils.getDynamicObjectBigDecimalData(dynObj, param);
        return value == null ? defaultValue : value;
    }

    public static Boolean getDynamicObjectBooleanData(DynamicObject dynObj, String param) {
        if (dynObj == null || param == null) {
            return Boolean.FALSE;
        }
        Object value = MMCUtils.getDynamicObjectData(dynObj, param);
        return value instanceof Boolean ? (Boolean)value : Boolean.FALSE;
    }

    public static Object getDynamicObjectData(DynamicObject dynObj, String param) {
        if (dynObj == null || param == null) {
            return null;
        }
        IDataEntityType det = dynObj.getDataEntityType();
        if (det == null) {
            return null;
        }
        DataEntityPropertyCollection depc = det.getProperties();
        if (MMCUtils.isEmptyList((List)depc)) {
            return null;
        }
        if (!depc.containsKey((Object)param)) {
            return null;
        }
        Object value = dynObj.get(param);
        return value;
    }

    public static Date getDynamicObjectDateData(DynamicObject dynObj, String param) {
        if (dynObj == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDynamicObjectData(dynObj, param);
        return value instanceof Date ? (Date)value : null;
    }

    public static DynamicObject getDynamicObjectDynamicObjectData(DynamicObject dynObj, String param) {
        if (dynObj == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDynamicObjectData(dynObj, param);
        return value instanceof DynamicObject ? (DynamicObject)value : null;
    }

    public static Integer getDynamicObjectIntegerData(DynamicObject dynObj, String param) {
        if (dynObj == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDynamicObjectData(dynObj, param);
        return value instanceof Integer ? (Integer)value : null;
    }

    public static Long getDynamicObjectPK(DynamicObject dynObj) {
        Object pkObj = dynObj == null ? null : dynObj.getPkValue();
        Long pk = pkObj == null ? Long.valueOf(-1L) : Long.valueOf(Long.parseLong(pkObj.toString()));
        return pk > 0L ? pk : -1L;
    }

    public static String getDynamicObjectStringData(DynamicObject dynObj, String param) {
        if (dynObj == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDynamicObjectData(dynObj, param);
        return value == null ? null : value.toString();
    }

    public static String getDynamicObjectStringData(DynamicObject dynObj, String param, String defaultValue) {
        if (dynObj == null || param == null) {
            return defaultValue;
        }
        String value = MMCUtils.getDynamicObjectStringData(dynObj, param);
        return value == null ? defaultValue : value;
    }

    public static Object getMapData(Map map, Object param) {
        if (MMCUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = null;
        if (map.get(param) != null) {
            value = map.get(param);
        }
        return value;
    }

    public static boolean isOne(BigDecimal a) {
        return a.compareTo(BigDecimal.ONE) == 0;
    }

    public static BigDecimal divide(BigDecimal a, BigDecimal b) {
        return MMCUtils.isOne(b) ? a : a.divide(b, 10, RoundingMode.HALF_UP);
    }

    public static BigDecimal multiply(BigDecimal a, BigDecimal b) {
        return MMCUtils.isOne(a) ? b : (MMCUtils.isOne(b) ? a : a.multiply(b).setScale(10, RoundingMode.HALF_UP));
    }

    public static BigDecimal multiplyAndDivide(BigDecimal a, BigDecimal b, BigDecimal c) {
        if (b.compareTo(c) == 0) {
            return a;
        }
        BigDecimal mulValue = MMCUtils.multiply(a, b);
        return MMCUtils.divide(mulValue, c);
    }

    public static String getMapStringData(Map map, Object param) {
        if (MMCUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = MMCUtils.getMapData(map, param);
        return value == null ? null : value.toString();
    }

    public static boolean isEmptyList(List list) {
        if (list == null) {
            return true;
        }
        return list.size() == 0;
    }

    public static boolean isEmptyMap(Map map) {
        if (map == null) {
            return true;
        }
        return map.size() == 0;
    }

    public static boolean isEmptySet(Set set) {
        if (set == null) {
            return true;
        }
        return set.size() == 0;
    }

    public static boolean isEmptyString(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().length() == 0;
    }

    public static boolean isEmptyStringBuilder(String sb) {
        if (sb == null) {
            return true;
        }
        if (sb.length() == 0) {
            return true;
        }
        return sb.trim().length() == 0;
    }

    public static LocaleString LocaleDynamicObjectCollectionToLocaleString(Object ldocObj, String propName) {
        String localeID;
        if (ldocObj == null || MMCUtils.isEmptyString(propName)) {
            return null;
        }
        LocaleString ls = new LocaleString();
        LocaleDynamicObjectCollection ldoc = ldocObj instanceof LocaleDynamicObjectCollection ? (LocaleDynamicObjectCollection)ldocObj : null;
        IDataEntityProperty localeDEP = ldoc == null ? null : ldoc.getLocaleIdProperty();
        String localeDEPName = localeDEP == null ? null : localeDEP.getName();
        int ldocSize = ldoc == null ? 0 : ldoc.size();
        Object localeIDObj = ldoc == null || localeDEP == null ? null : ldoc.getCurrentLocaleValue(localeDEP);
        String string = localeID = localeIDObj == null ? null : localeIDObj.toString();
        if (!MMCUtils.isEmptyString(localeID)) {
            for (int ldocIndex = 0; ldocIndex < ldocSize && ldoc != null; ++ldocIndex) {
                String tmpLocaleID;
                DynamicObject ldo = (DynamicObject)ldoc.get(ldocIndex);
                if (ldo == null || MMCUtils.isEmptyString(localeDEPName) || MMCUtils.isEmptyString(tmpLocaleID = MMCUtils.getDynamicObjectStringData(ldo, localeDEPName))) continue;
                String localeText = MMCUtils.getDynamicObjectStringData(ldo, propName);
                ls.setItem(tmpLocaleID, (Object)localeText);
            }
        }
        if (ls.size() == 0) {
            return null;
        }
        return ls;
    }

    public static LocaleString OrmLocaleValueToLocaleString(Object olvObj) {
        Iterator olvIterator;
        if (olvObj == null) {
            return null;
        }
        LocaleString ls = new LocaleString();
        OrmLocaleValue olv = olvObj instanceof OrmLocaleValue ? (OrmLocaleValue)olvObj : null;
        Set olvKeySet = olv == null ? null : olv.keySet();
        Iterator iterator = olvIterator = olvKeySet == null ? null : olvKeySet.iterator();
        if (olvIterator != null) {
            while (olvIterator.hasNext()) {
                String olvKey;
                Object olvKeyObj = olvIterator.next();
                String string = olvKey = olvKeyObj == null ? null : olvKeyObj.toString();
                if (MMCUtils.isEmptyString(olvKey)) continue;
                String olvValue = olv.get((Object)olvKey);
                ls.setItem(olvKey, (Object)olvValue);
            }
        }
        if (ls.size() == 0) {
            return null;
        }
        return ls;
    }

    public static int[] SetToInt(Set<Integer> allSet) {
        Integer[] temp = allSet.toArray(new Integer[0]);
        int[] intArray = new int[temp.length];
        for (int i = 0; i < temp.length; ++i) {
            intArray[i] = temp[i];
        }
        return intArray;
    }

    public static String getAllFields(String entityNumber, String entry) {
        return MMCUtils.getAllFields(MMCUtils.getAllFieldsByEntity(entityNumber, entry));
    }

    public static String getAllFields(Set<String> fieldSet) {
        StringBuilder msg = new StringBuilder();
        int seq = 0;
        for (String field : fieldSet) {
            if (seq > 0) {
                msg.append(",");
            }
            msg.append(field);
            ++seq;
        }
        return msg.toString();
    }

    private static boolean isEntityField(DynamicProperty prop) {
        if (MMCUtils.isMulLanguaueText(prop.getName())) {
            return false;
        }
        if (prop.getDisplayName() == null) {
            return false;
        }
        return !StringUtils.isEmpty((String)prop.getAlias());
    }

    private static boolean isMulLanguaueText(String propName) {
        return "multilanguagetext".equalsIgnoreCase(propName);
    }

    public static Set<String> getAllFieldsByEntity(String entityNumber, String entry) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Set headSet = mainType.getFields().keySet();
        HashSet<String> fieldSet = new HashSet<String>(64);
        for (String field : headSet) {
            DynamicProperty prop = mainType.getProperty(field);
            if (!MMCUtils.isEntityField(prop)) continue;
            fieldSet.add(field);
        }
        if (entry != null && !"".equals(entry)) {
            fieldSet.add(entry);
            fieldSet.add(entry + ".seq");
            EntityType subEntryType = (EntityType)mainType.getAllEntities().get(entry);
            Set keySet = subEntryType.getFields().keySet();
            for (String field : keySet) {
                DynamicProperty prop = subEntryType.getProperty(field);
                if (!MMCUtils.isEntityField(prop)) continue;
                fieldSet.add(entry + "." + field);
            }
        }
        return fieldSet;
    }
}

