/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProgrameVersionUtils {
    private static final String KEY_ENTITY_RULE = "bd_bomversionrule_new";
    private static final String KEY_ENTITY_VERSION = "bd_bomversion_new";
    private static Log logger = LogFactory.getLog(ProgrameVersionUtils.class);

    public static boolean isProgrameVsersion(Long orgId) {
        return ProgrameVersionUtils.getBizAppParam(orgId, "isopeprogrameversion", "fmm");
    }

    public static boolean isMaterialVsersion(DynamicObject material) {
        if (material.containsProperty("isenablematerialversion")) {
            return material.getBoolean("isenablematerialversion");
        }
        return MaterialQueryHelper.getDataCacheByID((Object)material.getPkValue()).getBoolean("isenablematerialversion");
    }

    public static boolean getBizAppParam(Long orgId, String paramNumber, String bizAppNum) {
        AppParam appParam = new AppParam();
        DynamicObject bizApp = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"id,orgfunc", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bizAppNum)});
        appParam.setAppId(bizApp.getString("id"));
        appParam.setViewType(bizApp.getString("orgfunc"));
        appParam.setOrgId(orgId);
        appParam.setActBookId(Long.valueOf(0L));
        Map syPparams = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        return syPparams.getOrDefault(paramNumber, false);
    }

    public static DynamicObject getDefaultVersionRule(String type) {
        String defField = "B".equals(type) ? "isdefaultroute" : ("C".equals(type) ? "isdefaultprograme" : "isdefault");
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterType = new QFilter("multype", "like", (Object)("%" + type + "%"));
        QFilter qFilter2 = new QFilter(defField, "=", (Object)Boolean.TRUE);
        return BusinessDataServiceHelper.loadSingleFromCache((String)KEY_ENTITY_RULE, (String)"id,number,entryentity.version", (QFilter[])new QFilter[]{qFilter2, qFilterStatus, qFilterEnable, qFilterType});
    }

    public static Date getValidDate(Date validdate) {
        return validdate == null ? new Date() : validdate;
    }

    public static Date getInValidDate(Date invaliddate) {
        if (invaliddate == null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                invaliddate = sdf.parse("2999-12-31");
            }
            catch (ParseException e) {
                logger.error((Object)"SimpleDateFormat ParseException", (Throwable)e);
            }
        }
        return invaliddate;
    }

    public static DynamicObject createAndGetProgrameVersion(DynamicObject programe, boolean isCreate, Set<Long> unVersionIdSet) {
        DynamicObject createorg = programe.getDynamicObject("createorg");
        DynamicObject material = programe.getDynamicObject("material");
        DynamicObject rule = ProgrameVersionUtils.getDefaultVersionRule("C");
        if (rule == null) {
            if (!isCreate) {
                return null;
            }
            ErrorCode ec = new ErrorCode("rule", ResManager.loadKDString((String)"\u672a\u627e\u5230\u9ed8\u8ba4\u7248\u672c\u89c4\u5219\uff0c\u65e0\u6cd5\u521b\u5efa\u4ea7\u54c1\u914d\u65b9\u7248\u672c\u3002", (String)"ProgrameVersionUtils_01", (String)"mmc-fmm-common", (Object[])new Object[0]));
            throw new KDBizException(ec, new Object[0]);
        }
        DynamicObject newRouteVersion = ProgrameVersionUtils.getProgrameVersion(createorg, material, rule, (Long)programe.getPkValue(), unVersionIdSet);
        return newRouteVersion == null && isCreate ? ProgrameVersionUtils.createProgrameVersion(createorg, material, rule, (Long)programe.getPkValue()) : newRouteVersion;
    }

    public static DynamicObject getInitProgrameVersion(DynamicObject createorg, DynamicObject material) {
        DynamicObject rule = ProgrameVersionUtils.getDefaultVersionRule("C");
        return rule == null ? null : ProgrameVersionUtils.getProgrameVersion(createorg, material, rule, 0L);
    }

    public static DynamicObject getProgrameVersion(DynamicObject createorg, DynamicObject material, DynamicObject rule, Long srcId) {
        return ProgrameVersionUtils.getProgrameVersion(createorg, material, rule, srcId, null);
    }

    public static DynamicObject getProgrameVersion(DynamicObject createorg, DynamicObject material, DynamicObject rule, Long srcId, Set<Long> unVersionIdSet) {
        if (material == null || rule == null) {
            return null;
        }
        QFilter qFilter = new QFilter("material", "=", material.getPkValue());
        qFilter.and(new QFilter("bomversionrule", "=", rule.getPkValue()));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("type", "=", (Object)"C"));
        if (unVersionIdSet != null && !unVersionIdSet.isEmpty()) {
            qFilter.and(new QFilter("id", "not in", unVersionIdSet));
        }
        Date date = new Date();
        QFilter qFilterDate = new QFilter("effectdate", "<=", (Object)date);
        qFilterDate.and(new QFilter("invaliddate", ">", (Object)date));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)KEY_ENTITY_VERSION, (String)"id,name,versionname.entryseq entryseq", (QFilter[])new QFilter[]{qFilter, qFilterDate}, (String)"versionname.entryseq desc ");
        Set versionIdSet = coll.stream().map(p -> p.getLong("id")).collect(Collectors.toSet());
        if (versionIdSet == null || versionIdSet.isEmpty()) {
            return null;
        }
        List<Long> versionIdList = coll.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
        qFilter = new QFilter("material", "=", material.getPkValue());
        qFilter.and(new QFilter("version", "in", versionIdSet));
        qFilter.and(new QFilter("id", "<>", (Object)srcId));
        qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"fmm_programe", (Long)createorg.getLong("id")));
        DynamicObjectCollection routeVersionColl = QueryServiceHelper.query((String)"fmm_programe", (String)"version", (QFilter[])new QFilter[]{qFilter}, (String)"");
        Set<Long> programeVersionIdSet = routeVersionColl.stream().map(p -> p.getLong("version")).collect(Collectors.toSet());
        Long maxVersionId = ProgrameVersionUtils.getNotUsedVersionId(versionIdList, programeVersionIdSet);
        return maxVersionId == null || maxVersionId.equals(0L) ? null : ProgrameVersionUtils.getCurrentVersionById(maxVersionId);
    }

    public static Long getNotUsedVersionId(List<Long> versionIdList, Set<Long> programeVersionIdSet) {
        int maxSeq = -1;
        int size = versionIdList.size();
        int i = 0;
        while (i < size) {
            Long id = versionIdList.get(i);
            if (programeVersionIdSet.contains(id)) {
                maxSeq = i - 1;
                break;
            }
            maxSeq = i++;
        }
        return maxSeq >= 0 ? versionIdList.get(maxSeq) : Long.valueOf(0L);
    }

    public static DynamicObject createProgrameVersion(DynamicObject createorg, DynamicObject material, DynamicObject rule, Long srcBillId) {
        DynamicObject versionDy = ProgrameVersionUtils.getAutoVersionWithDynamicObject(createorg.getPkValue(), material.getPkValue(), rule.getPkValue());
        if (versionDy == null) {
            ErrorCode ec = new ErrorCode("version", ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7248\u672c\u53f7\uff0c\u4e0d\u5141\u8bb8\u521b\u5efa\u4ea7\u54c1\u914d\u65b9\u7248\u672c\u3002", (String)"ProgrameVersionUtils_02", (String)"mmc-fmm-common", (Object[])new Object[0]));
            throw new KDBizException(ec, new Object[0]);
        }
        return ProgrameVersionUtils.buildVersionData(versionDy, material, rule, createorg, "C", srcBillId);
    }

    public static DynamicObject getCurrentVersion(DynamicObject createorg, DynamicObject material, DynamicObject rule, Long srcBillId) {
        QFilter qFilter = new QFilter("material", "=", material.getPkValue());
        qFilter.and(new QFilter("bomversionrule", "=", rule.getPkValue()));
        qFilter.and(new QFilter("srcbillid", "=", (Object)srcBillId));
        qFilter.and(new QFilter("type", "=", (Object)"C"));
        return ProgrameVersionUtils.getCurrentVersionByFilter(qFilter);
    }

    public static DynamicObject getCurrentVersionById(Long id) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        return ProgrameVersionUtils.getCurrentVersionByFilter(qFilter);
    }

    public static DynamicObject getCurrentVersionByFilter(QFilter qfilter) {
        return BusinessDataServiceHelper.loadSingle((String)KEY_ENTITY_VERSION, (String)ProgrameVersionUtils.getVersonSelectProperties(), (QFilter[])new QFilter[]{qfilter});
    }

    private static DynamicObject buildVersionData(DynamicObject versionDy, DynamicObject material, DynamicObject rule, DynamicObject createorg, String type, Long srcBillId) {
        String version = versionDy.getString("version");
        Long versionId = versionDy.getLong("id");
        DynamicObject bomversion = ORM.create().newDynamicObject(KEY_ENTITY_VERSION);
        String materNum = material.getString("number");
        String ruleNum = rule.getString("number");
        DynamicObject ruleEntry = BusinessDataServiceHelper.loadSingleFromCache((Object)versionId, (String)"bd_bomversionruleentry_f7");
        ILocaleString verName = ruleEntry.getLocaleString("version");
        String verNum = verName.getLocaleValue();
        String tag = "B".equals(type) ? "route" : ("C".equals(type) ? "formula" : "bom");
        String number = materNum + "-" + ruleNum + "-" + tag + "-" + verNum;
        bomversion.set("number", (Object)number);
        bomversion.set("name", (Object)version);
        bomversion.set("type", (Object)type);
        bomversion.set("versionname", (Object)ruleEntry);
        bomversion.set("bomversionrule", (Object)rule);
        bomversion.set("material", (Object)material);
        bomversion.set("createorg", (Object)createorg);
        bomversion.set("effectdate", (Object)ProgrameVersionUtils.getValidDate(null));
        bomversion.set("invaliddate", (Object)ProgrameVersionUtils.getInValidDate(null));
        bomversion.set("ctrlstrategy", (Object)"5");
        bomversion.set("enable", (Object)"1");
        bomversion.set("status", (Object)"C");
        bomversion.set("ecnbillno", (Object)"");
        bomversion.set("srcbillid", (Object)srcBillId);
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)KEY_ENTITY_VERSION, (DynamicObject[])new DynamicObject[]{bomversion}, (OperateOption)ProgrameVersionUtils.getOperateOption());
        if (!operateResult.isSuccess()) {
            StringBuilder sb = new StringBuilder();
            for (IOperateInfo info : operateResult.getAllErrorOrValidateInfo()) {
                sb.append(info.getMessage()).append('\n');
            }
            if (sb.length() <= 0) {
                sb.append(operateResult.getMessage());
            }
            ErrorCode ec = new ErrorCode("save", sb.toString());
            throw new KDBizException(ec, new Object[0]);
        }
        List addPkIds = operateResult.getSuccessPkIds();
        QFilter qFilter3 = new QFilter("id", "in", (Object)addPkIds);
        return ProgrameVersionUtils.getCurrentVersionByFilter(qFilter3);
    }

    private static String getVersonSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",number");
        sb.append(",name");
        sb.append(",material");
        sb.append(",ecnbillno");
        sb.append(",srcbillid");
        return sb.toString();
    }

    public static OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        option.setVariableValue("batchop_batchsize", "50");
        option.setVariableValue("needlog", String.valueOf(true));
        return option;
    }

    public static DynamicObject getAutoVersionWithDynamicObject(Object orgId, Object materId, Object ruleId) {
        int maxSeq = ProgrameVersionUtils.getExistsVersionMaxSeq(orgId, materId, ruleId);
        return ProgrameVersionUtils.getNoProgrameVersionDynamicObject(ruleId, maxSeq);
    }

    private static DynamicObject getNoProgrameVersionDynamicObject(Object ruleId, int maxSeq) {
        DynamicObjectCollection rules;
        QFilter qFilter = new QFilter("id", "=", ruleId);
        if (maxSeq >= 0) {
            qFilter.and(new QFilter("entryentity.seq", ">", (Object)maxSeq));
        }
        if ((rules = QueryServiceHelper.query((String)KEY_ENTITY_RULE, (String)"entryentity.id id,entryentity.version version,entryentity.seq seq", (QFilter[])new QFilter[]{qFilter}, (String)"entryentity.seq")) == null || rules.isEmpty()) {
            return null;
        }
        return (DynamicObject)rules.get(0);
    }

    private static int getExistsVersionMaxSeq(Object orgId, Object materId, Object ruleId) {
        QFilter qFilter1 = new QFilter("material", "=", materId);
        QFilter qFilter2 = new QFilter("bomversionrule", "=", ruleId);
        QFilter qFilter3 = new QFilter("type", "=", (Object)"C");
        String selectProperties = "versionname.entryseq entryseq";
        int maxSeq = -1;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(ProgrameVersionUtils.class.getName() + "_getExistsVersionNameSet"), (String)KEY_ENTITY_VERSION, (String)selectProperties, (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3}, (String)" versionname.entryseq desc ");){
            for (Row arow : ds) {
                if (maxSeq >= arow.getInteger("entryseq")) continue;
                maxSeq = arow.getInteger("entryseq");
            }
        }
        return maxSeq;
    }
}

