/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;

public class ResourceFieldHelper {
    public static String getFuncsXML(String[] supportMethod) {
        HashSet<String> functionSet = new HashSet<String>(Arrays.asList(supportMethod));
        FunctionTypes functionTypes = FunctionTypes.getCommonFuncs();
        Iterator functionTypeIterator = functionTypes.getFunctionTypes().iterator();
        while (functionTypeIterator.hasNext()) {
            FunctionType function = (FunctionType)functionTypeIterator.next();
            String functionId = function.getId();
            if (functionSet.contains(functionId)) continue;
            functionTypeIterator.remove();
        }
        ResourceFieldHelper.addRelationOrgCustomMethod(functionTypes, functionSet);
        ResourceFieldHelper.addDateDiffCustomMethod(functionTypes, functionSet);
        String funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
        return funcsXML;
    }

    public static void addCustomMethods(FunctionTypes functionTypes, Set<String> functionSet) {
        ResourceFieldHelper.addRelationOrgCustomMethod(functionTypes, functionSet);
        ResourceFieldHelper.addDateDiffCustomMethod(functionTypes, functionSet);
    }

    public static void addRelationOrgCustomMethod(FunctionTypes functionTypes, Set<String> functionSet) {
        if (functionSet.contains("GetRelationOrg")) {
            FunctionType customType = new FunctionType();
            customType.setDef("GetRelationOrg(ownerid, entryrecorgid, entryreqorgid)");
            customType.setId("GetRelationOrg");
            customType.setGroupId("Common");
            customType.setSeq(1);
            StringBuilder desc = new StringBuilder();
            desc.append(ResManager.loadKDString((String)"1.\u51fd\u6570\u63cf\u8ff0\uff1a\u83b7\u53d6\u53d7\u6e90\u7ec4\u7ec7\u59d4\u6258\u7684\u76ee\u6807\u7ec4\u7ec7\uff1b", (String)"ResourceFieldHelper_0", (String)"mmc-fmm-common", (Object[])new Object[0])).append('\n');
            desc.append(ResManager.loadKDString((String)"2.\u51fd\u6570\u683c\u5f0f\uff1aGetRelationOrg(ownerid, entryrecorgid, entryreqorgid)\uff1b", (String)"ResourceFieldHelper_1", (String)"mmc-fmm-common", (Object[])new Object[0])).append('\n');
            desc.append(ResManager.loadKDString((String)"3.\u51fd\u6570\u53c2\u6570\uff1aownerid, \u8d27\u4e3b; entryrecorgid, \u6536\u8d27\u7ec4\u7ec7; entryreqorgid\uff0c \u9700\u6c42\u7ec4\u7ec7\uff1b", (String)"ResourceFieldHelper_2", (String)"mpscmm-msplan-business", (Object[])new Object[0])).append('\n');
            desc.append(ResManager.loadKDString((String)"4.\u4e3e\u4f8b\uff1aGetRelationOrg(0,  billentry.entryrecorg ,  billentry.entryreqorg ), 0\u4ee3\u8868\u53c2\u6570\u503c\u4e3a\u7a7a\uff0c\u5176\u4ed6\u5219\u662f\u5b57\u6bb5\u6807\u8bc6\uff1b", (String)"ResourceFieldHelper_3", (String)"mpscmm-msplan-business", (Object[])new Object[0])).append('\n');
            customType.setDesc(new LocaleString(desc.toString()));
            customType.setReturnType("long");
            customType.setName(new LocaleString(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\u59d4\u6258\u7684\u6536\u8d27\u7ec4\u7ec7", (String)"ResourceFieldHelper_4", (String)"mmc-fmm-common", (Object[])new Object[0])));
            functionTypes.getFunctionTypes().add(customType);
        }
    }

    public static void addDateDiffCustomMethod(FunctionTypes functionTypes, Set<String> functionSet) {
        if (functionSet.contains("DATEDIFF")) {
            FunctionType customType = new FunctionType();
            customType.setDef("DATEDIFF(sourcedate, destdate)");
            customType.setId("DATEDIFF");
            customType.setGroupId("DateTime");
            customType.setSeq(10);
            StringBuilder desc = new StringBuilder();
            desc.append(ResManager.loadKDString((String)"1.\u51fd\u6570\u63cf\u8ff0\uff1a\u83b7\u53d6\u4e24\u4e2a\u65e5\u671f\u76f8\u51cf\u540e\u7684\u503c\uff08\u8fd4\u56de\u503c\u4ee5\u79d2\u4e3a\u5355\u4f4d\uff09\uff1b", (String)"ResourceFieldHelper_5", (String)"mmc-fmm-common", (Object[])new Object[0])).append('\n');
            desc.append(ResManager.loadKDString((String)"2.\u51fd\u6570\u683c\u5f0f\uff1aDATEDIFF(sourcedate, destdate)\uff1b", (String)"ResourceFieldHelper_6", (String)"mmc-fmm-common", (Object[])new Object[0])).append('\n');
            desc.append(ResManager.loadKDString((String)"3.\u51fd\u6570\u53c2\u6570\uff1asourcedate, \u6e90\u65e5\u671f\uff1bdestdate, \u76ee\u6807\u65e5\u671f\uff1b", (String)"ResourceFieldHelper_7", (String)"mpscmm-msplan-business", (Object[])new Object[0])).append('\n');
            desc.append(ResManager.loadKDString((String)"4.\u4e3e\u4f8b\uff1aDATEDIFF(sourcedate, destdate) > 5*60*60*24, \u4ee3\u8868\u6e90\u65e5\u671f - \u76ee\u6807\u65e5\u671f\u662f\u5426\u5927\u4e8e5\u5929\uff1b", (String)"ResourceFieldHelper_8", (String)"mpscmm-msplan-business", (Object[])new Object[0])).append('\n');
            customType.setDesc(new LocaleString(desc.toString()));
            customType.setReturnType("long");
            customType.setName(new LocaleString(ResManager.loadKDString((String)"\u65e5\u671f\u6bd4\u8f83", (String)"ResourceFieldHelper_9", (String)"mmc-fmm-common", (Object[])new Object[0])));
            functionTypes.getFunctionTypes().add(customType);
        }
    }

    public static TreeNode buildCalTreeNodes(BillTreeBuildParameter parameter) {
        MainEntityType mainType = parameter.getMainType();
        TreeNode billNode = new TreeNode("", mainType.getName(), mainType.getDisplayName().toString());
        billNode.setIsOpened(true);
        List<TreeNode> fldNodes = ResourceFieldHelper.buildFldCalTreeNodes(parameter);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        for (TreeNode node : fldNodes) {
            nodeMap.put(node.getId(), node);
        }
        for (TreeNode node : fldNodes) {
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) {
                node.setParentid(billNode.getId());
                billNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        return billNode;
    }

    public static List<TreeNode> buildFldCalTreeNodes(BillTreeBuildParameter parameter) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        MainEntityType mainType = parameter.getMainType();
        HashSet<String> selectedEntity = new HashSet<String>();
        selectedEntity.addAll(parameter.getSelectedEntity());
        if (selectedEntity.size() == 0) {
            selectedEntity = new HashSet();
            for (String entityKey : mainType.getAllEntities().keySet()) {
                selectedEntity.add(entityKey);
            }
        }
        for (Map.Entry entry : mainType.getAllEntities().entrySet()) {
            EntityType entityType;
            if (!selectedEntity.contains(entry.getKey()) || (entityType = (EntityType)entry.getValue()) instanceof LinkEntryType) continue;
            String entityNodeId = entityType.getName();
            String entityNodeName = "";
            boolean isHead = false;
            if (entityType instanceof MainEntityType) {
                entityNodeName = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ResourceFieldHelper_10", (String)"mmc-fmm-common", (Object[])new Object[0]);
                entityNodeId = "billhead";
                isHead = true;
            } else if (entityType.getDisplayName() != null) {
                entityNodeName = entityType.getDisplayName().toString();
            }
            TreeNode entityNode = new TreeNode(mainType.getName(), entityNodeId, entityNodeName);
            entityNode.setIsOpened(true);
            ArrayList<TreeNode> entityFldNodes = new ArrayList<TreeNode>();
            if (parameter.isIncludePKField()) {
                ResourceFieldHelper.buildPKFldTreeNode(entityType, entityNode, entityFldNodes, parameter);
            }
            for (IDataEntityProperty property : entityType.getFields().values()) {
                BasedataProp bdProp;
                MainEntityType bdType;
                List<TreeNode> refNodes;
                boolean matched = false;
                if (parameter.isOnlyPhysicsField() && StringUtils.isBlank((CharSequence)property.getAlias()) || "id".equalsIgnoreCase(property.getName()) || "seq".equalsIgnoreCase(property.getName())) continue;
                TreeNode fldNode = null;
                fldNode = isHead ? ResourceFieldHelper.BuildFldTreeNode(property, parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, "", parameter.isDynamicText()) : ResourceFieldHelper.BuildFldTreeNode(property, parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, entityType.getExtendName(), parameter.isDynamicText());
                if (fldNode != null) {
                    entityFldNodes.add(fldNode);
                    matched = true;
                }
                if (!(property instanceof BasedataProp)) continue;
                if (fldNode == null) {
                    fldNode = ResourceFieldHelper.BuildFldTreeNode(property, null, null, entityNode, "", parameter.isDynamicText());
                }
                if ((refNodes = ResourceFieldHelper.BuildBDFldRefPropNodes(bdType = (MainEntityType)(bdProp = (BasedataProp)property).getComplexType(), parameter.getMatchedProperty(), parameter.getMatchedClassType(), fldNode, entityType.getExtendName() + '.' + property.getName(), parameter.isDynamicText())).size() <= 0) continue;
                entityFldNodes.addAll(refNodes);
                if (matched) continue;
                entityFldNodes.add(fldNode);
            }
            if (entityFldNodes.size() <= 0) continue;
            nodes.add(entityNode);
            nodes.addAll(entityFldNodes);
        }
        return nodes;
    }

    public static TreeNode BuildFldTreeNode(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode parentNode, String prefix, boolean isDynamicText) {
        TreeNode fldNode = null;
        boolean isMatch = ResourceFieldHelper.isMatchType(fldProperty, matchedProperty, matchedClassType);
        DynamicProperty prop = null;
        if (fldProperty instanceof DynamicProperty) {
            prop = (DynamicProperty)fldProperty;
        }
        if (isMatch && prop != null) {
            String fullPropName;
            String fldNodeId = fullPropName = StringUtils.isBlank((CharSequence)prefix) ? prop.getName() : prefix + "." + prop.getName();
            if (isDynamicText) {
                fldNodeId = "{" + fullPropName + "}";
            }
            String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
            fldNode = new TreeNode(parentNode.getId(), fldNodeId, fldNodeName);
            fldNode.setIsOpened(false);
        }
        return fldNode;
    }

    private static boolean isMatchType(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType) {
        boolean isMatch = true;
        if (matchedClassType != null && !matchedClassType.isInstance(fldProperty)) {
            isMatch = false;
        }
        if (matchedProperty != null) {
            if (matchedProperty instanceof BasedataProp && fldProperty instanceof BasedataProp) {
                BasedataProp bdProp1 = (BasedataProp)matchedProperty;
                BasedataProp bdProp2 = (BasedataProp)fldProperty;
                if (matchedProperty.getClass().isInstance(fldProperty)) {
                    return true;
                }
                if (bdProp1.isFromSampleMaster((IDataEntityProperty)bdProp2)) {
                    return true;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)bdProp1.getBaseEntityId(), (CharSequence)bdProp2.getBaseEntityId())) {
                    isMatch = false;
                }
            } else if (!matchedProperty.getClass().isInstance(fldProperty)) {
                isMatch = false;
            }
            if (!isMatch && (matchedProperty instanceof DateProp || matchedProperty instanceof DateTimeProp) && (fldProperty instanceof DateProp || fldProperty instanceof DateTimeProp)) {
                isMatch = true;
            } else if (!isMatch && (matchedProperty instanceof IntegerProp || matchedProperty instanceof DecimalProp || matchedProperty instanceof QtyProp) && (fldProperty instanceof IntegerProp || fldProperty instanceof DecimalProp || fldProperty instanceof QtyProp)) {
                isMatch = true;
            } else if (!isMatch && (matchedProperty instanceof TextProp || matchedProperty instanceof MuliLangTextProp || matchedProperty instanceof ComboProp) && (fldProperty instanceof TextProp || fldProperty instanceof MuliLangTextProp || fldProperty instanceof ComboProp)) {
                isMatch = true;
            }
        }
        return isMatch;
    }

    private static void buildPKFldTreeNode(EntityType entityType, TreeNode entityNode, List<TreeNode> entityFldNodes, BillTreeBuildParameter parameter) {
        if (entityType instanceof MainEntityType) {
            TreeNode idNode = ResourceFieldHelper.BuildFldTreeNode((IDataEntityProperty)entityType.getPrimaryKey(), parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, "", parameter.isDynamicText());
            if (idNode != null) {
                idNode.setText(String.format(ResManager.loadKDString((String)"%s.\u5185\u7801", (String)"ResourceFieldHelper_11", (String)"mmc-fmm-common", (Object[])new Object[0]), entityType.getDisplayName().getLocaleValue()));
                entityFldNodes.add(idNode);
            }
        } else {
            TreeNode seqNode;
            DynamicProperty seqProp;
            TreeNode idNode = ResourceFieldHelper.BuildFldTreeNode((IDataEntityProperty)entityType.getPrimaryKey(), parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, entityType.getName(), parameter.isDynamicText());
            if (idNode != null) {
                idNode.setText(String.format(ResManager.loadKDString((String)"%s.\u5185\u7801", (String)"ResourceFieldHelper_11", (String)"mmc-fmm-common", (Object[])new Object[0]), entityType.getDisplayName().getLocaleValue()));
                entityFldNodes.add(idNode);
            }
            if ((seqProp = entityType.getProperty("seq")) != null && (seqNode = ResourceFieldHelper.BuildFldTreeNode((IDataEntityProperty)seqProp, parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, entityType.getName(), parameter.isDynamicText())) != null) {
                seqNode.setText(String.format(ResManager.loadKDString((String)"%s.\u5e8f\u53f7", (String)"ResourceFieldHelper_12", (String)"mmc-fmm-common", (Object[])new Object[0]), entityType.getDisplayName().getLocaleValue()));
                entityFldNodes.add(seqNode);
            }
        }
    }

    public static List<TreeNode> BuildBDFldRefPropNodes(MainEntityType bdType, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode bdFldNode, String prefix, boolean isDynamicText) {
        ArrayList<TreeNode> refNodes = new ArrayList<TreeNode>();
        if (bdType == null) {
            return refNodes;
        }
        for (IDataEntityProperty property : bdType.getFields().values()) {
            String prefix2;
            BasedataProp bdProp2;
            MainEntityType bdType2;
            List<TreeNode> refNodes2;
            if (property instanceof EntryProp) continue;
            TreeNode fldNode = ResourceFieldHelper.BuildFldTreeNode(property, matchedProperty, matchedClassType, bdFldNode, prefix, isDynamicText);
            boolean matched = false;
            if (fldNode != null) {
                refNodes.add(fldNode);
                matched = true;
            }
            if (!(property instanceof BasedataProp)) continue;
            if (fldNode == null) {
                fldNode = ResourceFieldHelper.BuildFldTreeNode(property, null, null, bdFldNode, prefix, isDynamicText);
            }
            if ((refNodes2 = ResourceFieldHelper.BuildBDFldRefPropNodes(bdType2 = (MainEntityType)(bdProp2 = (BasedataProp)property).getComplexType(), matchedProperty, matchedClassType, fldNode, prefix2 = prefix + "." + property.getName(), isDynamicText)).size() <= 0) continue;
            refNodes.addAll(refNodes2);
            if (matched) continue;
            refNodes.add(fldNode);
        }
        return refNodes;
    }
}

