/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.common.util;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.param.AppParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;

public class RouteOldVsersionInitUtils {
    private static final String ENTITY_PARAM = "pdm_routeversioninitset";
    private static final String KEY_INIT_TAG = "_initend";
    private static final String KEY_END = "true";
    private static final String KEY_RUNNING = "running";
    public static final DBRoute scmDBRoute = new DBRoute("scm");
    public static final String OPKEY_OPENPARAM = "openRtVersionSystemParam";
    public static final String ENTITY_TAG = "pdm_routeversioninittag";

    public static boolean isEndInit(Long orgId) {
        String numberTag = RouteOldVsersionInitUtils.buildInitNumber(orgId);
        String value = RouteOldVsersionInitUtils.getParamValue(numberTag);
        return KEY_END.equalsIgnoreCase(value);
    }

    public static boolean isInitRunning(Long orgId) {
        String numberTag = RouteOldVsersionInitUtils.buildInitNumber(orgId);
        String value = RouteOldVsersionInitUtils.getParamValue(numberTag);
        return KEY_RUNNING.equalsIgnoreCase(value);
    }

    public static boolean isExistsHisRtByParam(Long orgId) {
        String numberTag = "IsExistsHisRtData_" + String.valueOf(orgId);
        String value = RouteOldVsersionInitUtils.getParamValue(numberTag);
        return KEY_END.equalsIgnoreCase(value);
    }

    public static String buildInitNumber(Long orgId) {
        return orgId + KEY_INIT_TAG;
    }

    public static Set<Long> getEndInitStatusOrgId(Set<Long> orgIdSet) {
        return RouteOldVsersionInitUtils.getStatusOrgId(KEY_END, orgIdSet);
    }

    public static Set<Long> getIsRunningStatusOrgId(Set<Long> orgIdSet) {
        return RouteOldVsersionInitUtils.getStatusOrgId(KEY_RUNNING, orgIdSet);
    }

    public static Set<Long> getStatusOrgId(String status, Set<Long> orgIdSet) {
        QFilter qfilter = new QFilter("value", "=", (Object)status);
        if (orgIdSet == null || orgIdSet.isEmpty()) {
            qfilter.and(new QFilter("number", "like", (Object)"%_initend"));
        } else {
            HashSet<String> numbers = new HashSet<String>(orgIdSet.size());
            for (Long orgId : orgIdSet) {
                numbers.add(RouteOldVsersionInitUtils.buildInitNumber(orgId));
            }
            qfilter.and(new QFilter("number", "in", numbers));
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)ENTITY_PARAM, (String)"number", (QFilter[])new QFilter[]{qfilter});
        return RouteOldVsersionInitUtils.getOrgIdSetByNumber(coll);
    }

    public static Set<Long> getOrgIdSetByNumber(DynamicObjectCollection coll) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (DynamicObject dy : coll) {
            String number = dy.getString("number");
            String orgId = number.replace(KEY_INIT_TAG, "");
            idSet.add(Long.parseLong(orgId));
        }
        return idSet;
    }

    public static boolean isExistsHisRt(Long orgId, Set<Long> unRtIdSet) {
        QFilter qf = new QFilter("createorg", "=", (Object)orgId);
        if (unRtIdSet != null && !unRtIdSet.isEmpty()) {
            qf.and(new QFilter("id", "not in", unRtIdSet));
        }
        return QueryServiceHelper.exists((String)"pdm_route", (QFilter[])new QFilter[]{qf});
    }

    public static boolean isExistsHisNullVersionRt(Long orgId) {
        QFilter qf = new QFilter("createorg", "=", (Object)orgId);
        qf.and(new QFilter("routeversion", "=", (Object)0L));
        return QueryServiceHelper.exists((String)"pdm_route", (QFilter[])new QFilter[]{qf});
    }

    public static Set<Long> getOrgIdSet(String isAllOrgs, String selectOrgIds) {
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        if (KEY_END.equalsIgnoreCase(isAllOrgs)) {
            SqlBuilder sql = new SqlBuilder();
            sql.append("select distinct fcreateorgid from t_pdm_route ", new Object[0]);
            try (DataSet ds = DB.queryDataSet((String)RouteOldVsersionInitUtils.class.getName(), (DBRoute)scmDBRoute, (SqlBuilder)sql);){
                for (Row arow : ds) {
                    orgIdSet.add(arow.getLong("fcreateorgid"));
                }
            }
        } else if (selectOrgIds != null && !"".equals(selectOrgIds)) {
            String[] orgs;
            for (String orgIds : orgs = selectOrgIds.split(";")) {
                orgIdSet.add(Long.parseLong(orgIds));
            }
        }
        orgIdSet.remove(0L);
        return orgIdSet;
    }

    public static void setEndInit(Long orgId) {
        RouteOldVsersionInitUtils.setParamData(orgId, KEY_END);
    }

    public static void setInitRunning(Long orgId) {
        RouteOldVsersionInitUtils.setParamData(orgId, KEY_RUNNING);
    }

    public static void setParamData(Long orgId, String value) {
        String number = orgId + KEY_INIT_TAG;
        String name = String.format(ResManager.loadKDString((String)"%1$s\u65b0\u65e7\u7248\u672c\u521d\u59cb\u5316", (String)"RouteOldVsersionInitUtils_01", (String)"mmc-fmm-common", (Object[])new Object[0]), RouteOldVsersionInitUtils.getOrgName(orgId));
        RouteOldVsersionInitUtils.setParamData(orgId, number, name, value, "", "");
    }

    public static void setParamData(Long orgId, String number, String name, String value, String largeText, String largeText_tag) {
        DynamicObject dy = QueryServiceHelper.queryOne((String)ENTITY_PARAM, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        Long paramId = dy == null ? 0L : dy.getLong("id");
        DynamicObject paramObj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_PARAM);
        if (paramId != null && !paramId.equals(0L)) {
            paramObj = BusinessDataServiceHelper.loadSingle((Object)paramId, (DynamicObjectType)paramObj.getDynamicObjectType());
        }
        paramObj.set("number", (Object)number);
        paramObj.set("name", (Object)name);
        paramObj.set("value", (Object)value);
        paramObj.set("enable", (Object)"1");
        paramObj.set("status", (Object)"C");
        paramObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        paramObj.set("createtime", (Object)new Date());
        paramObj.set("largevalue", (Object)largeText);
        paramObj.set("largevalue_tag", (Object)largeText_tag);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{paramObj});
    }

    public static void addEndTag(Long orgId) {
        DynamicObject paramObj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_TAG);
        paramObj.set("number", (Object)(String.valueOf(orgId) + "_endinittag"));
        paramObj.set("name", (Object)RouteOldVsersionInitUtils.getOrgName(orgId));
        paramObj.set("enable", (Object)"1");
        paramObj.set("status", (Object)"A");
        paramObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        paramObj.set("createtime", (Object)new Date());
        paramObj.set("initorg", (Object)orgId);
        OperationServiceHelper.executeOperate((String)"save", (String)ENTITY_TAG, (DynamicObject[])new DynamicObject[]{paramObj}, (OperateOption)OperateOption.create());
    }

    public static String getOrgName(Long orgId) {
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org", (String)"number,name");
        return org.getString("number") + "_" + org.getString("name");
    }

    public static Set<Long> ParseStringToLongSet(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return new HashSet<Long>(16);
        }
        str = str.replace("[", "");
        str = str.replace("]", "");
        String[] array = str.split(",");
        int size = array.length;
        HashSet<Long> set = new HashSet<Long>(size);
        for (int i = 0; i < size; ++i) {
            String value = array[i];
            if (StringUtils.isEmpty((String)value)) continue;
            value = value.trim();
            set.add(Long.parseLong(value));
        }
        return set;
    }

    public static String getOrgNames(Set<Long> orgIdSet) {
        DynamicObject[] orgs;
        StringBuilder nams = new StringBuilder();
        int i = 0;
        for (DynamicObject org : orgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", orgIdSet)})) {
            if (++i > 1) {
                nams.append(",");
            }
            nams.append(org.getString("name"));
        }
        return nams.toString();
    }

    public static String getParamValue(String number) {
        DynamicObject dy = QueryServiceHelper.queryOne((String)ENTITY_PARAM, (String)"value", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        return dy == null ? "" : dy.getString("value");
    }

    public static String getDefRuleNumber() {
        String numberTag = "rtinit_rule_number";
        String value = RouteOldVsersionInitUtils.getParamValue(numberTag);
        return StringUtils.isEmpty((String)value) ? "RouteInitVersionRule" : value;
    }

    public static String getDefRuleName() {
        String numberTag = "rtinit_rule_name";
        String value = RouteOldVsersionInitUtils.getParamValue(numberTag);
        return StringUtils.isEmpty((String)value) ? ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u521d\u59cb\u5316\u7248\u672c\u89c4\u5219", (String)"RouteOldVsersionInitUtils_02", (String)"mmc-fmm-common", (Object[])new Object[0]) : value;
    }

    public static AppParam buildAppParam(Long orgId) {
        AppParam appParam = new AppParam();
        DynamicObject bizApp = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"id,orgfunc", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"fmm")});
        appParam.setAppId(bizApp.getString("id"));
        appParam.setViewType(bizApp.getString("orgfunc"));
        appParam.setOrgId(orgId);
        appParam.setActBookId(Long.valueOf(0L));
        return appParam;
    }

    public static void setBizAppParamData(Long orgId, String paramNumber, Object value) {
        HashMap<String, Object> syPparams = new HashMap<String, Object>(16);
        syPparams.put(paramNumber, value);
        DynamicObject bizApp = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"id,orgfunc", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"fmm")});
        String orgfunc = bizApp.getString("orgfunc");
        if (StringUtils.isEmpty((String)orgfunc)) {
            orgfunc = "15";
        }
        AppParam appParam = new AppParam();
        appParam.setAppId(bizApp.getString("id"));
        appParam.setViewType(orgfunc);
        appParam.setOrgId(orgId);
        appParam.setActBookId(Long.valueOf(0L));
        SystemParamServiceHelper.saveAppParameter((AppParam)appParam, syPparams);
    }

    public static DynamicObject getDefaultVersionRule(String type) {
        String defField = "B".equals(type) ? "isdefaultroute" : ("C".equals(type) ? "isdefaultprograme" : "isdefault");
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterType = new QFilter("multype", "like", (Object)("%" + type + "%"));
        QFilter qFilter2 = new QFilter(defField, "=", (Object)Boolean.TRUE);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_bomversionrule_new", (String)"id,number,entryentity.version,entryentity.seq", (QFilter[])new QFilter[]{qFilter2, qFilterStatus, qFilterEnable, qFilterType});
    }

    public static String checkVersionNameIsValide(Long orgId) {
        DynamicObject defRule = RouteOldVsersionInitUtils.getDefaultVersionRule("B");
        if (defRule == null) {
            return ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5de5\u827a\u8def\u7ebf\u9ed8\u8ba4\u7248\u672c\u89c4\u5219\u3002", (String)"RouteOldVsersionInitUtils_03", (String)"mmc-fmm-common", (Object[])new Object[0]);
        }
        QFilter qf = new QFilter("createorg", "=", (Object)orgId);
        qf.and(new QFilter("routeversion", "=", (Object)0L));
        qf.and(new QFilter("version", ">", (Object)0L));
        String selectFields = "version.orderseq orderseq";
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"pdm_route", (String)selectFields, (QFilter[])new QFilter[]{qf});
        Set oldVersionSeqSet = coll.stream().map(p -> p.getInt("orderseq")).collect(Collectors.toSet());
        DynamicObjectCollection ruleColl = defRule.getDynamicObjectCollection("entryentity");
        Set ruleVersionSeqSet = ruleColl.stream().map(p -> p.getInt("seq")).collect(Collectors.toSet());
        StringBuilder errorVersionSeqMsg = new StringBuilder();
        Iterator iterator = oldVersionSeqSet.iterator();
        while (iterator.hasNext()) {
            int oldVersionSeq = (Integer)iterator.next();
            if (oldVersionSeq == 0 || ruleVersionSeqSet.contains(oldVersionSeq)) continue;
            errorVersionSeqMsg.append(oldVersionSeq).append(" ");
        }
        if (errorVersionSeqMsg.length() > 1) {
            return String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u4e0a\u7684\u65e7\u7248\u672c\u987a\u5e8f\u53f7\u201c%1$s\u201d\u4e0d\u5b58\u5728\u4e8e\u9ed8\u8ba4\u7248\u672c\u89c4\u5219\u201c%2$s\u201d\u7684\u7248\u672c\u5206\u5f55\u4e2d\uff0c\u8bf7\u5148\u7ef4\u62a4\u5bf9\u5e94\u5173\u7cfb\u3002", (String)"RouteOldVsersionInitUtils_04", (String)"mmc-fmm-common", (Object[])new Object[0]), errorVersionSeqMsg, defRule.getString("number"));
        }
        return "";
    }

    public static boolean isFromSysParamOpen(String opKey) {
        return OPKEY_OPENPARAM.equalsIgnoreCase(opKey);
    }
}

