/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmbd.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class CommonUtils {
    private CommonUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isNull(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String && ((String)o).length() == 0) {
            return true;
        }
        if (o instanceof StringBuffer && ((StringBuffer)o).length() == 0) {
            return true;
        }
        if (o instanceof List && ((List)o).isEmpty()) {
            return true;
        }
        if (o instanceof Collection && ((Collection)o).isEmpty()) {
            return true;
        }
        if (o instanceof Object[] && ((Object[])o).length == 0) {
            return true;
        }
        return o instanceof Map && ((Map)o).size() == 0;
    }

    public static QFilter getQFilter(List<QFilter> qfilters, String cpropName) {
        String spropName = "";
        QFilter cQfilter = null;
        for (QFilter qfilter : qfilters) {
            spropName = qfilter.getProperty();
            if (!StringUtils.isNotEmpty((CharSequence)spropName) || !StringUtils.equalsIgnoreCase((CharSequence)spropName, (CharSequence)cpropName)) continue;
            cQfilter = qfilter;
            break;
        }
        return cQfilter;
    }

    public static Object getQFilterVal(List<QFilter> qfilters, String cpropName) {
        QFilter qFilter = CommonUtils.getQFilter(qfilters, cpropName);
        Object val = null;
        if (qFilter != null) {
            val = qFilter.getValue();
        }
        return val;
    }

    public static List<Long> getIDs(DynamicObject[] dyncObjs) {
        ArrayList<Long> lstID = new ArrayList<Long>();
        for (int i = 0; i < dyncObjs.length; ++i) {
            DynamicObject dyncObj = dyncObjs[i];
            Long id = (Long)dyncObj.getPkValue();
            if (lstID.contains(id) || id <= 0L) continue;
            lstID.add(id);
        }
        return lstID;
    }

    public static List<Long> getIDs(DynamicObjectCollection dyncObjs) {
        ArrayList<Long> lstID = new ArrayList<Long>();
        for (int i = 0; i < dyncObjs.size(); ++i) {
            DynamicObject dyncObj = (DynamicObject)dyncObjs.get(i);
            Long id = dyncObj.getLong("id");
            if (lstID.contains(id)) continue;
            lstID.add(id);
        }
        return lstID;
    }

    public static DynamicObject[] getLoadData(String entityName, QFilter[] qfilters) {
        DynamicObjectCollection objs = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])qfilters);
        List<Long> objids = CommonUtils.getIDs(objs);
        DynamicObject[] resObjs = CommonUtils.getLoadData(entityName, objids);
        return resObjs;
    }

    public static DynamicObject[] getLoadData(String entityName, List<Long> ids) {
        DynamicObject[] dyncObjs = null;
        if (ids.size() <= 0) {
            return dyncObjs;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        dyncObjs = BusinessDataServiceHelper.load((Object[])ids.toArray(new Object[ids.size()]), (DynamicObjectType)entityType);
        return dyncObjs;
    }

    public static DynamicObject getDyncObj(DynamicObject[] dyncObjEntrys, Long sID) {
        DynamicObject dyncRes = null;
        if (StringUtils.isNotBlank((Object)dyncObjEntrys) && sID > 0L) {
            for (int i = 0; i < dyncObjEntrys.length; ++i) {
                DynamicObject dyncObjEntry = dyncObjEntrys[i];
                Long id = dyncObjEntry.getLong("id");
                if (id <= 0L || !id.equals(sID)) continue;
                dyncRes = dyncObjEntry;
                break;
            }
        }
        return dyncRes;
    }

    public static OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("strictvalidation", String.valueOf(true));
        return option;
    }

    public static DynamicObjectCollection getNewDynamicObjs(String billNum, DataSet ds, String fields) {
        DynamicObjectCollection billCollObjs = QueryServiceHelper.query((String)billNum, (String)fields, (QFilter[])new QFilter("1", "!=", (Object)1).toArray());
        if (ds.hasNext()) {
            for (Row row : ds) {
                String[] fieldNames = ds.getRowMeta().getFieldNames();
                billCollObjs.addNew();
                DynamicObject dyncObj = (DynamicObject)billCollObjs.get(billCollObjs.size() - 1);
                for (String fieldName : fieldNames) {
                    Object objval = row.get(fieldName);
                    if (objval == null) continue;
                    dyncObj.set(fieldName, objval);
                }
            }
        }
        return billCollObjs;
    }

    public static Map<String, DynamicObject> getMapDync(DynamicObject[] dyncobjs, String ... mapKey) {
        HashMap<String, DynamicObject> mapDyncobjs = new HashMap<String, DynamicObject>();
        if (StringUtils.isBlank((Object)dyncobjs)) {
            return mapDyncobjs;
        }
        for (DynamicObject dyncobj : dyncobjs) {
            String mapKeyStr = CommonUtils.getMapDyncKey(dyncobj, mapKey);
            if (StringUtils.isEmpty((CharSequence)mapKeyStr)) continue;
            mapDyncobjs.put(mapKeyStr, dyncobj);
        }
        return mapDyncobjs;
    }

    public static String getMapDyncKey(DynamicObject dyncobj, String ... mapKey) {
        StringBuilder sbKey = new StringBuilder();
        for (String key : mapKey) {
            Object valObj = dyncobj.get(key);
            if (StringUtils.isBlank((Object)valObj)) continue;
            if (valObj instanceof String) {
                sbKey.append(valObj);
                continue;
            }
            if (!(valObj instanceof Date)) continue;
            sbKey.append(((Date)valObj).toLocaleString());
        }
        return sbKey.toString();
    }

    public static String validateBaseRef(DynamicObject[] dataEntities) {
        String entityNameF7 = "";
        if (dataEntities.length > 0) {
            entityNameF7 = dataEntities[0].getDataEntityType().getName();
        }
        return CommonUtils.validateBaseRef(dataEntities, entityNameF7);
    }

    public static String validateBaseRef(DynamicObject[] dataEntities, String entityNameF7) {
        String error = "";
        int length = dataEntities.length;
        if (entityNameF7.length() == 0) {
            return error;
        }
        for (int i = 0; i < length; ++i) {
            MainEntityType refMainType;
            String extendName;
            DynamicObject dataObj = dataEntities[i];
            Object idValue = dataObj.getPkValue();
            String entityName = dataObj.getDataEntityType().getName();
            BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
            checker.setDraftValidReference(true);
            BaseDataCheckRefrenceResult refrenceResult = checker.checkRef((BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entityNameF7), idValue);
            if (!refrenceResult.isRefence() || StringUtils.equalsIgnoreCase((CharSequence)entityName, (CharSequence)(extendName = (refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey())).getExtendName()))) continue;
            String billName = refMainType.getDisplayName().toString();
            String fieldName = refrenceResult.getRefenceKey().getRefCol();
            for (IDataEntityProperty property : refMainType.getAllFields().values()) {
                if (!(property instanceof IFieldHandle) || !StringUtils.equals((CharSequence)property.getAlias(), (CharSequence)refrenceResult.getRefenceKey().getRefCol())) continue;
                fieldName = ((IFieldHandle)property).getDisplayName().toString();
                break;
            }
            error = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\uff1a\u201c%1$s\u201d\u7684\u5b57\u6bb5\u201c%2$s\u201d\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e\u3002", (String)"CommonUtils_1", (String)"mmc-fmm-common", (Object[])new Object[0]), billName, fieldName);
            return error;
        }
        return error;
    }

    public static String getSelects(String ... vals) {
        if (vals != null && vals.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < vals.length; ++i) {
                sb.append(vals[i]);
                sb.append(',');
            }
            return sb.substring(0, sb.length() - 1);
        }
        return null;
    }

    public static void showLogForm(String FormId, OperationStatus status, long id, Map<String, Object> customParams, IFormView iFormView) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(FormId);
        formShowParameter.setStatus(status);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (customParams != null) {
            formShowParameter.setCustomParams(customParams);
        }
        formShowParameter.setCloseCallBack(null);
        iFormView.showForm(formShowParameter);
    }
}

