/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmbd.common.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class EnterpriseHumanResourcePoolUtils {
    private static ORM orm = ORM.create();

    public static Map<Long, DynamicObject> getOrgStructure(Set<Long> orgIdSet) {
        if (CollectionUtils.isEmpty(orgIdSet)) {
            return new HashMap<Long, DynamicObject>(0);
        }
        HashMap<Long, DynamicObject> orgStrutMap = new HashMap<Long, DynamicObject>(orgIdSet.size());
        QFilter viewFilter = new QFilter("view", "=", (Object)1L);
        QFilter orgFilter = new QFilter("org", "in", orgIdSet);
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
        Map structObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)structObjMap)) {
            return orgStrutMap;
        }
        for (DynamicObject structObj : structObjMap.values()) {
            DynamicObject orgObj = structObj.getDynamicObject("org");
            if (orgObj == null) continue;
            orgStrutMap.put(orgObj.getLong("id"), structObj);
        }
        return orgStrutMap;
    }

    public static String getSelects(String ... vals) {
        if (vals != null && vals.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < vals.length; ++i) {
                sb.append(vals[i]);
                sb.append(',');
            }
            return sb.substring(0, sb.length() - 1);
        }
        return null;
    }

    public static Map<Long, Map<String, String>> getProjectHmResPl(Set<Long> projecthmresplSet) {
        String selectFields = EnterpriseHumanResourcePoolUtils.getSelects("id", "billno", "pmbdproduct.number", "pmbdproduct.name");
        QFilter idsFilter = new QFilter("id", "in", projecthmresplSet);
        HashMap<Long, Map<String, String>> projectHmResPls = new HashMap<Long, Map<String, String>>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getProjectHmResPl", (String)"pmbd_project_hm_res_pl1", (String)selectFields, (QFilter[])new QFilter[]{idsFilter}, null);){
            for (Row row : ds) {
                HashMap<String, String> projectHmResPl = new HashMap<String, String>(16);
                projectHmResPl.put("billno", row.getString("billno"));
                projectHmResPl.put("pmbdproduct.number", row.getString("pmbdproduct.number"));
                projectHmResPl.put("pmbdproduct.name", row.getString("pmbdproduct.number"));
                projectHmResPls.put(row.getLong("id"), projectHmResPl);
            }
        }
        return projectHmResPls;
    }

    public static List<DynamicObject> insertPmbdEnterpriseHmResPo(Map<Long, Map<String, Object>> bosUserMap, String dataSources) {
        ArrayList<DynamicObject> pmbdEnterpriseHmResPoList = new ArrayList<DynamicObject>(1);
        DynamicObjectType entryEntityType = (DynamicObjectType)orm.getDataEntityType("pmbd_enterprise_hm_res_po.entryentity");
        DynamicObjectType contactentityType = (DynamicObjectType)orm.getDataEntityType("pmbd_enterprise_hm_res_po.contactentity");
        for (Map.Entry<Long, Map<String, Object>> entry : bosUserMap.entrySet()) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"pmbd_enterprise_hm_res_po");
            obj.set("gender", entry.getValue().get("gender"));
            obj.set("number", entry.getValue().get("number"));
            obj.set("name", entry.getValue().get("name"));
            obj.set("usertype", entry.getValue().get("usertype"));
            obj.set("picturefield", entry.getValue().get("picturefield"));
            obj.set("enable", entry.getValue().get("enable"));
            obj.set("status", entry.getValue().get("status"));
            obj.set("creator", (Object)RequestContext.get().getUserId());
            obj.set("createtime", (Object)new Date());
            obj.set("datasources", (Object)dataSources);
            obj.set("datasourcesid", entry.getValue().get("id"));
            DynamicObjectCollection entryentitys = new DynamicObjectCollection();
            List entryentityList = (List)entry.getValue().get("entryentity");
            for (Map entryentity : entryentityList) {
                DynamicObject entryObj = new DynamicObject(entryEntityType);
                entryObj.set("dpt", entryentity.get("dpt.id"));
                entryObj.set("orgstructure", entryentity.get("orgstructure.id"));
                entryObj.set("position", entryentity.get("position"));
                entryObj.set("isincharge", entryentity.get("isincharge"));
                entryObj.set("ispartjob", entryentity.get("ispartjob"));
                entryObj.set("superior", entryentity.get("superior.id"));
                entryentitys.add((Object)entryObj);
            }
            obj.set("entryentity", (Object)entryentitys);
            DynamicObjectCollection contactentitys = new DynamicObjectCollection();
            List contactentityList = (List)entry.getValue().get("contactentity");
            for (Map contactentity : contactentityList) {
                DynamicObject contactentityObj = new DynamicObject(contactentityType);
                contactentityObj.set("contacttype", contactentity.get("contacttype.id"));
                contactentityObj.set("contact", contactentity.get("contact"));
                contactentityObj.set("isdefault", contactentity.get("isdefault"));
                contactentitys.add((Object)contactentityObj);
            }
            obj.set("contactentity", (Object)contactentitys);
            pmbdEnterpriseHmResPoList.add(obj);
        }
        return pmbdEnterpriseHmResPoList;
    }

    public static List<DynamicObject> updatePmbdEnterpriseHmResPo(Map<Long, Map<String, Object>> bosUserMap, String dataSources, Map<Long, DynamicObject> podynMap) {
        ArrayList<DynamicObject> pmbdEnterpriseHmResPoList = new ArrayList<DynamicObject>(1);
        DynamicObjectType entryEntityType = (DynamicObjectType)orm.getDataEntityType("pmbd_enterprise_hm_res_po.entryentity");
        DynamicObjectType contactentityType = (DynamicObjectType)orm.getDataEntityType("pmbd_enterprise_hm_res_po.contactentity");
        DynamicObject obj = null;
        for (Map.Entry<Long, Map<String, Object>> entry : bosUserMap.entrySet()) {
            obj = podynMap.get(entry.getKey());
            if (obj == null) continue;
            obj.set("gender", entry.getValue().get("gender"));
            obj.set("number", entry.getValue().get("number"));
            obj.set("name", entry.getValue().get("name"));
            obj.set("usertype", entry.getValue().get("usertype"));
            obj.set("picturefield", entry.getValue().get("picturefield"));
            obj.set("enable", entry.getValue().get("enable"));
            obj.set("status", entry.getValue().get("status"));
            obj.set("creator", (Object)RequestContext.get().getUserId());
            obj.set("createtime", (Object)new Date());
            obj.set("datasources", (Object)dataSources);
            DynamicObjectCollection entryentitys = (DynamicObjectCollection)obj.get("entryentity");
            entryentitys.clear();
            List entryentityList = (List)entry.getValue().get("entryentity");
            for (Map entryentity : entryentityList) {
                DynamicObject entryObj = new DynamicObject(entryEntityType);
                entryObj.set("dpt", entryentity.get("dpt.id"));
                entryObj.set("orgstructure", entryentity.get("orgstructure.id"));
                entryObj.set("position", entryentity.get("position"));
                entryObj.set("isincharge", entryentity.get("isincharge"));
                entryObj.set("ispartjob", entryentity.get("ispartjob"));
                entryObj.set("superior", entryentity.get("superior.id"));
                entryentitys.add((Object)entryObj);
            }
            DynamicObjectCollection contactentitys = (DynamicObjectCollection)obj.get("contactentity");
            contactentitys.clear();
            List contactentityList = (List)entry.getValue().get("contactentity");
            for (Map contactentity : contactentityList) {
                DynamicObject contactentityObj = new DynamicObject(contactentityType);
                contactentityObj.set("contacttype", contactentity.get("contacttype.id"));
                contactentityObj.set("contact", contactentity.get("contact"));
                contactentityObj.set("isdefault", contactentity.get("isdefault"));
                contactentitys.add((Object)contactentityObj);
            }
            pmbdEnterpriseHmResPoList.add(obj);
        }
        return pmbdEnterpriseHmResPoList;
    }

    public static int excludeKeys(Set<Long> keys) {
        HashMap<Long, String> bosUserMap = new HashMap<Long, String>(1);
        String selectFields = EnterpriseHumanResourcePoolUtils.getSelects("id", "number");
        QFilter idsFilter = new QFilter("id", "in", keys);
        try (DataSet ds = orm.queryDataSet("getBosUserNumbers", "bos_user", selectFields, new QFilter[]{idsFilter});){
            for (Row row : ds) {
                bosUserMap.put(row.getLong("id"), row.getString("number"));
            }
        }
        selectFields = EnterpriseHumanResourcePoolUtils.getSelects("number");
        QFilter numberFilter = new QFilter("number", "in", bosUserMap.values());
        HashSet<String> numberSet = new HashSet<String>(1);
        DataSet ds = orm.queryDataSet("getBosUserNumbers", "pmbd_enterprise_hm_res_po", selectFields, new QFilter[]{numberFilter});
        Object object = null;
        try {
            for (Row row : ds) {
                numberSet.add(row.getString("number"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashSet excludeSet = new HashSet(numberSet.size());
        for (Map.Entry entry : bosUserMap.entrySet()) {
            if (!numberSet.contains(entry.getValue())) continue;
            excludeSet.add(entry.getKey());
        }
        keys.removeAll(excludeSet);
        return excludeSet.size();
    }

    public static Map<Long, Long> excludeKeys(Set<Long> keys, String dataSources) {
        HashMap<Long, Long> poMap = new HashMap<Long, Long>(keys.size());
        String selectFields = EnterpriseHumanResourcePoolUtils.getSelects("id", "datasourcesid");
        QFilter idsFilter = new QFilter("id", "in", keys);
        QFilter dataSourcesFilter = new QFilter("datasources", "=", (Object)dataSources);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getpmbd_enterprise_hm_res_po", (String)"pmbd_enterprise_hm_res_po", (String)selectFields, (QFilter[])new QFilter[]{idsFilter, dataSourcesFilter}, null);){
            for (Row row : ds) {
                if (row.getLong("datasourcesid") == null || row.getLong("datasourcesid") == 0L) continue;
                poMap.put(row.getLong("datasourcesid"), row.getLong("id"));
            }
        }
        return poMap;
    }

    public static Map<Long, Map<String, Object>> getMmcUsers(Set<Long> keys) {
        HashMap<Long, Map<String, Object>> mmcUsersMap = new HashMap<Long, Map<String, Object>>(16);
        String selectFields = EnterpriseHumanResourcePoolUtils.getSelects("id", "user.id", "workcenter.id", "entryentity", "entryentity.worktype.id", "entryentity.gradelevel.id", "entryentity.isdefworktype", "entryentity.qualifications.id", "entryentity.crenumber", "entryentity.effectivedate", "entryentity.closingdate", "entryentity.veridate", "entryentity.remark");
        QFilter idsFilter = new QFilter("id", "in", keys);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getMmcUsers", (String)"mpdm_manuperson", (String)selectFields, (QFilter[])new QFilter[]{idsFilter}, null);){
            for (Row row : ds) {
                Map repeatMap = (Map)mmcUsersMap.get(row.getLong("user.id"));
                if (repeatMap != null && !repeatMap.get("id").equals(row.getLong("id"))) continue;
                List list = new ArrayList(16);
                if (repeatMap != null && repeatMap.get("id").equals(row.getLong("id"))) {
                    list = (List)repeatMap.get("entryentity");
                }
                HashMap<String, Object> mmcMap = new HashMap<String, Object>(2);
                mmcMap.put("id", row.getLong("id"));
                HashMap<String, Object> entryEntityMap = new HashMap<String, Object>(10);
                entryEntityMap.put("workcenter.id", row.getLong("workcenter.id"));
                entryEntityMap.put("entryentity.worktype.id", row.getLong("entryentity.worktype.id"));
                entryEntityMap.put("entryentity.gradelevel.id", row.getLong("entryentity.gradelevel.id"));
                entryEntityMap.put("entryentity.isdefworktype", row.getBoolean("entryentity.isdefworktype"));
                entryEntityMap.put("entryentity.qualifications.id", row.getLong("entryentity.qualifications.id"));
                entryEntityMap.put("entryentity.crenumber", row.getString("entryentity.crenumber"));
                entryEntityMap.put("entryentity.effectivedate", row.getDate("entryentity.effectivedate"));
                entryEntityMap.put("entryentity.closingdate", row.getDate("entryentity.closingdate"));
                entryEntityMap.put("entryentity.veridate", row.getDate("entryentity.veridate"));
                entryEntityMap.put("entryentity.remark", row.getString("entryentity.remark"));
                list.add(entryEntityMap);
                mmcMap.put("entryentity", list);
                mmcUsersMap.put(row.getLong("user.id"), mmcMap);
            }
        }
        return mmcUsersMap;
    }

    public static String showMessage(int totalCount, int successCount, int existCount, int errorCount, String buttonName, String error) {
        String buttonDetail = successCount == 0 ? ResManager.loadKDString((String)"\u5931\u8d25", (String)"EnterpriseHumanResourcePoolUtils_0", (String)"mmc-fmm-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6210\u529f", (String)"EnterpriseHumanResourcePoolUtils_1", (String)"mmc-fmm-common", (Object[])new Object[0]);
        String bittonExt = String.format(ResManager.loadKDString((String)"%1$s\u9009\u62e9\u6761\u6570:%2$s%3$s", (String)"EnterpriseHumanResourcePoolUtils_2", (String)"mmc-fmm-common", (Object[])new Object[0]), "\u3002", totalCount, ResManager.loadKDString((String)"\u6761\u3002", (String)"EnterpriseHumanResourcePoolUtils_5", (String)"mmc-fmm-common", (Object[])new Object[0]));
        StringBuilder sb = new StringBuilder();
        sb.append(buttonName).append(buttonDetail).append(bittonExt);
        if (successCount != 0) {
            sb.append(String.format(ResManager.loadKDString((String)"%1$s\u6210\u529f\u6761\u6570:%2$s%3$s", (String)"EnterpriseHumanResourcePoolUtils_3", (String)"mmc-fmm-common", (Object[])new Object[0]), "\uff0c", successCount, ResManager.loadKDString((String)"\u6761\u3002", (String)"EnterpriseHumanResourcePoolUtils_5", (String)"mmc-fmm-common", (Object[])new Object[0])));
        }
        if (errorCount != 0) {
            sb.append(String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\u6761\u6570:%2$s%3$s", (String)"EnterpriseHumanResourcePoolUtils_4", (String)"mmc-fmm-common", (Object[])new Object[0]), ",", errorCount, ResManager.loadKDString((String)"\u6761\u3002", (String)"EnterpriseHumanResourcePoolUtils_5", (String)"mmc-fmm-common", (Object[])new Object[0])));
        }
        if (existCount != 0) {
            sb.append(error);
            sb.append(existCount);
            sb.append(ResManager.loadKDString((String)"\u6761\u3002", (String)"EnterpriseHumanResourcePoolUtils_5", (String)"mmc-fmm-common", (Object[])new Object[0]));
        } else {
            sb.append('\u3002');
        }
        return sb.toString();
    }

    public static List<DynamicObject> insertPmbdEnterpriseHmResPoForMmcUsers(List<DynamicObject> pmbdEnterpriseHmResPoList, Map<Long, Map<String, Object>> mmcUsers) {
        DynamicObject dynamicObject;
        Map<String, Object> map;
        DynamicObjectType qualificationType = (DynamicObjectType)orm.getDataEntityType("pmbd_enterprise_hm_res_po.qualificationentity");
        Iterator<DynamicObject> iterator = pmbdEnterpriseHmResPoList.iterator();
        while (iterator.hasNext() && (map = mmcUsers.get((dynamicObject = iterator.next()).getLong("datasourcesid"))) != null) {
            dynamicObject.set("datasourcesid", map.get("id"));
            DynamicObjectCollection qualificationEntitys = new DynamicObjectCollection();
            List qualificationEntityList = (List)map.get("entryentity");
            for (Map qualificationEntity : qualificationEntityList) {
                DynamicObject qualificationObj = new DynamicObject(qualificationType);
                dynamicObject.set("workcenter", qualificationEntity.get("workcenter.id"));
                qualificationObj.set("worktype", qualificationEntity.get("entryentity.worktype.id"));
                qualificationObj.set("gradelevel", qualificationEntity.get("entryentity.gradelevel.id"));
                qualificationObj.set("isdefworktype", qualificationEntity.get("entryentity.isdefworktype"));
                qualificationObj.set("qualifications", qualificationEntity.get("entryentity.qualifications.id"));
                qualificationObj.set("crenumber", qualificationEntity.get("entryentity.crenumber"));
                qualificationObj.set("effectivedate", qualificationEntity.get("entryentity.effectivedate"));
                qualificationObj.set("closingdate", qualificationEntity.get("entryentity.closingdate"));
                qualificationObj.set("veridate", qualificationEntity.get("entryentity.veridate"));
                qualificationObj.set("remark", qualificationEntity.get("entryentity.remark"));
                qualificationEntitys.add((Object)qualificationObj);
            }
            dynamicObject.set("qualificationentity", (Object)qualificationEntitys);
        }
        return pmbdEnterpriseHmResPoList;
    }

    public static List<DynamicObject> updatePmbdEnterpriseHmResPoForMmcUsers(List<DynamicObject> pmbdEnterpriseHmResPoList, Map<Long, Map<String, Object>> mmcUsers) {
        DynamicObject dynamicObject;
        Map<String, Object> map;
        DynamicObjectType qualificationType = (DynamicObjectType)orm.getDataEntityType("pmbd_enterprise_hm_res_po.qualificationentity");
        Iterator<DynamicObject> iterator = pmbdEnterpriseHmResPoList.iterator();
        while (iterator.hasNext() && (map = mmcUsers.get((dynamicObject = iterator.next()).getLong("datasourcesid"))) != null) {
            dynamicObject.set("datasourcesid", map.get("id"));
            DynamicObjectCollection qualificationEntitys = (DynamicObjectCollection)dynamicObject.get("qualificationentity");
            qualificationEntitys.clear();
            List qualificationEntityList = (List)map.get("entryentity");
            for (Map qualificationEntity : qualificationEntityList) {
                DynamicObject qualificationObj = new DynamicObject(qualificationType);
                dynamicObject.set("workcenter", qualificationEntity.get("workcenter.id"));
                qualificationObj.set("worktype", qualificationEntity.get("entryentity.worktype.id"));
                qualificationObj.set("gradelevel", qualificationEntity.get("entryentity.gradelevel.id"));
                qualificationObj.set("isdefworktype", qualificationEntity.get("entryentity.isdefworktype"));
                qualificationObj.set("qualifications", qualificationEntity.get("entryentity.qualifications.id"));
                qualificationObj.set("crenumber", qualificationEntity.get("entryentity.crenumber"));
                qualificationObj.set("effectivedate", qualificationEntity.get("entryentity.effectivedate"));
                qualificationObj.set("closingdate", qualificationEntity.get("entryentity.closingdate"));
                qualificationObj.set("veridate", qualificationEntity.get("entryentity.veridate"));
                qualificationObj.set("remark", qualificationEntity.get("entryentity.remark"));
                qualificationEntitys.add((Object)qualificationObj);
            }
            dynamicObject.set("qualificationentity", (Object)qualificationEntitys);
        }
        return pmbdEnterpriseHmResPoList;
    }

    public static Set<Long> getMapValues(Map<Long, Long> poMap) {
        HashSet<Long> set = new HashSet<Long>(poMap.size());
        Set<Map.Entry<Long, Long>> setEntry = poMap.entrySet();
        for (Map.Entry<Long, Long> entry : setEntry) {
            set.add(entry.getValue());
        }
        return set;
    }

    public static Map<Long, DynamicObject> getHmResPos(Set<Long> ids) {
        QFilter idsFilter = new QFilter("id", "in", ids);
        Map dynamicObjects = BusinessDataServiceHelper.loadFromCache((String)"pmbd_enterprise_hm_res_po", (QFilter[])new QFilter[]{idsFilter});
        if (dynamicObjects == null || dynamicObjects.isEmpty()) {
            return null;
        }
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(dynamicObjects.size());
        for (Map.Entry dynmap : dynamicObjects.entrySet()) {
            DynamicObject dyn = (DynamicObject)dynmap.getValue();
            map.put(dyn.getLong("datasourcesid"), dyn);
        }
        return map;
    }

    public static Map<String, String> getHmResPosToNumberDataSources(Set<Long> ids) {
        HashMap<String, String> numberMap = new HashMap<String, String>(ids.size());
        String selectFields = EnterpriseHumanResourcePoolUtils.getSelects("id", "number", "datasources");
        QFilter idsFilter = new QFilter("id", "in", ids);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getpmbd_enterprise_hm_res_po", (String)"pmbd_enterprise_hm_res_po", (String)selectFields, (QFilter[])new QFilter[]{idsFilter}, null);){
            for (Row row : ds) {
                numberMap.put(row.getString("number"), row.getString("datasources"));
            }
        }
        return numberMap;
    }

    public static Map<Long, Map<String, Object>> bosUserMapToMmcMap(Map<Long, Map<String, Object>> bosUserMap, Map<Long, Map<String, Object>> mmcUsers) {
        HashMap<Long, Map<String, Object>> map = new HashMap<Long, Map<String, Object>>(bosUserMap.size());
        Set<Map.Entry<Long, Map<String, Object>>> bosEntrySet = bosUserMap.entrySet();
        Set<Map.Entry<Long, Map<String, Object>>> mmcEntrySet = mmcUsers.entrySet();
        for (Map.Entry<Long, Map<String, Object>> bosentry : bosEntrySet) {
            for (Map.Entry<Long, Map<String, Object>> mmcentry : mmcEntrySet) {
                if (!bosentry.getKey().equals(mmcentry.getKey())) continue;
                Map<String, Object> mmcObj = mmcentry.getValue();
                Long mmcId = (Long)mmcObj.get("id");
                map.put(mmcId, bosentry.getValue());
            }
        }
        return map;
    }

    public static Map<Long, Map<Object, String>> getProjectTeam(Set<Long> projectTeamSet) {
        String selectFields = EnterpriseHumanResourcePoolUtils.getSelects("id", "billno", "pmpdproject.number", "pmpdproject.name", "entryentity.id", "entryentity.teamname");
        QFilter idsFilter = new QFilter("id", "in", projectTeamSet);
        HashMap<Long, Map<Object, String>> projectHmResPls = new HashMap<Long, Map<Object, String>>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getProjectTeam", (String)"pmpd_projectteam", (String)selectFields, (QFilter[])new QFilter[]{idsFilter}, null);){
            for (Row row : ds) {
                HashMap<Object, String> projectHmResPl = new HashMap<Object, String>(16);
                projectHmResPl.put("billno", row.getString("billno"));
                projectHmResPl.put("pmbdproduct.number", row.getString("pmpdproject.number"));
                projectHmResPl.put("pmbdproduct.name", row.getString("pmpdproject.name"));
                projectHmResPl.put(row.getLong("entryentity.id"), row.getString("entryentity.teamname"));
                projectHmResPls.put(row.getLong("id"), projectHmResPl);
            }
        }
        return projectHmResPls;
    }
}

