/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmbd.common.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.pmc.pmbd.common.util.CommonLan;
import kd.pmc.pmbd.enums.WeekDayEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeUtils {
    private static final Log logger = LogFactory.getLog(TimeUtils.class);

    public static int daysBetween(Calendar smallDate, Calendar bigDate) {
        long time1 = smallDate.getTimeInMillis();
        long time2 = bigDate.getTimeInMillis();
        long betweendays = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(betweendays)) + 1;
    }

    public static Date getDate(Date dateval, String format) {
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            String sDate = sdf.format(dateval);
            date = sdf.parse(sDate);
        }
        catch (Exception ex) {
            logger.error((Object)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38", (Throwable)ex);
        }
        return date;
    }

    public static Date getDate(String dateval, String format) {
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            date = sdf.parse(dateval);
        }
        catch (Exception ex) {
            logger.error((Object)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38", (Throwable)ex);
        }
        return date;
    }

    public static String dateToWeek(Date date) {
        String[] weekDays = new String[]{WeekDayEnum.Sunday.getValue(), WeekDayEnum.Monday.getValue(), WeekDayEnum.Tuesday.getValue(), WeekDayEnum.Wednesday.getValue(), WeekDayEnum.Thursday.getValue(), WeekDayEnum.Friday.getValue(), WeekDayEnum.Saturday.getValue()};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static String getDateError(Date startTime, Date endTime, String startTimeCap, String endTimeCap) {
        String errStr = "";
        if (startTime == null && endTime == null) {
            errStr = "%1$s" + CommonLan.emptyDesc;
            errStr = String.format(errStr, startTimeCap);
        }
        if (startTime != null && endTime == null) {
            errStr = "%1$s" + CommonLan.emptyDesc;
            errStr = String.format(errStr, endTimeCap);
        }
        if (startTime != null && endTime != null && endTime.getTime() - startTime.getTime() < 0L) {
            errStr = String.format(ResManager.loadKDString((String)"%2$s\u5e94\u5f53\u665a\u4e8e%1$s\u3002", (String)"TimeUtils_0", (String)"mmc-fmm-common", (Object[])new Object[0]), startTimeCap, endTimeCap);
        }
        return errStr;
    }
}

