/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmbd.helper;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmbd.common.util.CommonUtils;
import kd.pmc.pmbd.common.util.TimeUtils;

public class ProjectCalendarHelper {
    public static final String ID = "id";
    public static final String SELECTED_ORG_ID = "org";
    public static final String DATA_ORG_ID = "dataorg";
    public static final String WORK_DATE = "workDate";
    public static final String DATE_TYPE = "dateType";
    public static final String PROJECT_ID = "projectid";
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    public static List<Map<String, String>> loadWorkCalendar(Map<String, String> orgMap, int year) {
        if (orgMap == null || !orgMap.containsKey(SELECTED_ORG_ID)) {
            return new ArrayList<Map<String, String>>();
        }
        String dateFrom = year + "-01-01";
        String dateTo = year + "-12-31";
        return ProjectCalendarHelper.loadWorkCalendar(orgMap, dateFrom, dateTo);
    }

    public static List<Map<String, String>> loadWorkCalendar(Map<String, String> orgMap, String dateFrom, String dateTo) {
        if (orgMap == null || !orgMap.containsKey(SELECTED_ORG_ID) || StringUtils.isBlank((CharSequence)dateFrom) || StringUtils.isBlank((CharSequence)dateTo)) {
            return new ArrayList<Map<String, String>>();
        }
        ArrayList<Map<String, String>> workDataList = new ArrayList<Map<String, String>>();
        String orgId = orgMap.get(SELECTED_ORG_ID);
        orgMap.put(DATA_ORG_ID, orgId);
        ProjectCalendarHelper.load(workDataList, orgMap, dateFrom, dateTo);
        return workDataList;
    }

    private static void load(List<Map<String, String>> workDataList, Map<String, String> orgMap, String dateFromStr, String dateToStr) {
        String orgId = orgMap.get(DATA_ORG_ID);
        if (StringUtils.isBlank((CharSequence)orgId)) {
            return;
        }
        ProjectCalendarHelper.loadCommon(workDataList, orgMap, dateFromStr, dateToStr);
    }

    private static void loadCommon(List<Map<String, String>> workDataList, Map<String, String> orgMap, String dateFromStr, String dateToStr) {
        String calid = orgMap.get("pjcalendar");
        Date dateFrom = TimeUtils.getDate(dateFromStr, DATE_FORMAT);
        Date dateTo = TimeUtils.getDate(dateToStr, DATE_FORMAT);
        QFilter qfilter = new QFilter("pjcalendar", "=", (Object)Long.parseLong(calid));
        qfilter.and("workdate", ">=", (Object)dateFrom);
        qfilter.and("workdate", "<=", (Object)dateTo);
        StringBuilder sbField = new StringBuilder();
        sbField.append("pjcalendar,");
        sbField.append("workdate,");
        sbField.append("datetype,");
        sbField.append("settype,");
        sbField.deleteCharAt(sbField.length() - 1);
        String orderBys = "workdate asc";
        try (AlgoContext context = Algo.newContext();){
            DataSet ds = QueryServiceHelper.queryDataSet((String)ProjectCalendarHelper.class.getName(), (String)"pmbd_calendarexpr", (String)sbField.toString(), (QFilter[])qfilter.toArray(), (String)orderBys);
            DynamicObjectCollection caleObjs = CommonUtils.getNewDynamicObjs("pmbd_calendarexpr", ds, sbField.toString());
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            for (DynamicObject caleObj : caleObjs) {
                HashMap<String, String> data = new HashMap<String, String>();
                String dateKey = sdf.format(caleObj.getDate("workdate"));
                data.put(WORK_DATE, dateKey);
                data.put(DATE_TYPE, caleObj.getString("datetype"));
                workDataList.add(data);
            }
        }
    }

    public static Boolean isCalendarAtYear(Long prjID, Long curyear) {
        Boolean atYear = Boolean.FALSE;
        ArrayList<Long> prgIDs = new ArrayList<Long>();
        prgIDs.add(prjID);
        DynamicObject[] dyncObjs = CommonUtils.getLoadData("pmbd_calendar", prgIDs);
        Calendar cale = Calendar.getInstance();
        if (dyncObjs.length <= 0) {
            return atYear;
        }
        DynamicObject dyncObj = dyncObjs[0];
        Date expirstartdate = dyncObj.getDate("expirstartdate");
        cale.setTime(expirstartdate);
        int expirstartYear = cale.get(1);
        Date expirendate = dyncObj.getDate("expirendate");
        cale.setTime(expirendate);
        int expirendateYear = cale.get(1);
        if (curyear >= (long)expirstartYear && curyear <= (long)expirendateYear) {
            atYear = Boolean.TRUE;
        }
        return atYear;
    }

    public static DynamicObject getCalendar(Long prjID) {
        ArrayList<Long> prgIDs = new ArrayList<Long>();
        prgIDs.add(prjID);
        DynamicObject[] dyncObjs = CommonUtils.getLoadData("pmbd_calendar", prgIDs);
        return dyncObjs[0];
    }

    public static Boolean existDefaultCalendar(Long orgID, Long calID) {
        Boolean existDefaultCalendar = Boolean.FALSE;
        QFilter qfilter = new QFilter("createorg", "=", (Object)orgID);
        qfilter.and("isfault", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection dyncObjs = QueryServiceHelper.query((String)"pmbd_calendar", (String)"id,name", (QFilter[])qfilter.toArray());
        DynamicObject dyncObj = null;
        if (dyncObjs.size() > 1) {
            existDefaultCalendar = Boolean.TRUE;
        } else if (dyncObjs.size() == 1 && !StringUtils.equalsIgnoreCase((CharSequence)(dyncObj = (DynamicObject)dyncObjs.get(0)).getString(ID), (CharSequence)calID.toString())) {
            existDefaultCalendar = Boolean.TRUE;
        }
        return existDefaultCalendar;
    }
}

