/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.common.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import org.apache.commons.collections4.CollectionUtils;

public class DateTimeFieldUtils {
    private static final String TODAY = "today";

    public static void setDefaultMaxSelectedDate(IFormView formView, List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        TimeZone timeZone = DateTimeFieldUtils.getTimeZone(formView, keys.get(0));
        String maxFormatString = DateTimeFieldUtils.getMaxFormatString(timeZone);
        DateTimeFieldUtils.setDefaultSelectedDate(formView, maxFormatString, keys);
    }

    public static void setDefaultMinSelectedDate(IFormView formView, List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        TimeZone timeZone = DateTimeFieldUtils.getTimeZone(formView, keys.get(0));
        String minFormatString = DateTimeFieldUtils.getMinFormatString(timeZone);
        DateTimeFieldUtils.setDefaultSelectedDate(formView, minFormatString, keys);
    }

    public static void setDefaultSelectedDate(IFormView formView, String defaultFormatString, List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        ArrayList metas = new ArrayList(keys.size());
        for (String key : keys) {
            HashMap<String, String> meta = new HashMap<String, String>(2);
            meta.put("k", key);
            meta.put(TODAY, defaultFormatString);
            metas.add(meta);
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        clientViewProxy.addAction("u", metas);
    }

    public static String getMinFormatString(TimeZone timeZone) {
        return KDDateFormatUtils.getDateFormat((TimeZone)timeZone).format(new Date());
    }

    public static String getMaxFormatString(TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return KDDateFormatUtils.getDateTimeFormat((TimeZone)timeZone).format(calendar.getTime());
    }

    public static TimeZone getTimeZone(IFormView formView, String dateTimeKey) {
        DateTimeEdit dateTimeEdit = (DateTimeEdit)formView.getControl(dateTimeKey);
        return dateTimeEdit == null ? KDDateUtils.getTimeZone() : dateTimeEdit.getTimeZone().getTimeZone();
    }
}

