/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.pmc.pmpd.common.model.TaskNode;
import kd.pmc.pmpd.common.util.TimeResult;

public class MileStoneTplUtils {
    public static Map<Long, TimeResult> calTplTime(DynamicObject tpl, Date beginTime, BigDecimal projectPeriod) {
        if (tpl == null) {
            return new HashMap<Long, TimeResult>();
        }
        DynamicObjectCollection entrys = tpl.getDynamicObjectCollection("treeentryentity");
        List<TaskNode> taskNodes = MileStoneTplUtils.analysisTaskNodes(entrys);
        MileStoneTplUtils.calEveryNodeTime(taskNodes, beginTime, projectPeriod);
        Map<Long, TimeResult> timeReusltMap = MileStoneTplUtils.getTimeReusltMap(taskNodes);
        return timeReusltMap;
    }

    public static Map<Long, TimeResult> getTimeReusltMap(List<TaskNode> taskNodes) {
        HashMap<Long, TimeResult> resultMap = new HashMap<Long, TimeResult>(8);
        for (TaskNode taskNode : taskNodes) {
            resultMap.put(taskNode.getId(), MileStoneTplUtils.createTimeResult(taskNode));
            for (TaskNode post = taskNode.getPost(); post != null; post = post.getPost()) {
                resultMap.put(post.getId(), MileStoneTplUtils.createTimeResult(post));
            }
        }
        return resultMap;
    }

    public static TimeResult createTimeResult(TaskNode taskNode) {
        TimeResult timeResult = new TimeResult();
        timeResult.setBeginDate(taskNode.getBeginDate());
        timeResult.setFinishDate(taskNode.getEndDate());
        timeResult.setDays(taskNode.getPlanPeriod());
        return timeResult;
    }

    public static void calEveryNodeTime(List<TaskNode> taskNodes, Date beginTime, BigDecimal projectPeriod) {
        Map<String, String> relationMap = MileStoneTplUtils.getRelationMap();
        for (TaskNode taskNode : taskNodes) {
            TimeResult timeResult = MileStoneTplUtils.calTaskNodeTime(taskNode, beginTime, projectPeriod);
            taskNode.setBeginDate(timeResult.getBeginDate());
            taskNode.setEndDate(timeResult.getFinishDate());
            Date beginDate = taskNode.getBeginDate();
            Date endDate = taskNode.getEndDate();
            BigDecimal delay = taskNode.getPostDelay();
            for (TaskNode post = taskNode.getPost(); post != null; post = post.getPost()) {
                String postRelation = relationMap.get(taskNode.getPostRelation());
                if (StringUtils.equals((CharSequence)"FF", (CharSequence)relationMap.get(postRelation))) {
                    post.setEndDate(MileStoneTplUtils.addTime(endDate, delay));
                    post.setBeginDate(MileStoneTplUtils.addTime(post.getEndDate(), post.getPlanPeriod().negate()));
                } else if (StringUtils.equals((CharSequence)"SS", (CharSequence)relationMap.get(postRelation))) {
                    post.setBeginDate(MileStoneTplUtils.addTime(beginDate, delay));
                    post.setEndDate(MileStoneTplUtils.addTime(post.getBeginDate(), post.getPlanPeriod()));
                } else if (StringUtils.equals((CharSequence)"SF", (CharSequence)relationMap.get(postRelation))) {
                    post.setEndDate(MileStoneTplUtils.addTime(beginDate, delay));
                    post.setBeginDate(MileStoneTplUtils.addTime(post.getEndDate(), post.getPlanPeriod().negate()));
                } else {
                    post.setBeginDate(MileStoneTplUtils.addTime(endDate, delay));
                    post.setEndDate(MileStoneTplUtils.addTime(post.getBeginDate(), post.getPlanPeriod()));
                }
                beginDate = post.getBeginDate();
                endDate = post.getEndDate();
                delay = post.getPostDelay();
            }
        }
    }

    public static Date addTime(Date time, BigDecimal period) {
        BigDecimal addTime = period.multiply(new BigDecimal(86400000));
        long result = time.getTime() + addTime.longValue();
        return new Date(result);
    }

    public static Map<String, String> getRelationMap() {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("1", "FS");
        map.put("2", "FF");
        map.put("3", "SS");
        map.put("4", "SF");
        return map;
    }

    public static List<TaskNode> analysisTaskNodes(DynamicObjectCollection entrys) {
        HashMap<Long, TaskNode> taskNodeMap = new HashMap<Long, TaskNode>(8);
        ArrayList<Long> headTaskId = new ArrayList<Long>(8);
        for (DynamicObject entry : entrys) {
            long id = (Long)entry.getPkValue();
            long frontTaskId = (Long)entry.get("fronttaskid");
            long postTaskId = (Long)entry.get("posttaskid");
            BigDecimal planPeriod = (BigDecimal)entry.get("planperiod");
            int planBegin = (Integer)entry.get("planbegin");
            int planFinish = (Integer)entry.get("planfinish");
            BigDecimal percent = (BigDecimal)entry.get("percent");
            String postRelation = (String)entry.get("postrelation");
            BigDecimal postDelay = (BigDecimal)entry.get("postdelay");
            TaskNode taskNode = new TaskNode();
            taskNode.setId(id);
            taskNode.setPlanBegin(planBegin);
            taskNode.setPlanFinish(planFinish);
            taskNode.setPercent(percent);
            taskNode.setPlanPeriod(planPeriod);
            if (frontTaskId == 0L) {
                headTaskId.add(id);
            }
            if (postTaskId != 0L) {
                TaskNode postNode = new TaskNode();
                postNode.setId(postTaskId);
                taskNode.setPost(postNode);
                taskNode.setPostRelation(postRelation);
                taskNode.setPostDelay(postDelay);
            }
            taskNodeMap.put(id, taskNode);
        }
        ArrayList<TaskNode> headNodes = new ArrayList<TaskNode>(8);
        Iterator iterator = headTaskId.iterator();
        while (iterator.hasNext()) {
            long taskId = (Long)iterator.next();
            TaskNode taskNode = (TaskNode)taskNodeMap.get(taskId);
            MileStoneTplUtils.setPost(taskNodeMap, taskNode);
            headNodes.add(taskNode);
        }
        return headNodes;
    }

    public static void setPost(Map<Long, TaskNode> taskNodeMap, TaskNode node) {
        if (node == null) {
            return;
        }
        TaskNode post = node.getPost();
        if (post == null) {
            return;
        }
        long postId = post.getId();
        post = taskNodeMap.get(postId);
        MileStoneTplUtils.setPost(taskNodeMap, post);
        node.setPost(post);
    }

    public static TimeResult calTaskNodeTime(TaskNode taskNode, Date planBeginTime, BigDecimal projectPeriod) {
        TimeResult result = new TimeResult();
        if (planBeginTime == null || projectPeriod == null) {
            return result;
        }
        long planBeginTimeStamp = planBeginTime.getTime();
        BigDecimal planPeriod = taskNode.getPlanPeriod();
        int planBegin = taskNode.getPlanBegin();
        int planFinish = taskNode.getPlanFinish();
        BigDecimal percent = taskNode.getPercent();
        if (planBegin == 0 && planFinish == 0) {
            result = new TimeResult(planBeginTime, planBeginTime, planPeriod);
            if (BigDecimal.ZERO.compareTo(planPeriod) != 0) {
                BigDecimal beginDays;
                long endTime = planBeginTimeStamp + MileStoneTplUtils.getTimeMs(planPeriod);
                result = new TimeResult(planBeginTime, new Date(endTime), planPeriod);
                if (percent.compareTo(BigDecimal.ZERO) > 0 && BigDecimal.ZERO.compareTo(beginDays = projectPeriod.multiply(percent).divide(new BigDecimal(100), 0, 4)) != 0) {
                    long beginTime = planBeginTimeStamp + MileStoneTplUtils.getTimeMs(beginDays);
                    endTime = beginTime + MileStoneTplUtils.getTimeMs(planPeriod);
                    result = new TimeResult(new Date(beginTime), new Date(endTime), planPeriod);
                }
            } else if (percent.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal beginDays = projectPeriod.multiply(percent).divide(new BigDecimal(100), 0, 4);
                long beginTime = planBeginTimeStamp + MileStoneTplUtils.getTimeMs(beginDays);
                result = new TimeResult(new Date(beginTime), new Date(beginTime), planPeriod);
            }
        } else if (planBegin != 0 && planFinish == 0) {
            long beginTime = planBeginTimeStamp + MileStoneTplUtils.getTimeMs(new BigDecimal(planBegin));
            long endTime = beginTime + MileStoneTplUtils.getTimeMs(planPeriod);
            result = new TimeResult(new Date(beginTime), new Date(endTime), planPeriod);
        } else if (planBegin == 0 && planFinish != 0) {
            long endTime = planBeginTimeStamp + MileStoneTplUtils.getTimeMs(new BigDecimal(planFinish));
            long beginTime = endTime - MileStoneTplUtils.getTimeMs(planPeriod);
            result = new TimeResult(new Date(beginTime), new Date(endTime), planPeriod);
        } else if (planBegin != 0 && planFinish != 0) {
            long beginTime = planBeginTimeStamp + MileStoneTplUtils.getTimeMs(new BigDecimal(planBegin));
            long endTime = planBeginTimeStamp + MileStoneTplUtils.getTimeMs(new BigDecimal(planFinish));
            result = new TimeResult(new Date(beginTime), new Date(endTime), new BigDecimal((endTime - beginTime) / 86400000L).setScale(2, 4));
        }
        return result;
    }

    public static long getTimeMs(BigDecimal period) {
        return (long)(period.setScale(4).doubleValue() * 24.0 * 60.0 * 60.0 * 1000.0);
    }

    public static TimeResult calTime(DynamicObject entry, Date planBeginTime, BigDecimal projectPeriod) {
        TimeResult result = new TimeResult();
        if (planBeginTime == null || projectPeriod == null) {
            return result;
        }
        Calendar calendar = Calendar.getInstance();
        BigDecimal planPeriod = entry.getBigDecimal("planperiod");
        int planBegin = entry.getInt("planbegin");
        int planFinish = entry.getInt("planfinish");
        BigDecimal percent = entry.getBigDecimal("percent");
        if (planBegin == 0 && planFinish == 0) {
            calendar.setTime(planBeginTime);
            result.setBeginDate(planBeginTime);
            result.setFinishDate(calendar.getTime());
            result.setDays(planPeriod);
            if (BigDecimal.ZERO.compareTo(planPeriod) != 0) {
                BigDecimal beginDays;
                calendar.add(6, planPeriod.intValue() - 1);
                result.setBeginDate(planBeginTime);
                calendar.add(10, 23);
                calendar.add(12, 59);
                calendar.add(13, 59);
                result.setFinishDate(calendar.getTime());
                result.setDays(planPeriod);
                if (percent.compareTo(BigDecimal.ZERO) > 0 && BigDecimal.ZERO.compareTo(beginDays = projectPeriod.multiply(percent).divide(new BigDecimal(100), 0, 4)) != 0) {
                    calendar.setTime(planBeginTime);
                    calendar.add(6, beginDays.intValue() == 0 ? 0 : beginDays.intValue() - 1);
                    result.setBeginDate(calendar.getTime());
                    calendar.add(6, planPeriod.intValue() - 1);
                    calendar.add(10, 23);
                    calendar.add(12, 59);
                    calendar.add(13, 59);
                    result.setFinishDate(calendar.getTime());
                    result.setDays(planPeriod);
                }
            } else if (percent.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal beginDays = projectPeriod.multiply(percent).divide(new BigDecimal(100), 0, 4);
                calendar.setTime(planBeginTime);
                calendar.add(6, beginDays.intValue() == 0 ? 0 : beginDays.intValue() - 1);
                result.setBeginDate(calendar.getTime());
                calendar.add(10, 23);
                calendar.add(12, 59);
                calendar.add(13, 59);
                result.setFinishDate(calendar.getTime());
                result.setDays(BigDecimal.ONE);
            }
        } else if (planBegin != 0 && planFinish == 0) {
            calendar.setTime(planBeginTime);
            calendar.add(6, planBegin - 1);
            result.setBeginDate(calendar.getTime());
            if (BigDecimal.ZERO.compareTo(planPeriod) != 0) {
                calendar.add(6, planPeriod.intValue() - 1);
                calendar.add(10, 23);
                calendar.add(12, 59);
                calendar.add(13, 59);
            }
            result.setFinishDate(calendar.getTime());
            result.setDays(planPeriod);
        } else if (planBegin == 0 && planFinish != 0) {
            calendar.setTime(planBeginTime);
            calendar.add(6, planFinish - 1);
            calendar.add(10, 23);
            calendar.add(12, 59);
            calendar.add(13, 59);
            result.setFinishDate(calendar.getTime());
            if (BigDecimal.ZERO.compareTo(planPeriod) != 0) {
                calendar.add(6, -planPeriod.intValue() + 1);
                calendar.add(10, 0);
                calendar.add(12, 0);
                calendar.add(13, 0);
            }
            result.setBeginDate(calendar.getTime());
            result.setDays(planPeriod);
        } else if (planBegin != 0 && planFinish != 0) {
            calendar.setTime(planBeginTime);
            calendar.add(6, planBegin - 1);
            long beginTimeMillis = calendar.getTimeInMillis();
            result.setBeginDate(calendar.getTime());
            calendar.setTime(planBeginTime);
            calendar.add(6, planFinish - 1);
            long finishTimeMillis = calendar.getTimeInMillis();
            calendar.add(10, 23);
            calendar.add(12, 59);
            calendar.add(13, 59);
            result.setFinishDate(calendar.getTime());
            result.setDays(new BigDecimal((finishTimeMillis - beginTimeMillis) / 86400000L).setScale(2, 4));
        }
        return result;
    }
}

