/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class TimeUnitUtils {
    public static final String RATE = "rate";
    public static final String SCALE = "scale";

    public static BigDecimal convertTimeUnit(String sourceNo, String targetNo, BigDecimal value) {
        BigDecimal result = value;
        Map<String, BigDecimal> convertProperty = TimeUnitUtils.getConvertProperty(sourceNo, targetNo);
        if (!convertProperty.isEmpty() && value != null) {
            result = value.multiply(convertProperty.get(RATE)).setScale(convertProperty.get(SCALE).intValue(), 4);
        }
        return result;
    }

    public static List<BigDecimal> batchConvertTimeUnit(String sourceNo, String targetNo, List<BigDecimal> values) {
        ArrayList<BigDecimal> result = new ArrayList<BigDecimal>(values);
        Map<String, BigDecimal> convertProperty = TimeUnitUtils.getConvertProperty(sourceNo, targetNo);
        if (!convertProperty.isEmpty() && !values.isEmpty()) {
            result.clear();
            BigDecimal rate = convertProperty.get(RATE);
            int scale = convertProperty.get(SCALE).intValue();
            for (BigDecimal value : values) {
                result.add(value.multiply(rate).setScale(scale, 4));
            }
        }
        return result;
    }

    public static Map<String, BigDecimal> getConvertProperty(String sourceNo, String targetNo) {
        HashMap<String, BigDecimal> property = new HashMap<String, BigDecimal>(2);
        QFilter qFilter = new QFilter("number", "=", (Object)sourceNo);
        qFilter.and(new QFilter("entryentity.targetunit.number", "=", (Object)targetNo));
        DynamicObject timeUnit = QueryServiceHelper.queryOne((String)"pmpd_timeunit", (String)"id,entryentity.rate,entryentity.scale", (QFilter[])qFilter.toArray());
        if (timeUnit != null) {
            property.put(RATE, timeUnit.getBigDecimal("entryentity.rate"));
            property.put(SCALE, timeUnit.getBigDecimal("entryentity.scale"));
        }
        return property;
    }

    public static BigDecimal calPeriod(String number, Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return BigDecimal.ZERO;
        }
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        DynamicObject timeUnit = QueryServiceHelper.queryOne((String)"pmpd_timeunit", (String)"id,calrate", (QFilter[])qFilter.toArray());
        if (timeUnit != null) {
            BigDecimal calrate = new BigDecimal(timeUnit.getLong("calrate") * 1000L);
            BigDecimal startDateTime = new BigDecimal(startDate.getTime());
            BigDecimal endDateTime = new BigDecimal(endDate.getTime());
            return endDateTime.subtract(startDateTime).divide(calrate, 10, 4);
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal calPeriod(String number, Date startDate, Date endDate, int day) {
        if (startDate == null || endDate == null) {
            return BigDecimal.ZERO;
        }
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        DynamicObject timeUnit = QueryServiceHelper.queryOne((String)"pmpd_timeunit", (String)"id,calrate", (QFilter[])qFilter.toArray());
        if (timeUnit != null) {
            BigDecimal calrate = new BigDecimal(timeUnit.getLong("calrate") * 1000L);
            BigDecimal startDateTime = new BigDecimal(startDate.getTime());
            GregorianCalendar cld = new GregorianCalendar();
            cld.setTime(endDate);
            ((Calendar)cld).add(5, 1);
            BigDecimal endDateTime = new BigDecimal(cld.getTime().getTime());
            return endDateTime.subtract(startDateTime).divide(calrate, 10, 4);
        }
        return BigDecimal.ZERO;
    }

    public static Date calEndDate(String number, Date startDate, BigDecimal period) {
        if (startDate == null || period == null) {
            return null;
        }
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        DynamicObject timeUnit = QueryServiceHelper.queryOne((String)"pmpd_timeunit", (String)"id,calrate", (QFilter[])qFilter.toArray());
        if (timeUnit != null) {
            BigDecimal calrate = new BigDecimal(timeUnit.getLong("calrate") * 1000L);
            BigDecimal startDateTime = new BigDecimal(startDate.getTime());
            BigDecimal endTime = startDateTime.add(calrate.multiply(period));
            return new Date(endTime.longValue());
        }
        return null;
    }
}

