/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.list.IListView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmts.common.model.BindOrderModel;

public class BindOrderUtils {
    public static Object[] saveBindOrderModel(BindOrderModel[] bindOrderModels) {
        if (bindOrderModels == null || bindOrderModels.length == 0) {
            return new Object[0];
        }
        DynamicObject[] relations = new DynamicObject[bindOrderModels.length];
        for (int i = 0; i < bindOrderModels.length; ++i) {
            BindOrderModel bindOrderModel = bindOrderModels[i];
            DynamicObject relation = BusinessDataServiceHelper.newDynamicObject((String)"fmm_task_relations");
            relation.set("sourcebilltype", (Object)bindOrderModel.getSourceBillType());
            relation.set("sourcebillid", (Object)bindOrderModel.getSourceBillId());
            relation.set("sourcebillentryid", (Object)bindOrderModel.getSourceBillEntryId());
            relation.set("targetbilltype", (Object)bindOrderModel.getTargetBillType());
            relation.set("targetbillid", (Object)bindOrderModel.getTargetBillId());
            relation.set("targetbillentryid", (Object)bindOrderModel.getTargetBillEntryId());
            relations[i] = relation;
        }
        return SaveServiceHelper.save((DynamicObject[])relations);
    }

    public static int deleteTargetBillRelations(List<String> targetIds, String sourceBillType) {
        if (targetIds == null || targetIds.isEmpty()) {
            return 0;
        }
        QFilter qFilter = new QFilter("targetbillid", "in", targetIds);
        if (StringUtils.isNotBlank((CharSequence)sourceBillType)) {
            qFilter.and(new QFilter("sourcebilltype", "=", (Object)sourceBillType));
        }
        return DeleteServiceHelper.delete((String)"fmm_task_relations", (QFilter[])qFilter.toArray());
    }

    public static List<String> getSourceBillEntryIds(String targetId, String sourceBillType) {
        ArrayList<String> sourceBillEntryIds = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)targetId) && StringUtils.isNotBlank((CharSequence)sourceBillType)) {
            QFilter qFilter = new QFilter("targetbillid", "=", (Object)targetId);
            qFilter = qFilter.and(new QFilter("sourcebilltype", "=", (Object)sourceBillType));
            DynamicObjectCollection fmm_task_relations = QueryServiceHelper.query((String)"fmm_task_relations", (String)"id,sourcebillentryid", (QFilter[])qFilter.toArray());
            for (DynamicObject relation : fmm_task_relations) {
                String sourcebillentryid = relation.getString("sourcebillentryid");
                sourceBillEntryIds.add(sourcebillentryid);
            }
        }
        return sourceBillEntryIds;
    }

    public static void deleteRelations(String targetId, String sourceBillType, List<String> sourceBillEntryIds) {
        if (StringUtils.isNotBlank((CharSequence)targetId) && StringUtils.isNotBlank((CharSequence)sourceBillType) && sourceBillEntryIds != null) {
            QFilter[] qFilters = new QFilter[]{new QFilter("targetbillid", "=", (Object)targetId), new QFilter("sourcebilltype", "=", (Object)sourceBillType), new QFilter("sourcebillentryid", "in", sourceBillEntryIds)};
            DeleteServiceHelper.delete((String)"fmm_task_relations", (QFilter[])qFilters);
        }
    }

    public static List<String> getBatchSourceBillEntryIds(List<String> targetIds, String sourceBillType) {
        ArrayList<String> sourceBillEntryIds = new ArrayList<String>();
        if (targetIds != null && !targetIds.isEmpty()) {
            QFilter qFilter = new QFilter("targetbillid", "in", targetIds);
            qFilter = qFilter.and(new QFilter("sourcebilltype", "=", (Object)sourceBillType));
            DynamicObjectCollection fmm_task_relations = QueryServiceHelper.query((String)"fmm_task_relations", (String)"id,sourcebillentryid", (QFilter[])qFilter.toArray());
            for (DynamicObject relation : fmm_task_relations) {
                String sourcebillentryid = relation.getString("sourcebillentryid");
                sourceBillEntryIds.add(sourcebillentryid);
            }
        }
        return sourceBillEntryIds;
    }

    public static void updateTaskBindStauts(List<String> taskIds) {
        DynamicObject[] tasks;
        QFilter qFilter = new QFilter("targetbillid", "in", taskIds);
        DynamicObjectCollection fmm_task_relations = QueryServiceHelper.query((String)"fmm_task_relations", (String)"id,targetbillid", (QFilter[])qFilter.toArray());
        HashSet<String> bindTaskIds = new HashSet<String>(8);
        for (DynamicObject relation : fmm_task_relations) {
            bindTaskIds.add(relation.getString("targetbillid"));
        }
        for (DynamicObject task : tasks = BusinessDataServiceHelper.load((String)"pmts_task", (String)"id,bindstatus", (QFilter[])new QFilter("id", "in", BindOrderUtils.stringToLong(taskIds)).toArray())) {
            String id = task.getString("id");
            String bindStatus = "A";
            if (bindTaskIds.contains(id)) {
                bindStatus = "B";
            }
            task.set("bindstatus", (Object)bindStatus);
        }
        SaveServiceHelper.save((DynamicObject[])tasks);
    }

    public static void updateRelatedOrderQtys(List<String> taskIds) {
        DynamicObject[] tasks;
        ArrayList<String> orderEntryIds;
        QFilter qFilter = new QFilter("targetbillid", "in", taskIds);
        DynamicObjectCollection fmm_task_relations = QueryServiceHelper.query((String)"fmm_task_relations", (String)"id,targetbillid,sourcebillentryid", (QFilter[])qFilter.toArray());
        HashMap<String, ArrayList<String>> relatedOrderMap = new HashMap<String, ArrayList<String>>();
        for (Object relation : fmm_task_relations) {
            String string = relation.getString("sourcebillentryid");
            String targetbillid = relation.getString("targetbillid");
            orderEntryIds = (ArrayList<String>)relatedOrderMap.get(targetbillid);
            if (orderEntryIds == null) {
                orderEntryIds = new ArrayList<String>();
            }
            orderEntryIds.add(string);
            relatedOrderMap.put(targetbillid, orderEntryIds);
        }
        HashMap<String, Integer> relatedOrderQtys = new HashMap<String, Integer>(16);
        for (Map.Entry entry : relatedOrderMap.entrySet()) {
            String taskId = (String)entry.getKey();
            orderEntryIds = (List)entry.getValue();
            DynamicObjectCollection sfc_mromanuftech = QueryServiceHelper.query((String)"sfc_mromanuftech", (String)"id,oprentryentity.id", (QFilter[])new QFilter("oprentryentity.id", "in", BindOrderUtils.stringToLong(orderEntryIds)).toArray());
            relatedOrderQtys.put(taskId, sfc_mromanuftech.size());
        }
        for (DynamicObject task : tasks = BusinessDataServiceHelper.load((String)"pmts_task", (String)"id,relatedorderqty", (QFilter[])new QFilter("id", "in", BindOrderUtils.stringToLong(taskIds)).toArray())) {
            String taksId = task.getString("id");
            Integer qty = (Integer)relatedOrderQtys.get(taksId);
            if (qty != null) {
                task.set("relatedorderqty", (Object)qty);
                continue;
            }
            task.set("relatedorderqty", (Object)0);
        }
        SaveServiceHelper.save((DynamicObject[])tasks);
    }

    public static void autoBindRelations(DynamicObject[] tasks) {
        ArrayList<BindOrderModel> allBindOrderModel = new ArrayList<BindOrderModel>(8);
        ArrayList<String> deleteRelationIds = new ArrayList<String>(8);
        for (DynamicObject dataEntity : tasks) {
            long pkValue = (Long)dataEntity.getPkValue();
            long projectId = dataEntity.getLong("projectnum_id");
            DynamicObject standardtask = dataEntity.getDynamicObject("standardtask");
            if (projectId == 0L || standardtask == null) continue;
            DynamicObjectCollection cardEntrys = standardtask.getDynamicObjectCollection("entryentity");
            HashMap<Long, Set<Long>> cardMap = new HashMap<Long, Set<Long>>(8);
            for (DynamicObject cardEntry : cardEntrys) {
                long cardId = cardEntry.getLong("cardid");
                HashSet<Long> cardGroup = (HashSet<Long>)cardMap.get(cardId);
                if (cardGroup == null) {
                    cardGroup = new HashSet<Long>(8);
                }
                cardGroup.add(cardEntry.getLong("progroup_id"));
                cardMap.put(cardId, cardGroup);
            }
            if (cardMap.isEmpty()) continue;
            List<BindOrderModel> bindOrderModels = BindOrderUtils.getBindOrderModelsByCard(Long.toString(pkValue), projectId, cardMap);
            allBindOrderModel.addAll(bindOrderModels);
            deleteRelationIds.add(Long.toString(pkValue));
        }
        if (!allBindOrderModel.isEmpty()) {
            BindOrderUtils.deleteTargetBillRelations(deleteRelationIds, "sfc_mromanuftech");
            BindOrderUtils.saveBindOrderModel(allBindOrderModel.toArray(new BindOrderModel[0]));
        }
    }

    public static List<BindOrderModel> getBindOrderModelsByCard(String taskId, long projectId, Map<Long, Set<Long>> cardMap) {
        String algoKey = BindOrderUtils.class.getName();
        ArrayList<BindOrderModel> list = new ArrayList<BindOrderModel>(8);
        QFilter qFilter = new QFilter("project", "=", (Object)projectId);
        qFilter = qFilter.and(new QFilter("workcard", "in", cardMap.keySet()));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(algoKey + "_queryMroManufTechByCard"), (String)"sfc_mromanuftech", (String)"id,workcard,oprentryentity.id,oprentryentity.oprprocessgroup", (QFilter[])qFilter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                long processGroupId = next.getLong("oprentryentity.oprprocessgroup");
                Set<Long> cardGroup = cardMap.get(next.getLong("workcard"));
                if (!cardGroup.contains(processGroupId)) continue;
                BindOrderModel bindOrderModel = new BindOrderModel();
                bindOrderModel.setSourceBillType("sfc_mromanuftech");
                bindOrderModel.setSourceBillId(next.getString("id"));
                bindOrderModel.setSourceBillEntryId(next.getString("oprentryentity.id"));
                bindOrderModel.setTargetBillId(taskId);
                bindOrderModel.setTargetBillType("pmts_task");
                list.add(bindOrderModel);
            }
        }
        return list;
    }

    public static Set<Long> getUnBindEntryIds(Long projectId, String type) {
        String algoKey = BindOrderUtils.class.getName();
        HashSet<Long> taskIds = new HashSet<Long>(8);
        QFilter qFilter = new QFilter("projectnum", "=", (Object)projectId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(algoKey + "_queryTask"), (String)"pmts_task", (String)"id", (QFilter[])qFilter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                taskIds.add(next.getLong("id"));
            }
        }
        List<String> taskIdStr = BindOrderUtils.longToString(new ArrayList<Long>(taskIds));
        qFilter = new QFilter("targetbillid", "in", taskIdStr);
        HashSet<String> bindEntryIds = new HashSet<String>(8);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(algoKey + "_queryRelations"), (String)"fmm_task_relations", (String)"id,sourcebillentryid", (QFilter[])qFilter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                bindEntryIds.add(next.getString("sourcebillentryid"));
            }
        }
        HashSet<Long> unBindEntryIds = new HashSet<Long>(8);
        qFilter = new QFilter("oprentryentity.id", "not in", BindOrderUtils.stringToLong(new ArrayList<String>(bindEntryIds)));
        qFilter = qFilter.and(new QFilter("oprentryentity.oprprocessgroup", "!=", (Object)0));
        qFilter = qFilter.and(new QFilter("oprentryentity.oprprocessgroup", "is not null", null));
        qFilter = qFilter.and(new QFilter("project", "=", (Object)projectId));
        if (StringUtils.equals((CharSequence)"A", (CharSequence)type)) {
            qFilter = qFilter.and("transactiontype", "!=", (Object)1435381552417619968L);
        } else if (StringUtils.equals((CharSequence)"D", (CharSequence)type)) {
            qFilter = qFilter.and("transactiontype", "=", (Object)1435381552417619968L);
            QFilter[] orderFilters = new QFilter[]{new QFilter("treeentryentity.project", "=", (Object)projectId), new QFilter("issuborder", "=", (Object)Boolean.TRUE)};
            DynamicObjectCollection orders = QueryServiceHelper.query((String)"pom_mroorder", (String)"id", (QFilter[])orderFilters);
            ArrayList<String> orderIds = new ArrayList<String>();
            for (DynamicObject order : orders) {
                orderIds.add(order.getString("id"));
            }
            qFilter = qFilter.and("manufactureorderid", "not in", orderIds);
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(algoKey + "_queryMroManufTech"), (String)"sfc_mromanuftech", (String)"id,oprentryentity.id", (QFilter[])qFilter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                Object oprentryentityId = next.get("oprentryentity.id");
                if (oprentryentityId == null) continue;
                unBindEntryIds.add((Long)oprentryentityId);
            }
        }
        return unBindEntryIds;
    }

    public static void updateSpecialTask(DynamicObject[] tasks) {
        if (tasks != null) {
            for (DynamicObject task : tasks) {
                List<String> sourceBillEntryIds = BindOrderUtils.getSourceBillEntryIds(task.getString("id"), "sfc_mromanuftech");
                task.set("isspecial", (Object)BindOrderUtils.isSpecialCard(new HashSet<Long>(BindOrderUtils.stringToLong(sourceBillEntryIds))));
            }
            SaveServiceHelper.save((DynamicObject[])tasks);
        }
    }

    public static boolean isSpecialCard(Set<Long> entryIds) {
        if (entryIds != null && !entryIds.isEmpty()) {
            QFilter qFilter = new QFilter("oprentryentity.id", "in", entryIds);
            HashSet<Long> workCardIds = new HashSet<Long>(8);
            DynamicObjectCollection sfc_mromanuftech = QueryServiceHelper.query((String)"sfc_mromanuftech", (String)"id,workcard", (QFilter[])qFilter.toArray());
            for (DynamicObject obj : sfc_mromanuftech) {
                workCardIds.add(obj.getLong("workcard"));
            }
            qFilter = new QFilter("riskcard", "=", (Object)"1");
            qFilter = qFilter.and(new QFilter("id", "in", workCardIds));
            return QueryServiceHelper.exists((String)"mpdm_mrocardroute", (QFilter[])qFilter.toArray());
        }
        return false;
    }

    public static Set<Long> getMroManufTechEntryIds(Set<Long> cardEntryIds) {
        HashSet<Long> mroManufTechEntryIds = new HashSet<Long>(8);
        return mroManufTechEntryIds;
    }

    public static List<Long> stringToLong(List<String> list) {
        ArrayList<Long> ids = new ArrayList<Long>(list.size());
        for (String id : list) {
            ids.add(Long.parseLong(id));
        }
        return ids;
    }

    public static List<String> longToString(List<Long> list) {
        ArrayList<String> ids = new ArrayList<String>(list.size());
        for (long id : list) {
            ids.add(Long.toString(id));
        }
        return ids;
    }

    public static long getPlanTypeId(IFormView view) {
        long planTypeId = 0L;
        if (view instanceof IListView) {
            String formId = ((ListView)view).getBillFormId();
            if (StringUtils.equals((CharSequence)"pmts_task_masterplan", (CharSequence)formId)) {
                planTypeId = 1437660575319473152L;
            } else if (StringUtils.equals((CharSequence)"pmts_task_regionplan", (CharSequence)formId)) {
                planTypeId = 1437660676930681856L;
            } else if (StringUtils.equals((CharSequence)"pmts_task_industryplan", (CharSequence)formId)) {
                planTypeId = 1437660742504453120L;
            }
        }
        return planTypeId;
    }

    public static Long getProjectId(IFormView formView) {
        String pageId;
        Object filterValue;
        if (formView instanceof IListView && (filterValue = GanttUtils.getFilterValue((String)"projectnum.id", (String)(pageId = formView.getPageId()))) instanceof Long) {
            return (Long)filterValue;
        }
        return 0L;
    }
}

