/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;

public class DateUtil {
    private static ThreadLocal<SimpleDateFormat> simpleDateFormatThreadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };

    public static Date addSecond(Date date, long second) {
        Calendar c = Calendar.getInstance();
        if (date != null) {
            c.setTimeInMillis(DateUtil.getMillis(date) + second * 1000L);
        }
        return c.getTime();
    }

    public static Date reduceSecond(Date date, long second) {
        Calendar c = Calendar.getInstance();
        if (date != null) {
            c.setTimeInMillis(DateUtil.getMillis(date) - second * 1000L);
        }
        return c.getTime();
    }

    public static long getMillis(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.getTimeInMillis();
    }

    public static Date parseStrDate(String strDate) {
        try {
            return simpleDateFormatThreadLocal.get().parse(strDate);
        }
        catch (ParseException e) {
            new KDBizException(new ErrorCode("", ""), new Object[]{e});
            return null;
        }
    }

    public static String formatDate(Date date) {
        return simpleDateFormatThreadLocal.get().format(date);
    }
}

