/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.common.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmts.common.model.SaveStandardTaskModel;

public class SaveStandardTaskUtils {
    public static String getWbsFields() {
        return "id,name,wbstype,plandays,durationunit,plantype,planarea,projectnum";
    }

    public static String getTaskFields() {
        return "id,name,tasktype,plantype,plantime,durationunit,planarea,projectnum,biztype,scheduletype";
    }

    public static void saveStandardTask(SaveStandardTaskModel saveStandardTaskModel) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(8);
        result.addAll(SaveStandardTaskUtils.getWbsStandardTask(saveStandardTaskModel.getWbsCol()));
        result.addAll(SaveStandardTaskUtils.getTaskStandardTask(saveStandardTaskModel.getTaskCol()));
        result.addAll(SaveStandardTaskUtils.getMileStandardTask(saveStandardTaskModel.getMileCol()));
        if (!result.isEmpty()) {
            DynamicObject[] save = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[0]));
            String sql = "INSERT INTO t_fmm_standardtask_U (FDATAID,FUSEORGID) VALUES (?,?)";
            ArrayList<Object[]> values = new ArrayList<Object[]>(8);
            for (DynamicObject obj : save) {
                Object[] value = new Object[]{obj.getPkValue(), obj.get("createorg")};
                values.add(value);
            }
            if (values.size() > 0) {
                DBRoute dbRoute = DBRoute.of((String)"scm");
                DB.executeBatch((DBRoute)dbRoute, (String)sql, values);
            }
        }
    }

    public static List<DynamicObject> getWbsStandardTask(DynamicObjectCollection wbsCol) {
        ArrayList<DynamicObject> wbsStandardTask = new ArrayList<DynamicObject>(8);
        if (wbsCol == null) {
            return wbsStandardTask;
        }
        String[] batchNumber = SaveStandardTaskUtils.getBatchNumber(wbsCol.size());
        for (int i = 0; i < wbsCol.size(); ++i) {
            DynamicObject wbs = (DynamicObject)wbsCol.get(i);
            DynamicObject standardTask = BusinessDataServiceHelper.newDynamicObject((String)"fmm_standardtask");
            standardTask.set("number", (Object)batchNumber[i]);
            standardTask.set("name", (Object)wbs.getString("name"));
            standardTask.set("biztype", (Object)"C");
            standardTask.set("wbstype", wbs.get("wbstype"));
            if (wbs.get("plantype") != null) {
                DynamicObjectCollection planTypes = standardTask.getDynamicObjectCollection("plantypes");
                DynamicObject planType = planTypes.addNew();
                planType.set("fbasedataid", wbs.get("plantype"));
            }
            standardTask.set("planarea", wbs.get("planarea"));
            standardTask.set("planperiod", wbs.get("plandays"));
            standardTask.set("timeunit", wbs.get("durationunit"));
            standardTask.set("sourceproject", wbs.get("projectnum"));
            standardTask.set("creator", (Object)RequestContext.get().getCurrUserId());
            standardTask.set("createorg", (Object)RequestContext.get().getOrgId());
            standardTask.set("status", (Object)"A");
            standardTask.set("enable", (Object)"1");
            standardTask.set("ctrlstrategy", (Object)"5");
            wbsStandardTask.add(standardTask);
        }
        return wbsStandardTask;
    }

    public static List<DynamicObject> getMileStandardTask(DynamicObjectCollection mileCol) {
        ArrayList<DynamicObject> mileStandardTask = new ArrayList<DynamicObject>(8);
        if (mileCol == null) {
            return mileStandardTask;
        }
        String[] batchNumber = SaveStandardTaskUtils.getBatchNumber(mileCol.size());
        for (int i = 0; i < mileCol.size(); ++i) {
            DynamicObject mile = (DynamicObject)mileCol.get(i);
            DynamicObject standardTask = BusinessDataServiceHelper.newDynamicObject((String)"fmm_standardtask");
            standardTask.set("number", (Object)batchNumber[i]);
            standardTask.set("name", (Object)mile.getString("name"));
            standardTask.set("biztype", (Object)"B");
            standardTask.set("tasktype", mile.get("tasktype"));
            if (mile.get("plantype") != null) {
                DynamicObjectCollection planTypes = standardTask.getDynamicObjectCollection("plantypes");
                DynamicObject planType = planTypes.addNew();
                planType.set("fbasedataid", mile.get("plantype"));
            }
            standardTask.set("planarea", mile.get("planarea"));
            standardTask.set("planperiod", mile.get("plantime"));
            standardTask.set("timeunit", mile.get("durationunit"));
            standardTask.set("sourceproject", mile.get("projectnum"));
            standardTask.set("creator", (Object)RequestContext.get().getCurrUserId());
            standardTask.set("createorg", (Object)RequestContext.get().getOrgId());
            standardTask.set("status", (Object)"A");
            standardTask.set("enable", (Object)"1");
            standardTask.set("ctrlstrategy", (Object)"5");
            mileStandardTask.add(standardTask);
        }
        return mileStandardTask;
    }

    public static List<DynamicObject> getTaskStandardTask(DynamicObjectCollection taskCol) {
        ArrayList<DynamicObject> taskStandardTask = new ArrayList<DynamicObject>(8);
        if (taskCol == null) {
            return taskStandardTask;
        }
        String[] batchNumber = SaveStandardTaskUtils.getBatchNumber(taskCol.size());
        for (int i = 0; i < taskCol.size(); ++i) {
            DynamicObject task = (DynamicObject)taskCol.get(i);
            DynamicObject standardTask = BusinessDataServiceHelper.newDynamicObject((String)"fmm_standardtask");
            standardTask.set("number", (Object)batchNumber[i]);
            standardTask.set("name", (Object)task.getString("name"));
            standardTask.set("biztype", (Object)"A");
            standardTask.set("tasktype", task.get("tasktype"));
            if (task.get("plantype") != null) {
                DynamicObjectCollection planTypes = standardTask.getDynamicObjectCollection("plantypes");
                DynamicObject planType = planTypes.addNew();
                planType.set("fbasedataid", task.get("plantype"));
            }
            standardTask.set("planarea", task.get("planarea"));
            standardTask.set("planperiod", task.get("plantime"));
            standardTask.set("timeunit", task.get("durationunit"));
            standardTask.set("sourceproject", task.get("projectnum"));
            standardTask.set("creator", (Object)RequestContext.get().getCurrUserId());
            standardTask.set("createorg", (Object)RequestContext.get().getOrgId());
            standardTask.set("status", (Object)"A");
            standardTask.set("enable", (Object)"1");
            standardTask.set("ctrlstrategy", (Object)"5");
            taskStandardTask.add(standardTask);
        }
        return taskStandardTask;
    }

    public static String[] getBatchNumber(int count) {
        String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)"fmm_standardtask", (DynamicObject)new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fmm_standardtask")), (String)String.valueOf(RequestContext.get().getOrgId()), (int)count);
        return batchNumber;
    }
}

