/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.common.util;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.form.operate.MutexHelper;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;

public class SingleProjectBenchLockUtils {
    private static final String ENTITY = "pmts_single_project_bench";
    private static final String OPTIONKEY = "modify";

    public static Boolean lockProject(IFormView view, Long projectId) {
        StringBuilder errMsg = new StringBuilder();
        String concat = String.valueOf(projectId).concat("&").concat(view.getPageId());
        concat = concat.length() > 100 ? concat.substring(0, 100) : concat;
        MutexLockInfo lockInfo = new MutexLockInfo(concat, null, (String)null, ENTITY, OPTIONKEY, true, "default");
        boolean require = MutexHelper.require((IFormView)view, (MutexLockInfo)lockInfo, (StringBuilder)errMsg);
        return require;
    }

    public static Boolean unLockProject(String pageId, Long projectId) {
        String concat = String.valueOf(projectId).concat("&").concat(pageId);
        concat = concat.length() > 100 ? concat.substring(0, 100) : concat;
        boolean release = MutexHelper.release((String)ENTITY, (String)OPTIONKEY, (String)concat);
        return release;
    }

    public static Boolean judgeProjectIsLock(Long projectId) {
        String concat = String.valueOf(projectId).concat("&%");
        QFilter qFilter = new QFilter("objectid", "like", (Object)concat);
        qFilter.and(new QFilter("entitykey", "=", (Object)ENTITY));
        qFilter.and(new QFilter("operationkey", "=", (Object)OPTIONKEY));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_datalock", (String)"objectid", (QFilter[])new QFilter[]{qFilter});
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            for (DynamicObject dynamicObject : query) {
                String pageIdStr = dynamicObject.getString("objectid");
                String pageId = pageIdStr.substring(concat.length() - 1);
                IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
                if (view != null) {
                    return true;
                }
                SingleProjectBenchLockUtils.unLockProject(pageId, projectId);
            }
        }
        return false;
    }
}

