/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.mservice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.fmm.business.bom.BomBeanUtil;
import kd.mmc.fmm.mservice.api.BOMNestingCheckService;

public class BOMNestingCheckServiceImpl
implements BOMNestingCheckService {
    private static Log logger = LogFactory.getLog(BOMNestingCheckServiceImpl.class);

    public ArrayList<List> bomCheck(List<String> bomNumbers) {
        logger.warn("BOMinto\uff1a" + bomNumbers.toString());
        DataSet material2 = QueryServiceHelper.queryDataSet((String)"BOMNestingCheckServiceImpl0", (String)"pdm_mftbom", (String)"material,configuredcode,version,replaceno,auxproperty,entry.entrymaterial,entry.entrymaterialid,entry.entryconfiguredcode,entry.entryversion,entry.entryauxproperty", (QFilter[])new QFilter[]{new QFilter("number", "in", bomNumbers)}, null);
        DataSet copy = material2.copy();
        ArrayList<Long> longs = new ArrayList<Long>();
        for (Row row : copy) {
            longs.add(row.getLong("material"));
            longs.add(row.getLong("entry.entrymaterialid"));
        }
        DataSet material1 = QueryServiceHelper.queryDataSet((String)"BOMNestingCheckServiceImpl1", (String)"bd_material", (String)"id,masterid material.masterid,number entry.entrymaterialid.number", (QFilter[])new QFilter[]{new QFilter("id", "in", longs)}, null);
        DataSet material = material2.leftJoin(material1).on("material", "id").select(material2.getRowMeta().getFieldNames(), material1.getRowMeta().getFieldNames()).finish();
        HashSet<BomBeanUtil> mainMaterials = this.getMaterials(material, true);
        HashSet<BomBeanUtil> entryMaterials = this.getMaterials(material, false);
        HashSet<BomBeanUtil> materials = new HashSet<BomBeanUtil>();
        HashSet<BomBeanUtil> zeroMaterials = new HashSet<BomBeanUtil>();
        HashSet<BomBeanUtil> oneMaterials = new HashSet<BomBeanUtil>();
        materials.addAll(mainMaterials);
        materials.addAll(entryMaterials);
        for (BomBeanUtil mainMaterial : mainMaterials) {
            boolean flag = false;
            for (BomBeanUtil entryMaterial : entryMaterials) {
                if (!mainMaterial.compare((Object)entryMaterial)) continue;
                flag = true;
            }
            if (flag) continue;
            zeroMaterials.add(mainMaterial);
            this.isReplaceMaterial(mainMaterial, materials, null);
        }
        HashSet<BomBeanUtil> nestingMaterials = this.getNestingMaterials(materials, zeroMaterials, oneMaterials, material, 0, true);
        return this.buildNestingRelation(nestingMaterials);
    }

    private HashSet<BomBeanUtil> getNestingMaterials(HashSet<BomBeanUtil> allMaterials, HashSet<BomBeanUtil> thisMaterials, HashSet<BomBeanUtil> nextMaterials, DataSet material, int flag, Boolean flags) {
        DataSet copy = material.copy();
        HashMap<String, List<BomBeanUtil>> boms = this.getBom(copy);
        for (BomBeanUtil zeroMat : thisMaterials) {
            String zeroMaterial = zeroMat.getMaterial() + zeroMat.getConfiguredcode() + zeroMat.getVersion() + zeroMat.getReplaceno() + zeroMat.getAuxproperty();
            List<BomBeanUtil> entryM = boms.get(zeroMaterial);
            if (entryM == null) continue;
            nextMaterials.addAll(entryM);
        }
        DataSet copy1 = material.copy();
        HashMap<String, Set<String>> toolMap = this.getToolMap(copy1);
        HashSet<BomBeanUtil> removeSet = new HashSet<BomBeanUtil>();
        ArrayList<String> compareList = new ArrayList<String>();
        for (BomBeanUtil thisMat : thisMaterials) {
            String zeroMat = thisMat.getMaterial() + thisMat.getConfiguredcode() + thisMat.getVersion() + thisMat.getReplaceno() + thisMat.getAuxproperty();
            compareList.add(zeroMat);
        }
        for (BomBeanUtil nextMat : nextMaterials) {
            String nextEntrMat = nextMat.getEntrymaterialid() + nextMat.getEntryconfiguredcode() + nextMat.getEntryversion() + nextMat.getEntryreplaceno() + nextMat.getEntryauxproperty();
            for (Map.Entry<String, Set<String>> tool : toolMap.entrySet()) {
                if (!nextEntrMat.equalsIgnoreCase(tool.getKey())) continue;
                Set<String> toolMatIdSets = tool.getValue();
                for (String toolMatId : toolMatIdSets) {
                    if (compareList.contains(toolMatId)) continue;
                    this.isReplaceMaterial(nextMat, nextMaterials, removeSet);
                }
            }
        }
        nextMaterials.removeAll(removeSet);
        thisMaterials.clear();
        thisMaterials.addAll(nextMaterials);
        for (BomBeanUtil nextMaterial : nextMaterials) {
            this.isReplaceMaterial(nextMaterial, allMaterials, null);
            if (allMaterials.size() != 0) continue;
            return allMaterials;
        }
        nextMaterials.clear();
        if (flag != allMaterials.size()) {
            this.getNestingMaterials(allMaterials, thisMaterials, nextMaterials, material, allMaterials.size(), flags);
        }
        return allMaterials;
    }

    private HashSet<BomBeanUtil> getMaterials(DataSet material, boolean flag) {
        DataSet copy = material.copy();
        DataSet copy1 = material.copy();
        if (flag) {
            HashSet<BomBeanUtil> mainProMaterials = new HashSet<BomBeanUtil>();
            for (Row mat : copy1) {
                BomBeanUtil mainProMaterial = new BomBeanUtil();
                mainProMaterial.setMaterial(mat.getString("material"));
                mainProMaterial.setMaterial_id(mat.getString("material.masterid"));
                mainProMaterial.setConfiguredcode(mat.getString("configuredcode"));
                mainProMaterial.setVersion(mat.getString("version"));
                mainProMaterial.setReplaceno(mat.getString("replaceno"));
                mainProMaterial.setAuxproperty(mat.getString("auxproperty"));
                mainProMaterial.setEntrymaterialid(mat.getString("material"));
                mainProMaterial.setEntrymaterialid_id(mat.getString("material.masterid"));
                mainProMaterial.setEntryconfiguredcode(mat.getString("configuredcode"));
                mainProMaterial.setEntryversion(mat.getString("version"));
                mainProMaterial.setEntryreplaceno(mat.getString("replaceno"));
                mainProMaterial.setEntryauxproperty(mat.getString("auxproperty"));
                if (mainProMaterials.size() != 0) {
                    if (mainProMaterials.contains(mainProMaterial)) continue;
                    mainProMaterials.add(mainProMaterial);
                    continue;
                }
                mainProMaterials.add(mainProMaterial);
            }
            return mainProMaterials;
        }
        HashSet<BomBeanUtil> entryMaterials = new HashSet<BomBeanUtil>();
        for (Row mat : copy) {
            BomBeanUtil entryMaterial = new BomBeanUtil();
            entryMaterial.setEntrymaterialid(mat.getString("entry.entrymaterial"));
            entryMaterial.setEntrymaterialid_id(mat.getString("entry.entrymaterialid"));
            entryMaterial.setEntryconfiguredcode(mat.getString("entry.entryconfiguredcode"));
            entryMaterial.setEntryversion(mat.getString("entry.entryversion"));
            entryMaterial.setEntryreplaceno(mat.getString("replaceno"));
            entryMaterial.setEntryauxproperty(mat.getString("entry.entryauxproperty"));
            entryMaterial.setMaterial(mat.getString("entry.entrymaterial"));
            entryMaterial.setMaterial_id(mat.getString("entry.entrymaterialid"));
            entryMaterial.setConfiguredcode(mat.getString("entry.entryconfiguredcode"));
            entryMaterial.setVersion(mat.getString("entry.entryversion"));
            entryMaterial.setReplaceno(mat.getString("replaceno"));
            entryMaterial.setAuxproperty(mat.getString("entry.entryauxproperty"));
            if (entryMaterials.size() != 0) {
                if (entryMaterials.contains(entryMaterial)) continue;
                entryMaterials.add(entryMaterial);
                continue;
            }
            entryMaterials.add(entryMaterial);
        }
        return entryMaterials;
    }

    private HashMap<String, List<BomBeanUtil>> getBom(DataSet material) {
        HashMap<String, List<BomBeanUtil>> stringListMap = new HashMap<String, List<BomBeanUtil>>();
        for (Row mat : material) {
            BomBeanUtil bom = new BomBeanUtil();
            bom.setEntrymaterialid(mat.getString("entry.entrymaterial"));
            bom.setEntrymaterialid_id(mat.getString("entry.entrymaterialid"));
            bom.setEntryconfiguredcode(mat.getString("entry.entryconfiguredcode"));
            bom.setEntryversion(mat.getString("entry.entryversion"));
            bom.setEntryreplaceno(mat.getString("replaceno"));
            bom.setEntryauxproperty(mat.getString("entry.entryauxproperty"));
            bom.setMaterial(mat.getString("entry.entrymaterial"));
            bom.setMaterial_id(mat.getString("entry.entrymaterialid"));
            bom.setConfiguredcode(mat.getString("entry.entryconfiguredcode"));
            bom.setVersion(mat.getString("entry.entryversion"));
            bom.setReplaceno(mat.getString("replaceno"));
            bom.setAuxproperty(mat.getString("entry.entryauxproperty"));
            Set<String> keys = stringListMap.keySet();
            String materialKey = mat.getString("material") + mat.getString("configuredcode") + mat.getString("version") + mat.getString("replaceno") + mat.getString("auxproperty");
            if (keys.contains(materialKey)) {
                List<BomBeanUtil> entryList = stringListMap.get(materialKey);
                entryList.add(bom);
                stringListMap.put(materialKey, entryList);
                continue;
            }
            ArrayList<BomBeanUtil> entry = new ArrayList<BomBeanUtil>();
            entry.add(bom);
            stringListMap.put(materialKey, entry);
        }
        return stringListMap;
    }

    private HashMap<String, Set<String>> getToolMap(DataSet material) {
        HashMap<String, Set<String>> stringMap = new HashMap<String, Set<String>>();
        for (Row mat : material) {
            String key = mat.getString("entry.entrymaterial") + mat.getString("entry.entryconfiguredcode") + mat.getString("entry.entryversion") + mat.getString("replaceno") + mat.getString("entry.entryauxproperty");
            String value = mat.getString("material") + mat.getString("configuredcode") + mat.getString("version") + mat.getString("replaceno") + mat.getString("auxproperty");
            Set valueSet = stringMap.getOrDefault(key, new HashSet(16));
            valueSet.add(value);
            stringMap.put(key, valueSet);
        }
        return stringMap;
    }

    private ArrayList<List> buildNestingRelation(HashSet<BomBeanUtil> materials) {
        JSONArray boms = new JSONArray();
        HashSet<Long> materialSet = new HashSet<Long>();
        for (BomBeanUtil bomBeanUtil : materials) {
            String material = bomBeanUtil.getMaterial();
            materialSet.add(Long.valueOf(material));
        }
        QFilter qFilter = new QFilter("material", "in", materialSet);
        QFilter qFilter2 = new QFilter("entry.entrymaterial", "in", materialSet);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"pdm_mftbom", (String)"id,number,material.masterid as materialid,materialid.name as materialname,entry.entrymaterial.masterid as  entrymaterialid,entry.entrymaterialid.name as entrymaterialname,entry.entryreplaceplan as entryreplaceplan", (QFilter[])new QFilter[]{qFilter.or(qFilter2)}, null);){
            for (Row row : dataSet) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)row.getLong("id"));
                jsonObject.put("number", (Object)row.getString("number"));
                jsonObject.put("materialid", (Object)row.getString("materialid"));
                jsonObject.put("materialname", (Object)row.getString("materialname"));
                jsonObject.put("entrymaterialid", (Object)row.getString("entrymaterialid"));
                jsonObject.put("entrymaterialname", (Object)row.getString("entrymaterialname"));
                jsonObject.put("entryreplaceplan", (Object)row.getLong("entryreplaceplan"));
                if (row.getLong("id") == null || row.getLong("id") == 0L || "0".equals(row.getString("number")) || "0".equals(row.getString("materialid")) || "0".equals(row.getString("entrymaterialid"))) continue;
                boms.add((Object)jsonObject);
            }
        }
        logger.warn("BOMintoMsplan\uff1a" + boms.toJSONString());
        Object o = DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMRPBOMCheckService", (String)"bomCyclicCheck", (Object[])new Object[]{boms.toJSONString()});
        logger.warn("BOMOutFromMsplan" + o.toString());
        JSONObject jsonObject = JSONArray.parseObject((String)o.toString());
        ArrayList<List> nestingBomList = new ArrayList<List>();
        JSONArray dataArray = (JSONArray)jsonObject.get((Object)"data");
        for (int i = 0; i < dataArray.size(); ++i) {
            JSONObject o1 = (JSONObject)dataArray.get(i);
            JSONArray jsonBoms = (JSONArray)o1.get((Object)"boms");
            ArrayList nestingBomListTemp = new ArrayList();
            for (int j = 0; j < jsonBoms.size(); ++j) {
                JSONObject o2 = (JSONObject)jsonBoms.get(j);
                HashMap<String, Object> bomMap = new HashMap<String, Object>();
                bomMap.put("id", o2.get((Object)"id"));
                bomMap.put("number", o2.get((Object)"number"));
                bomMap.put("materialname", o2.get((Object)"materialname"));
                bomMap.put("entrymaterialname", o2.get((Object)"entrymaterialname"));
                bomMap.put("entryreplaceplan", o2.get((Object)"entryreplaceplan"));
                nestingBomListTemp.add(bomMap);
            }
            nestingBomList.add(nestingBomListTemp);
        }
        logger.warn("return" + nestingBomList);
        return nestingBomList;
    }

    private void isReplaceMaterial(BomBeanUtil material, HashSet<BomBeanUtil> allMaterials, HashSet<BomBeanUtil> removeSet) {
        ArrayList<Long> haveReplaceList = new ArrayList<Long>();
        Long preMaterial = Long.valueOf(material.getMaterial());
        QFilter qFilter = new QFilter("mainmaterentry.material", "=", (Object)preMaterial);
        QFilter qFilter1 = new QFilter("repmaterentry.repmaterial", "=", (Object)preMaterial);
        DynamicObjectCollection replacePlan = QueryServiceHelper.query((String)"mpdm_replaceplan", (String)"mainmaterentry.material,repmaterentry.repmaterial", (QFilter[])new QFilter[]{qFilter.or(qFilter1)});
        if (!replacePlan.isEmpty()) {
            for (DynamicObject repMaterial : replacePlan) {
                if (repMaterial.getLong("mainmaterentry.material") == preMaterial.longValue()) {
                    haveReplaceList.add(repMaterial.getLong("repmaterentry.repmaterial"));
                    continue;
                }
                haveReplaceList.add(repMaterial.getLong("mainmaterentry.material"));
                haveReplaceList.add(repMaterial.getLong("repmaterentry.repmaterial"));
            }
            DynamicObjectCollection haveRepMatTree = QueryServiceHelper.query((String)"pdm_mftbom", (String)"id, entry.entrymaterial", (QFilter[])new QFilter[]{new QFilter("material", "in", haveReplaceList)});
            HashSet<String> numberSet = new HashSet<String>(16);
            while (!haveRepMatTree.isEmpty()) {
                ArrayList<Long> replaceList = new ArrayList<Long>(haveRepMatTree.size());
                ArrayList<Long> compareList = new ArrayList<Long>(haveRepMatTree.size());
                for (DynamicObject a : haveRepMatTree) {
                    compareList.add(a.getLong("entry.entrymaterial"));
                }
                QFilter qFilter4 = new QFilter("mainmaterentry.material", "in", compareList);
                QFilter qFilter5 = new QFilter("repmaterentry.repmaterial", "in", compareList);
                DynamicObjectCollection isReplace = QueryServiceHelper.query((String)"mpdm_replaceplan", (String)"mainmaterentry.material,repmaterentry.repmaterial", (QFilter[])new QFilter[]{qFilter4.or(qFilter5)});
                if (!isReplace.isEmpty()) {
                    for (Long compareMat : compareList) {
                        for (DynamicObject replaceMat : isReplace) {
                            if (replaceMat.getLong("mainmaterentry.material") == compareMat.longValue()) {
                                haveReplaceList.add(replaceMat.getLong("mainmaterentry.material"));
                                haveReplaceList.add(replaceMat.getLong("repmaterentry.repmaterial"));
                                continue;
                            }
                            if (replaceMat.getLong("repmaterentry.repmaterial") != compareMat.longValue()) continue;
                            haveReplaceList.add(replaceMat.getLong("repmaterentry.repmaterial"));
                            haveReplaceList.add(replaceMat.getLong("mainmaterentry.material"));
                        }
                    }
                }
                for (DynamicObject dynamicObj : haveRepMatTree) {
                    if (dynamicObj.getLong("entry.entrymaterial") == preMaterial.longValue()) {
                        allMaterials.add(material);
                        return;
                    }
                    if (haveReplaceList.contains(dynamicObj.getLong("entry.entrymaterial"))) {
                        allMaterials.add(material);
                        return;
                    }
                    StringBuilder key = new StringBuilder(dynamicObj.getString("id"));
                    key.append('-').append(dynamicObj.getString("entry.entrymaterial"));
                    if (numberSet.contains(key.toString())) {
                        if (removeSet == null) {
                            allMaterials.remove(material);
                        } else {
                            removeSet.add(material);
                        }
                    }
                    numberSet.add(key.toString());
                    replaceList.add(dynamicObj.getLong("entry.entrymaterial"));
                }
                haveRepMatTree = QueryServiceHelper.query((String)"pdm_mftbom", (String)"id, entry.entrymaterial", (QFilter[])new QFilter[]{new QFilter("material", "in", replaceList)});
            }
        }
        if (removeSet == null) {
            allMaterials.remove(material);
        } else {
            removeSet.add(material);
        }
    }
}

