/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.mservice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.fmm.mservice.api.IndependentWokerService;

public class IndependentWokerServiceImpl
implements IndependentWokerService {
    public JSONObject getInformation(JSONArray jsonArray) {
        String errorcode;
        String msg;
        String isSuccess;
        JSONObject result = new JSONObject();
        JSONArray jsonArr = new JSONArray();
        if (jsonArray.isEmpty()) {
            isSuccess = "false";
            msg = ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u4f20\u5165\u6b63\u786e\u53c2\u6570\u3002", (String)"IndependentWokerServiceImpl_0", (String)"mmc-fmm-mservice", (Object[])new Object[0]);
            errorcode = "9999";
        } else if (!this.isValidate(jsonArray).booleanValue()) {
            isSuccess = "false";
            msg = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4f20\u5165\u7684JSONObject\u5bf9\u8c61\u683c\u5f0f\u662f\u5426\u7b26\u5408\u8981\u6c42\u3002", (String)"IndependentWokerServiceImpl_1", (String)"mmc-fmm-mservice", (Object[])new Object[0]);
            errorcode = "9999";
        } else {
            isSuccess = "true";
            msg = ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u6210\u529f\u3002", (String)"IndependentWokerServiceImpl_2", (String)"mmc-fmm-mservice", (Object[])new Object[0]);
            errorcode = "0000";
            jsonArr = this.getInform(jsonArray);
        }
        result.put("successful", (Object)isSuccess);
        result.put("message", (Object)msg);
        result.put("errorcode", (Object)errorcode);
        result.put("data", (Object)jsonArr);
        return result;
    }

    private Boolean isValidate(JSONArray jsonArray) {
        Boolean flag = Boolean.TRUE;
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Set keySet = jsonObject.keySet();
            if (keySet.contains("userid") && keySet.contains("industryid") && keySet.contains("authorizemodelid") && keySet.contains("uniqueid")) continue;
            flag = Boolean.FALSE;
            break;
        }
        return flag;
    }

    private JSONArray getInform(JSONArray jsonArray) {
        HashSet<Long> userIdSet = new HashSet<Long>(16);
        HashSet<Long> industryIdSet = new HashSet<Long>(16);
        HashSet<Long> modelIdSet = new HashSet<Long>(16);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Long userId = jsonObject.getLong("userid");
            Long industryId = jsonObject.getLong("industryid");
            Long authorizeModelId = jsonObject.getLong("authorizemodelid");
            userIdSet.add(userId);
            industryIdSet.add(industryId);
            jsonObject.put("id", (Object)(userId + "" + industryId + authorizeModelId));
        }
        DynamicObjectCollection collection = this.queryByFilter(userIdSet, industryIdSet, modelIdSet);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObj = jsonArray.getJSONObject(i);
            jsonObj.put("result", (Object)Boolean.FALSE);
            for (DynamicObject dynObj : collection) {
                Long userId = dynObj.getLong("userid");
                Long industryId = dynObj.getLong("entryentity.industry");
                Long authorizemodelId = dynObj.getLong("entryentity.authorizemodel");
                String uniqueStr = userId + "" + industryId + authorizemodelId;
                if (!StringUtils.equals((CharSequence)uniqueStr, (CharSequence)jsonObj.getString("id")) || authorizemodelId == 0L && !modelIdSet.contains(jsonObj.getLong("authorizemodelid"))) continue;
                jsonObj.put("result", (Object)Boolean.TRUE);
            }
            jsonObj.remove((Object)"id");
            jsonObj.remove((Object)"authorizemodelid");
            jsonObj.remove((Object)"userid");
            jsonObj.remove((Object)"industryid");
        }
        return jsonArray;
    }

    private DynamicObjectCollection queryByFilter(Set<Long> userIdSet, Set<Long> industryIdSet, Set<Long> modelIdSet) {
        HashSet<Long> modelGroupIdSet = new HashSet<Long>(16);
        QFilter[] qFilters = new QFilter[]{new QFilter("userid", "in", userIdSet), new QFilter("entryentity.industry", "in", industryIdSet), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")};
        String selectFields = "id,userid,entryentity.industry,entryentity.authorizemodel,entryentity.modelgroup";
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"fmm_independentwoker", (String)selectFields, (QFilter[])qFilters);
        List collect = collection.stream().filter(x -> x.getLong("entryentity.modelgroup") != 0L).collect(Collectors.toList());
        for (DynamicObject dyn : collect) {
            Long modelGroupId = dyn.getLong("entryentity.modelgroup");
            modelGroupIdSet.add(modelGroupId);
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", modelGroupIdSet), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")};
        DynamicObjectCollection modelGroupCollection = QueryServiceHelper.query((String)"mpdm_modelgroup", (String)"id,entryentity.modeltype", (QFilter[])filters);
        for (DynamicObject dyn : modelGroupCollection) {
            modelIdSet.add(dyn.getLong("entryentity.modeltype"));
        }
        return collection;
    }
}

