/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.mservice;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.fmm.mservice.api.MbpRatioService;

public class MbpRatioServiceImpl
implements MbpRatioService {
    public BigDecimal getMbpRatio(Long departmentId, Long positionId, BigDecimal timeLimit) {
        DynamicObject[] mbpRatioCollection;
        QFilter[] qFilters = new QFilter[]{new QFilter("department", "=", (Object)departmentId), new QFilter("position", "=", (Object)positionId)};
        String selectFields = "department,position,mbpschema,fixedvalue,mbpratio";
        for (DynamicObject dynObj : mbpRatioCollection = BusinessDataServiceHelper.load((String)"fmm_mbpratio", (String)selectFields, (QFilter[])qFilters, null)) {
            if (dynObj == null) continue;
            boolean isFixedValue = dynObj.getBoolean("fixedvalue");
            if (isFixedValue) {
                return dynObj.getBigDecimal("mbpratio");
            }
            DynamicObject mbpSchema = dynObj.getDynamicObject("mbpschema");
            String timeLimitUnit = mbpSchema.getString("timelimitunit");
            if ("M".equals(timeLimitUnit)) {
                timeLimit = timeLimit.multiply(new BigDecimal(12));
            }
            DynamicObjectCollection entryCollection = mbpSchema.getDynamicObjectCollection("entryentity");
            for (DynamicObject dyn : entryCollection) {
                BigDecimal timelim;
                if (dyn == null || timeLimit.compareTo(timelim = dyn.getBigDecimal("timelimit")) > 0) continue;
                return dyn.getBigDecimal("mbpratio");
            }
        }
        return null;
    }
}

