/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.mservice;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.mmc.fmm.mservice.api.ProjectUpdateStateService;

public class ProjectUpdateStateServiceImpl
implements ProjectUpdateStateService {
    private String schedule_num = "fmm_project_projectstateupdateTask";
    private String job_num = "fmm_project_projectstateupdate_SKDJ_";
    private String taskdefine_num = "ProjectStateUpdateTask";
    private String class_name = "kd.pmc.pmpd.business.project.task.ProjectStateUpdateTask";
    SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private int projectMax = 5;

    public void updateProjectStateCreateTask(Object obj) {
        Date now = new Date();
        Map para = (Map)obj;
        Set projectIds = (Set)para.get("projectIds");
        String day = (String)para.get("day");
        String stateNumber = (String)para.get("stateNumber");
        if (!projectIds.isEmpty()) {
            int size = projectIds.size() / this.projectMax + 1;
            for (int i = 0; i < size; ++i) {
                int num = 0;
                HashSet projectSet = new HashSet(5);
                Iterator ids = projectIds.iterator();
                while (ids.hasNext()) {
                    projectSet.add(ids.next());
                    ids.remove();
                    if (num == this.projectMax) break;
                    ++num;
                }
                this.createScheduleJob(Integer.parseInt(day), stateNumber, SerializationUtils.toJsonString(projectSet), now, i);
            }
        }
    }

    private void createScheduleJob(int day, String stateNumber, String projectId, Date now, int size) {
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        JobInfo jobInfo = new JobInfo();
        jobInfo.setNumber(this.job_num + size + "_" + this.sf.format(now));
        jobInfo.setName(this.taskdefine_num + this.sf.format(now));
        jobInfo.setJobType(JobType.BIZ);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("stateNumber", stateNumber);
        params.put("projectId", projectId);
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setParams(params);
        jobInfo.setAppId("fmm");
        jobInfo.setTaskClassname(this.class_name);
        jobInfo.setEnable(true);
        jobInfo.setRunByUserId(0L);
        String jobId = proxy.createJob(jobInfo);
        this.createPlanJob(day, projectId, now, jobId, proxy);
    }

    private void createPlanJob(int day, String projectId, Date now, String jobId, JobDispatcherProxy proxy) {
        PlanInfo planInfo = new PlanInfo();
        planInfo.setJobId(jobId);
        planInfo.setName(this.taskdefine_num + this.sf.format(now));
        planInfo.setNumber(this.schedule_num + this.sf.format(now));
        Calendar startTime = Calendar.getInstance();
        startTime.setTime(new Date(now.getTime() + 60000L));
        startTime.add(5, day);
        planInfo.setStartTime(startTime);
        Calendar endTime = Calendar.getInstance();
        endTime.setTime(new Date(now.getTime() + 300000L));
        endTime.add(5, day);
        planInfo.setEndTime(endTime);
        planInfo.setRepeatMode(RepeatModeEnum.NONE);
        planInfo.setEnable(true);
        proxy.createPlan(planInfo);
    }
}

