/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.mservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;

public class SyncSysWbsServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(SyncSysWbsServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, final String dbKey, String sqlFileName) {
        ThreadPools.executeOnce((String)"SyncSysWbsServiceImpl", (Runnable)new Runnable(){

            @Override
            public void run() {
                ArrayList<DynamicObject> pmtsDynList = new ArrayList<DynamicObject>();
                try (TXHandle h1 = TX.requiresNew();){
                    try {
                        logger.info("\u5f00\u59cb\u5904\u7406\u540c\u6b65\u7cfb\u7edf\u4e91wbs...");
                        long startTime = System.currentTimeMillis();
                        QFilter filter = new QFilter("version.id", "is null", null);
                        filter.or("version.id", "=", (Object)0L);
                        List pmtsIdList = QueryServiceHelper.queryPrimaryKeys((String)"pmts_wbs", (QFilter[])new QFilter[]{filter}, null, (int)-1);
                        List bdIdList = QueryServiceHelper.queryPrimaryKeys((String)"bd_wbs", (QFilter[])new QFilter[]{new QFilter("id", "!=", (Object)0L)}, null, (int)-1);
                        pmtsIdList.removeAll(bdIdList);
                        if (!CollectionUtils.isEmpty((Collection)pmtsIdList)) {
                            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])pmtsIdList.toArray(new Long[pmtsIdList.size()]), (String)"pmts_wbs");
                            ArrayList<DynamicObject> saveDynList = new ArrayList<DynamicObject>(dynamicObjectMap.size());
                            for (DynamicObject dataEntity : dynamicObjectMap.values()) {
                                DynamicObject bdWbsDyn = BusinessDataServiceHelper.newDynamicObject((String)"bd_wbs");
                                bdWbsDyn.set("id", (Object)dataEntity.getLong("id"));
                                bdWbsDyn.set("masterid", (Object)dataEntity.getLong("masterid"));
                                bdWbsDyn.set("createorg", dataEntity.get("createorg"));
                                bdWbsDyn.set("useorg", dataEntity.get("useorg"));
                                bdWbsDyn.set("org", dataEntity.get("org"));
                                bdWbsDyn.set("ctrlstrategy", (Object)Character.valueOf('5'));
                                bdWbsDyn.set("datasource", (Object)Character.valueOf('2'));
                                bdWbsDyn.set("status", dataEntity.get("status"));
                                bdWbsDyn.set("enable", dataEntity.get("enable"));
                                bdWbsDyn.set("number", dataEntity.get("number"));
                                bdWbsDyn.set("name", dataEntity.get("name"));
                                bdWbsDyn.set("project", (Object)dataEntity.getLong("projectnum.id"));
                                bdWbsDyn.set("parent", (Object)dataEntity.getLong("parent.id"));
                                bdWbsDyn.set("businessstate", dataEntity.get("businessstate"));
                                bdWbsDyn.set("ischeck", dataEntity.get("costobj"));
                                bdWbsDyn.set("creator", dataEntity.get("creator"));
                                bdWbsDyn.set("modifier", dataEntity.get("modifier"));
                                bdWbsDyn.set("createtime", dataEntity.get("createtime"));
                                bdWbsDyn.set("modifytime", dataEntity.get("modifytime"));
                                bdWbsDyn.set("longnumber", dataEntity.get("longnumber"));
                                bdWbsDyn.set("fullname", dataEntity.get("fullname"));
                                bdWbsDyn.set("isleaf", dataEntity.get("isleaf"));
                                bdWbsDyn.set("level", dataEntity.get("level"));
                                saveDynList.add(bdWbsDyn);
                                pmtsDynList.add(dataEntity);
                            }
                            if (!CollectionUtils.isEmpty(saveDynList)) {
                                SaveServiceHelper.save((DynamicObject[])saveDynList.toArray(new DynamicObject[saveDynList.size()]));
                                BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject[])saveDynList.toArray(new DynamicObject[saveDynList.size()]));
                            }
                        }
                        long endTime = System.currentTimeMillis();
                        logger.info("\u540c\u6b65\u7cfb\u7edf\u4e91wbs\u603b\u8017\u65f6\uff1a" + (endTime - startTime) + "\u6beb\u79d2");
                    }
                    catch (Exception e) {
                        logger.error("\u540c\u6b65\u7cfb\u7edf\u4e91wbs\u5931\u8d25\uff1a", (Throwable)e);
                        pmtsDynList.clear();
                        h1.markRollback();
                    }
                }
                if (!CollectionUtils.isEmpty(pmtsDynList)) {
                    for (DynamicObject dynamicObject : pmtsDynList) {
                        SqlBuilder sqlb = new SqlBuilder();
                        sqlb.append("update t_pmts_wbs set ", new Object[0]).append("fsyswbsid = ?", new Object[]{dynamicObject.get("id")}).append(" , fsyncsucess = ?", new Object[]{"1"}).append("where fid = ?", new Object[]{dynamicObject.get("id")});
                        DB.execute((DBRoute)DBRoute.of((String)dbKey), (SqlBuilder)sqlb);
                    }
                }
            }
        });
        return new UpgradeResult();
    }
}

