/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.mservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;

public class UpdateBOMReplaceGroupDataServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(UpdateBOMReplaceGroupDataServiceImpl.class);
    public static final DBRoute scmDBRoute = new DBRoute("scm");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        ThreadPools.executeOnce((String)"UpdateBOMReplaceGroupDataServiceImpl", (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try (TXHandle h1 = TX.requiresNew();){
                    UpgradeResult result = new UpgradeResult();
                    try {
                        result = UpdateBOMReplaceGroupDataServiceImpl.this.exec();
                    }
                    finally {
                        if (!result.isSuccess()) {
                            h1.markRollback();
                        }
                    }
                }
            }
        });
        return new UpgradeResult();
    }

    public boolean isExistsTable(DBRoute dbRoute, String tableName) {
        return DB.exitsTable((DBRoute)scmDBRoute, (String)tableName);
    }

    private String genReplaceGroupNo(Long entryId, int seq) {
        return "init_" + entryId + "_" + seq;
    }

    public UpgradeResult exec() {
        logger.info("begin exec UpdateBOMReplaceGroupDataServiceImpl data ...");
        long startTime = System.currentTimeMillis();
        int count = this.execSql();
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        long endTime = System.currentTimeMillis();
        logger.info("\u603b\u8017\u65f6\uff1a" + (endTime - startTime) + "\u6beb\u79d2\uff1b");
        result.setLog(String.format(ResManager.loadKDString((String)"\u5171\u6267\u884c\u4e86\u201c%1$s\u201d\u6761BOM\u6570\u636e", (String)"UpdateBOMReplaceGroupDataServiceImpl_01", (String)"mmc-fmm-mservice", (Object[])new Object[0]), count));
        return result;
    }

    public int execSql() {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(128);
        if (this.isExistsTable(scmDBRoute, "T_MPDM_REPLACEPLAN")) {
            HashMap<String, String> groupMap = new HashMap<String, String>(64);
            HashSet<String> execIdSet = new HashSet<String>(64);
            String updateSql = " update t_pdm_mftbomentry set fentryreplacegroup = ? where fentryid = ? ";
            StringBuilder sb = new StringBuilder();
            sb.append(" select d.fentryid,d.freplaceplanid ,d.fentryreplacegroup ,d.fentrymatid ,d.fauxpropertyid ,d.fversionid,h.fid,d.fseq ");
            sb.append(" from t_pdm_mftbom h ");
            sb.append(" inner join t_pdm_mftbomentry d on h.fid = d.fid  ");
            sb.append(" where d.freplaceplanid > 0 ");
            sb.append(" and (d.fentryreplacegroup = ' ' or d.fentryreplacegroup = '' or d.fentryreplacegroup is null) ");
            sb.append(" order by h.fid,d.fseq ");
            try (DataSet ds = DB.queryDataSet((String)UpdateBOMReplaceGroupDataServiceImpl.class.getName(), (DBRoute)scmDBRoute, (String)sb.toString());){
                while (ds.hasNext()) {
                    String rowKeys;
                    Row arow = ds.next();
                    long entryId = arow.getLong("fentryid");
                    long freplaceplanid = arow.getLong("freplaceplanid");
                    long fentrymatid = arow.getLong("fentrymatid");
                    long fauxpropertyid = arow.getLong("fauxpropertyid");
                    long fversionid = arow.getLong("fversionid");
                    long fid = arow.getLong("fid");
                    int seq = arow.getInteger("fseq");
                    String groupKeys = fid + "_" + freplaceplanid;
                    String newGroupno = (String)groupMap.get(groupKeys);
                    if (StringUtils.isEmpty((String)newGroupno)) {
                        newGroupno = this.genReplaceGroupNo(entryId, seq);
                        groupMap.put(groupKeys, newGroupno);
                    }
                    if (!execIdSet.add(rowKeys = groupKeys + "_" + fentrymatid + "_" + fversionid + "_" + fauxpropertyid)) {
                        newGroupno = this.genReplaceGroupNo(entryId, seq);
                        groupMap.put(groupKeys, newGroupno);
                    }
                    paramList.add(new Object[]{newGroupno, entryId});
                }
            }
            if (!paramList.isEmpty()) {
                DB.executeBatch((DBRoute)scmDBRoute, (String)updateSql, paramList);
            }
        }
        return paramList.size();
    }
}

