/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.mservice;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class UpdateRouteOldVersionParamServiceImpl
implements IUpgradeService {
    public static final DBRoute scmRoute = new DBRoute("scm");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        ArrayList<Object[]> paramHeadList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> paramLanList = new ArrayList<Object[]>(16);
        StringBuilder sql = new StringBuilder();
        sql.append(" select distinct fcreateorgid from T_PDM_ROUTE  where FVERSIONID > 0 ");
        try (DataSet ds = DB.queryDataSet((String)UpdateRouteOldVersionParamServiceImpl.class.getName(), (DBRoute)scmRoute, (String)sql.toString());){
            for (Row arow : ds) {
                Long orgId = arow.getLong("fcreateorgid");
                String initNumber = "IsExistsHisRtData_" + String.valueOf(orgId);
                Long initId = this.queryExistsInitData(initNumber);
                if (initId != null && !initId.equals(0L)) continue;
                initId = this.getPkId("t_pdm_rtversion_init");
                paramHeadList.add(new Object[]{initId, initNumber, initNumber, new Date(), initId});
                paramLanList.add(new Object[]{this.getLanTableId("t_pdm_rtversion_init_l"), initId, "zh_CN", initNumber});
            }
        }
        if (!paramLanList.isEmpty()) {
            DB.executeBatch((DBRoute)scmRoute, (String)this.buildSetLanInsertSql(), paramLanList);
        }
        if (!paramHeadList.isEmpty()) {
            DB.executeBatch((DBRoute)scmRoute, (String)this.buildInsertSql(), paramHeadList);
        }
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private Long queryExistsInitData(String initNumber) {
        StringBuilder sqlA = new StringBuilder();
        Long initId = 0L;
        sqlA.append(" select fid from T_PDM_RTVERSION_INIT  where fnumber = ? ");
        try (DataSet dsA = DB.queryDataSet((String)(UpdateRouteOldVersionParamServiceImpl.class.getName() + "_2"), (DBRoute)scmRoute, (String)sqlA.toString(), (Object[])new Object[]{initNumber});){
            for (Row arowA : dsA) {
                initId = arowA.getLong("fid");
            }
        }
        return initId;
    }

    private Long getPkId(String tableName) {
        return DB.genLongId((String)tableName);
    }

    private String getLanTableId(String tableName) {
        return DB.genStringId((String)tableName);
    }

    public String buildInsertSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into t_pdm_rtversion_init(fid,fnumber,fname,fstatus,fcreatorid,fenable,fcreatetime,fmasterid,fvalue)");
        sql.append(" values(?,?,?,'C',1,'1',?,?,'true')");
        return sql.toString();
    }

    public String buildSetLanInsertSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into t_pdm_rtversion_init_l(fpkid,fid,flocaleid,fname)");
        sql.append(" values(?,?,?,?)");
        return sql.toString();
    }
}

