/*
 * Decompiled with CFR 0.152.
 */
package kd.industry.opplugin.validator;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ProcessPlanlibSaveValidator
extends AbstractValidator {
    public void validate() {
        String operate = this.getOperateKey();
        ExtendedDataEntity[] objs = this.getDataEntities();
        if (objs == null || objs.length <= 0) {
            return;
        }
        if ("save".equalsIgnoreCase(operate) || "submit".equalsIgnoreCase(operate)) {
            for (ExtendedDataEntity obj : objs) {
                this.bizValidator(obj);
            }
        }
    }

    private void bizValidator(ExtendedDataEntity obj) {
        Document document;
        DynamicObject businessPlan = obj.getDataEntity();
        if (businessPlan == null) {
            return;
        }
        String cellsData = businessPlan.getString("nodedata_tag");
        if (StringUtils.isBlank((CharSequence)cellsData)) {
            this.addErrorMessage(obj, ResManager.loadKDString((String)"\u8282\u70b9\u4e3a\u7a7a\uff0c\u8bf7\u65b0\u589e\u81f3\u5c11\u4e00\u4e2a\u8282\u70b9\u3002", (String)"ProcessPlanlibSaveValidator_0", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
            return;
        }
        String rootXml = businessPlan.getString("xml_tag");
        if (StringUtils.isBlank((CharSequence)rootXml)) {
            this.addErrorMessage(obj, ResManager.loadKDString((String)"\u753b\u677f\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u5148\u4fdd\u5b58\u753b\u677f\u4fe1\u606f\u3002", (String)"ProcessPlanlibSaveValidator_1", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
            return;
        }
        Map cellsDataMap = (Map)JSON.parse((String)cellsData);
        try {
            document = DocumentHelper.parseText((String)rootXml);
        }
        catch (DocumentException e1) {
            throw new KDBizException(e1.getMessage());
        }
        Element root = document.getRootElement();
        List mxCellElements = root.elements();
        if (mxCellElements.isEmpty()) {
            this.addErrorMessage(obj, ResManager.loadKDString((String)"\u753b\u677f\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u5148\u4fdd\u5b58\u753b\u677f\u4fe1\u606f\u3002", (String)"ProcessPlanlibSaveValidator_1", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Element> edgeElement = new HashSet<Element>(mxCellElements.size());
        for (int i = 0; i < mxCellElements.size(); ++i) {
            Element cell = (Element)mxCellElements.get(i);
            String id = cell.attributeValue("id");
            String edge = cell.attributeValue("edge");
            if (StringUtils.isNotBlank((CharSequence)edge)) {
                Map map;
                String source = cell.attributeValue("source");
                String target = cell.attributeValue("target");
                if (StringUtils.isBlank((CharSequence)source)) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ebf\u8282\u70b9\u201c%s\u201d\uff0c\u6e90\u8282\u70b9\u4e3a\u7a7a\u3002", (String)"ProcessPlanlibSaveValidator_2", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), id));
                }
                if ((map = (Map)cellsDataMap.get(source)) != null) {
                    source = (String)map.get("selectname");
                }
                if (StringUtils.isBlank((CharSequence)target)) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ebf\u8282\u70b9\u201c%1$s\u201d\u3001\u6e90\u8282\u70b9\u201c%2$s\u201d\uff0c\u5176\u76ee\u6807\u8282\u70b9\u4e3a\u7a7a\uff0c\u8bf7\u6b63\u786e\u8fde\u63a5\u76ee\u6807\u8282\u70b9\u3002", (String)"ProcessPlanlibSaveValidator_3", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), id, source));
                    continue;
                }
                edgeElement.add(cell);
                continue;
            }
            Map map = (Map)cellsDataMap.get(id);
            if (map != null) {
                String processNode = (String)map.get("processnode");
                if (StringUtils.isBlank((CharSequence)processNode)) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u8282\u70b9\u201c%s\u201d\uff0c\u8282\u70b9\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"ProcessPlanlibSaveValidator_4", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), id));
                    continue;
                }
                String selectName = (String)map.get("selectname");
                if (!StringUtils.isBlank((CharSequence)selectName)) continue;
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u8282\u70b9\u201c%s\u201d\uff0c\u8282\u70b9\u540d\u79f0\u4e3a\u7a7a\u3002", (String)"ProcessPlanlibSaveValidator_5", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), id));
                continue;
            }
            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u8282\u70b9\u201c%s\u201d\uff0c\u8282\u70b9\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"ProcessPlanlibSaveValidator_4", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), id));
        }
        this.checkNode(obj, cellsDataMap, edgeElement);
    }

    private void checkNode(ExtendedDataEntity obj, Map<String, Map<String, String>> cellsDataMap, Set<Element> edgeElement) {
        if (edgeElement == null || edgeElement.size() < 1) {
            return;
        }
        Map<Object, DynamicObject> processNodesCacheMap = new HashMap(1);
        HashSet<Long> processPlanNodeIds = new HashSet<Long>(cellsDataMap.size());
        for (Map<String, String> nodeInfo : cellsDataMap.values()) {
            String processNodeId = nodeInfo.get("processnode");
            if (!StringUtils.isNotBlank((CharSequence)processNodeId) || StringUtils.equals((CharSequence)"0", (CharSequence)processNodeId)) continue;
            processPlanNodeIds.add(Long.parseLong(processNodeId));
        }
        if (processPlanNodeIds.size() > 0) {
            QFilter qf = new QFilter("id", "in", processPlanNodeIds);
            processNodesCacheMap = BusinessDataServiceHelper.loadFromCache((String)"fmm_processplannode", (QFilter[])qf.toArray());
        }
        for (Element cell : edgeElement) {
            String targetid;
            String srcobjid;
            Long processNodeId;
            DynamicObject processNode;
            String nodeType;
            String source = cell.attributeValue("source");
            String target = cell.attributeValue("target");
            Map<String, String> map = cellsDataMap.get(target);
            if (map == null) continue;
            String processNodeIdstr = map.get("processnode");
            String selectName = map.get("selectname");
            if (!StringUtils.isNotBlank((CharSequence)processNodeIdstr) || StringUtils.equals((CharSequence)"0", (CharSequence)processNodeIdstr) || StringUtils.equalsIgnoreCase((CharSequence)"B", (CharSequence)(nodeType = (processNode = (DynamicObject)processNodesCacheMap.get(processNodeId = Long.valueOf(Long.parseLong(processNodeIdstr)))).getString("nodetype"))) || StringUtils.equalsIgnoreCase((CharSequence)(srcobjid = processNode.getString("srcobj.id")), (CharSequence)(targetid = processNode.getString("targetobj.id")))) continue;
            Map<String, String> sourceMap = cellsDataMap.get(source);
            this.nodeCheck(obj, processNodesCacheMap, selectName, srcobjid, sourceMap);
        }
    }

    private void nodeCheck(ExtendedDataEntity obj, Map<Object, DynamicObject> processNodesCacheMap, String selectName, String srcobjid, Map<String, String> sourceMap) {
        Long sourceProcessNodeId;
        DynamicObject sourceProcessNode;
        String targetobjid;
        if (sourceMap == null) {
            return;
        }
        String sourceProcessNodeIdstr = sourceMap.get("processnode");
        String sourceSelectName = sourceMap.get("selectname");
        if (StringUtils.isNotBlank((CharSequence)sourceProcessNodeIdstr) && !StringUtils.equals((CharSequence)"0", (CharSequence)sourceProcessNodeIdstr) && !StringUtils.equals((CharSequence)srcobjid, (CharSequence)(targetobjid = (sourceProcessNode = processNodesCacheMap.get(sourceProcessNodeId = Long.valueOf(Long.parseLong(sourceProcessNodeIdstr)))).getString("targetobj.id")))) {
            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u8282\u70b9\u3010%1$s\u3011\u7684\u6e90\u5355\u4e0d\u7b49\u4e8e\u4e0a\u4e00\u8282\u70b9\u3010%2$s\u3011\u7684\u5f53\u524d\u5355", (String)"ProcessPlanlibSaveValidator_6", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), selectName, sourceSelectName));
        }
    }
}

