/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.opplugin.basedata;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bd.mpdm.common.utils.PdmParamSetHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.IImportDataPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.mmc.fmm.common.constants.RouteConst;
import kd.mmc.fmm.common.util.MMCUtils;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class RouteImportOp
extends BatchImportPlugin
implements IImportDataPlugin {
    public static final Set<String> activeOpStNumberStSet = new HashSet<String>(32);
    public static final Set<String> activeOpStNameStSet = new HashSet<String>(32);
    private static Log logger = LogFactory.getLog(RouteImportOp.class);

    public static boolean isTrue(Object val) {
        if (val == null) {
            return false;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        String literal = String.valueOf(val);
        return "true".equalsIgnoreCase(literal) || "1".equals(literal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveExcel() {
        FileService service = FileServiceFactory.getAttachmentFileService();
        Iterator var4 = this.ctx.getAllUrls().iterator();
        RouteConst.operatDescMap.clear();
        RouteConst.machTypeMap.clear();
        RouteConst.materialUnitMap.clear();
        RouteConst.operatActiveMap.clear();
        RouteConst.columnMap.clear();
        RouteConst.routeVerMap.clear();
        RouteConst.existRoute.clear();
        activeOpStNumberStSet.clear();
        activeOpStNameStSet.clear();
        while (var4.hasNext()) {
            String url = (String)var4.next();
            InputStream in = service.getInputStream(url);
            try {
                this.readExcel(in);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                if (SystemParamServiceHelper.isShowStackTrace()) {
                    this.ctx.getLogger(url).log(Integer.valueOf(0), (Throwable)e);
                } else {
                    Throwable cause = e.getCause();
                    String importErrMsg = cause instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"RouteImportOp_0", (String)"mmc-fmm-opplugin", (Object[])new Object[0]);
                    this.ctx.getLogger(url).log(Integer.valueOf(0), importErrMsg);
                }
                this.ctx.addBillData(url, new ImportBillData(new JSONObject(), 0, 0));
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.info("\u8f93\u5165\u6d41\u5173\u95ed\u5f02\u5e38" + e.getMessage());
                }
            }
        }
        super.resolveExcel();
    }

    public int getMaxSize() {
        return PdmParamSetHelper.getIntParamValue((String)"ProcessRouteMaxByteSize");
    }

    public void readExcel(InputStream inputStream) {
        XSSFWorkbook xssfWorkbook = null;
        try {
            int maxByteArraySize = this.getMaxSize();
            if (maxByteArraySize > 0) {
                IOUtils.setByteArrayMaxOverride((int)maxByteArraySize);
            }
            xssfWorkbook = new XSSFWorkbook(inputStream);
            int number = xssfWorkbook.getNumberOfSheets();
            HashSet<String> opNumberInfoSet = new HashSet<String>(64);
            HashSet<String> opNameInfoSet = new HashSet<String>(64);
            HashSet<String> opStNumberInfoSet = new HashSet<String>(64);
            HashSet<String> opStNameInfoSet = new HashSet<String>(64);
            HashSet<String> materNumberInfoSet = new HashSet<String>(64);
            HashSet<String> materNameInfoSet = new HashSet<String>(64);
            HashSet<String> workInfoNumberSet = new HashSet<String>(64);
            HashSet<String> workInfoNameSet = new HashSet<String>(64);
            HashSet<String> createOrgNumberInfoSet = new HashSet<String>(64);
            HashSet<String> createOrgNameInfoSet = new HashSet<String>(64);
            HashSet<String> routeNumberInfoSet = new HashSet<String>(64);
            HashSet<String> routeNameInfoSet = new HashSet<String>(64);
            HashSet<String> createOrgColName = new HashSet<String>(2);
            HashSet<String> opColName = new HashSet<String>(2);
            HashSet<String> materialColName = new HashSet<String>(2);
            HashSet<String> workColName = new HashSet<String>(2);
            HashSet<String> opStColName = new HashSet<String>(2);
            for (int i = 0; i < number; ++i) {
                XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(i);
                int rownum = xssfSheet.getPhysicalNumberOfRows();
                if (rownum <= 4) continue;
                XSSFRow columnRow = xssfSheet.getRow(2);
                int lastCellNum = columnRow.getLastCellNum();
                HashSet<Integer> opNumberIndex = new HashSet<Integer>(2);
                HashSet<Integer> opNameIndex = new HashSet<Integer>(2);
                HashSet<Integer> opStNumberIndex = new HashSet<Integer>(2);
                HashSet<Integer> opStNameIndex = new HashSet<Integer>(2);
                HashSet<Integer> materNumberIndex = new HashSet<Integer>(2);
                HashSet<Integer> materNameIndex = new HashSet<Integer>(2);
                HashSet<Integer> workNumberIndex = new HashSet<Integer>(2);
                HashSet<Integer> workNameIndex = new HashSet<Integer>(2);
                HashSet<Integer> createOrgNumberIndex = new HashSet<Integer>(2);
                HashSet<Integer> createOrgNameIndex = new HashSet<Integer>(2);
                HashSet<String> unitColName = new HashSet<String>(2);
                HashSet<String> headUnitColName = new HashSet<String>(2);
                HashSet<String> optionUnitColName = new HashSet<String>(2);
                HashSet<Integer> routeNumberIndex = new HashSet<Integer>(2);
                HashSet<Integer> routeNameIndex = new HashSet<Integer>(2);
                block42: for (int cellIndex = 0; cellIndex < lastCellNum; ++cellIndex) {
                    String columnName;
                    XSSFCell cell = columnRow.getCell(cellIndex);
                    if (cell == null) continue;
                    switch (columnName = cell.getStringCellValue()) {
                        case "number": {
                            routeNumberIndex.add(cellIndex);
                            continue block42;
                        }
                        case "name.zh_CN": 
                        case "name.en_US": 
                        case "name.zh_TW": {
                            routeNameIndex.add(cellIndex);
                            continue block42;
                        }
                        case "createorg.number": {
                            createOrgColName.add(columnName.substring(columnName.indexOf(".") + 1, columnName.length()));
                            createOrgNumberIndex.add(cellIndex);
                            continue block42;
                        }
                        case "createorg.name": {
                            createOrgNameIndex.add(cellIndex);
                            createOrgColName.add(columnName.substring(columnName.indexOf(".") + 1, columnName.length()));
                            continue block42;
                        }
                        case "operation.number": {
                            opNumberIndex.add(cellIndex);
                            opColName.add(columnName.substring(columnName.indexOf(".") + 1, columnName.length()));
                            continue block42;
                        }
                        case "operation.name": {
                            opNameIndex.add(cellIndex);
                            opColName.add(columnName.substring(columnName.indexOf(".") + 1, columnName.length()));
                            continue block42;
                        }
                        case "oprctrlstrategy.number": {
                            opStNumberIndex.add(cellIndex);
                            opStColName.add(columnName.substring(columnName.indexOf(".") + 1, columnName.length()));
                            continue block42;
                        }
                        case "oprctrlstrategy.name": {
                            opStNameIndex.add(cellIndex);
                            opStColName.add(columnName.substring(columnName.indexOf(".") + 1, columnName.length()));
                            continue block42;
                        }
                        case "material.number": {
                            materNumberIndex.add(cellIndex);
                            materialColName.add(columnName.substring(columnName.indexOf(".") + 1, columnName.length()));
                            continue block42;
                        }
                        case "material.name": {
                            materNameIndex.add(cellIndex);
                            materialColName.add(columnName.substring(columnName.indexOf(".") + 1, columnName.length()));
                            continue block42;
                        }
                        case "workcenter.number": {
                            workNumberIndex.add(cellIndex);
                            workColName.add(columnName.substring(columnName.indexOf(".") + 1, columnName.length()));
                            continue block42;
                        }
                        case "workcenter.name": {
                            workNameIndex.add(cellIndex);
                            workColName.add(columnName.substring(columnName.indexOf(".") + 1, columnName.length()));
                            continue block42;
                        }
                        case "unit.number": 
                        case "unit.name": {
                            unitColName.add(columnName.substring(columnName.indexOf(".") + 1, columnName.length()));
                            continue block42;
                        }
                        case "headunit.number": 
                        case "headunit.name": {
                            headUnitColName.add(columnName.substring(columnName.indexOf(".") + 1, columnName.length()));
                            continue block42;
                        }
                        case "operationunit.number": 
                        case "operationunit.name": {
                            optionUnitColName.add(columnName.substring(columnName.indexOf(".") + 1, columnName.length()));
                            continue block42;
                        }
                    }
                }
                RouteConst.columnMap.put("unit", unitColName);
                RouteConst.columnMap.put("headunit", headUnitColName);
                RouteConst.columnMap.put("operationunit", optionUnitColName);
                RouteConst.columnMap.put("material", materialColName);
                RouteConst.columnMap.put("operation", opColName);
                RouteConst.columnMap.put("oprctrlstrategy", opStColName);
                RouteConst.columnMap.put("workcenter", workColName);
                for (int row = 4; row < rownum; ++row) {
                    XSSFRow rowInfo = xssfSheet.getRow(row);
                    if (rowInfo == null) continue;
                    opNumberInfoSet.addAll(this.getMapInfo(opNumberIndex, rowInfo));
                    opNameInfoSet.addAll(this.getMapInfo(opNameIndex, rowInfo));
                    opStNumberInfoSet.addAll(this.getMapInfo(opStNumberIndex, rowInfo));
                    opStNameInfoSet.addAll(this.getMapInfo(opStNameIndex, rowInfo));
                    materNumberInfoSet.addAll(this.getMapInfo(materNumberIndex, rowInfo));
                    materNameInfoSet.addAll(this.getMapInfo(materNameIndex, rowInfo));
                    workInfoNumberSet.addAll(this.getMapInfo(workNumberIndex, rowInfo));
                    workInfoNameSet.addAll(this.getMapInfo(workNameIndex, rowInfo));
                    createOrgNumberInfoSet.addAll(this.getMapInfo(createOrgNumberIndex, rowInfo));
                    createOrgNameInfoSet.addAll(this.getMapInfo(createOrgNameIndex, rowInfo));
                    this.getRouteCellInfo(routeNumberInfoSet, routeNameInfoSet, routeNumberIndex, routeNameIndex, rowInfo);
                }
            }
            ArrayList<QFilter> creatOrgList = new ArrayList<QFilter>(1);
            String createOrgKeyStr = "number";
            if (createOrgColName.contains("number")) {
                creatOrgList.add(new QFilter("number", "in", createOrgNumberInfoSet));
                createOrgKeyStr = "number";
            } else {
                creatOrgList.add(new QFilter("name", "in", createOrgNameInfoSet));
                createOrgKeyStr = "name";
            }
            Map<String, Object> createOrgMap = this.getBaseData("bos_org", creatOrgList, createOrgKeyStr, "id,number", "id");
            ArrayList<QFilter> opQFList = new ArrayList<QFilter>(1);
            String opKeyStr = this.getQFilterKeyStr(opColName, opQFList, opNumberInfoSet, opNameInfoSet);
            RouteConst.operatDescMap.putAll(this.getBaseData("mpdm_workprocedure", opQFList, opKeyStr, "id,number,name", "name"));
            ArrayList<QFilter> materQFList = new ArrayList<QFilter>(1);
            String materKeyStr = this.getQFilterKeyStr(materialColName, materQFList, materNumberInfoSet, materNameInfoSet);
            RouteConst.materialUnitMap.putAll(this.getBaseData("bd_material", materQFList, materKeyStr, "id,number,baseunit.number,baseunit.name", "baseunit"));
            ArrayList<QFilter> workQFList = new ArrayList<QFilter>(1);
            String workKeyStr = this.getQFilterKeyStr(workColName, workQFList, workInfoNumberSet, workInfoNameSet);
            RouteConst.operatActiveMap.putAll(this.getBaseData("mpdm_workcentre", workQFList, workKeyStr, "id,number,processstrategy.id,processstrategy.number,processstrategy.name,processstrategy.promode,processactivetable.processnumber,processactivetable.activeformula,processactivetable.reportformula,processactivetable.processqty,processactivetable.processunit,processactivetable.processroutecontrol", "processactivetable", "processstrategy"));
            opStNumberInfoSet.addAll(activeOpStNumberStSet);
            opStNameInfoSet.addAll(activeOpStNameStSet);
            ArrayList<QFilter> opStQFList = new ArrayList<QFilter>(1);
            String opStKeyStr = this.getQFilterKeyStr(opStColName, opStQFList, opStNumberInfoSet, opStNameInfoSet);
            RouteConst.machTypeMap.putAll(this.getBaseData("mpdm_proctrlstrategy", opStQFList, opStKeyStr, "id,number,promode", "promode"));
            RouteConst.existRoute.putAll(this.getRouteMap("pdm_route", routeNumberInfoSet, routeNameInfoSet));
            RouteConst.existEcnRoute.putAll(this.getExistsECNRouteMap("pdm_route", routeNumberInfoSet, routeNameInfoSet));
            xssfWorkbook.close();
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("readExcel-exeption", ResManager.loadKDString((String)"\u8bfb\u53d6EXCEL\u5931\u8d25\u3002", (String)"RouteImportOp_1", (String)"mmc-fmm-opplugin", (Object[])new Object[0])), new Object[0]);
        }
    }

    public String getQFilterKeyStr(Set<String> colName, List<QFilter> qFilters, Set<String> numberInfoSet, Set<String> nameInfoSet) {
        String keyStr = "number";
        if (colName == null || qFilters == null) {
            return keyStr;
        }
        if (colName.contains("number")) {
            qFilters.add(new QFilter("number", "in", numberInfoSet));
            keyStr = "number";
        } else {
            qFilters.add(new QFilter("name", "in", nameInfoSet));
            keyStr = "name";
        }
        return keyStr;
    }

    public Set<String> getMapInfo(Set<Integer> sets, XSSFRow rowInfo) {
        HashSet<String> valueInfo = new HashSet<String>(32);
        Iterator<Integer> iterator = sets.iterator();
        if (rowInfo == null) {
            return valueInfo;
        }
        while (iterator.hasNext()) {
            Integer index = iterator.next();
            XSSFCell cell = rowInfo.getCell(index.intValue());
            if (cell == null) continue;
            String cellValue = "";
            CellType cellType = cell.getCellType();
            if (cellType.name().equals("STRING")) {
                cellValue = cell.getStringCellValue();
            } else if (cellType.name().equals("NUMERIC")) {
                double numericCellValue = cell.getNumericCellValue();
                BigDecimal bigDecimal = BigDecimal.valueOf(numericCellValue);
                cellValue = bigDecimal.toPlainString();
            } else if (cellType.name().equals("BOOLEAN")) {
                cellValue = cell.getBooleanCellValue() + "";
            } else if (cellType.name().equals("FORMULA")) {
                cellValue = cell.getCellFormula() + "";
            }
            valueInfo.add(cellValue);
        }
        return valueInfo;
    }

    public Map<String, Object> getBaseData(String formID, List<QFilter> qFilterLists, String keyField, String filterField, String ... resultFields) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(32);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        if (resultFields == null || resultFields.length <= 0) {
            return resultMap;
        }
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        qFilters.addAll(qFilterLists);
        DynamicObject[] dynamicObjDOC = BusinessDataServiceHelper.load((String)formID, (String)filterField, (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        if (dynamicObjDOC == null || dynamicObjDOC.length <= 0) {
            return resultMap;
        }
        boolean multipleFlag = false;
        if (resultFields.length > 1) {
            multipleFlag = true;
        }
        for (DynamicObject dynamicObj : dynamicObjDOC) {
            Map<String, Object> ormLocalMapValue;
            Object keyObj = dynamicObj.get(keyField);
            if (!multipleFlag) {
                Object valueObj0 = dynamicObj.get(resultFields[0]);
                if (keyObj instanceof String) {
                    if (valueObj0 instanceof DynamicObjectCollection && ((DynamicObjectCollection)valueObj0).isEmpty()) continue;
                    resultMap.put(keyObj.toString(), valueObj0);
                    continue;
                }
                if (!(keyObj instanceof OrmLocaleValue)) continue;
                OrmLocaleValue keyOrmLocal = (OrmLocaleValue)keyObj;
                ormLocalMapValue = this.getOrmLocalMapValue(keyOrmLocal, valueObj0);
                resultMap.putAll(ormLocalMapValue);
                continue;
            }
            HashMap<String, Object> valueMap = new HashMap<String, Object>(2);
            for (int i = 0; i < resultFields.length; ++i) {
                Object valueObj = dynamicObj.get(resultFields[i]);
                if (valueObj instanceof DynamicObjectCollection && ((DynamicObjectCollection)valueObj).isEmpty()) continue;
                valueMap.put(resultFields[i], valueObj);
                if (!"processstrategy".equals(resultFields[i]) || !(valueObj instanceof DynamicObject)) continue;
                DynamicObject proStrategyDO = (DynamicObject)valueObj;
                String number = MMCUtils.getDynamicObjectStringData((DynamicObject)proStrategyDO, (String)"number");
                String name = MMCUtils.getDynamicObjectStringData((DynamicObject)proStrategyDO, (String)"name");
                activeOpStNumberStSet.add(number);
                activeOpStNameStSet.add(name);
            }
            if (keyObj instanceof String) {
                resultMap.put(keyObj.toString(), valueMap);
                continue;
            }
            if (!(keyObj instanceof OrmLocaleValue)) continue;
            OrmLocaleValue keyOrmLocal = (OrmLocaleValue)keyObj;
            ormLocalMapValue = this.getOrmLocalMapValue(keyOrmLocal, valueMap);
            resultMap.putAll(ormLocalMapValue);
        }
        return resultMap;
    }

    public Map<String, Object> getOrmLocalMapValue(OrmLocaleValue keyOrmLocal, Object valueObj) {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        if (keyOrmLocal == null) {
            return result;
        }
        Set keyOrmKey = keyOrmLocal.keySet();
        Iterator iterator = keyOrmKey.iterator();
        while (iterator.hasNext()) {
            String key = keyOrmLocal.get(iterator.next());
            result.put(key, valueObj);
        }
        return result;
    }

    public Map<String, List<String>> getRouteMap(String pdm_route, Set<String> routeNumberInfoSet, Set<String> routeNameInfoSet) {
        HashMap<String, List<String>> resltMap = new HashMap<String, List<String>>(8);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
        qFilterList.add(new QFilter("status", "=", (Object)"C").or(new QFilter("status", "=", (Object)"B")));
        qFilterList.add(new QFilter("number", "in", routeNumberInfoSet).or(new QFilter("name", "in", routeNameInfoSet)));
        qFilterList.add(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection routeDOC = QueryServiceHelper.query((String)"pdm_route", (String)"number,createorg.number", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
        if (routeDOC == null || routeDOC.isEmpty()) {
            return resltMap;
        }
        for (DynamicObject routeDO : routeDOC) {
            ArrayList<String> valueList;
            String key = routeDO.getString("number");
            String value = routeDO.getString("createorg.number");
            if (resltMap.containsKey(key)) {
                valueList = (ArrayList<String>)resltMap.get(key);
                valueList.add(value);
            } else {
                valueList = new ArrayList<String>(2);
                valueList.add(value);
            }
            resltMap.put(key, valueList);
        }
        return resltMap;
    }

    public Map<String, List<String>> getExistsECNRouteMap(String pdm_route, Set<String> routeNumberInfoSet, Set<String> routeNameInfoSet) {
        HashMap<String, List<String>> resltMap = new HashMap<String, List<String>>(8);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
        qFilterList.add(new QFilter("processentry.entryecnid", ">", (Object)0));
        qFilterList.add(new QFilter("number", "in", routeNumberInfoSet).or(new QFilter("name", "in", routeNameInfoSet)));
        DynamicObjectCollection routeDOC = QueryServiceHelper.query((String)"pdm_route", (String)"number,createorg.number", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
        if (routeDOC == null || routeDOC.isEmpty()) {
            return resltMap;
        }
        for (DynamicObject routeDO : routeDOC) {
            ArrayList<String> valueList;
            String key = routeDO.getString("number");
            String value = routeDO.getString("createorg.number");
            if (resltMap.containsKey(key)) {
                valueList = (ArrayList<String>)resltMap.get(key);
                valueList.add(value);
            } else {
                valueList = new ArrayList<String>(2);
                valueList.add(value);
            }
            resltMap.put(key, valueList);
        }
        return resltMap;
    }

    public void getRouteCellInfo(Set<String> routeNumberInfoSet, Set<String> routeNameInfoSet, Set<Integer> routeNumberIndex, Set<Integer> routeNameIndex, XSSFRow rowInfo) {
        if (routeNumberIndex == null && routeNameIndex == null) {
            return;
        }
        if (rowInfo == null) {
            return;
        }
        boolean exitNumber = false;
        if (routeNumberIndex != null) {
            for (int cellIndex : routeNumberIndex) {
                XSSFCell routeNumberCell = rowInfo.getCell(cellIndex);
                String routeNumberStr = this.getCellValue(routeNumberCell);
                if (StringUtils.isNotEmpty((CharSequence)routeNumberStr)) {
                    exitNumber = true;
                }
                if (routeNumberInfoSet == null) continue;
                routeNumberInfoSet.add(routeNumberStr);
            }
        }
        if (!exitNumber && routeNameIndex != null) {
            for (int cellIndex : routeNameIndex) {
                XSSFCell routeNameCell = rowInfo.getCell(cellIndex);
                String routeNameStr = this.getCellValue(routeNameCell);
                if (routeNameInfoSet == null) continue;
                routeNameInfoSet.add(routeNameStr);
            }
        }
    }

    public String getCellValue(XSSFCell cell) {
        String cellValue = "";
        if (cell == null) {
            return cellValue;
        }
        CellType cellType = cell.getCellType();
        if (cellType.name().equals("STRING")) {
            cellValue = cell.getStringCellValue();
        } else if (cellType.name().equals("NUMERIC")) {
            double numericCellValue = cell.getNumericCellValue();
            BigDecimal bigDecimal = BigDecimal.valueOf(numericCellValue);
            cellValue = bigDecimal.toPlainString();
        } else if (cellType.name().equals("BOOLEAN")) {
            cellValue = cell.getBooleanCellValue() + "";
        } else if (cellType.name().equals("FORMULA")) {
            cellValue = cell.getCellFormula() + "";
        }
        return cellValue;
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ApiResult result = super.save(rowdatas, logger);
        if (result != null && result.getData() != null) {
            List dataList;
            List<DynamicObject> retData;
            Object data = result.getData();
            ArrayList<DynamicObject> saveDatas = new ArrayList<DynamicObject>();
            if (data instanceof List && (retData = this.checkFields(dataList = (List)data)) != null && !retData.isEmpty()) {
                saveDatas.addAll(retData);
            }
            SaveServiceHelper.update((DynamicObject[])saveDatas.toArray(new DynamicObject[saveDatas.size()]));
        }
        return result;
    }

    private String getSelectFields() {
        return "material,auxproperty,processtype,routeversion,materialgroup,processentry.workcenter,processentry.parent,processentry.actentryentity.id,activity,operationno,standardformula,standardformula1,processentry.productionorg,processentry.productionworkshop,processentry.operation,processentry.oprctrlstrategy,processentry.purchaseorg,processentry.supplier,entryentity.processseqtype,entryentity.reference,entryentity.output,entryentity.input";
    }

    private HashSet<Long> getRouteIdSet(List<Object> dataList) {
        HashSet<Long> idSet = new HashSet<Long>();
        for (Object o : dataList) {
            if (!(o instanceof Map)) continue;
            Map map = (Map)o;
            Object success = map.get("success");
            String number = String.valueOf(map.get("number"));
            String id = String.valueOf(map.get("id"));
            if (!RouteImportOp.isTrue(success) || !StringUtils.isNotBlank((CharSequence)id)) continue;
            idSet.add(Long.parseLong(id));
        }
        return idSet;
    }

    private List<DynamicObject> checkFields(List<Object> dataList) {
        ArrayList<DynamicObject> saveDatas = new ArrayList<DynamicObject>();
        HashSet<Long> idSet = this.getRouteIdSet(dataList);
        if (idSet.isEmpty()) {
            return saveDatas;
        }
        String selectFields = this.getSelectFields();
        DynamicObject[] routes = BusinessDataServiceHelper.load((String)"pdm_route", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)});
        Map<Long, DynamicObject> routeMap = this.convertRouteMap(routes);
        Map<String, DynamicObject> workCentreData = this.getWorkCentreData(routes);
        Map<String, DynamicObject> workshopsetupData = this.getWorkshopsetupData(routes);
        Map<String, DynamicObject> workproceduresData = this.getWorkproceduresData(routes);
        Map<String, DynamicObject> oprctrlstrategyData = this.getOprctrlstrategyData(routes);
        Map<String, DynamicObject> activityData = this.getActivityData(routes);
        Map<String, DynamicObject> supplierData = this.getSupplierData(routes);
        for (Object o : dataList) {
            if (!(o instanceof Map)) continue;
            Map map = (Map)o;
            Object success = map.get("success");
            String id = String.valueOf(map.get("id"));
            if (!RouteImportOp.isTrue(success) || !StringUtils.isNotBlank((CharSequence)id)) continue;
            DynamicObject route = routeMap.get(Long.parseLong(id));
            this.clearIllegalData(route, workCentreData, workshopsetupData, workproceduresData, oprctrlstrategyData, activityData, supplierData);
            saveDatas.add(route);
        }
        return saveDatas;
    }

    private Map<String, DynamicObject> getWorkCentreData(DynamicObject[] routes) {
        Map<Long, Set<Long>> workCentreMap = this.getWorkCentreGroupByOrg(routes);
        HashMap<String, DynamicObject> dataMap = new HashMap<String, DynamicObject>(16);
        if (routes == null || routes.length < 1) {
            return dataMap;
        }
        for (Map.Entry<Long, Set<Long>> entrys : workCentreMap.entrySet()) {
            Long orgId = entrys.getKey();
            Set<Long> workCentreId = entrys.getValue();
            QFilter qFilter = new QFilter("id", "in", workCentreId);
            qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_workcentre", (Long)orgId));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            qFilter.and(new QFilter("status", "=", (Object)"C"));
            Map cacheMap = BusinessDataServiceHelper.loadFromCache((String)"mpdm_workcentre", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (cacheMap == null || cacheMap.isEmpty()) continue;
            for (Map.Entry cache : cacheMap.entrySet()) {
                DynamicObject cacheValue = (DynamicObject)cache.getValue();
                String keyString = this.replaceOrgKey(orgId, cacheValue.getLong("id"));
                dataMap.put(keyString, cacheValue);
            }
        }
        return dataMap;
    }

    private Map<String, DynamicObject> getWorkshopsetupData(DynamicObject[] routes) {
        Map<Long, Set<Long>> workshopsetupMap = this.getWorkshopsetupByOrg(routes);
        HashMap<String, DynamicObject> dataMap = new HashMap<String, DynamicObject>(16);
        if (routes == null || routes.length < 1) {
            return dataMap;
        }
        for (Map.Entry<Long, Set<Long>> entrys : workshopsetupMap.entrySet()) {
            Long orgId = entrys.getKey();
            Set<Long> workshopsetupMapId = entrys.getValue();
            QFilter qFilter = new QFilter("id", "in", workshopsetupMapId);
            qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_workshopsetup", (Long)orgId));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            qFilter.and(new QFilter("status", "=", (Object)"C"));
            Map cacheMap = BusinessDataServiceHelper.loadFromCache((String)"mpdm_workshopsetup", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (cacheMap == null || cacheMap.isEmpty()) continue;
            for (Map.Entry cache : cacheMap.entrySet()) {
                DynamicObject cacheValue = (DynamicObject)cache.getValue();
                String keyString = this.replaceOrgKey(orgId, cacheValue.getLong("id"));
                dataMap.put(keyString, cacheValue);
            }
        }
        return dataMap;
    }

    private Map<String, DynamicObject> getWorkproceduresData(DynamicObject[] routes) {
        Map<Long, Set<Long>> workproceduresMap = this.getWorkproceduresByOrg(routes);
        HashMap<String, DynamicObject> dataMap = new HashMap<String, DynamicObject>(16);
        if (routes == null || routes.length < 1) {
            return dataMap;
        }
        for (Map.Entry<Long, Set<Long>> entrys : workproceduresMap.entrySet()) {
            Long orgId = entrys.getKey();
            Set<Long> workproceduresMapId = entrys.getValue();
            QFilter qFilter = new QFilter("id", "in", workproceduresMapId);
            qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_workprocedure", (Long)orgId));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            qFilter.and(new QFilter("status", "=", (Object)"C"));
            Map cacheMap = BusinessDataServiceHelper.loadFromCache((String)"mpdm_workprocedure", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (cacheMap == null || cacheMap.isEmpty()) continue;
            for (Map.Entry cache : cacheMap.entrySet()) {
                DynamicObject cacheValue = (DynamicObject)cache.getValue();
                String keyString = this.replaceOrgKey(orgId, cacheValue.getLong("id"));
                dataMap.put(keyString, cacheValue);
            }
        }
        return dataMap;
    }

    private Map<String, DynamicObject> getOprctrlstrategyData(DynamicObject[] routes) {
        Map<Long, Set<Long>> oprctrlstrategyIdMap = this.getOprctrlstrategyByOrg(routes);
        HashMap<String, DynamicObject> dataMap = new HashMap<String, DynamicObject>(16);
        if (routes == null || routes.length < 1) {
            return dataMap;
        }
        for (Map.Entry<Long, Set<Long>> entrys : oprctrlstrategyIdMap.entrySet()) {
            Long orgId = entrys.getKey();
            Set<Long> oprctrlstrategyMapId = entrys.getValue();
            QFilter qFilter = new QFilter("id", "in", oprctrlstrategyMapId);
            qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_proctrlstrategy", (Long)orgId));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            qFilter.and(new QFilter("status", "=", (Object)"C"));
            Map cacheMap = BusinessDataServiceHelper.loadFromCache((String)"mpdm_proctrlstrategy", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (cacheMap == null || cacheMap.isEmpty()) continue;
            for (Map.Entry cache : cacheMap.entrySet()) {
                DynamicObject cacheValue = (DynamicObject)cache.getValue();
                String keyString = this.replaceOrgKey(orgId, cacheValue.getLong("id"));
                dataMap.put(keyString, cacheValue);
            }
        }
        return dataMap;
    }

    private Map<String, DynamicObject> getActivityData(DynamicObject[] routes) {
        Map<Long, Set<Long>> activityIdMap = this.getActivityByOrg(routes);
        HashMap<String, DynamicObject> dataMap = new HashMap<String, DynamicObject>(16);
        if (routes == null || routes.length < 1) {
            return dataMap;
        }
        for (Map.Entry<Long, Set<Long>> entrys : activityIdMap.entrySet()) {
            Long orgId = entrys.getKey();
            Set<Long> activityIdMapId = entrys.getValue();
            QFilter qFilter = new QFilter("id", "in", activityIdMapId);
            qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_processactivity", (Long)orgId));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            qFilter.and(new QFilter("status", "=", (Object)"C"));
            Map cacheMap = BusinessDataServiceHelper.loadFromCache((String)"mpdm_processactivity", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (cacheMap == null || cacheMap.isEmpty()) continue;
            for (Map.Entry cache : cacheMap.entrySet()) {
                DynamicObject cacheValue = (DynamicObject)cache.getValue();
                String keyString = this.replaceOrgKey(orgId, cacheValue.getLong("id"));
                dataMap.put(keyString, cacheValue);
            }
        }
        return dataMap;
    }

    private Map<String, DynamicObject> getSupplierData(DynamicObject[] routes) {
        Map<Long, Set<Long>> supplierIdMap = this.getSupplierByOrg(routes);
        HashMap<String, DynamicObject> dataMap = new HashMap<String, DynamicObject>(16);
        if (routes == null || routes.length < 1) {
            return dataMap;
        }
        for (Map.Entry<Long, Set<Long>> entrys : supplierIdMap.entrySet()) {
            Long orgId = entrys.getKey();
            Set<Long> supplierIdMapId = entrys.getValue();
            QFilter qFilter = new QFilter("id", "in", supplierIdMapId);
            qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)orgId));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            qFilter.and(new QFilter("status", "=", (Object)"C"));
            Map cacheMap = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (cacheMap == null || cacheMap.isEmpty()) continue;
            for (Map.Entry cache : cacheMap.entrySet()) {
                DynamicObject cacheValue = (DynamicObject)cache.getValue();
                String keyString = this.replaceOrgKey(orgId, cacheValue.getLong("id"));
                dataMap.put(keyString, cacheValue);
            }
        }
        return dataMap;
    }

    private Map<Long, Set<Long>> getWorkCentreGroupByOrg(DynamicObject[] routes) {
        HashMap<Long, Set<Long>> orgDataMap = new HashMap<Long, Set<Long>>(16);
        if (routes == null || routes.length < 1) {
            return orgDataMap;
        }
        for (DynamicObject route : routes) {
            DynamicObjectCollection processentry = route.getDynamicObjectCollection("processentry");
            processentry.forEach(entryRow -> {
                DynamicObject workcenter = entryRow.getDynamicObject("workcenter");
                DynamicObject productionorg = entryRow.getDynamicObject("productionorg");
                if (workcenter != null && productionorg != null) {
                    Long workcenterId = workcenter.getLong("id");
                    Long productionorgId = productionorg.getLong("id");
                    this.addToLongMap(productionorgId, workcenterId, orgDataMap);
                }
            });
        }
        return orgDataMap;
    }

    private Map<Long, Set<Long>> getWorkshopsetupByOrg(DynamicObject[] routes) {
        HashMap<Long, Set<Long>> orgDataMap = new HashMap<Long, Set<Long>>(16);
        if (routes == null || routes.length < 1) {
            return orgDataMap;
        }
        for (DynamicObject route : routes) {
            DynamicObjectCollection processentry = route.getDynamicObjectCollection("processentry");
            processentry.forEach(entryRow -> {
                DynamicObject productionworkshop = entryRow.getDynamicObject("productionworkshop");
                DynamicObject productionorg = entryRow.getDynamicObject("productionorg");
                if (productionworkshop != null && productionorg != null) {
                    Long productionworkshopId = productionworkshop.getLong("id");
                    Long productionorgId = productionorg.getLong("id");
                    this.addToLongMap(productionorgId, productionworkshopId, orgDataMap);
                }
            });
        }
        return orgDataMap;
    }

    private Map<Long, Set<Long>> getWorkproceduresByOrg(DynamicObject[] routes) {
        HashMap<Long, Set<Long>> orgDataMap = new HashMap<Long, Set<Long>>(16);
        if (routes == null || routes.length < 1) {
            return orgDataMap;
        }
        for (DynamicObject route : routes) {
            DynamicObjectCollection processentry = route.getDynamicObjectCollection("processentry");
            processentry.forEach(entryRow -> {
                DynamicObject operation = entryRow.getDynamicObject("operation");
                DynamicObject productionorg = entryRow.getDynamicObject("productionorg");
                if (operation != null && productionorg != null) {
                    Long operationId = operation.getLong("id");
                    Long productionorgId = productionorg.getLong("id");
                    this.addToLongMap(productionorgId, operationId, orgDataMap);
                }
            });
        }
        return orgDataMap;
    }

    private Map<Long, Set<Long>> getOprctrlstrategyByOrg(DynamicObject[] routes) {
        HashMap<Long, Set<Long>> orgDataMap = new HashMap<Long, Set<Long>>(16);
        if (routes == null || routes.length < 1) {
            return orgDataMap;
        }
        for (DynamicObject route : routes) {
            DynamicObjectCollection processentry = route.getDynamicObjectCollection("processentry");
            processentry.forEach(entryRow -> {
                DynamicObject oprctrlstrategy = entryRow.getDynamicObject("oprctrlstrategy");
                DynamicObject productionorg = entryRow.getDynamicObject("productionorg");
                if (oprctrlstrategy != null && productionorg != null) {
                    Long oprctrlstrategyId = oprctrlstrategy.getLong("id");
                    Long productionorgId = productionorg.getLong("id");
                    this.addToLongMap(productionorgId, oprctrlstrategyId, orgDataMap);
                }
            });
        }
        return orgDataMap;
    }

    private Map<Long, Set<Long>> getActivityByOrg(DynamicObject[] routes) {
        HashMap<Long, Set<Long>> orgDataMap = new HashMap<Long, Set<Long>>(16);
        if (routes == null || routes.length < 1) {
            return orgDataMap;
        }
        for (DynamicObject route : routes) {
            DynamicObjectCollection processentry = route.getDynamicObjectCollection("processentry");
            processentry.forEach(entryRow -> {
                DynamicObject productionorg = entryRow.getDynamicObject("productionorg");
                DynamicObjectCollection actentryentity = entryRow.getDynamicObjectCollection("actentryentity");
                actentryentity.forEach(subEntryRow -> {
                    DynamicObject activity = subEntryRow.getDynamicObject("activity");
                    if (activity != null && productionorg != null) {
                        Long activityId = activity.getLong("id");
                        Long productionorgId = productionorg.getLong("id");
                        this.addToLongMap(productionorgId, activityId, orgDataMap);
                    }
                });
            });
        }
        return orgDataMap;
    }

    private Map<Long, Set<Long>> getSupplierByOrg(DynamicObject[] routes) {
        HashMap<Long, Set<Long>> orgDataMap = new HashMap<Long, Set<Long>>(16);
        if (routes == null || routes.length < 1) {
            return orgDataMap;
        }
        for (DynamicObject route : routes) {
            DynamicObjectCollection processentry = route.getDynamicObjectCollection("processentry");
            processentry.forEach(entryRow -> {
                DynamicObject supplier = entryRow.getDynamicObject("supplier");
                DynamicObject purchaseorg = entryRow.getDynamicObject("purchaseorg");
                if (supplier != null && purchaseorg != null) {
                    Long supplierId = supplier.getLong("id");
                    Long productionorgId = purchaseorg.getLong("id");
                    this.addToLongMap(productionorgId, supplierId, orgDataMap);
                }
            });
        }
        return orgDataMap;
    }

    private void addToLongMap(Long orgId, Long DataId, Map<Long, Set<Long>> map) {
        Set<Long> idSet = map.get(orgId);
        if (idSet == null) {
            idSet = new HashSet<Long>(16);
        }
        idSet.add(DataId);
        map.put(orgId, idSet);
    }

    private String replaceOrgKey(Object orgId, Object dataId) {
        return String.valueOf(orgId) + "_" + String.valueOf(dataId);
    }

    private Map<Long, DynamicObject> convertRouteMap(DynamicObject[] routes) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(routes.length);
        for (DynamicObject route : routes) {
            map.put((Long)route.getPkValue(), route);
        }
        return map;
    }

    private DynamicObject getValidNewDataFromMap(String orgid, DynamicObject oldData, Map<String, DynamicObject> cacheMap) {
        if (oldData != null) {
            return cacheMap.get(orgid + "_" + oldData.getPkValue().toString());
        }
        return null;
    }

    private void clearIllegalData(DynamicObject route, Map<String, DynamicObject> WorkcentreData, Map<String, DynamicObject> workshopsetupData, Map<String, DynamicObject> workproceduresData, Map<String, DynamicObject> oprctrlstrategyData, Map<String, DynamicObject> activityData, Map<String, DynamicObject> supplierData) {
        String processtype = route.getString("processtype");
        if (!"B".equals(processtype)) {
            route.set("materialgroup", null);
        }
        if (!"A".equals(processtype)) {
            route.set("material", null);
        }
        DynamicObjectCollection processentry = route.getDynamicObjectCollection("processentry");
        processentry.forEach(entryRow -> {
            Long orgId;
            Long orgId2;
            DynamicObject oprctrlstrategy;
            Long orgId3;
            DynamicObject operation;
            Long orgId4;
            DynamicObject productionworkshop;
            Long orgId5;
            DynamicObject workcenter = entryRow.getDynamicObject("workcenter");
            DynamicObject productionorg = entryRow.getDynamicObject("productionorg");
            if (workcenter != null && productionorg != null && (workcenter = this.getValidNewDataFromMap((orgId5 = Long.valueOf(productionorg.getLong("id"))).toString(), workcenter, WorkcentreData)) == null) {
                entryRow.set("workcenter", null);
            }
            if ((productionworkshop = entryRow.getDynamicObject("productionworkshop")) != null && productionorg != null && (productionworkshop = this.getValidNewDataFromMap((orgId4 = Long.valueOf(productionorg.getLong("id"))).toString(), productionworkshop, workshopsetupData)) == null) {
                entryRow.set("productionworkshop", null);
            }
            if ((operation = entryRow.getDynamicObject("operation")) != null && productionorg != null && (operation = this.getValidNewDataFromMap((orgId3 = Long.valueOf(productionorg.getLong("id"))).toString(), operation, workproceduresData)) == null) {
                entryRow.set("operation", null);
            }
            if ((oprctrlstrategy = entryRow.getDynamicObject("oprctrlstrategy")) != null && productionorg != null && (oprctrlstrategy = this.getValidNewDataFromMap((orgId2 = Long.valueOf(productionorg.getLong("id"))).toString(), oprctrlstrategy, oprctrlstrategyData)) == null) {
                entryRow.set("oprctrlstrategy", null);
            }
            DynamicObjectCollection actentryentity = entryRow.getDynamicObjectCollection("actentryentity");
            actentryentity.forEach(subEntryRow -> {
                Long orgId = productionorg.getLong("id");
                String activityId = String.valueOf(subEntryRow.getDynamicObject("activity").getLong("id"));
                DynamicObject isExies = (DynamicObject)activityData.get(orgId + "_" + activityId);
                if (isExies != null) {
                    String activityProcessstage = subEntryRow.getDynamicObject("activity").getString("processstage");
                    DynamicObject standardformula = subEntryRow.getDynamicObject("standardformula");
                    DynamicObject standardformula1 = subEntryRow.getDynamicObject("standardformula1");
                    if (standardformula != null && standardformula1 != null) {
                        String routeProcessstage = standardformula.getString("processstage");
                        String routeProcessstage1 = standardformula1.getString("processstage");
                        if (!Objects.equals(activityProcessstage, routeProcessstage)) {
                            subEntryRow.set("standardformula", null);
                        }
                        if (!Objects.equals(activityProcessstage, routeProcessstage1)) {
                            subEntryRow.set("standardformula1", null);
                        }
                    }
                } else {
                    subEntryRow.set("standardformula", null);
                    subEntryRow.set("standardformula1", null);
                    subEntryRow.set("activity", null);
                }
            });
            DynamicObject supplier = entryRow.getDynamicObject("supplier");
            DynamicObject purchaseorg = entryRow.getDynamicObject("purchaseorg");
            if (supplier != null && purchaseorg != null && (supplier = this.getValidNewDataFromMap((orgId = Long.valueOf(purchaseorg.getLong("id"))).toString(), supplier, supplierData)) == null) {
                entryRow.set("supplier", null);
            }
            DynamicObjectCollection entryentity = route.getDynamicObjectCollection("entryentity");
            entryentity.forEach(enetryRow -> {
                String processseqtype = enetryRow.getString("processseqtype");
                if ("C".equals(processseqtype)) {
                    enetryRow.set("reference", (Object)1);
                }
                DynamicObjectCollection subProcessentrys = new DynamicObjectCollection();
                String reference = enetryRow.getString("reference");
                String output = enetryRow.getString("output");
                String input = enetryRow.getString("input");
                for (DynamicObject process : processentry) {
                    String parent = process.getString("parent");
                    if (!StringUtils.equals((CharSequence)reference, (CharSequence)parent)) continue;
                    subProcessentrys.add((Object)process);
                }
                HashSet operationnos = new HashSet();
                subProcessentrys.forEach(subProcessentry -> operationnos.add(subProcessentry.getString("operationno")));
                if (!operationnos.contains(output)) {
                    enetryRow.set("output", null);
                }
                if (!operationnos.contains(input)) {
                    enetryRow.set("input", null);
                }
            });
        });
    }
}

