/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.opplugin.basedata.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class BOMConfigCodeValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] objs = this.getDataEntities();
        if (objs == null || objs.length <= 0) {
            return;
        }
        for (ExtendedDataEntity obj : objs) {
            DynamicObject bom = obj.getDataEntity();
            DynamicObject typeObj = bom.getDynamicObject("type");
            if (typeObj == null) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199BOM\u7c7b\u578b\u3002", (String)"BOMConfigCodeValidator_5", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), new Object[0]));
                continue;
            }
            String purpose = typeObj.getString("purpose");
            if ("B".equals(purpose)) continue;
            DynamicObject configCodeObj = bom.getDynamicObject("configuredcode");
            if ("C".equals(purpose) && configCodeObj == null) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"BOM\u7c7b\u578b\u201c%s\u201d\u7528\u9014\u4e3a\u201c\u8ba2\u5355\u201d\uff0c\u8bf7\u586b\u5199\u201c\u914d\u7f6e\u53f7\u201d\u3002", (String)"BOMConfigCodeValidator_6", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), typeObj.getString("number")));
                continue;
            }
            this.entryValidate(bom, obj);
        }
    }

    public void entryValidate(DynamicObject bom, ExtendedDataEntity obj) {
        DynamicObject typeObj = bom.getDynamicObject("type");
        String purpose = typeObj.getString("purpose");
        DynamicObjectCollection entryCol = bom.getDynamicObjectCollection("entry");
        if (entryCol == null) {
            return;
        }
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryCol.get(i);
            DynamicObject entryMatInfo = entry.getDynamicObject("entrymaterial");
            if (entry.getDataEntityType().getProperties().containsKey((Object)"entrymaterialid")) {
                entryMatInfo = entry.getDynamicObject("entrymaterialid");
            }
            if (entryMatInfo == null) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%s\u884c,\u7ec4\u4ef6\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u7ec4\u4ef6\u7f16\u7801\u3002", (String)"BOMConfigCodeValidator_7", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), i + 1));
                return;
            }
            DynamicObject entryMatObj = null;
            entryMatObj = "bd_materialmftinfo".equals(entryMatInfo.getDataEntityType().getName()) ? entryMatInfo.getDynamicObject("masterid") : entryMatInfo;
            String configproperties = entryMatObj.getString("configproperties");
            DynamicObject entryConfigCode = entry.getDynamicObject("entryconfiguredcode");
            if ("C".equals(purpose) && "2".equals(configproperties) && entryConfigCode == null) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c\u201c%1$s\u201d\u884c\uff0c\u7ec4\u4ef6\u7f16\u7801\u201c%2$s\u201d\u5bf9\u5e94\u7269\u6599\u4e3a\u914d\u7f6e\u4ef6\uff0c\u8bf7\u586b\u5199\u201c\u914d\u7f6e\u53f7\u201d\u3002", (String)"BOMConfigCodeValidator_8", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), i + 1, entryMatObj.getString("number")));
            }
            if ("C".equals(purpose) && !"2".equals(configproperties) && entryConfigCode != null) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c\u201c%1$s\u201d\u884c,\u7ec4\u4ef6\u7f16\u7801\u201c%3$s\u201d\u5bf9\u5e94\u7269\u6599\u4e3a\u901a\u7528\u4ef6\uff0c\u4e0d\u80fd\u586b\u5199\u201c\u914d\u7f6e\u53f7\u201d\u3002", (String)"BOMConfigCodeValidator_9", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), i + 1, entryMatObj.getString("number")));
            }
            entry.set("configproperties", (Object)configproperties);
        }
    }
}

