/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.opplugin.basedata.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class IndustryTimeRelValidator
extends AbstractValidator {
    public void validate() {
        block18: {
            String operate;
            block17: {
                operate = this.getOperateKey();
                if (!"save".equals(operate) && !"submit".equals(operate)) break block17;
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    DynamicObject workShift = this.dataEntities[i].getDataEntity();
                    DynamicObjectCollection schemeCols = workShift.getDynamicObjectCollection("schemeentry");
                    this.checkData(i, schemeCols);
                }
                break block18;
            }
            if (!"delete".equals(operate)) break block18;
            HashSet<Object> schemeEntryids = new HashSet<Object>(16);
            HashMap<Object, ExtendedDataEntity> workShifts = new HashMap<Object, ExtendedDataEntity>(this.dataEntities.length);
            for (int i = 0; i < this.dataEntities.length; ++i) {
                DynamicObject workShift = this.dataEntities[i].getDataEntity();
                workShifts.put(workShift.getPkValue(), this.dataEntities[i]);
                DynamicObjectCollection schemeCols = workShift.getDynamicObjectCollection("schemeentry");
                for (DynamicObject schemeEntry : schemeCols) {
                    Object pkValue = schemeEntry.getPkValue();
                    schemeEntryids.add(pkValue);
                }
            }
            if (schemeEntryids.size() > 0) {
                SqlBuilder sql = new SqlBuilder();
                sql.append("select distinct s.fid,s.fschemename,h.ftaskname \r\n", new Object[0]);
                sql.append("from t_fmm_schemeentry s", new Object[0]);
                sql.append("inner join t_sfc_dpentry_plan p on p.ftimeslotproid = s.fentryid", new Object[0]);
                sql.append("inner join t_sfc_dailyplan_new h on p.fid = h.fid", new Object[0]);
                sql.append("where", new Object[0]);
                sql.appendIn("s.fentryid", schemeEntryids.toArray());
                try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sql);){
                    for (Row row : dataSet) {
                        Object fid = row.get("fid");
                        Object schemename = row.get("fschemename");
                        Object taskname = row.get("ftaskname");
                        this.addErrorMessage((ExtendedDataEntity)workShifts.get(fid), String.format(ResManager.loadKDString((String)"\u65f6\u95f4\u6bb5\u65b9\u6848\u7b2c%1$s\u88ab\u4efb\u52a1%2$s\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"IndustryTimeRelValidator_11", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), schemename, taskname));
                    }
                }
            }
        }
    }

    private void checkData(int i, DynamicObjectCollection schemeCols) {
        if (schemeCols != null && schemeCols.size() > 0) {
            for (DynamicObject schemeCol : schemeCols) {
                int seq = schemeCol.getInt("seq");
                Object schemeName = schemeCol.get("schemename");
                DynamicObjectCollection subentrys = schemeCol.getDynamicObjectCollection("subentry");
                int entrySize = subentrys.size();
                if (null == subentrys || entrySize <= 0) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u65f6\u95f4\u6bb5\u65b9\u6848\u7b2c%1$s\u884c\u5bf9\u5e94\u65f6\u95f4\u6bb5\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"IndustryTimeRelValidator_6", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), seq));
                    continue;
                }
                this.getRepeatRow(subentrys, i, seq);
                this.checkSchemeRepeat(i, schemeCols, seq, schemeName, subentrys, entrySize);
            }
        } else {
            this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u65f6\u95f4\u6bb5\u65b9\u6848\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IndustryTimeRelValidator_7", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkSchemeRepeat(int i, DynamicObjectCollection schemeCols, int seq, Object schemeName, DynamicObjectCollection subentrys, int entrySize) {
        List collect = schemeCols.stream().filter(a -> {
            DynamicObjectCollection dynamicObjectCollection = a.getDynamicObjectCollection("subentry");
            return a.getInt("seq") > seq && dynamicObjectCollection != null && dynamicObjectCollection.size() > 0 && dynamicObjectCollection.size() == entrySize;
        }).collect(Collectors.toList());
        if (collect == null || collect.isEmpty()) {
            return;
        }
        for (DynamicObject col : collect) {
            int repeatRowCont = 0;
            Object repeatSchemeName = col.get("schemename");
            DynamicObjectCollection repetSubentrys = col.getDynamicObjectCollection("subentry");
            for (DynamicObject repetSubentry : repetSubentrys) {
                int rworkStartTime = Integer.parseInt(repetSubentry.get("workstarttime").toString());
                int rworkEndTime = Integer.parseInt(repetSubentry.get("workendtime").toString());
                for (DynamicObject subentry : subentrys) {
                    int workStartTime = Integer.parseInt(subentry.get("workstarttime").toString());
                    int workEndTime = Integer.parseInt(subentry.get("workendtime").toString());
                    if (workStartTime != rworkStartTime || workEndTime != rworkEndTime) continue;
                    ++repeatRowCont;
                }
            }
            if (repeatRowCont != entrySize) continue;
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u65f6\u95f4\u6bb5\u65b9\u6848%1$s\u4e0e%2$s\u7684\u65f6\u95f4\u6bb5\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"IndustryTimeRelValidator_8", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), schemeName, repeatSchemeName));
        }
    }

    private void getRepeatRow(DynamicObjectCollection col, int row, int schemeSeq) {
        ArrayList<Integer> repectList = new ArrayList<Integer>();
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject entry = (DynamicObject)col.get(i);
            int seq = entry.getInt("seq");
            int workStartTime = Integer.parseInt(entry.get("workstarttime").toString());
            int workEndTime = Integer.parseInt(entry.get("workendtime").toString());
            if (workEndTime != -1 && workStartTime == workEndTime) {
                this.addErrorMessage(this.dataEntities[row], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u65f6\u95f4\u6bb5\u65b9\u6848\u5206\u5f55\u5bf9\u5e94\u7b2c%2$s\u884c\u65f6\u95f4\u6bb5\u4fe1\u606f,\u5de5\u4f5c\u65f6\u95f4\u4e0d\u80fd\u4e3a24\u5c0f\u65f6\uff01", (String)"IndustryTimeRelValidator_9", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), schemeSeq, seq));
                return;
            }
            for (int j = i + 1; j < col.size(); ++j) {
                int end;
                DynamicObject obj = (DynamicObject)col.get(j);
                int seq1 = obj.getInt("seq");
                boolean cross = false;
                int start = Integer.parseInt(obj.get("workstarttime").toString());
                boolean flag = this.compareDay1(false, cross, workStartTime, workEndTime, start, end = Integer.parseInt(obj.get("workendtime").toString()));
                if (flag) {
                    repectList.add(seq);
                    repectList.add(seq1);
                }
                if (!(flag = this.compareDay2(false, cross, workStartTime, workEndTime, start, end))) continue;
                repectList.add(seq);
                repectList.add(seq1);
            }
        }
        HashSet set = new HashSet(repectList);
        if (!(repectList = new ArrayList(set)).isEmpty()) {
            this.addErrorMessage(this.dataEntities[row], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u65f6\u95f4\u6bb5\u65b9\u6848\u5206\u5f55\u5bf9\u5e94\u7b2c%2$s\u884c\u5206\u5f55\u65f6\u95f4\u4fe1\u606f\u6bb5\u6709\u91cd\u53e0\uff01", (String)"IndustryTimeRelValidator_10", (String)"mmc-fmm-opplugin", (Object[])new Object[0]), schemeSeq, ((Object)repectList).toString()));
        }
    }

    private boolean compareDay1(boolean isCrossDay, boolean cross, int workStartTime, int workEndTime, int start, int end) {
        boolean flag = !isCrossDay && !cross && Math.max(workStartTime, start) <= Math.min(workEndTime, end);
        return flag;
    }

    private boolean compareDay2(boolean isCrossDay, boolean cross, int workStartTime, int workEndTime, int start, int end) {
        boolean flag = !isCrossDay && cross && (workEndTime >= start || workStartTime <= end);
        return flag;
    }
}

