/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.opplugin.basedata.validator;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ManuVersionEffectTimeValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(ManuVersionEffectTimeValidator.class);

    public void validate() {
        HashMap<Object, Object> bomAndVersionMap = new HashMap<Object, Object>(16);
        HashMap<Object, Object> routeAndVersionMap = new HashMap<Object, Object>(16);
        this.getVersionData(bomAndVersionMap, routeAndVersionMap);
        block7: for (int i = 0; i < this.dataEntities.length; ++i) {
            String operateKey;
            DynamicObject manuVersion = this.dataEntities[i].getDataEntity();
            switch (operateKey = this.getOperateKey()) {
                case "save": 
                case "submit": {
                    this.checkVersionWithBomTime(this.dataEntities[i], manuVersion, bomAndVersionMap);
                    this.checkVersionWithRouteTime(this.dataEntities[i], manuVersion, routeAndVersionMap);
                    continue block7;
                }
            }
        }
    }

    private void checkVersionWithBomTime(ExtendedDataEntity dataEntity, DynamicObject manuVersion, Map<Object, Object> versionMap) {
        DynamicObject bom = manuVersion.getDynamicObject("bom");
        if (bom != null) {
            boolean checkTimeFlag = false;
            if (bom.get("version") == null) {
                return;
            }
            Object manuVersionPkValue = manuVersion.getPkValue();
            DynamicObject version = (DynamicObject)versionMap.get(manuVersionPkValue);
            Date effectDate = version.getDate("effectdate");
            Date invalidDate = version.getDate("invaliddate");
            logger.info("BOM\u7248\u672c\u53f7 " + version.getString("number") + " \u7684\u5f53\u524d\u5931\u6548\u65f6\u95f4\uff1a" + invalidDate.toString());
            Date beginDate = manuVersion.getDate("begindate");
            Date endDate = manuVersion.getDate("enddate");
            if (effectDate.compareTo(beginDate) > 0 || invalidDate.compareTo(endDate) < 0) {
                checkTimeFlag = true;
            }
            if (checkTimeFlag) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u751f\u4ea7\u7248\u672c\u7684\u751f\u5931\u6548\u65f6\u95f4\u4e0d\u5728BOM\u7248\u672c\u7684\u751f\u5931\u6548\u65f6\u95f4\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539\u6570\u636e\u3002", (String)"ManuVersionEffectTimeValidator_4", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void checkVersionWithRouteTime(ExtendedDataEntity dataEntity, DynamicObject manuVersion, Map<Object, Object> versionMap) {
        DynamicObject route = manuVersion.getDynamicObject("processroute");
        if (route != null) {
            boolean checkTimeFlag = false;
            if (route.get("version") == null) {
                return;
            }
            Object manuVersionPkValue = manuVersion.getPkValue();
            DynamicObject version = (DynamicObject)versionMap.get(manuVersionPkValue);
            Date effectDate = version.getDate("effectivedate");
            Date invalidDate = version.getDate("expirationdate");
            logger.info("\u5de5\u827a\u8def\u7ebf\u7248\u672c\u53f7 " + version.getString("number") + " \u7684\u5f53\u524d\u5931\u6548\u65f6\u95f4\uff1a" + invalidDate.toString());
            Date beginDate = manuVersion.getDate("begindate");
            Date endDate = manuVersion.getDate("enddate");
            if (effectDate.compareTo(beginDate) > 0 || invalidDate.compareTo(endDate) < 0) {
                checkTimeFlag = true;
            }
            if (checkTimeFlag) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u751f\u4ea7\u7248\u672c\u7684\u751f\u5931\u6548\u65f6\u95f4\u4e0d\u5728\u5de5\u827a\u8def\u7ebf\u7248\u672c\u7684\u751f\u5931\u6548\u65f6\u95f4\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539\u6570\u636e\u3002", (String)"ManuVersionEffectTimeValidator_5", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void getVersionData(Map<Object, Object> bomAndVersionMap, Map<Object, Object> routeAndVersionMap) {
        DynamicObject[] routeVersionDyns;
        DynamicObject[] bomVersionDyns;
        HashSet<Object> bomVersionIds = new HashSet<Object>(16);
        HashSet<Object> routeVersionIds = new HashSet<Object>(16);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject version;
            DynamicObject route;
            DynamicObject version2;
            DynamicObject manuVersion = this.dataEntities[i].getDataEntity();
            DynamicObject[] bom = manuVersion.getDynamicObject("bom");
            if (bom != null && (version2 = bom.getDynamicObject("version")) != null) {
                Object versionId = version2.getPkValue();
                bomVersionIds.add(versionId);
                bomAndVersionMap.put(manuVersion.getPkValue(), versionId);
            }
            if ((route = manuVersion.getDynamicObject("processroute")) == null || (version = route.getDynamicObject("version")) == null) continue;
            Object versionId = version.getPkValue();
            routeVersionIds.add(versionId);
            routeAndVersionMap.put(manuVersion.getPkValue(), versionId);
        }
        QFilter bomFilter = new QFilter("id", "in", bomVersionIds);
        for (DynamicObject dyn : bomVersionDyns = BusinessDataServiceHelper.load((String)"bd_bomversion_new", (String)"id,number,effectdate,invaliddate", (QFilter[])new QFilter[]{bomFilter})) {
            for (Map.Entry<Object, Object> entry : bomAndVersionMap.entrySet()) {
                if (!dyn.get("id").equals(entry.getValue())) continue;
                bomAndVersionMap.put(entry.getKey(), dyn);
            }
        }
        QFilter routeFilter = new QFilter("id", "in", routeVersionIds);
        for (DynamicObject dyn : routeVersionDyns = BusinessDataServiceHelper.load((String)"mpdm_processversion", (String)"id,number,effectivedate,expirationdate", (QFilter[])new QFilter[]{routeFilter})) {
            for (Map.Entry<Object, Object> entry : routeAndVersionMap.entrySet()) {
                if (!dyn.get("id").equals(entry.getValue())) continue;
                routeAndVersionMap.put(entry.getKey(), dyn);
            }
        }
    }
}

