/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.opplugin.basedata.validator;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ManuVersionImportValidator
extends AbstractValidator {
    public void validate() {
        block10: for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject manuVersion = this.dataEntities[i].getDataEntity();
            String operateKey = this.getOperateKey();
            this.validateQty(this.dataEntities[i], manuVersion);
            switch (operateKey) {
                case "save": {
                    this.checkMaterialAndBom(this.dataEntities[i], manuVersion);
                    continue block10;
                }
                case "submit": {
                    this.checkMaterialAndBom(this.dataEntities[i], manuVersion);
                    continue block10;
                }
                case "audit": {
                    this.checkMaterialAndBom(this.dataEntities[i], manuVersion);
                    continue block10;
                }
            }
        }
    }

    private void validateQty(ExtendedDataEntity dataEntity, DynamicObject manuVersion) {
        BigDecimal endqty;
        BigDecimal beginqty = manuVersion.getBigDecimal("beginqty");
        if (beginqty.compareTo(endqty = manuVersion.getBigDecimal("endqty")) > 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b57\u6bb5\"\u6570\u91cf\u8303\u56f4\u4ece\"\u4e0d\u5141\u8bb8\u5927\u4e8e\"\u6570\u91cf\u81f3\"\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ManuVersionImportValidator_1", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkMaterialAndBom(ExtendedDataEntity dataEntity, DynamicObject manuVersion) {
        DynamicObject material = manuVersion.getDynamicObject("material");
        DynamicObject bom = manuVersion.getDynamicObject("bom");
        if (null != material && null != bom) {
            boolean checkFlag = false;
            if (null != (material = material.getDynamicObject("masterid"))) {
                DynamicObject[] xmfBoms;
                Long materialId = material.getLong("id");
                for (DynamicObject xmfBom : xmfBoms = BusinessDataServiceHelper.load((String)"pdm_mftbom", (String)"number", (QFilter[])new QFilter[]{new QFilter("material.masterid.id", "=", (Object)materialId)})) {
                    String bomNumber;
                    if (null == xmfBom || !StringUtils.equals((CharSequence)(bomNumber = xmfBom.getString("number")), (CharSequence)bom.getString("number"))) continue;
                    checkFlag = true;
                    break;
                }
                if (!checkFlag) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u586b\u5199\u7684bom\u4e0e\u7269\u6599\u4e2d\u7684bom\u4e0d\u4e00\u81f4\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ManuVersionImportValidator_0", (String)"mmc-fmm-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }
}

