/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.opplugin.basedata.validator;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class OutSourceQuotaDimensionValidator
extends AbstractValidator {
    private static final String sysTem = "mmc-fmm-opplugin";
    private static final Log log = LogFactory.getLog(OutSourceQuotaDimensionValidator.class);

    public void validate() {
        HashMap<Long, List<ExtendedDataEntity>> curBillMap = new HashMap<Long, List<ExtendedDataEntity>>();
        HashMap<Long, DynamicObject> quotaCategoryMap = new HashMap<Long, DynamicObject>();
        this.prepareData(curBillMap, quotaCategoryMap);
        for (Map.Entry listEntry : curBillMap.entrySet()) {
            Long categoryId = (Long)listEntry.getKey();
            List<ExtendedDataEntity> bills = (List<ExtendedDataEntity>)listEntry.getValue();
            bills = this.filter(bills);
            DynamicObject quotaCategory = (DynamicObject)quotaCategoryMap.get(categoryId);
            if (quotaCategory == null) continue;
            try {
                DataSet pmQuota = this.queryData(bills, quotaCategory);
                Throwable throwable = null;
                try {
                    DataSet curData = this.convertToDataSet(bills, pmQuota.getRowMeta());
                    Throwable throwable2 = null;
                    try {
                        this.checkDataUnique(pmQuota, curData.copy(), quotaCategory);
                        this.checkResultUnique(curData.copy(), quotaCategory);
                        this.checkQuotaRatio(curData.copy(), quotaCategory);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (curData == null) continue;
                        if (throwable2 != null) {
                            try {
                                curData.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        curData.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (pmQuota == null) continue;
                    if (throwable != null) {
                        try {
                            pmQuota.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    pmQuota.close();
                }
            }
            catch (Exception e) {
                log.error("quota validator error", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u6821\u9a8c\u5f02\u5e38\u3002", (String)"OutSourceQuotaDimensionValidator_3", (String)sysTem, (Object[])new Object[0]));
            }
        }
    }

    private List<ExtendedDataEntity> filter(List<ExtendedDataEntity> bills) {
        return bills.stream().filter((? super T e) -> e.getDataEntity().getString("status").equals("A")).collect(Collectors.toList());
    }

    private void checkDataUnique(DataSet pmQuota, DataSet curData, DynamicObject quotaCategory) {
        HashSet<Integer> errorData = new HashSet<Integer>();
        this.checkDateUniqueInSelf(curData.copy(), quotaCategory, errorData);
        DataSet union = pmQuota.union(curData.copy());
        this.checkDateUniqueInAll(union.copy(), quotaCategory, errorData);
        this.checkDataUniqueInAll(union.copy(), quotaCategory, errorData);
    }

    private void checkDataUniqueInAll(DataSet pmQuota, DynamicObject quotaCategory, Set<Integer> errorData) {
        List<String> conditionDimensions = this.getConditionDimensionFields(quotaCategory);
        HashSet<String> selectFields = new HashSet<String>(16);
        selectFields.add("dataindex");
        for (String dimension : conditionDimensions) {
            selectFields.add(dimension);
            if (!dimension.startsWith("entryentity.")) continue;
            selectFields.add("entryentity.seq");
        }
        pmQuota = pmQuota.select(selectFields.toArray(new String[selectFields.size()])).distinct();
        if (!conditionDimensions.contains("entryentity.effectdate") && !conditionDimensions.contains("entryentity.expirydate")) {
            DataSet[] splitByGroup = pmQuota.splitByGroup(conditionDimensions.toArray(new String[conditionDimensions.size()]));
            String msg = String.format(ResManager.loadKDString((String)"\u540c\u4e00\u914d\u989d\u7c7b\u578b\u4e2d\uff0c%s\u7684\u7ec4\u5408\u503c\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OutSourceQuotaDimensionValidator_0", (String)sysTem, (Object[])new Object[0]), quotaCategory.getString(sysTem).replace('+', '\u3001'));
            for (DataSet dataSet : splitByGroup) {
                int count = 0;
                while (dataSet.hasNext()) {
                    Integer dataIndex;
                    Row row = dataSet.next();
                    if (++count <= 1 || !(dataIndex = row.getInteger("dataindex")).equals(0) || !errorData.add(dataIndex)) continue;
                    this.addErrorMessage(this.getDataEntities()[dataIndex], msg);
                }
            }
        }
    }

    private void checkDateUniqueInSelf(DataSet pmQuota, DynamicObject quotaCategory, Set<Integer> errorData) {
        List<String> conditionDimensions = this.getConditionDimensionFields(quotaCategory);
        if (conditionDimensions.contains("entryentity.effectdate") && conditionDimensions.contains("entryentity.expirydate")) {
            conditionDimensions.remove("entryentity.effectdate");
            conditionDimensions.remove("entryentity.expirydate");
            conditionDimensions.add("dataindex");
            DataSet[] splitByGroup = pmQuota.splitByGroup(conditionDimensions.toArray(new String[conditionDimensions.size()]));
            String msg = String.format(ResManager.loadKDString((String)"\u540c\u4e00\u914d\u989d\u7c7b\u578b\u4e2d\uff0c%s\u7684\u7ec4\u5408\u503c\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OutSourceQuotaDimensionValidator_0", (String)sysTem, (Object[])new Object[0]), quotaCategory.getString(sysTem).replace('+', '\u3001'));
            ArrayList groupList = new ArrayList(16);
            for (DataSet dataSet : splitByGroup) {
                DataSet orderBy = dataSet.orderBy(new String[]{"entryentity.effectdate asc", "entryentity.expirydate asc"});
                HashMap<Integer, List> groupBillMap = new HashMap<Integer, List>();
                while (orderBy.hasNext()) {
                    Row row = orderBy.next();
                    Integer dataIndex = row.getInteger("dataindex");
                    Date effectdate = row.getDate("entryentity.effectdate");
                    Date expirydate = row.getDate("entryentity.expirydate");
                    List list = groupBillMap.computeIfAbsent(dataIndex, a -> new ArrayList());
                    list.add(new Object[]{dataIndex, effectdate, expirydate});
                }
                groupList.add(groupBillMap);
            }
            for (Map map : groupList) {
                for (Map.Entry entry : map.entrySet()) {
                    Integer dataIndex = (Integer)entry.getKey();
                    Date preValidDate = null;
                    Date preInValidDate = null;
                    List value = (List)entry.getValue();
                    for (Object[] obj : value) {
                        Date curValidDate = (Date)obj[1];
                        Date curInValidDate = (Date)obj[2];
                        if (preValidDate != null && preInValidDate != null && (preValidDate.compareTo(curValidDate) != 0 || preInValidDate.compareTo(curInValidDate) != 0) && preInValidDate.compareTo(curValidDate) >= 0) {
                            if (errorData.add(dataIndex)) {
                                this.addErrorMessage(this.getDataEntities()[dataIndex], msg);
                            }
                            return;
                        }
                        preValidDate = curValidDate;
                        preInValidDate = curInValidDate;
                    }
                }
            }
        }
    }

    private void checkDateUniqueInAll(DataSet pmQuota, DynamicObject quotaCategory, Set<Integer> errorData) {
        List<String> conditionDimensions = this.getConditionDimensionFields(quotaCategory);
        HashSet<String> selectFields = new HashSet<String>(16);
        selectFields.add("dataindex");
        for (String dimension : conditionDimensions) {
            selectFields.add(dimension);
            if (!dimension.startsWith("entryentity.")) continue;
            selectFields.add("entryentity.seq");
        }
        pmQuota = pmQuota.select(selectFields.toArray(new String[selectFields.size()])).distinct();
        if (conditionDimensions.contains("entryentity.effectdate") && conditionDimensions.contains("entryentity.expirydate")) {
            conditionDimensions.remove("entryentity.effectdate");
            conditionDimensions.remove("entryentity.expirydate");
            DataSet[] splitByGroup = pmQuota.splitByGroup(conditionDimensions.toArray(new String[conditionDimensions.size()]));
            String msg = String.format(ResManager.loadKDString((String)"\u540c\u4e00\u914d\u989d\u7c7b\u578b\u4e2d\uff0c%s\u7684\u7ec4\u5408\u503c\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OutSourceQuotaDimensionValidator_0", (String)sysTem, (Object[])new Object[0]), quotaCategory.getString(sysTem).replace('+', '\u3001'));
            for (DataSet dataSet : splitByGroup) {
                DataSet orderByDate = dataSet.orderBy(new String[]{"entryentity.effectdate asc", "entryentity.expirydate asc"});
                Date preDate = null;
                Integer preDataIndex = null;
                while (orderByDate.hasNext()) {
                    Row row = orderByDate.next();
                    Date curValidDate = row.getDate("entryentity.effectdate");
                    Date curInValidDate = row.getDate("entryentity.expirydate");
                    Integer dataIndex = row.getInteger("dataindex");
                    if (preDataIndex == null) {
                        preDataIndex = dataIndex;
                        preDate = curInValidDate;
                        continue;
                    }
                    if (curValidDate == null || curInValidDate == null) continue;
                    if (!dataIndex.equals(preDataIndex) && preDate != null && preDate.compareTo(curValidDate) >= 0) {
                        if (dataIndex != -1 && errorData.add(dataIndex)) {
                            this.addErrorMessage(this.getDataEntities()[dataIndex], msg);
                        }
                        if (preDataIndex != -1 && errorData.add(preDataIndex)) {
                            this.addErrorMessage(this.getDataEntities()[preDataIndex], msg);
                        }
                    }
                    preDate = curInValidDate;
                    preDataIndex = dataIndex;
                }
            }
        }
    }

    private void checkQuotaRatio(DataSet dataSet, DynamicObject quotaCategory) {
        List<String> dimensionFields = this.getConditionDimensionFields(quotaCategory);
        DataSet[] dimensionGroups = dataSet.splitByGroup(dimensionFields.toArray(new String[dimensionFields.size()]));
        String resourceId = "OutSourceQuotaDimensionValidator_2";
        String msg = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c%2$s\u540c\u4e00\u4f18\u5148\u7ea7\u914d\u989d\u6bd4\u4f8b\u4e4b\u548c\u4e0d\u4e3a100\uff0c\u8bf7\u4fee\u6539\u3002", (String)resourceId, (String)sysTem, (Object[])new Object[0]);
        String conDimension = quotaCategory.getString("OutSourceQuotaDimensionValidator_4");
        ArrayList<Object[]> ratioList = new ArrayList<Object[]>(16);
        for (DataSet group : dimensionGroups) {
            DataSet[] priorityGroups;
            for (DataSet priorityGroup : priorityGroups = group.splitByGroup(new String[]{"entryentity.supplyrank"})) {
                priorityGroup = priorityGroup.orderBy(new String[]{"dataindex asc", "entryentity.seq desc"});
                BigDecimal ratio = BigDecimal.ZERO;
                while (priorityGroup.hasNext()) {
                    Row row = priorityGroup.next();
                    Integer dataIndex = row.getInteger("dataindex");
                    Integer seq = row.getInteger("entryentity.seq");
                    BigDecimal quotarate = row.getBigDecimal("entryentity.quotarate");
                    ratio = ratio.add(quotarate);
                    ratioList.add(new Object[]{dataIndex, seq});
                }
                if (ratio.compareTo(new BigDecimal(100)) != 0) {
                    for (Object[] obj : ratioList) {
                        Integer dataIndex = (Integer)obj[0];
                        Integer seq = (Integer)obj[1];
                        if (dataIndex == null || dataIndex == -1) continue;
                        this.addErrorMessage(this.getDataEntities()[dataIndex], String.format(msg, seq, conDimension.replace('+', '\u3001')));
                    }
                }
                ratioList.clear();
            }
        }
    }

    private void checkResultUnique(DataSet dataSet, DynamicObject quotaCategory) {
        List<String> conDimensions = this.getConditionDimensionFields(quotaCategory);
        conDimensions.add("dataindex");
        List<String> resultDimensions = this.getResultDimensionFields(quotaCategory);
        DataSet[] splitByGroups = dataSet.splitByGroup(conDimensions.toArray(new String[conDimensions.size()]));
        ArrayList<Object[]> repeatData = new ArrayList<Object[]>(16);
        String replaceTag = ResManager.loadKDString((String)"\u3001", (String)"OutSourceQuotaDimensionValidator_5", (String)sysTem, (Object[])new Object[0]);
        for (DataSet splitByGroup : splitByGroups) {
            DataSet[] resultGroups = splitByGroup.splitByGroup(resultDimensions.toArray(new String[resultDimensions.size()]));
            String conDimension = quotaCategory.getString("condimension");
            String resultDimension = quotaCategory.getString("resultdimension");
            for (DataSet result : resultGroups) {
                while (result.hasNext()) {
                    Row row = result.next();
                    Integer dataIndex = row.getInteger("dataindex");
                    Integer seq = row.getInteger("entryentity.seq");
                    repeatData.add(new Object[]{dataIndex, seq});
                }
                if (repeatData.size() > 1) {
                    String resourceID = "QuotaDimensionValidator_1";
                    String msg = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c%2$s\u76f8\u540c\u7684\u6570\u636e\uff0c%3$s\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)resourceID, (String)sysTem, (Object[])new Object[0]);
                    String calDimensionStr = conDimension.replace("OutSourceQuotaDimensionValidator_1", replaceTag);
                    String resultDimensionStr = resultDimension.replace("OutSourceQuotaDimensionValidator_1", replaceTag);
                    for (Object[] data : repeatData) {
                        Integer dataIndex = (Integer)data[0];
                        if (-1 == dataIndex) continue;
                        this.addErrorMessage(this.getDataEntities()[dataIndex], String.format(msg, data[1], calDimensionStr, resultDimensionStr));
                    }
                }
                repeatData.clear();
            }
        }
    }

    private void prepareData(Map<Long, List<ExtendedDataEntity>> curBillMap, Map<Long, DynamicObject> quotaCategoryMap) {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObject quotaCategory = bill.getDynamicObject("quotacategory");
            if (quotaCategory == null) continue;
            Long quotaCategoryId = (Long)quotaCategory.getPkValue();
            List<ExtendedDataEntity> groupList = curBillMap.get(quotaCategoryId);
            if (groupList == null) {
                groupList = new ArrayList<ExtendedDataEntity>();
                curBillMap.put(quotaCategoryId, groupList);
            }
            groupList.add(data);
            quotaCategoryMap.put(quotaCategoryId, quotaCategory);
        }
    }

    private List<String> getConditionDimensionFields(DynamicObject quotaCategory) {
        String conDimensionJson = quotaCategory.getString("condimensionjson");
        List dimensionFields = (List)JSON.parseObject((String)conDimensionJson, List.class);
        dimensionFields.remove("entryentity.quotarate");
        dimensionFields.remove("entryentity.supplyrank");
        return dimensionFields;
    }

    private List<String> getResultDimensionFields(DynamicObject quotaCategory) {
        String resultDimensionJson = quotaCategory.getString("resultdimensionjson");
        List dimensionFields = (List)JSON.parseObject((String)resultDimensionJson, List.class);
        dimensionFields.remove("entryentity.effectdate");
        dimensionFields.remove("entryentity.expirydate");
        dimensionFields.remove("entryentity.quotarate");
        dimensionFields.remove("entryentity.supplyrank");
        return dimensionFields;
    }

    private DataSet queryData(List<ExtendedDataEntity> bills, DynamicObject quotaCategory) {
        DynamicObjectCollection entryentity;
        DynamicObject bill;
        String conDimensionJson = quotaCategory.getString("condimensionjson");
        Set conDimensions = (Set)JSON.parseObject((String)conDimensionJson, Set.class);
        String resultDimensionJson = quotaCategory.getString("resultdimensionjson");
        Set resultDimensions = (Set)JSON.parseObject((String)resultDimensionJson, Set.class);
        QFilter qFilter = new QFilter("quotacategory", "=", quotaCategory.getPkValue());
        qFilter = qFilter.and(new QFilter("status", "!=", (Object)"A"));
        if (conDimensions.contains("org")) {
            HashSet<Long> orgIds = new HashSet<Long>(16);
            for (ExtendedDataEntity dataEntity : bills) {
                bill = dataEntity.getDataEntity();
                orgIds.add(bill.getLong("org.id"));
            }
            qFilter = qFilter.and(new QFilter("org", "in", orgIds));
        }
        if (conDimensions.contains("entryentity.material")) {
            HashSet<Long> materialIds = new HashSet<Long>();
            for (ExtendedDataEntity dataEntity : bills) {
                bill = dataEntity.getDataEntity();
                entryentity = bill.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryentity) {
                    materialIds.add(entry.getLong("material.id"));
                }
            }
            qFilter = qFilter.and(new QFilter("entryentity.material", "in", materialIds));
        }
        if (conDimensions.contains("entryentity.procedure")) {
            HashSet<Long> procedureIds = new HashSet<Long>();
            for (ExtendedDataEntity dataEntity : bills) {
                bill = dataEntity.getDataEntity();
                entryentity = bill.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryentity) {
                    procedureIds.add(entry.getLong("procedure.id"));
                }
            }
            qFilter = qFilter.and(new QFilter("entryentity.procedure", "in", procedureIds));
        }
        if (conDimensions.contains("entryentity.supplier")) {
            HashSet<Long> providorIds = new HashSet<Long>();
            for (ExtendedDataEntity dataEntity : bills) {
                bill = dataEntity.getDataEntity();
                entryentity = bill.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryentity) {
                    providorIds.add(entry.getLong("supplier.id"));
                }
            }
            qFilter = qFilter.and(new QFilter("entryentity.supplier", "in", providorIds));
        }
        QFilter[] filters = new QFilter[]{qFilter};
        HashSet<String> selectFields = new HashSet<String>();
        selectFields.addAll(conDimensions);
        selectFields.addAll(resultDimensions);
        selectFields.add("number");
        selectFields.add("org");
        selectFields.add("quotacategory");
        selectFields.add("status");
        selectFields.add("enable");
        selectFields.add("entryentity.seq");
        selectFields.add("entryentity.quotarate");
        selectFields.add("entryentity.supplyrank");
        selectFields.add("-1 as dataindex");
        StringJoiner joiner = new StringJoiner(",");
        for (String field : selectFields) {
            joiner.add(field);
        }
        return QueryServiceHelper.queryDataSet((String)"queryFmmQuota", (String)"fmm_purquota", (String)joiner.toString(), (QFilter[])filters, null);
    }

    private DataSet convertToDataSet(List<ExtendedDataEntity> bills, RowMeta rowMeta) {
        String[] fields = rowMeta.getFieldNames();
        ArrayList<Object[]> currentData = new ArrayList<Object[]>();
        for (ExtendedDataEntity dataEntity : bills) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectType mainObjectType = bill.getDynamicObjectType();
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                Object[] row = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    String field = fields[i];
                    if (field.equals("dataindex")) {
                        row[i] = dataEntity.getDataEntityIndex();
                        continue;
                    }
                    if (field.contains("entryentity.")) {
                        String entryField = field.replace("entryentity.", "");
                        DynamicProperty property = entryEntity.getDynamicObjectType().getProperty(entryField);
                        if (property instanceof BasedataProp) {
                            DynamicObject object = (DynamicObject)entry.get(entryField);
                            if (object != null) {
                                row[i] = object.getLong("id");
                                continue;
                            }
                            row[i] = null;
                            continue;
                        }
                        row[i] = entry.get(entryField);
                        continue;
                    }
                    DynamicProperty property = mainObjectType.getProperty(field);
                    if (property instanceof BasedataProp) {
                        DynamicObject object = (DynamicObject)bill.get(field);
                        if (object != null) {
                            row[i] = object.getLong("id");
                            continue;
                        }
                        row[i] = null;
                        continue;
                    }
                    row[i] = bill.get(field);
                }
                currentData.add(row);
            }
        }
        DataSet quotaData = Algo.create((String)"createCurrentQuotaData").createDataSet(currentData, rowMeta);
        return quotaData;
    }
}

